TMGLOAD1 ;TMG/kst-Functions to load ICD and CPT codes in ;11/20/08
         ;;1.0;TMG-LIB;**1**;11/20/08

 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"3/24/07

 ;"=======================================================================
 ;" Public Functions.
 ;"=======================================================================

CPT
        new cptArray
        if $$LoadCPT("cptArray")=0 goto CPTDone
        do CompCPT("cptArray")

CPTDone
        quit


CompCPT(pNewCPT)
        ;"Purpose: to compare new CPT file with existing values
        ;"Input: name of array, as made by LoadCPT

        write "Prepping..."

        new scrlArray,oneLine,oldCPTName
        new lineNum set lineNum=1
        new cptNum set cptNum=""
        for  set cptNum=$order(@pNewCPT@(cptNum)) quit:(cptNum="")  do
        . set oldCPTName=$piece($get(^ICPT(cptNum,0)),"^",2)
        . set oneLine=cptNum_": "_$get(@pNewCPT@(cptNum))_" <-- "_oldCPTName
        . set scrlArray(lineNum,oneLine)=cptNum
        . set lineNum=lineNum+1

        set cptNum=0
        for  set cptNum=$order(^ICPT(cptNum)) quit:(+cptNum'>0)  do
        . if $data(@pNewCPT@(cptNum)) quit
        . set oldCPTName=$piece($get(^ICPT(cptNum,0)),"^",2)
        . set oneLine=cptNum_": DELETED <-- "_oldCPTName
        . set scrlArray(lineNum,oneLine)=cptNum
        . set lineNum=lineNum+1

        new Option
        set Option("HEADER")="Display of new <-- old CPT's"
        do Scroller^TMGUSRIF("scrlArray",.Option)

        quit

LoadCPT(pArray)
        ;"Purpose: load a CSV CPT file into an array
        ;"Input: pArray -- PASS BY NAME, the array to be loaded with the data
        ;"              e.g. "MyArray"
        ;"Output: If no error, then output will be:
        ;"      @pArray@(CPT#)=DescrText
        ;"      @pArray@(CPT#)=DescrText
        ;"Results: 1=success, 0=failure

        new tempArray
        new FPath,FName,Result set Result=0
        if $$GetFName^TMGIOUTL("Select CPT text file",,,,.FPath,.FName)="^" goto LCDone
        set Result=$$FTG^%ZISH(FPath,FName,"tempArray(0)",1)
        if Result=0 goto LCDone
        new lineNum set lineNum=""
        for  set lineNum=$order(tempArray(lineNum)) quit:(lineNum="")  do
        . new cptNum set cptNum=$piece($get(tempArray(lineNum)),$char(9),1)
        . quit:(cptNum="")
        . new descrText set descrText=$piece($get(tempArray(lineNum)),$char(9),2)
        . set @pArray@(cptNum)=descrText
LCDone
        quit Result
