TMGNDF1D ;TMG/kst/FDA Import: Import name cleanup ;03/25/06
         ;;1.0;TMG-LIB;**1**;01/23/07

 ;"FDA - NATIONAL DRUG FILES COMPILING FUNCTIONS
 ;"Code for cleaning up names.
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"1-23-07

 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"Menu
 ;"Fix1Name(IEN) -- perform this units fixes for just 1 record

 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 ;"PickSkips -- select records to mark as to be skipped.
 ;"RemoveDups -- Set duplicate records to be skipped
 ;"=======================================================================

Menu
        ;"Purpose: To give an interactive menu of tools to clean up data.

        new Menu,UsrSlct
        new i set i=0
        set Menu(i)="Pick Option for Cleaning Up FDA Imported Data (1D)",i=i+1
        set Menu(i)="Fix common misspellings etc. in Trade Names"_$char(9)_"NormalizeNames",i=i+1
        set Menu(i)="SEARCH and REPLACE words in drug TRADE NAME"_$char(9)_"SEARCHd05",i=i+1
        set Menu(i)="SEARCH and REPLACE words in drug STRENGTH"_$char(9)_"SEARCH1",i=i+1
        set Menu(i)="SEARCH and REPLACE words in drug UNITS"_$char(9)_"SEARCH2",i=i+1
        set Menu(i)="Fix dose decimals (e.g. '.5;.125' --> '0.5;0.125')"_$char(9)_"DECIMAL",i=i+1
        set Menu(i)="Fix units decimals (e.g. 'MG/.5 ML;' --> 'MG/0.5ML')"_$char(9)_"UNITS",i=i+1
        set Menu(i)="Remove unwanted DOSES from TRADE NAME"_$char(9)_"ScrubDoses",i=i+1
        set Menu(i)="Edit import TRADE NAME (Caution)"_$char(9)_"EditTradeName",i=i+1
        set Menu(i)="HELP"_$char(9)_"?"
        set Menu("P")="Prev Stage"_$char(9)_"Prev"
        set Menu("N")="Next Stage"_$char(9)_"Next"

CD1
        write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
        if UsrSlct="^" goto CDDone
        if UsrSlct=0 set UsrSlct=""

        if UsrSlct="Prev" goto Menu^TMGNDF1A  ;"quit can occur from there...
        if UsrSlct="Next" goto Menu^TMGNDF1E  ;"quit can occur from there...

        if UsrSlct="NormalizeNames" do NormalizeNames goto CD1
        if UsrSlct="SEARCHd05" do Srch5Replace goto CD1
        if UsrSlct="SEARCH1" do Srch1Replace goto CD1
        if UsrSlct="SEARCH2" do Srch2Replace goto CD1
        if UsrSlct="DECIMAL" do FixDecimals goto CD1
        if UsrSlct="UNITS" do FixUnits goto CD1
        if UsrSlct="ScrubDoses" do ScrubDoses goto CD1
        if UsrSlct="EditTradeName" do EditTradename() goto CD1
        if UsrSlct="?" do ShowHelp goto CD1
        goto CDDone
CDDone
        quit

ShowHelp
        ;"Purpose: to display help instructions

        write #,!
        write "Q: Why does the data need clean up?",!
        write "A: The FDA database seems to consist of data provided",!
        write "   by vendors.  As such, there is a big variety in the",!
        write "   formats of drug names and in the dose specifications,",!
        write "   and also accuracy (many drugs are missing information.)",!
        write !
        write "Q: Are inaccurate or unwanted drug records deleted?",!
        write "A: No.  They are kept so that with the NEXT import, their",!
        write "   unwanted status will be remembered.  Instead, they are",!
        write "   flagged with a SKIP THIS RECORD marker.  They will be",!
        write "   ignored during further processing.",!
        write !
        write "Q: How do I flag an unwanted record to be SKIPPED?",!
        write "A: Drug records are browsed in a 'selector' (more below)",!
        write "   and all the drugs to be skipped are selected.  Then the",!
        write "   selector is exited by typing [ESC][ESC], and one is ",!
        write "   given a chance to mark all to be SKIPPED at once.",!
        write !
        do PressToCont^TMGUSRIF
        write !
        write "Q: How do I use the selector?",!
        write "A: The selector is a tool from the VPE library.  It has its",!
        write "   own help.  A quick answer is to move the cursor up and down",!
        write "   and press SPACE to select or deselect a record.  I recommend",!
        write "   using the '+' feature to select all records matching a",!
        write "   specified pattern.",!
        write !
        write "... more later...",!

        do PressToCont^TMGUSRIF
        quit


Fix1Name(IEN)
        ;"Purpose: perform this units fixes for just 1 record
        ;"Input: IEN -- IEN in 22706.9
        ;"results: none

        new temp

        set temp=$$Fix1Dec(IEN)
        set temp=$$Fix1Unit(IEN)
        set temp=$$Norm1Name(IEN)
        set temp=$$Scrub1Dose(IEN)

        quit


FixDecimals
        ;"Purpose: To convert bare decimals (e.g. '.5' --> '0.5') in STRENGTH

        new Itr,IEN,strength,abort,count,newStr
        set abort=0,count=0
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 quit  ;"1=SKIP
        . if $$KeyPressed^TMGUSRIF=27 set abort=1 quit
        . set count=count+$$Fix1Dec(IEN)

        write !,count," records changed",!
        do PressToCont^TMGUSRIF

        quit

Fix1Dec(IEN)
        ;"Purpose: To convert bare decimals (e.g. '.5' --> '0.5') in STRENGTH
        ;"Input: IEN -- IEN in 22706.9
        ;"Results: 1 if modified, 0 if not

        new result set result=0
        set strength=$piece($get(^TMG(22706.9,IEN,0)),"^",2)
        if strength'["." goto F1DD
        set newStr=$$FixNum(strength)
        if newStr'=strength do
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.9,IEN_",",1)=newStr
        . do FILE^DIE("K","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG,.result)

F1DD    quit result


FixUnits
        ;"Purpose: To fix errors in Units (remove spaces, fix hanging decimals)

        new Itr,IEN,strength,abort,count,newStr
        set abort=0,count=0
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . if $$KeyPressed^TMGUSRIF=27 set abort=1 quit
        . if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 quit  ;"1=SKIP
        . set count=count+$$Fix1Unit(IEN)
        write !,count," records changed",!
        do PressToCont^TMGUSRIF

        quit


Fix1Unit(IEN)
        ;"Purpose: To fix errors in Units (remove spaces, fix hanging decimals)
        ;"Input: IEN -- IEN in 22706.9
        ;"Results: 1 if changed, 0 if not

        new result set result=0
         set units=$piece($get(^TMG(22706.9,IEN,0)),"^",3)
         set newStr=$$FixNum(units)
         set newStr=$$Substitute^TMGSTUTL(newStr,"/PER","/")
         set newStr=$$Substitute^TMGSTUTL(newStr,"/VIL","/VIAL")
         set newStr=$translate(newStr," ","")
         if $extract(newStr,$length(newStr))=";" set newStr=$extract(newStr,1,$length(newStr)-1)
         if newStr'=units do
         . new TMGFDA,TMGMSG
         . set TMGFDA(22706.9,IEN_",",2)=newStr
         . do FILE^DIE("K","TMGFDA","TMGMSG")
         . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
         . set result=1

        quit result


FixNum(numStr)
        ;"Purpose: to fix hanging decimals in numStr (e.g. '.5' --> '0.5')
        ;"Input: numStr -- the string to be fixed
        ;"Results: returns fixed string
        new result set result=numStr
        new i for i=1:1:$length(result,".")-1 do
        . new p set p=$$Pos^TMGSTUTL(".",result,i)
        . new priorCh set priorCh=$extract(result,p-1)
        . if +priorCh=priorCh quit
        . if (p=1) do
        . . set result="0"_result
        . else  do
        . . new sA,sB
        . . set sA=$extract(result,1,p-1),sB=$extract(result,p,9999)
        . . set result=sA_"0"_sB

        quit result

Srch5Replace
        ;"Purpose: To provide a mechanism for altering the drug trade names (.05 field)
        ;"        e.g. TETRACYCLINE HYDROCHLORIDE --> TETRACYCLINE HCL
        ;"     or      LISINOPRIL/HYDROCHLOROTHIAZIDE --> LISINOPRIL/HCTZ
        ;"     The reason for this is that many drugs are put in BOTH WAYS, leading to
        ;"     duplicate entries, differing only in the expansion of these words.

        do SrchReplace^TMGMISC(22706.9,.05,"SEARCH & REPLACE in Trade Name of FDA Imported Drugs")
        quit

Srch2Replace
        ;"Purpose: To provide a mechanism for altering the drug UNITS (field 2)
        ;"     The reason for this is that many drugs are put in BOTH WAYS, leading to
        ;"     duplicate entries, differing only in the expansion of these words.

        do SrchReplace^TMGMISC(22706.9,2,"SEARCH & REPLACE in UNITS of FDA Imported Drugs")
        quit

Srch1Replace
        ;"Purpose: To provide a mechanism for altering the drug STRENGTH (field 1)
        ;"     The reason for this is that many drugs are put in BOTH WAYS, leading to
        ;"     duplicate entries, differing only in the expansion of these words.

        do SrchReplace^TMGMISC(22706.9,1,"SEARCH & REPLACE in STRENGTH of FDA Imported Drugs")
        quit


NormalizeNames
        ;"Purpose: To 'normalize' names, meaning replacing common misspellings etc.

        new map  ;"These are numbered to preserve their order
        do SetupMap(.map)

        new Itr,IEN,count
        set count=0
        new abort set abort=0
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 quit  ;"1=SKIP
        . set count=count+$$Norm1Name(IEN,.map)

        do ProgressDone^TMGITR(.Itr)

        write count," Trade names (.05 field) modified.",!
        if count>1 write "Because some changes are interdependant, please run this option again.",!
        do PressToCont^TMGUSRIF

        quit


Norm1Name(IEN,map)
        ;"Purpose: To 'normalize' names, meaning replacing common misspellings etc. for 1 record
        ;"Input: IEN -- IEN in 22706.9
        ;"       map -- OPTIONAL.  Array of changes to be made.  If not provided, then
        ;"              it will be created here.
        ;"Results: 1 if modified, 0 if not

        if $data(map)=0 do SetupMap(.map)

        new result set result=0
        new TradeName set TradeName=$piece($get(^TMG(22706.9,IEN,0)),"^",4) ;"field .05
        new oldName set oldName=TradeName
        new num set num=""
        for  set num=$order(map(num)) quit:(num="")  do
        . set srchS=$order(map(num,"")) quit:(srchS="")
        . if TradeName'[srchS quit
        . write !,srchS,"-->",$get(map(num,srchS)),!
        . set TradeName=$$Substitute^TMGSTUTL(TradeName,srchS,$get(map(num,srchS)))

        if TradeName'=oldName do
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.9,IEN_",",.05)=TradeName
        . do FILE^DIE("K","TMGFDA","TMGMSG")
        . set result=1
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)

        quit result


SetupMap(map)
        ;"Purpose: to set up mapping of spelling corrections to be made.
        ;"Input: map -- PASS BY REFERENCE. An OUT parameter.

        ;"NOTE: These are numbered to preserve their order
        new i set i=0
        set i=i+1,map(i,"SOLUTION")="SOLN"
        set i=i+1,map(i,"OINTMENT")="OINT"
        set i=i+1,map(i,"CAPSULES")="CAP"
        set i=i+1,map(i,"CAPSULE")="CAP"
        set i=i+1,map(i,"TALBETS")="TAB"
        set i=i+1,map(i,"INJECTION")="INJ"
        set i=i+1,map(i,"FOR INJ")="INJ"
        set i=i+1,map(i,"EXTENDED")="EXT"
        set i=i+1,map(i,"RELEASE")="REL"
        set i=i+1,map(i,"INH ")="IHNL "
        set i=i+1,map(i,"INHALATION")="INHL"
        set i=i+1,map(i,"SUSPENSION")="SUSP"
        set i=i+1,map(i,"OPHTHALMIC")="OPHTH"
        set i=i+1,map(i,"HYDROCHLORIDE")="HCL"
        set i=i+1,map(i,"FOR INJECTABLE SUSPENSION")="INJ"
        set i=i+1,map(i,"CODEINE PHOSPHATE")="CODEINE"
        set i=i+1,map(i,"WITH CODEINE")="CODEINE"
        set i=i+1,map(i,"SOLN FOR INJ")="INJ SOLN"
        set i=i+1,map(i,"POWDER FOR INJ")="INJ POWDER"
        set i=i+1,map(i,"SOLN OPHTH")="OPHTH SOLN"
        set i=i+1,map(i," SUFATE")=" SULFATE"
        set i=i+1,map(i,"ALBUTEROL SULFATE")="ALBUTEROL"
        set i=i+1,map(i,"FOR INHL")="INHL"
        set i=i+1,map(i,"SOLN INHL")="INHL SOLN"
        set i=i+1,map(i,"SUSTAINED")="SUST"
        set i=i+1,map(i," BITART ")=" BITARTRATE "
        set i=i+1,map(i," BITARTRATERATER")=" BITARTRATER"
        set i=i+1,map(i," BITARTRATER ")=" BITARTRATE "
        set i=i+1,map(i," BITRATE")=" BITARTRATE"
        set i=i+1,map(i,"BITARTARATE")="BITARTRATE"
        set i=i+1,map(i,"BITARTRATERATE")="BITARTRATE"
        set i=i+1,map(i,"HYDROCODONEARATE")="HYDROCODONE"
        set i=i+1,map(i,"HYDROCODONE ACET")="HYDROCODONE APAP"
        set i=i+1,map(i,"HYDROCODONE BITARTRATE")="HYDROCODONE"
        set i=i+1,map(i,"DIHYDROCODEINE BITARTRATE")="DIHYDROCODEINE"
        set i=i+1,map(i,"WITH HYDROCODONE")="HYDROCODONE"
        set i=i+1,map(i,"SOLN FOR IRRIGATION")="IRRIGATION SOLN"
        set i=i+1,map(i,"CAPLETS")="CAP"
        set i=i+1,map(i,"TABLET")="TAB"
        set i=i+1,map(i,"POWDER")="PWDR"
        set i=i+1,map(i,"TAB EXT REL")="EXT REL TAB"
        set i=i+1,map(i,"SOLN ORAL")="ORAL SOLN"
        set i=i+1,map(i,"TAB SUST REL")="SUST REL TAB"
        set i=i+1,map(i,"RELD ")="REL "
        set i=i+1,map(i,"  ")=" "
        set i=i+1,map(i," SULFATE")=""
        set i=i+1,map(i,"HYDROCHLOROTHIAZIDE")="HCTZ"
        set i=i+1,map(i," AND ")=" "
        set i=i+1,map(i,"HYDROCLORIDE")="HCL"
        set i=i+1,map(i,"HYDROCLOROTHIAZIDE")="HCTZ"
        set i=i+1,map(i,"HYDROCHLORITHIZIDE")="HCTZ"
        set i=i+1,map(i,"HYDROCHLOROHIAZIDE")="HCTZ"
        set i=i+1,map(i,"HYDROCLORTHIAZIDE")="HCTZ"
        set i=i+1,map(i,"HYDROCLORIDE")="HCTZ"
        set i=i+1,map(i,"HYDROCHLORIRDE")="HCTZ"
        set i=i+1,map(i," HCT ")=" HCTZ "
        set i=i+1,map(i,"HYDROCHLORIC ACID")="HCL"
        set i=i+1,map(i,"HYDROCHORIDE")="HCL"
        set i=i+1,map(i,"HYDROCHLORITHIAZIDE")="HCTZ"
        set i=i+1,map(i,"HYDROCHLOROTIAZIDE")="HCTZ"
        set i=i+1,map(i,"HYDROCHOROTHIAZIDE")="HCTZ"
        set i=i+1,map(i,"HYDROCHLOROTHIAZED")="HCTZ"
        set i=i+1,map(i,"HYDROCHLOROYTHIAZIDE")="HCTZ"
        set i=i+1,map(i,"HYDROCHLOROTHIZED")="HCYZ"
        set i=i+1,map(i,"HYDROCHLROTHIAZIDE")=""
        set i=i+1,map(i,"HYDROCHOLRIDE")="HCL"
        set i=i+1,map(i,"HYDROCHOLORIDE")="HCL"
        set i=i+1,map(i,"HYDROCHLORTHIAZIDE")="HCTZ"
        set i=i+1,map(i,"HYDROCHOLIRDE")="HCL"
        set i=i+1,map(i,"HYDROCHLROIDE")="HCL"
        set i=i+1,map(i,"HYDROCHLORIE")="HCL"
        set i=i+1,map(i,"HYDROCHLORINE")="HCL"
        set i=i+1,map(i,"CODIENE")="CODEINE"
        set i=i+1,map(i,"SOLN INJ")="INJ SOLN"
        set i=i+1,map(i,"SUBSTAINED")="SUST"
        set i=i+1,map(i,"SODIM")="SODIUM"
        set i=i+1,map(i,"CAP EXT REL")="EXT REL CAP"
        set i=i+1,map(i,"CAP SUST REL")="SUST REL CAP"
        set i=i+1,map(i,"INHAL ")="INHL "
        set i=i+1,map(i,"FOR ORAL SOLN")="ORAL SOLN"
        set i=i+1,map(i," I V ")=" IV "
        set i=i+1,map(i,"INTRAVENOUS")="IV"
        set i=i+1,map(i,"FOR ORAL SUSP")="ORAL SUSP"
        set i=i+1,map(i,"CAPLET")="CAP"
        set i=i+1,map(i,"WITH HCTZ")="HCTZ"
        set i=i+1,map(i," HCL ")=" "
        set i=i+1,map(i," HCL/")=""
        set i=i+1,map(i,"SUST REL")="SR"
        set i=i+1,map(i,"SR SR")="SR"
        set i=i+1,map(i,"SUPENSION")="SUSP"
        set i=i+1,map(i,"FOR SUSP")="SUSP"
        set i=i+1,map(i,"SUSP ORAL")="ORAL SUSP"
        set i=i+1,map(i," USP")=""
        set i=i+1,map(i,"PHOSPHATE")="PHOS"
        set i=i+1,map(i,"PHOSPHATES")="PHOS"
        set i=i+1,map(i,"METROPROLOL")="METOPROLOL"
        set i=i+1,map(i,"EXT-REL")="EXT REL"
        set i=i+1,map(i," HCLT")=" HCL"
        set i=i+1,map(i," HCLM")=" HCL"
        set i=i+1,map(i," HCL")=""
        set i=i+1,map(i,"INJECTABLE")="INJ"
        set i=i+1,map(i,"HYDROCHODONE")="HYDROCODONE"
        set i=i+1,map(i,"HYDROCHLOROTHAZIDE")="HCTZ"
        set i=i+1,map(i,"HYDROCHLOROIDE")="HCL"
        set i=i+1,map(i,"SODIUM CHLORIDE")="NACL"
        set i=i+1,map(i," NAD ")=" AND "
        set i=i+1,map(i," SODIUM")=""
        set i=i+1,map(i,"LEVOYHYROXINE")="LEVOTHYROXINE"
        set i=i+1,map(i," ACETAMINOPHEN")=" APAP"
        set i=i+1,map(i,"NAPSLATE")="NAPSYLATE"
        set i=i+1,map(i,"NAPSULATE")="NAPSYLATE"
        set i=i+1,map(i," NAPSYLATE")=""
        set i=i+1,map(i,"DARVOCET-N")="DARVOCET N"
        set i=i+1,map(i,"PROPOX NAP")="PROPOXYPHENE"
        set i=i+1,map(i,"PROPOX ")="PROPOXYPHENE "
        set i=i+1,map(i,"PROPOXY ")="PROPOXYPHENE "
        set i=i+1,map(i,"PROPOXYPHEN ")="PROPOXYPHENE "
        set i=i+1,map(i,"PROPACET ")="PROPOXYPHENE APAP "
        set i=i+1,map(i,"CLAULNATE ")="CLAVULANATE "
        set i=i+1,map(i,"ASPPIRIN ")="ASPIRIN "

        set i=i+1,map(i," &")=""
        set i=i+1,map(i," / ")=" "
        set i=i+1,map(i," CAFFINE")=" CAFFEINE"
        set i=i+1,map(i,"MGAPAP")="MG APAP"
        set i=i+1,map(i,"5MG")="5 MG"
        set i=i+1,map(i,"0MG")="0 MG"

        quit


ScrubDoses
        ;"Purpose: To remove doses from Tradename
        ;"

        new skips,ignore,PreSelArray
        do SetScrubMaps(.skips,.ignore)

        new Itr,IEN,count
        set count=0
        new abort set abort=0
        write "Gathering a list of suggested name changes, removing #'s and doses...",!
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . set count=count+$$Scrub1Dose(IEN,.skips,.ignore,0,.PreSelArray)
        do ProgressDone^TMGITR(.Itr)

        if $data(PreSelArray)=0 goto SDDone
        new DelArray
        do SelRxList("PreSelArray","DelArray","SELECT ALLOWED NAME CHANGES (COLUMN 1=OLD,2=NEW) ESC ESC WHEN DONE",3)
        if $data(DelArray)=0 goto SDDone

        new NewName set NewName=""
        for  set NewName=$order(DelArray(NewName)) quit:(NewName="")  do
        . new IEN set IEN=0
        . for  set IEN=$order(DelArray(NewName,IEN)) quit:(+IEN'>0)  do
        . . new TMGFDA,TMGMSG
        . . set TMGFDA(22706.9,IEN_",",.05)=NewName
        . . do FILE^DIE("K","TMGFDA","TMGMSG")
        . . set count=count+1
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)

SDDone
        write count," Trade names (.05 field) modified.",!
        do PressToCont^TMGUSRIF

        quit


Scrub1Dose(IEN,skips,ignore,askuser,PreSelArray)
        ;"Purpose: To remove doses from Tradename from 1 record
        ;"Input: skips -- PASS BY REFERENCE.  OPTIONAL
        ;"       ignore -- PASS BY REFERENCE.  OPTIONAL
        ;"       askuser -- if 1, then user is asked.  Default=1
        ;"                  Otherwise, PreSelArray is filled with questions for user
        ;"       PreSelArray -- PASS BY REFERENCE.  OPTIONAL
        ;"Results: 1 if modified, 0 if not (including options put into PreSelArray)

        new result set result=0
        if ($data(skips)=0)!($data(ignore)=0) do
        . kill skips,ignore
        . do SetScrubMaps(.skips,.ignore)
        set askuser=+$get(askuser,1)

        new TradeName set TradeName=$piece($get(^TMG(22706.9,IEN,0)),"^",4) ;"field .05
        new j set j=0
        new ignore1 set ignore1=0
        for  set j=$order(ignore(j)) quit:(j="")  do
        . if TradeName[ignore(j) set ignore1=1
        if ignore1 goto S1DD
        set j=0
        for  set j=$order(skips(j)) quit:(j="")  do
        . new srchS set srchS=$get(skips(j))
        . if TradeName'[srchS quit
        . set TradeName=$$Substitute^TMGSTUTL(TradeName,srchS,"@@@"_$char(64+j)_"@@@")
        new oldName set oldName=TradeName
        set TradeName=$$ScrubNumeric^TMGSTUTL(TradeName)
        if TradeName=oldName goto S1DD
        if TradeName="" goto S1DD
        if TradeName["@@@" do
        . new j set j=$ascii($piece(TradeName,"@@@",2))-64
        . set TradeName=$piece(TradeName,"@@@",1)_$get(skips(j))_$piece(TradeName,"@@@",3)
        . set oldName=$piece(oldName,"@@@",1)_$get(skips(j))_$piece(oldName,"@@@",3)
        ;"
        if askuser'=1 set PreSelArray(TradeName,IEN)="" goto S1DD  ;"bypass user asking...
        ;"------------------
        write !,IEN,": '",oldName,"' --> '",TradeName,"'",!
        new % set %=2
        write "Accept Change" do YN^DICN write !
        if %=-1 set abort=1 goto S1DD
        if %'=1 goto S1DD
        if TradeName'=oldName do
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.9,IEN_",",.05)=TradeName
        . do FILE^DIE("K","TMGFDA","TMGMSG")
        . set result=1
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)

S1DD    quit result


SetScrubMaps(skips,ignore)
        ;"Purpose: setup arrays for removing doses from Tradename
        ;"Input: skips -- PASS BY REFERENCE
        ;"       ignore -- PASS BY REFERENCE
        ;"result

        new i
        set i=0  ;"NOTE!!! ASCII encoding only allow i up to 63!!
        set i=i+1,skips(i)="5% DEXTROSE"
        set i=i+1,skips(i)="5 % DEXTROSE"
        set i=i+1,skips(i)="10% DEXTROSE"
        set i=i+1,skips(i)="0.9% NA"
        set i=i+1,skips(i)=".9% NA"
        set i=i+1,skips(i)="0.45% NA"
        set i=i+1,skips(i)="7 7 7"
        set i=i+1,skips(i)="70 30"
        set i=i+1,skips(i)="7.4"
        set i=i+1,skips(i)="3 MONTH"
        set i=i+1,skips(i)="4 MONTH"
        set i=i+1,skips(i)="28 TAB"
        set i=i+1,skips(i)="I 131"
        set i=i+1,skips(i)="I-131"
        set i=i+1,skips(i)="I 123"
        set i=i+1,skips(i)="7 VAGINAL"
        set i=i+1,skips(i)="3 VAGINAL"
        set i=i+1,skips(i)="0.3% NACL"
        set i=i+1,skips(i)="0.2% NACL"
        set i=i+1,skips(i)="B12"
        set i=i+1,skips(i)="B6"
        set i=i+1,skips(i)="TC 99M"
        set i=i+1,skips(i)="TC99M"
        set i=i+1,skips(i)="THEO 24"
        set i=i+1,skips(i)="24 H"
        set i=i+1,skips(i)="12 H"
        set i=i+1,skips(i)=" 12 "
        set i=i+1,skips(i)=" 24 "
        set i=i+1,skips(i)="VITAMIN K1"
        set i=i+1,skips(i)="PH7"

        ;"Put entries here when the presence of a word is enough to ignore entire drug name.
        ;"if TradeName[ingore(x) then no further check done
        set i=0  ;"no limit on # here...
        set i=i+1,ignore(i)="TERAZOL"
        set i=i+1,ignore(i)="ORTHO "
        set i=i+1,ignore(i)="DARVOCET"
        set i=i+1,ignore(i)="DEMULEN"
        set i=i+1,ignore(i)="LEVLEN"
        set i=i+1,ignore(i)="LEVLITE"
        set i=i+1,ignore(i)="LOESTRIN"
        set i=i+1,ignore(i)="NECON"
        set i=i+1,ignore(i)=" MT "
        set i=i+1,ignore(i)="ORTHOCEPT"
        set i=i+1,ignore(i)="GYNAZOLE"
        set i=i+1,ignore(i)="OVCON"
        set i=i+1,ignore(i)="MONISTAT"
        set i=i+1,ignore(i)="MICROGESTIN"
        set i=i+1,ignore(i)="ULTRASE"
        set i=i+1,ignore(i)="MTE "
        set i=i+1,ignore(i)="M T E "
        set i=i+1,ignore(i)="INSULIN"

        quit


CautionMsg
        ;"Purpose: To show a caution message.

        write !,"**NOTICE**",!
        write "This will use the MULTI-selector to pick imports to be",!
        write "be edited.  BE VERY CAREFUL not to select more than one",!
        write "drug before exiting to enter the edit screen.",!
        write "For example:  If 3 different drugs were selected, and then",!
        write "ESC ESC pressed, then one will be presented with an opportunity",!
        write "to edit the drug name.  BUT NOTE: one would be editing ALL THREE",!
        write "drugs AT ONCE, very likely creating an error in 2 of the drugs.",!
        write !

        do PressToCont^TMGUSRIF
        quit


EditTradename(SkipValue)
        ;"Purpose: to select records to mark as to be skipped.
        ;"Input: SkipValue: OPTIONAL. Default=0.
        ;"              0=show only values NOT marked to be skipped
        ;"              1=show only values MARKED to be skipped
        ;"              ALL=show BOTH skip and non-skipped fields.
        ;"Output: User may alter the value of SKIP THIS RECORD field for all records
        ;"Results: none

        do CautionMsg

        new Options,IEN
        set Options("FIELDS",1)=".04^LONG NAME^25"
        set Options("FIELDS",1,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",2)=".05^TRADENAME^64"
        set Options("FIELDS","MAX NUM")=2
        set Options("FILE")="22706.9^TMG FDA IMPORT COMPILED"

        set SkipValue=$get(SkipValue,0)  ;"0=NOT SKIPPED
        ;"Get all records with chosed SKIP THIS RECORD value
        do GetFldValue^TMGSELED(22706.9,6,SkipValue,$name(Options("IEN LIST")))

PSK1    if $$SELED^TMGSELED(.Options)'=2 goto ETNDone
        if $$GetIENs^TMGSELED(.Options)=0 goto ETNDone
        goto PSK1

ETNDone quit




SelRxList(pList,pSelList,HdrText,mode)
        ;"Purpose: To display the Drug list, and allow user to select from the list.
        ;"Input: pList -- PASS BY NAME -- list of drugs to be added, as created by FillList(pList)
        ;"                   @pList@(drugName,IEN)=""
        ;"       pSelList -- PASS BY NAME, an OUT PARAMETER.
        ;"              Returns list of selected items
        ;"                   @pSelList@(drugName,IEN)=""  ;IEN is from 22706.9
        ;"                   @pSelList@(drugName,IEN)=""
        ;"       HdrText -- optional, some text to show on top of selector
        ;"       mode -- OPTIONAL.  Default=1
        ;"                 1 --> Display by LONG NAME  .04 name
        ;"                 2 --> Display by VA PRODUCT (50.68) .01 name
        ;"                 3 --> Display by FDA import name
        ;"                 4 --> Display by VA GENERIC name

        ;"Results: none

        new ref set ref="^TMP(""VEE"",$J)"
        kill @ref
        new count set count=1
        set mode=$get(mode,1)

        ;"new pNDCIndex set pNDCIndex=$$GetNDCIndex^TMGNDF4A(1)

        write "Prepping to display list...",!
        ;"First convert list to a display format
        new name,IEN,Itr

        set name=$$ItrAInit^TMGITR(pList,.Itr)
        do PrepProgress^TMGITR(.Itr,20,1,"name")
        if name'="" for  do  quit:($$ItrANext^TMGITR(.Itr,.name)="")
        . new addedArray,showName
        . set IEN=0
        . for  set IEN=$order(@pList@(name,IEN)) quit:(IEN="")  do
        . . new NameInfo do GetInfo^TMGNDF3B(IEN,.NameInfo)
        . . new IdxName set IdxName=$get(NameInfo("MODES",mode))
        . . if mode=3 do  ;"Display by FDA import name (TradeName)
        . . . set showName=""
        . . . for  set showName=$order(NameInfo(IdxName,showName)) quit:(showName="")  do
        . . . . set @ref@(count)=name_"^"_IEN_$char(9)
        . . . . new newShowName set newShowName=$extract(showName,1,35)
        . . . . set newShowName=$$LJ^XLFSTR(newShowName,35," ")
        . . . . new newName set newName=$extract(name,1,35)
        . . . . set newName=$$LJ^XLFSTR(newName,35," ")
        . . . . set @ref@(count)=@ref@(count)_newShowName_"|"_newName
        . . . . set count=count+1
        . . . set showName=""  ;"prevent duplicate addition below
        . . else  if (mode>0)&(mode<5) set showName=$order(NameInfo(IdxName,""))
        . . if (showName'="") set @ref@(count)=name_"^"_IEN_$char(9)_showName set count=count+1

        set @ref@("HD")=$get(HdrText,"MENU")

        ;"Note: Rules of use:
        ;"  ref must=^TMP("VEE",$J)
        ;"  Each line should be in this format:
        ;"      @ref@(number)=ReturnValue_$char(9)_DisplayValue
        ;"      @ref@(number)=ReturnValue_$char(9)_DisplayValue
        ;"      @ref@(number)=ReturnValue_$char(9)_DisplayValue
        ;"  Results come back in:
        ;"      ^TMP("VPE","SELECT",$J,number)=ReturnValue_$char(9)_DisplayValue
        ;"      ^TMP("VPE","SELECT",$J,number)=ReturnValue_$char(9)_DisplayValue
        ;"      ^TMP("VPE","SELECT",$J,number)=ReturnValue_$char(9)_DisplayValue

        write !,"Passing off to Selector..."
        D SELECT^%ZVEMKT(ref)

        set ref="^TMP(""VPE"",""SELECT"","_$J_")"
        new number set number=""
        for  set number=$order(@ref@(number)) quit:(number="")  do
        . new ReturnValue set ReturnValue=$piece(@ref@(number),$char(9),1)
        . new drugName set drugName=$piece(ReturnValue,"^",1)
        . new IEN set IEN=$piece(ReturnValue,"^",2)
        . set @pSelList@(drugName,IEN)=""

        quit

 ;"========================================================
PickEdit
        ;"Purpose: ask user to pick record, and then edit.

        new DIC,X,Y
        set DIC=22706.9
        set DIC(0)="MAEQ"
        set DIC("A")="Enter Imported Drug to Edit (^ to abort): "
PE1
        do ^DIC write !
        if +Y>0 do Edit1(+Y) goto PE1

        quit


Edit1(IEN)
        ;"Purpose: To edit one record in 22706.9
        ;"Input: IEN -- IEN in 22706.9
        ;"Results: none

        new Options,IENlist
        set IENlist(IEN)=""
        set Options("FILE")=22706.9
        new temp
        set temp=$$GetFields^TMGSELED(.Options)
        if temp=1 set temp=$$EditRecs^TMGSELED("IENlist",.Options)

        quit


