TMGRPC1D ;TMG/kst-RPC Functions ;07/21/10
         ;;1.0;TMG-LIB;**1**;07/21/10

 ;"TMG RPC FUNCTIONS especially related to imaging.

 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"7/21/10

 ;"=======================================================================
 ;" RPC -- Public Functions.
 ;"=======================================================================
 ;"CONFIG -- Set up imaging site parameters, so that TMG-CPRS works.
 ;"TESTCFG -- Test configuration
 ;"=======================================================================
 ;"PRIVATE API FUNCTIONS
 ;"=======================================================================
 ;"PINST1 - entry point for POST-INSTALL routine for patch TMG-CPRS-IMAGING*1.0*1
 ;
 ;"=======================================================================
 ;"Dependancies: TMGKERNL,TMGUSRIF
 ;"=======================================================================
 ;
CONFIG ;
        ;"Purpose: Set up imaging site parameters, so that TMG-CPRS works.
        ;"Input: None
        ;"Results: none
        ;
        WRITE "   ------------------------------------------",!
        WRITE "   -      Configuration of TMG Imaging      -",!      
        WRITE "   ------------------------------------------",!,!
        ;
        ;"First get default INSTITUTION, stored in KERNEL SYSTEM PARAMETERS file.
        NEW %,DA,DR,DIE,DIC,X,Y,DIK
        NEW TMGFDA,TMGMSG,TMGDIV,TMGDROP,TMGSTORE,TMGNODIV
        NEW INSTPTR,IMGSPPTR 
CF1     SET INSTPTR=+$PIECE($GET(^XTV(8989.3,1,"XUS")),"^",17)  ;"Ptr to file $4 (Institution)
        IF INSTPTR>0 DO  GOTO CF2
        . WRITE "Using DEFAULT INSTITUTION: ",$$GET1^DIQ(4,INSTPTR,.01),!  
        WRITE "No value for DEFAULT INSTITUTION found in field 217 in file KERNEL SYSTEM PARAMETERS",!
        WRITE "Edit settings now to correct this"
        SET %=1 DO YN^DICN WRITE !
        IF %'=1 GOTO CFDN
        SET DA=1,DR="[XUSITEPARM]",DIE=8989.3 
        DO XUDIE^XUS5  ;"Launch screenman form to edit KERNEL SYSTEM PARAMETERS.        
        GOTO CF1
        ;
CF2     ;"Now get IMAGING SITE PARAMETERS for Institution Name
        SET IMGSPPTR=+$ORDER(^MAG(2006.1,"B",INSTPTR,0))
        IF IMGSPPTR>0 DO  GOTO CF3
        . WRITE "Using IMAGING SITE PARAMETERS IEN #",IMGSPPTR,", "
        . WRITE $$GET1^DIQ(2006.1,IMGSPPTR,.01),!
        WRITE "Next, a entry in IMAGING SITE PARAMENTERS file must be linked in.",!
        WRITE "Please select entry to use, or add a new one if needed.",!
        DO PRESSTOCONT^TMGUSRIF
        SET DIC=2006.1,DIC(0)="MAEQL"
        DO ^DIC WRITE !
        IF Y>-1 SET IMGSPPTR=+Y GOTO CF2B
        WRITE "Valid entry in IMAGING SITE PARAMETERS file not selected.",!
        SET %=1
        WRITE "Start over" DO YN^DICN WRITE !
        IF %=1 GOTO CF1
        GOTO ABORT
CF2B    KILL TMGFDA,TMGMSG
        SET TMGFDA(2006.1,IMGSPPTR_",",.01)=INSTPTR
        DO FILE^DIE("K","TMGFDA","TMGMSG")
        IF $DATA(TMGMSG("DIERR")) DO  GOTO ABORT
        . DO ShowDIERR^TMGDEBUG(.TMGMSG)        
        GOTO CF2 ;"loop back just be sure the B index is setup.
        ;
CF3     ;"Now get NETWORK LOCATION stored in IMAGING SITE PARAMETERS record
        NEW LOCPTR SET LOCPTR=+$PIECE($GET(^MAG(2006.1,IMGSPPTR,0)),"^",3)
        IF LOCPTR>0 DO  GOTO CF4
        . WRITE "Using NETWORK LOCATION IEN #",LOCPTR,", "
        . WRITE $$GET1^DIQ(2005.2,LOCPTR,.01),!
        WRITE "Next, a entry in NETWORK LOCATION file must be linked in.",!
        WRITE "Please select entry to use, or add a new one if needed.",!
        DO PRESSTOCONT^TMGUSRIF
        SET DIC=2005.1,DIC(0)="MAEQL"
        IF Y>-1 SET LOCPTR=+Y GOTO CF4
        WRITE "Valid entry in NETWORK LOCATION file not selected.",!
        SET %=1
        WRITE "Start over" DO YN^DICN WRITE !
        IF %=1 GOTO CF1
        GOTO ABORT
        ;
CF4     ;"Now set up NETWORK LOCATION file.
        WRITE !,"A NODE DIVIDER is the symbol used to separt folders in a path",!
        WRITE "E.g. for UNIX, with a sample path of '/opt/var/me',  uses '/'",!
        WRITE "For Windows, with sample path of 'c:\temp\me', uses '\'",!                
        SET %=1,TMGNODIV=0
        SET TMGDIV=$$GET1^DIQ(2005.2,LOCPTR,22701)
        IF TMGDIV'="" DO
        . WRITE "Current Node divider= '",TMGDIV,"'"
        . SET %=2
        . IF TMGDIV="/" WRITE " (UNIX filesystem)",!
        . ELSE  IF TMGDIV="\" WRITE " (WINDOWS filesystem)",!
        . ELSE  WRITE " (?? filesystem)",! SET %=1
        WRITE "Do you want to specify a NODE DIVIDER" DO YN^DICN WRITE !
        IF %=-1 GOTO ABORT
        IF %=2 SET TMGNODIV=1 GOTO CF4A
        ;
        WRITE "Is the server running on a Linux/Unix box" DO YN^DICN WRITE !       
        IF %=-1 GOTO ABORT
        IF %=1 SET TMGDIV="/"
        ELSE  SET TMGDIV="\"
        ;
CF4A    WRITE !,"A DROPBOX is a file folder where the server may place files for",!
        WRITE "pick up by a client (i.e. CPRS).  This folder could be on a ",!
        WRITE "separate file system (e.g. a windows file system mounted into",!
        WRITE "the server file system.)  This is a security measure that negates",!
        WRITE "a need for the client to have read access to the entire images",!
        WRITE "folder.  A dropbox path is only required if client is configured",!
        WRITE "to use it.",!
        SET %=1
        SET TMGDROP=$$GET1^DIQ(2005.2,LOCPTR,22702)
        IF TMGDROP'="" DO
        . WRITE "Current DROPBOX: ",TMGDROP,!,!
        . SET %=2
        WRITE "Do you want to specify a DROPBOX FOLDER" DO YN^DICN WRITE !
        IF %=-1 GOTO ABORT
        IF %=2 SET TMGDROP="" GOTO CF4C
        ;
CF4B    WRITE "Enter full path of the DROPBOX is it would be accessed on the ",!
        WRITE "server (**NOT the path that the client would use**)",!
        READ "Enter full DROPBOX path (^ to abort): ",TMGDROP:DTIME,!
        IF TMGDROP="^" GOTO ABORT
        IF TMGDROP="" WRITE ! GOTO CF4A
        IF $$IsDir^TMGKERNL(TMGDROP,TMGDIV)=1 GOTO CF4B
        WRITE "ERROR: Path specified is not valid.  Does folder exist?",!,!
        GOTO CF4B
        ;        
CF4C    WRITE !,"A STORE PATH is the file folder that the server will use to",!
        WRITE "store images.  This should be a complete and valid path.",!
        SET %=1
        SET TMGSTORE=$$GET1^DIQ(2005.2,LOCPTR,22700)
        IF TMGSTORE'="" DO
        . WRITE "Current image file storage path: ",TMGSTORE,!
        . SET %=2
        WRITE "Do you want to specify a STORE FOLDER" DO YN^DICN WRITE !
        IF %=-1 GOTO ABORT
        IF %=2 SET TMGSTORE="" GOTO CF4D
        ;        
        READ "Enter store path (^ to abort): ",TMGSTORE:DTIME,!
        IF TMGDROP="^" GOTO ABORT
        IF TMGSTORE="" WRITE ! GOTO CF4C
        IF $$IsDir^TMGKERNL(TMGSTORE,TMGDIV)=1 GOTO CF4D
        WRITE "ERROR: Path specified is not valid.  Does folder exist?",!,!
        GOTO CF4C
        ;
CF4D    ;"Next force field 1 (PHYSICAL REFERENCE) to be same as TMGDIV
        IF $PIECE($GET(^MAG(2005.2,LOCPTR,0)),"^",2)=TMGDIV GOTO CF4E
        SET DIK="^MAG(2005.2,"
        SET DA=LOCPTR
        DO ^DIK  ;"Kill prior entry.  Leaves DIK and DA unchanged
        ;"Note: Input transform doesn't allow the value I put in here.
        SET $PIECE(^MAG(2005.2,LOCPTR,0),"^",2)=TMGDIV ;"NOTE!! Low-level write
        SET DIK(1)=1 ;"Field 1 = PHYSICAL REFERENCE
        DO EN^DIK ;"Reindex field, to populate crossrefences with new value.
        ;
CF4E    KILL TMGFDA,TMGMSG
        IF TMGSTORE'="" SET TMGFDA(2005.2,LOCPTR_",",22700)=TMGSTORE
        IF TMGNODIV=0 SET TMGFDA(2005.2,LOCPTR_",",22701)=TMGDIV
        IF TMGDROP'="" SET TMGFDA(2005.2,LOCPTR_",",22702)=TMGDROP
        IF $DATA(TMGFDA) DO FILE^DIE("K","TMGFDA","TMGMSG")
        IF $DATA(TMGMSG("DIERR")) DO  GOTO ABORT
        . DO ShowDIERR^TMGDEBUG(.TMGMSG)
        WRITE !,"Done with configuration.",!,!        
        DO TESTCFG
        GOTO CFDN
        ;
ABORT   WRITE "Aborting configuration process.",!
        WRITE "Try again later, using 'DO CONFIG^TMGRPC1D'",!      
CFDN    QUIT  
        ;
        ;
TESTCFG ;
        ;"Purpose: Test configuration
        NEW LOCPTR SET LOCPTR=$$GETDEFNL^TMGRPC1C()
        IF LOCPTR'>0 DO  QUIT
        . WRITE "ERROR: Can't find NETWORK LOCATION to use",!
        WRITE "Storage path: ",$$GETLOCFPATH^TMGRPC1C("/"),!
        NEW DROPPATH
        IF $$GETDROPPATH^TMGRPC1C(LOCPTR,.DROPPATH)=-1 DO  QUIT
        . WRITE "ERROR: Unable to get Dropbox path",!
        WRITE "Dropbox path: ",DROPPATH,!
        QUIT
        ;
PINST1 ;
        ;"Purpose: This is an entry point for POST-INSTALL routine for patch
        ;"         TMG-CPRS-IMAGING*1.0*1
        DO ENSUREAL^TMGRPC1B
        DO CONFIG
        QUIT
        ;
