TMGRPC3 ;TMG/kst/RPC Functions for GUI_Config ;07/20/08, 7/7/10
         ;;1.0;TMG-LIB;**1**;08/31/08
 ;
 ;"TMG RPC FUNCTIONS for a GUI config program
 ;
 ;"Kevin Toppenberg MD
 ;"GNU Lessor General Public License (LGPL) applies
 ;"7/20/08
 ;
 ;"=======================================================================
 ;" RPC -- Public Functions.
 ;"=======================================================================
 ;"CHANNEL(TMGRESULT,INPUT) -- general purpose channel RPC from a GUI config program
 ;
 ;"=======================================================================
 ;"Dependencies:
 ;"  TMGRPC3* only
 ;
 ;"=======================================================================
 ;
CHANNEL(TMGRESULT,INPUT) ;
        ;"Purpose: This will be a general purpose channel RPC from a GUI config program
        ;"Input: TMGRESULT -- this is an OUT parameter, and it is always passed by reference
        ;"       INPUT -- this will be array of data sent from the GUI client.  Defined below:
        ;"            <Stuff will go here>
        ;"            INPUT("REQUEST")="cmd^params"  Valid values for "cmd" are:
        ;"              "GET USER LIST"
        ;"                   params: <empty> or NODISUSER
        ;"              "GET RECORDS LIST"  -- get list of all .01 fields for file.
        ;"                   params: FileNumber  (e.g. 'GET RECORDS LIST^8989.3')
        ;"              "GET ONE USER"
        ;"                   params: IEN (e.g. 'GET ONE USER^12345')
        ;"              "GET ONE RECORD"
        ;"                   params: FileNum^IENS (e.g. 'GET ONE RECORD^200^73,')
        ;"              "GET ONE WP FIELD"
        ;"                   params: FileNum^Field^IENS^ (e.g. 'GET ONE WP FIELD^200^2^73,')
        ;"              "FILE ENTRY SUBSET"
        ;"                   params: FileNum^ListStartValue^direction^MaxCount(optional, def=44)
        ;"              "GET SUB RECS LIST"  -- get all .01 sub record entries for a subfile
        ;"                   params: SubFileNum^ParentIENS
        ;"              "POST DATA"
        ;"                   params: (not used)
        ;"                   INPUT(0)=FileNum^IENS^FieldNum^FieldName^newValue^oldValue
        ;"                   INPUT(1)=FileNum^IENS^FieldNum^FieldName^newValue^oldValue
        ;"                   ...    (note: FieldName and oldValue are not used)
        ;"              "POST WP FIELD"
        ;"                   params: FileNum^FieldNum^IENS (e.g. 'POST WP FIELD^200^2^73,')
        ;"                   WP field itself is stored as follows:
        ;"                   INPUT(0)=0TH line
        ;"                   INPUT(1)=1st line
        ;"                   INPUT(2)=2nd line
        ;"                   ...
        ;"                   Note: don't include INPUT("REQUEST") with text.
        ;"              "GET EMPTY ENTRY"  -- getting stub entries for subfiles typically
        ;"                   params: file entry (file or subfile number)
        ;"              "GET CURRENT USER NAME" -- return name of DUZ (current) user
        ;"                   (params: not used)
        ;"              "CLONE USER"
        ;"                   params: SourceIENS^New.01Value
        ;"              "CLONE RECORD"
        ;"                   params: FileNum^SourceIENS^New.01Value
        ;"              "GET HELP MSG"
        ;"                   params     : FileNum^FieldNum^HelpType^IENS
        ;"              "IS WP FIELD"
        ;"                   params: FileNum^FieldNum
        ;"              "GET ONE WP FIELD" -- retrieve on word processing (WP) field entry
        ;"                   param -- FileNum^Field^IENS (e.g. 'GET ONE WP FIELD^200^2^73,')
        ;"              "REGISTER PATIENT"
        ;"                   param -- FieldNum1^FieldValue1^FieldNum2^FieldValue2^FieldNum3^FieldValue3^...
        ;"Output: results of this function should be put into TMGRESULTS array.
        ;"        For cmd:
        ;"          "GET USER LIST"
        ;"            TMGRESULT(0)="1^Success" or "-1^Message"
        ;"            TMGRESULT(1)=Name^IEN^200^DISUSER   DISUSER will be 1 for "Y" or 0 for "N"
        ;"            TMGRESULT(2)=Name^IEN^200^DISUSER
        ;"            etc ...
        ;"          "GET RECORDS LIST"
        ;"            TMGRESULT(0)="1^Success" or "-1^Message"
        ;"            TMGRESULT(1)=.01Value^IEN^FileNum
        ;"            TMGRESULT(2)=.01Value^IEN^FileNum
        ;"            etc ...
        ;"          "GET ONE USER"
        ;"            TMGRESULT(0)="1^Success" or "-1^Message"
        ;"            TMGRESULT(1)=File^IENS^FieldNum^ExternalValue^DDInfo...
        ;"            TMGRESULT(2)=File^IENS^FieldNum^ExternalValue^DDInfo...
        ;"            etc ...
        ;"          "GET ONE RECORD"
        ;"            TMGRESULT(0)="1^Success" or "-1^Message"
        ;"            TMGRESULT(1)=File^IENS^FieldNum^ExternalValue^DDInfo...
        ;"            TMGRESULT(2)=File^IENS^FieldNum^ExternalValue^DDInfo...
        ;"            ...
        ;"          "GET ONE WP FIELD"
        ;"            TMGRESULT(0): "1^Success" or "-1^Message"
        ;"            TMGRESULT(1) will contain Fileman error, if any
        ;"            - or to return WP array -
        ;"            TMGRESULT(1)=1st line of text
        ;"            TMGRESULT(2)=2nd line of text
        ;"            etc..
        ;"          "FILE ENTRY SUBSET"
        ;"            TMGRESULT(0)="1^Success" or "-1^Message"
        ;"            TMGRESULT(1)=Value
        ;"            TMGRESULT(2)=Value
        ;"            etc ...
        ;"          "GET SUB RECS LIST"
        ;"            TMGRESULT(0)="1^Success" or "-1^Message"
        ;"            TMGRESULT(1)=IEN^Value
        ;"            TMGRESULT(2)=IEN^Value
        ;"            ...
        ;"          "POST DATA"
        ;"            TMGRESULT(0)="1^Success" or "-1^Message"
        ;"            TMGRESULT(1)=Fileman message (long) (if generated)
        ;"            -or (if +1 etc values used)-
        ;"            TMGRESULT(1)=+5^1234  <--  results of IEN array returned (+5 converted to record 1234)
        ;"            TMGRESULT(2)=+3^2341  <--  results of IEN array returned (+3 converted to record 2341)
        ;"            ...
        ;"          "GET EMPTY ENTRY"
        ;"            TMGRESULT(0)="1^Success" or "-1^Message"
        ;"            TMGRESULT(1)=File^^FieldNum^^DDInfo...
        ;"            TMGRESULT(2)=File^^FieldNum^^DDInfo...
        ;"            etc ...
        ;"          "GET CURRENT USER NAME" -- return name of DUZ (current) user
        ;"            TMGRESULT(0)="1^Success^UserName" or "-1^Message"
        ;"          "CLONE USER"
        ;"            TMGRESULT(0)="1^Success^NewIENS" or "-1^Message"
        ;"            TMGRESULT(1)=Long Fileman message (if -1 error)
        ;"          "CLONE RECORD"
        ;"            TMGRESULT(0)="1^Success^NewIENS" or "-1^Message"
        ;"            TMGRESULT(1)=Fileman message (long) (if generated)
        ;"          "GET HELP MSG"
        ;"            TMGRESULT(0)="1^Success^NewIENS" or "-1^Message"
        ;"            TMGRESULT(1)=Fileman message (long) (if generated)
        ;"          "IS WP FIELD"
        ;"            TMGRESULT(0)="1^Success^YES/NO" or "-1^Message"
        ;"            "YES" if is a WP subfile, otherwise "NO"
        ;"            TMGRESULT(1)=Fileman message (long) (if generated)
        ;"          "REGISTER PATIENT"
        ;"            TMGRESULT(0)="1^Success^NewIEN" or
        ;"                         "-1^Message"    Frank failure...  or
        ;"                         "0^BoolAndMessage^NewIEN".  Format:
        ;"                       [Bool1;Bool2;Bool3;Bool4;Bool5*MessageText]  (e.g. '1;0;1;0;0*ErrorMsg')
        ;"                         (for Bool fields, 0=no or 1=yes)
        ;"                         Bool1 -- patient had previously been registered
        ;"                         Bool2 -- patient registered during this Fn
        ;"                         Bool3 -- problem filing data into non-identifier fields
        ;"                         Bool4 -- problem filing data into sub-file fields
        ;"                         Bool5 -- problem with filing HRN
        ;"            TMGRESULT(1)=Long Fileman message (if -1 error, or perhaps 0 code)

 ;
        ;"Result: none
 ;
        NEW TMGCOMMAND,TMGCOMMAND
        SET TMGCOMMAND=$$TRIM^XLFSTR($$UP^XLFSTR($PIECE($GET(INPUT("REQUEST")),"^",1)))
        SET TMGPARAMS=$$UP^XLFSTR($PIECE($GET(INPUT("REQUEST")),"^",2,199))
        SET TMGRESULT(0)="-1^No command requested."  ;"default to error state.
        IF TMGCOMMAND="GET USER LIST" DO
        . DO GETUSRLT^TMGRPC3B(.TMGRESULT,TMGPARAMS)
        IF TMGCOMMAND="GET RECORDS LIST" DO
        . DO GETRECLT^TMGRPC3B(.TMGRESULT,TMGPARAMS)
        ELSE  IF TMGCOMMAND="GET ONE USER" DO
        . DO GET1USER^TMGRPC3B(.TMGRESULT,TMGPARAMS)
        ELSE  IF TMGCOMMAND="GET ONE RECORD" DO
        . DO GET1REC^TMGRPC3B(.TMGRESULT,TMGPARAMS)
        ELSE  IF TMGCOMMAND="FILE ENTRY SUBSET" DO
        . DO GFLSUBST^TMGRPC3B(.TMGRESULT,TMGPARAMS)
        ELSE  IF TMGCOMMAND="GET SUB RECS LIST" DO
        . DO GETSRLST^TMGRPC3D(.TMGRESULT,TMGPARAMS)
        ELSE  IF TMGCOMMAND="POST DATA" DO
        . KILL INPUT("REQUEST")
        . DO POSTDATA^TMGRPC3C(.TMGRESULT,.INPUT)
        ELSE  IF TMGCOMMAND="GET EMPTY ENTRY" DO
        . DO GETEMPTY^TMGRPC3E(.TMGRESULT,TMGPARAMS)
        ELSE  IF TMGCOMMAND="GET CURRENT USER NAME" DO
        . SET TMGRESULT(0)="1^Success^"_$PIECE($GET(^VA(200,DUZ,0)),"^",1)
        ELSE  IF TMGCOMMAND="CLONE RECORD" DO
        . DO CLONEREC^TMGRPC3D(.TMGRESULT,TMGPARAMS)
        ELSE  IF TMGCOMMAND="CLONE USER" DO
        . DO CLONEUSR^TMGRPC3D(.TMGRESULT,TMGPARAMS)
        ELSE  IF TMGCOMMAND="GET HELP MSG" DO
        . DO GETHELPM^TMGRPC3E(.TMGRESULT,TMGPARAMS)
        ELSE  IF TMGCOMMAND="IS WP FIELD" DO
        . DO GETIFWP^TMGRPC3E(.TMGRESULT,TMGPARAMS)
        ELSE  IF TMGCOMMAND="GET ONE WP FIELD" DO
        . DO GETWPFLD^TMGRPC3E(.TMGRESULT,TMGPARAMS)
        ELSE  IF TMGCOMMAND="POST WP FIELD" DO
        . KILL INPUT("REQUEST")
        . DO PSTWPFLD^TMGRPC3E(.TMGRESULT,TMGPARAMS,.INPUT)
        ELSE  IF TMGCOMMAND="REGISTER PATIENT" DO
        . DO REGPAT^TMGRPC3F(.TMGRESULT,TMGPARAMS)
 ;
 ;
        QUIT
 ;
