TMGTIU01 ;TMG/kst-Misc TIU Related Fns;11/08/08
         ;;1.0;TMG-LIB;**1**;11/08/08
 ;
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"11/08/08

 ;"---------------------------------------------------------------------------
 ;"PUBLIC FUNCTIONS
 ;"---------------------------------------------------------------------------
 ;"ENSURVST(PATIENT,VISIT,CLINIC,DOCTOR) -- Ensure that patient has an entry in the VISIT file.
 ;"GetPCEInfo(.array,DFN,DT,LocIEN) -- Get Patient Care Event info for patient on given date.

 ;"---------------------------------------------------------------------------
 ;"PRIVATE FUNCTIONS
 ;"---------------------------------------------------------------------------



 ;"---------------------------------------------------------------------------

T1
        new DFN,IEN,Y,X,DIC
        set DIC=2,DIC(0)="MAEQ"
        do ^DIC write !
        if +Y'>0 goto TDone
        set DFN=+Y

        new locIEN
        set DIC=44 ;"hospital location
        do ^DIC write !
        if +Y'>0 goto TDone
        set locIEN=+Y

        new %DT,selDT
        set %DT="AE"
        do ^%DT write !
        if Y'>0 goto TDone
        set setDT=Y

        new array
        do GetPCEInfo(.array,DFN,setDT,locIEN)
        if $data(array) zwr array

TDone
        quit


ENSURVST(PATIENT,VISIT,CLINIC,DOCTOR) ;
        ;"Purpose: To ensure that patient has an entry in the VISIT file.
        ;"Input: PATIENT: the name and DOB of the patient.  format:
        ;"              'LName,FName I^12/12/1912'
        ;"       VISIT: Date and time of visit.  Format: 12/12/1912@23:15 (military time)
        ;"       CLINIC: the name of the clinic, to match entry in HOSPITAL LOCATION file
        ;"       DOCTOR: the name of the provider for the appt, to match entry in NEW PERSON file
        ;"Results: 1=OK, or 0^Error Message

        new result set result=1
        new IEN2,Entry
        set Entry(.01)=$piece(PATIENT,"^",1)  ;"Name
        set Entry(.03)=$piece(PATIENT,"^",2)  ;"DOB

        set IEN2=$$GetDFN2^TMGGDFN(Entry,AutoRegister)
        if IEN2'>0 do  goto EVDone
        . set result="0^Patient Name/DOB not registered"

        new HLIEN,DIC,X,Y
        set DIC=44  ;"HOSPITAL LOCATION file
        set DIC(0)="M",X=CLINIC
        do ^DIC
        if Y'>0 do  goto EVDone
        . set result="0^Can't find clinic '"_CLINIC_"' in HOSPITAL LOCATION file"

        set DIC=200,X=DOCTOR
        do ^DIC
        if Y'>0 do  goto EVDone
        . set result="0^Can't find doctor '"_DOCTOR+"' in NEW PERSON file"

        new VDT,%DT kill Y
        set %DT="T",X=VISIT
        do ^%DT
        if Y'>0 do  goto EVDone
        . set result="0^Invalid visit date: '"_VISIT_"'"



EVDone
        quit result


GetPCEInfo(array,DFN,DT,LocIEN)
        ;"Purpose: to get Patient Care Event info for patient on given date.
        ;"Input: array -- PASS BY REFERENCE, an OUT PARAMETER.  Prior data killed.
        ;"       DFN -- the patient IEN
        ;"       DT -- the Date of the visit in FM format.
        ;"       LocIEN -- the IEN in the HOSPITAL LOCATION file for the clinic.
        ;"Output: array is filled, format:
        ;"              array(VISITDT,#)=InfoLine
        ;"              array(VISITDT,#)=InfoLine
        ;"                        ...,1)=HDR^AllowEdit^CPTRequired^VStr^Author^hasCPT
        ;"                        ...,n)=TYP+^CODE^CAT^NARR^QUAL1^QUAL2 (QUAL1=Primary!Qty, QUAL2=Prv)
        ;"Results: None

        kill array
        new vIEN set vIEN=0
        for  set vIEN=$order(^AUPNVSIT("C",DFN,vIEN)) quit:(+vIEN'>0)  do
        . new vDT set vDT=$piece($get(^AUPNVSIT(vIEN,0)),"^",1)
        . if vDT'>0 quit
        . new %Y,X,X1,X2 set X1=setDT,X2=vDT
        . do ^%DTC
        . if (X'=0)!(%Y=0) quit
        . new tempArray
        . do PCE4NOTE^ORWPCE3(.tempArray,,DFN,LocIEN_";"_vDT)
        . merge array(vDT)=tempArray
        quit

