TMGEDIT ;TMG/kst/Interface to allow use of linux editor in Fileman ;03/25/06
         ;;1.0;TMG-LIB;**1**;7/19/08

 ;"TMG EDITOR FUNCTIONS

 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"$$EDIT(Editor)

 ;"=======================================================================
 ;"PRIVATE API FUNCTIONS
 ;"=======================================================================


 ;"=======================================================================
 ;"=======================================================================

EDIT(Editor)
        ;"Purpose: This will be a shell for a linux editor
        ;"Input: Editor -- the name of the linux editor to use (i.e. vim, joe, pico etc)
        ;"              Allowed values: joe,vim,pico
        ;"Note: When this function gets called, VistA sets up some variables
        ;"      first to tell what should be edited etc.
        ;"      DIC=The global root of the WP field where the text to be edited is
        ;"              stored (or where new text should be stored)
        ;"              e.g. "^TMG(22702,27,DV,"
        ;"      (DV is also predefined, so reference to DV in DIC is covered.)
        ;"      There are other variables set up re margins etc.  I will be ignoring these.
        ;"Results: none

        new result set result=0
        new GlobalP

        ;"By limiting value to certain values, it prevents a rouge user from putting a wedged
        ;"linux command into "Editor" and executing a system command through zsystem.
        set Editor=$get(Editor,"rvim")
        if (Editor'="rvim")&(Editor'="joe")&(Editor'="pico")&(Editor'="nano") goto EditAbort

        ;"Only allow users with programmer access to use joe
        if (Editor="joe") do  if result=1 goto EditAbort
        . new AccessCode set AccessCode=$get(DUZ(0))
        . if AccessCode'["@" do
        . . write !!,"*** Sorry.  Insufficient security clearance to use insecure 'joe' editor. ***",!
        . . write "Fileman access code of @ required, because JOE can shell out to linux prompt.",!!
        . . write "Please enter 'User's Toolbox', then 'Edit User Characteristics' at a menu",!
        . . write " option to change PREFERRED EDITOR to something other than JOE.",!!
        . . set result=1

        new EditErrFile set EditErrFile="/tmp/trashjoeoutput.txt"

        set GlobalP=$extract(DIC,1,$length(DIC)-1)_")"  ;"convert to closed form
        new Filename set Filename=$$UNIQUE^%ZISUTL("/tmp/vistaedit.tmp")
        set result=$$WP2HFSfp^TMGIOUTL(GlobalP,Filename)
        if result=0 goto EditDone


        new HookCmd
        set HookCmd=Editor_" "_Filename_" 2>"_EditErrFile  ;"use NULL instead??
        zsystem HookCmd
        set result=$ZSYSTEM&255  ;"get result of execution. (low byte only). 0=success
        if result>0 goto EditDone

        ;"read file back into global WP
        set result=$$HFS2WPfp^TMGIOUTL(Filename,GlobalP)
        ;"if result=1 do

EditDone
        new temp set temp=$$DelFile^TMGIOUTL(Filename)
        set temp=$$DelFile^TMGIOUTL(Filename_"~")  ;"joe editor copies output to filename~ as a backup
        set temp=$$DelFile^TMGIOUTL(EditErrFile)
EditAbort
        quit



LinuxEdit(Editor,FullPathName)
        ;"Purpose: This will be a shell for a linux editor
        ;"Input: Editor -- the name of the linux editor to use (i.e. vim, joe, pico etc)
        ;"              Allowed values: joe,vim,pico
        ;"         FullPathName -- the path name on the Linux HFS to edit.
        ;"Results: none

        new result set result=0
        new GlobalP

        ;"By limiting value to certain values, it prevents a rouge user from putting a wedged
        ;"linux command into "Editor" and executing a system command through zsystem.
        set Editor=$get(Editor,"rvim")
        if (Editor'="rvim")&(Editor'="joe")&(Editor'="pico") goto LEditAbort

        ;"Only allow users with programmer access to use joe
        if (Editor="joe") do  if result=1 goto EditAbort
        . new AccessCode
        . set AccessCode=$piece(^VA(200,DUZ,0),"^",4)
        . if AccessCode'="@" do
        . . write !!,"*** Sorry.  Insufficient security clearance to use insecure 'joe' editor. ***",!
        . . write "Please enter 'User's Toolbox', then 'Edit User Characteristics' at a menu",!
        . . write " option to change PREFERRED EDITOR to something other than JOE.",!!
        . . set result=1

        ;"new EditErrFile set EditErrFile="/tmp/trashjoeoutput.txt"

        new Filename set Filename=FullPathName

        new HookCmd
        ;"set HookCmd=Editor_" "_Filename_" 2>"_EditErrFile  ;"use NULL instead??
        set HookCmd=Editor_" "_Filename
        zsystem HookCmd
        set result=$ZSYSTEM&255  ;"get result of execution. (low byte only). 0=success
        if result>0 goto LEditDone


LEditDone
        ;"set temp=$$DelFile^TMGIOUTL(Filename_"~")  ;"joe editor copies output to filename~ as a backup
        ;"set temp=$$DelFile^TMGIOUTL(EditErrFile)
LEditAbort
        quit


