TMGNDF1F ;TMG/kst/FDA Import: Work with drug ROUTES ;03/25/06
         ;;1.0;TMG-LIB;**1**;02/26/07

 ;" FDA - NATIONAL DRUG FILES COMPILING FUNCTIONS
 ;"      -- Working with Dosage ROUTES
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"2-26-07

 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"Menu

 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================

 ;"=======================================================================
 ;"=======================================================================

 ;"ScrnAll -- Fix missing Dose ROUTES from DRUG file

 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
Menu
        ;"Purpose: Provide menu to entry points of main routines

        new Menu,UsrSlct
        set Menu(0)="Pick Option for Ensuring correct DOSE ROUTES (1F)"

        new i set i=1
        set Menu(i)="Find new import ROUTES"_$char(9)_"FINDNEW" set i=i+1
        set Menu(i)="Match imports ROUTE --> VA ROUTE"_$char(9)_"MATCH" set i=i+1
        set Menu(i)="Fix imports with missing ROUTE"_$char(9)_"FixMissingRoute" set i=i+1
        set Menu(i)="Screen ALL imports for INCORRECT ROUTE"_$char(9)_"ScreenAll" set i=i+1
        set Menu(i)="Edit match file (IF NEEDED)"_$char(9)_"EditMatch" set i=i+1
        set Menu(i)="Edit VA ROUTES (file 51.2) (ONLY IF NEEDED)"_$char(9)_"EDITVA" set i=i+1
        set Menu(i)="USE links for import ROUTE --> VA ROUTE (DO THIS LAST)"_$char(9)_"FillVARoute" set i=i+1

        set Menu("P")="Prev Stage"_$char(9)_"Prev"
        set Menu("N")="Next Stage"_$char(9)_"Next"

MC1     write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
        if UsrSlct="^" goto MCDone
        if UsrSlct=0 set UsrSlct=""

        if UsrSlct="FixMissingRoute" do FixMissingRoute goto MC1
        if UsrSlct="ScreenAll" do ScrnAll goto MC1

        if UsrSlct="FillVARoute" do FillVARoute goto MC1
        if UsrSlct="EditMatch" do EditMatchFile goto MC1
        if UsrSlct="FINDNEW" do FindUnmatched goto MC1
        if UsrSlct="MATCH" do HandleLinks goto MC1
        if UsrSlct="EDITVA" do EditVARoutes goto MC1


        if UsrSlct="Prev" goto Menu^TMGNDF1E  ;"quit can occur from there...
        if UsrSlct="Next" goto Menu^TMGNDF2A  ;"quit can occur from there...
        goto MC1

MCDone
        quit

 ;"=======================================================================


ScrnAll
        ;"Purpose: Fix missing or screen for Dose ROUTES from DRUG file
        ;"Results -- none.

        write "Scanning for records to display...",!
        do SelEdRArray()
        quit


FixMissingRoute
        ;"Purpose: Fix missing or screen for Dose ROUTES from DRUG file
        ;"Results: none

        new PreSelArray,JustSelected
        set JustSelected=0

        write "Scanning for entries with no DOSE ROUTE...",!
        do GetFldVScreen^TMGSELED(22706.9,3,"$$ScrnTest^TMGNDF1F","PreSelArray")

        write "Show just those preselected? (Faster)"
        new % set %=1 do YN^DICN write !
        if %=1 set JustSelected=1
        else  write "Now scanning for the rest of the entries...",!
        do SelEdRArray(.PreSelArray,JustSelected)

        do FindUnmatched
        quit


ScrnTest()
        ;"Purpose: this is a callback function for GetFldVScreen^TMGSELED
        ;"         Screen out if value is null (i.e. LOOK FOR MISSING VALUES),
        ;"         or SKIP=true,
        ;"Input: None.  But following global-scope variables will be available for use
        ;"              File -- the File name or number
        ;"              FieldNum -- the field number
        ;"              IEN -- the IEN of the current record.
        ;"              RecValue -- the current value of the field
        ;"Results: 1 if should be skipped, 0 if should be keps

        new result set result=1;" default to SKIP
        if RecValue'="" goto STDone  ;"if not null, then skip
        ;"Now see if 22706.9 is marked for SKIP
        if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 goto STDone ;"1;4=SKIP field, 1=SKIP
        set result=0 ;"keep
STDone
        quit result


Scrn2Test()
        ;"Purpose: this is a callback function for GetFldVScreen^TMGSELED
        ;"         Screen out if record in 22706.9=SKIP,
        ;"Input: None.  But following global-scope variables will be available for use
        ;"              File -- the File name or number
        ;"              FieldNum -- the field number
        ;"              IEN -- the IEN of the current record.
        ;"              RecValue -- the current value of the field
        ;"Results: 1 if should be skipped, 0 if should be keps

        new result set result=1;" default to SKIP
        ;"Now see if matching record in 22706.9 is marked for SKIP
        if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 goto ST2Done ;"1;4=SKIP field, 1=SKIP
        if $data(^TMG(22706.9,IEN))=0 goto ST2Done  ;"if null record (for some reason)
        set result=0 ;"keep
ST2Done
        quit result



SelEdRArray(SelArray,JustSelected)
        ;"Purpose: Fix missing or screen for Dose ROUTES from DRUG file
        ;"Input:  SelList -- PASS BY REFERENCE.  An OUT PARAMETER.  Format
        ;"              List(IEN)=""
        ;"              List(IEN)=""  <-- IEN in 50 that was selected.
        ;"        Mode -- 0 for missing routes, or "ALL" for screening all
        ;"Results: none

        new Options,IEN
        set Options("FIELDS",1)=".05^TRADENAME^40"
        set Options("FIELDS",1,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",2)="3.4^FDA DOSAGE FORM^15"
        ;"set Options("FIELDS",2,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",3)="3^FDA ROUTE^15"
        ;"set Options("FIELDS",4)="3.1^VA ROUTE^15"
        set Options("FIELDS","MAX NUM")=3
        set Options("FILE")="22706.9^TMG FDA IMPORT COMPILED"
        ;"Get all records with SKIP THIS RECORD = 0 (KEEP)

        if +$get(JustSelected)=0 do
        . do GetFldVScreen^TMGSELED(22706.9,3,"$$Scrn2Test^TMGNDF1F",$name(Options("IEN LIST")))
        else  do
        . merge Options("IEN LIST")=SelArray
        . kill SelArray

SE1     if $data(SelArray) do
        . set IEN=""
        . for  set IEN=$order(SelArray(IEN)) quit:(IEN="")  do
        . . if $data(Options("IEN LIST",IEN))>0 do
        . . . set Options("IEN LIST",IEN,"SEL")=""

        if $$SELED^TMGSELED(.Options)'=2 goto SERDone
        if $$GetIENs^TMGSELED(.Options)=0 goto SERDone
        goto SE1

SERDone quit



 ;"=======================================================================


FindUnmatched
        ;"Purpose: Find new, unhandled, FDA dosage forms, and create a new record in
        ;"         TMG NDF FORMS VISTA EQUIVALENTS

        new Array
        write !,"Checking compiled FDA import records for new FDA drug ROUTES...",!
        do GetFDARoute(.Array)
        do TrimFoundRoutes(.Array)
        if $data(Array) do
        . write $$ListCt^TMGMISC("Array")," new drug ROUTES found.  Adding now...",!
        . do StubInNewRec(.Array)
        . do HandleLinks
        . write "Done.",!
        else  do
        . write !,"No new FDA drug ROUTES found",!

        do PressToCont^TMGUSRIF

        quit


GetFDARoute(Array)
        ;"Purpose: to scan file 22706.9 (TMG FDA IMPORT COMPILED) and compile a list of all ROUTES
        ;"Input: Array -- PASS BY REFERENCE.  An OUT PARAMETER.  Prior entries will be killed
        ;"Results: Data passed back as follows:
        ;"              Array(Route)=""
        ;"              Array(Route)=""
        ;"Result: none.

        new Itr,IEN
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)
        . if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 quit  ;"1=SKIP
        . new Route
        . set Route=$piece($get(^TMG(22706.9,IEN,0)),"^",5)
        . if Route="" quit
        . set Array(Route)=IEN
        do ProgressDone^TMGITR(.Itr)


        quit


TrimFoundRoutes(Array)
        ;"Purpose: To remove entries from Array, for which mapping to a VistA equivilent
        ;"         has already ben created
        ;"Input: Array -- PASS BY REFERENCE.  Array as created by GetFDARoute
        new Form set Form=""
        for  set Form=$order(Array(Form)) quit:(Form="")  do
        . new shortForm set shortForm=$extract(Form,1,30)
        . if $order(^TMG(22706.82,"B",shortForm,""))'="" kill Array(Form)
        quit


StubInNewRec(Array)
        ;"Purpose: To create new entries in 22706.8 for FDA forms not yet added.
        ;"Input: Array -- PASS BY REFERENCE.  An array of Forms to be added, as created
        ;"                by GetFDARoute.
        ;"NOTE: ALL entries in Array will be added as new records.  Thus, screening for
        ;"      prior entries must be performed, such as through TrimFoundRoutes()

        new TMGFDA,TMGMSG,TMGIEN
        new Form set Form=""
        for  set Form=$order(Array(Form)) quit:(Form="")  do
        . set TMGFDA(22706.82,"+1,",.01)=Form
        . kill TMGMSG,TMGIEN
        . do UPDATE^DIE("K","TMGFDA","TMGIEN","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        quit



DisplayRoutes(Answers)
        ;"Purpose: to display the list of Dosage forms that don't have a corresponding VA DOSE FORM
        ;"Input: Answers -- PASS BY REFERENCE, and OUT PARAMETER. Old values killed.
        ;"Output: Answers filled in as follows:
        ;"      Answers(n)=RxRoute^IEN in 22706.82
        ;"      Answers(n)=RxRoute^IEN in 22706.82
        ;"Results: None

        kill Answers
        new count set count=0
        new Itr,IEN
        set IEN=$$ItrInit^TMGITR(22706.82,.Itr)
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)
        . new VARouteIEN set VARouteIEN=+$piece($get(^TMG(22706.82,IEN,0)),"^",2)
        . if VARouteIEN'=0 quit
        . new FDARoute set FDARoute=$piece($get(^TMG(22706.82,IEN,0)),"^",1)
        . set count=count+1
        . write count,".    ",FDARoute," --> ??",!
        . set Answers(count)=FDARoute_"^"_IEN
        if count=0 do
        . write " -- List is Empty --",!

        quit


HandleLinks
        ;"Purpose: To interact with user and find a link between FDA dosage forms, and VA dosage forms
        ;"Input: none
        ;"Output: results are stored in 22706.8
        ;"Results: none

        new Answers
        new done set done=0
        new input set input="R"
        new LastNum
        new VAPIndex

        for  do  quit:(done=1)
        . if input="R" do
        . . write !!
        . . write "-------------------------------------------------------------------",!
        . . write "Specify which Dosage ROUTE to Look up",!
        . . write "-------------------------------------------------------------------",!
        . . do DisplayRoutes(.Answers)
        . . set LastNum=$order(Answers(""),-1)
        . . if LastNum="" set LastNum="^"
        . . write "-------------------------------------------------------------------",!
        . . write "Specify which Dosage ROUTE to Look up",!
        . . write "-------------------------------------------------------------------",!
        . write "  R to refresh, E show Examples",!
        . write "  ^ to continue",!
        . write "Enter number to Lookup (or codes listed above): ",LastNum,"//"
        . read input
        . if input="" set input=LastNum write LastNum
        . write !
        . ;"if input="" set input="^"
        . if input="" set input=LastNum write LastNum
        . set input=$$UP^XLFSTR(input)
        . if input="^" set done=1
        . if +input=input do
        . . do DoLink(input,.Answers)
        . . set input="R"
        . if input="E" do
        . . write "...Enter number to show examples for: "_LastNum_"//"
        . . read input,!
        . . if input="" set input=LastNum
        . . do ShowExamples(+input,.Answers,.VAPIndex)
        . . set input="R"

        quit


DoLink(InputNum,Answers)
        ;"Purpose: To try to establish a link between 1 FDA ROUTE and a VA ROUTE
        ;"Input:  InputNum -- the number that the user chose to fix.
        ;"         Answers -- PASS BY REFERENCE.  Array as put out by DisplayRoutes
        ;"Output:  if link is established then it will be store in 22706.8
        ;"Results: none

        new RxRoute,IEN
        set RxRoute=$piece($get(Answers(InputNum)),"^",1)
        set IEN=$piece($get(Answers(InputNum)),"^",2)
        if RxRoute="" goto DLDone
        new done set done=0

        new VistaIEN set VistaIEN=0
        new DIC,X,Y
        set DIC=51.2
        set X=RxRoute
        set DIC(0)="M"
        do ^DIC
        if +Y>0 do
        . write !,"Match automatically found...",!
        . write "Use '",$piece(Y,"^",2),"' for '",RxRoute,"'"
        . new % set %=1 do YN^DICN
        . if %'=1 quit
        . set VistaIEN=+Y
        if VistaIEN'=0 goto DL2

        set DIC(0)="AEQML"
        set DIC("A")="Enter VA DOSE FORM name: // "
        write !,"Enter name to match '"_RxRoute_"'"
        do ^DIC write !
        if +Y>0 do
        . write "Use '",$piece(Y,"^",2),"' for '",RxRoute,"'"
        . new % set %=1 do YN^DICN
        . if %'=1 quit
        . set VistaIEN=+Y

DL2     if VistaIEN'=0 do
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.82,IEN_",",1)=VistaIEN
        . do FILE^DIE("K","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)

DLDone
        quit


ShowExamples(InputNum,Answers,Index)
        ;"Purpose: To show all entries using dosage form specified
        ;"Input: InputNum -- the input number from user to show
        ;"       Answers -- PASS BY REFERENCE, array as put out by DisplayForms
        ;"       Index -- OPTIONAL.  An index of VAProduct

        new RxRoute
        set RxRoute=$piece($get(Answers(InputNum)),"^",1)
        if RxRoute="" goto SEDone

        new count set count=0
        new IEN set IEN=0
        new abort set abort=0
        for  set IEN=$order(^TMG(22706.9,"ROUTE",RxRoute,IEN)) quit:(+IEN'>0)!abort  do
        . write "#",IEN,": "
        . do DumpRec2^TMGDEBUG(22706.9,IEN_",")
        . set count=count+1
        . write " -- Press ENTER to Continue (ESC to quit) --"
        . new ch set ch=$$KeyPressed^TMGUSRIF(0,60)
        . write !
        . if ch=27 set abort=1 quit

        if count=0 do
        . write !,"Couldn't find any examples (error occurred).",!

        do PressToCont^TMGUSRIF
SEDone
        quit


 ;"========================================
EditVARoutes
       ;"Purpose: To edit Vista Routes file file 51.2

        new Options,IEN
        set Options("FIELDS",1)=".01^NAME^30"
        set Options("FIELDS",1,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",2)="1^ABBREVIATION^15"
        set Options("FIELDS",3)="3^PACKAGE USE^10"
        set Options("FIELDS",4)="5^INACTIVATION DATE^10"
        set Options("FIELDS",5)="6^IV FLAG^5"
        set Options("FIELDS","MAX NUM")=5
        set Options("FILE")="51.2^MEDICATION ROUTE"

        do GetFldValue^TMGSELED(51.2,.01,"ALL",$name(Options("IEN LIST")))

EF1
        if $$SELED^TMGSELED(.Options)'=2 goto EFDone
        if $$GetIENs^TMGSELED(.Options)=0 goto EFDone
        goto EF1

EFDone quit

 ;"========================================

FillVARoute
        ;"Purpose: To ensure that there is a entry in the VA ROUTE field
        ;"         in all records in TMG FDA IMPORT COMPILED
        ;"              (that are not marked to be skipped)

        new Itr,IEN,abort,count,missingRoute
        set abort=0,count=0,missingRoute=0

        write "Scanning through all imports and applying matches from ROUTE --> VA ROUTE...",!
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 quit  ;"1=SKIP
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . new FDARoute set FDARoute=$piece($get(^TMG(22706.9,IEN,0)),"^",5)
        . new VARouteIEN set VARouteIEN=+$piece($get(^TMG(22706.9,IEN,7)),"^",7)
        . if FDARoute="" do  quit
        . . if VARouteIEN'=0 quit
        . . ;"write !,"No FDA drug ROUTE found for drug in record #",IEN,!
        . . set missingRoute=missingRoute+1
        . new mapIEN set mapIEN=+$order(^TMG(22706.82,"B",$extract(FDARoute,1,30),""))
        . new VistaIEN set VistaIEN=+$piece($get(^TMG(22706.82,mapIEN,0)),"^",2)
        . if (VARouteIEN=VistaIEN)&(VistaIEN'=0) quit  ;"already set properly
        . if VistaIEN=0 do  quit
        . . write !,"Mapping to VA ROUTE incomplete:  ",FDARoute," --> ??.  Edit Match File.",!
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.9,IEN_",",3.1)=VistaIEN
        . do FILE^DIE("K","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . ;"write !,IEN," field 3.1 set to `",VistaIEN,!
        . set count=count+1

        write !,count," records changed",!
        if missingRoute>0 write missingRoute," imports are missing a specified ROUTE",!
        do PressToCont^TMGUSRIF

FRFDone
        quit

 ;"========================================

EditMatchFile
        ;"Purpose: use Selector to browse and edit TMG FDA ROUTE VISTA EQUIVALENTS (22706.82)

        new Options,IEN
        set Options("FIELDS",1)=".01^FDA ROUTE^25"
        set Options("FIELDS",1,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",2)="1^VISTA ROUTE^25"
        set Options("FIELDS","MAX NUM")=2
        set Options("FILE")="22706.82^TMG FDA ROUTES VISTA EQUIVALENTS"

        do GetFldValue^TMGSELED(22706.82,.01,"ALL",$name(Options("IEN LIST")))

SFM1
        if $$SELED^TMGSELED(.Options)'=2 goto SFMDone
        if $$GetIENs^TMGSELED(.Options)=0 goto SFMDone
        goto SFM1

SFMDone quit




