TMGNDF2C ;TMG/kst/FDA Import: Fill VA GENERIC entries;03/25/06
         ;;1.0;TMG-LIB;**1**;11/21/06

 ;" FDA - NATIONAL DRUG FILES COMPILING FUNCTIONS
 ;"      -- FILLING VA GENERIC FILE WITH NEW VALUES
 ;"      -- and linking field .08 (VA GENERIC) in file TMG FDA IMPORT with links to apprpriate values.
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"11-21-2006

 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"Menu
 ;"=======================================================================
 ;"FillGenerics  --  scan TMG FDA IMPORT file and make sure that all of the GENERIC NAMEs
 ;"      have been added into the VA GENERIC file, or that a link exists between a
 ;"      GENERIC name and an existing VA GENERIC name.
 ;"      Then use this data and fill in field .08 in file TMG FDA IMPORT COMPILED

 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 ;"CheckGenerics(Results)
 ;"Rescan(Array,Label,number)
 ;"FindSimGenerics(Generic,Array)
 ;"NarrowGenMatches(Generic,Array)
 ;"FindGenContain(name,Array)
 ;"Scan4Generics(Array)
 ;"Unlock50dot6
 ;"Lock50dot6
 ;"ShowList(Array,Label)
 ;"ProcessList(Array) -- handle adding generic names, returning a list of linkages
 ;"HandleAdds(Array) -- handle adding those entries in Array that need to be added to VA GENERIC file.
 ;"Remove(Array,Label,Num,EndNum) -- remove name(s) from Array of additions to VA GENERIC file
 ;"CustLookup(Array,Label,Num) -- manually link entry in Array to an existing entry in VA GENERIC file
 ;"DoAdds(Array,Label,Num,EndNum) -- extract name(s) from Array and add to VA GENERIC file, via Add1Generic
 ;"Add1Generic(Name) -- add on entry to the VA GENERIC FILE
 ;"HandleQAdds(Array) -- review 'Uncertain Matches' node of Array and allow user to specify whether
 ;"DoLinks(Array,Num,EndNum) -- change a link from the "Uncertain Matches" node, to a formal link
 ;"DoMltLink(Array,Num,TMGGeneric) -- interact with user and pick which link (amoung multiple)
 ;"FillCompFile(Array) -- fill in field .08 in file TMG FDA IMPORT COMPILED

 ;"=======================================================================
 ;"=======================================================================

Menu
        ;"Purpose: Provide menu to entry points of main routines

        new Menu,UsrSlct
        set Menu(0)="Pick Option for filling VA GENERIC entries (2C)"
        set Menu(1)="Ensure link between import GENERIC name, and VA GENERIC name"_$char(9)_"FillGenerics"
        set Menu("P")="Prev Stage"_$char(9)_"Prev"
        set Menu("N")="Next Stage"_$char(9)_"Next"

MC1     write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
        if UsrSlct="^" goto MCDone
        if UsrSlct=0 set UsrSlct=""

        if UsrSlct="FillGenerics" do FillGenerics goto MC1
        if UsrSlct="Prev" goto Menu^TMGNDF2A  ;"quit can occur from there...
        if UsrSlct="Next" goto Menu^TMGNDF2E  ;"quit can occur from there...
        goto MC1

MCDone
        quit


FillGenerics
        ;"Purpose: To scan TMG FDA IMPORT file and make sure that all of the GENERIC NAMEs
        ;"      have been added into the VA GENERIC file, or that a link exists between a
        ;"      GENERIC name and an existing VA GENERIC name.
        ;"      Then use this data and fill in field .08 in file TMG FDA IMPORT COMPILED

        new list

        write #
        write "======================================================",!
        write "Link FDA import entries to entries in VA GENERIC file",!
        write "======================================================",!,!
        new list
        if $data(^TMG("templist")) do
        . write "Data from another work run found.  Continue to use this"
        . new % set %=1 do YN^DICN write !
        . if %=1 merge list=^TMG("templist")
        . if %=2 do
        . . write "Delete old data from prior run"
        . . set %=2 do YN^DICN write !
        . . if %=1 kill ^TMG("templist"),list
        . . do CheckGenerics(.list)
        else  do CheckGenerics(.list)
        kill ^TMG("templist")

        if $data(list)=0 goto FGDone

        do ProcessList(.list)
        merge ^TMG("templist")=list
        write "Use data to fill in VA GENERIC field in TMG FDA IMPORT COMPILED now"
        set %=1 do YN^DICN write !
        if %=1 do FillCompFile(.list)

FGDone
        write "Goodbye.",!
        quit


CheckGenerics(Results)
        ;"Purpose: To scan TMG FDA IMPORT file and make sure that all of the GENERIC NAMEs
        ;"      have been added into the VA GENERIC file, or that a link exists between a
        ;"      GENERIC NAME and an existing VA GENERIC name.
        ;"Input: Results -- PASS BY REFERENCE, and OUT PARAMETER.  Returns array with results.

        new Array,i
        write "Collecting list of imports not linked to a VA GENERIC entry.",!
        do Scan4Generics(.Array) ;"note: result Array will not include SKIPPED records
        if $data(Array)=0 do  goto CGDone
        . write "No unmatched entries found--great!",!

        write "Processing GENERIC names...",!

        new DIC,X,Y
        set DIC=50.6
        set DIC(0)="M" ;"multiple index, LAYGO (add if not found)

        new abort set abort=0
        new temp set temp=""
        new count set count=1
        new TMGGeneric
        new Itr,i
        set i=$$ItrAInit^TMGITR("Array",.Itr)
        do PrepProgress^TMGITR(.Itr,20,1,"i")
        if i'="" for  do  quit:($$ItrANext^TMGITR(.Itr,.i)="")!abort
        . set X=i,TMGGeneric=i
        . set DIC(0)="M" do ^DIC
        . if Y=-1 do
        . . set DIC(0)="MX"
        . . do ^DIC
        . if Y=-1 do
        . . if $data(^PSNDF(50.6,"B",X)) do
        . . . new IEN set IEN=+$order(^PSNDF(50.6,"B",X,""))
        . . . if IEN'>0 write "?? IEN for ",X," is NULL??",! quit
        . . . set Y=IEN_"^"_X  ;"only get first match
        . if +Y>0 do  quit
        . . set Results("Uncertain Matches",count,TMGGeneric,$piece(Y,"^",2))=Y
        . . set count=count+1
        . new list
        . do FindSimGenerics(TMGGeneric,.list)
        . if $data(list) do
        . . merge Results("Uncertain Matches",count,TMGGeneric)=list
        . . set count=count+1  ;"is this right???
        . else  do
        . . set Results("Should Add",count,TMGGeneric)=""
        . . set count=count+1
        do ProgressDone^TMGITR(.Itr)

CGDone
        quit

Rescan(Array,Label,number)
        ;"Purpose: to allow rescan of one entry
        ;"Input: Array -- PASS BY REFERENCE -- Array with drug lists, as used by CheckGenerics
        ;"       Label -- i.e. "Uncertain Matches", or "Should Add"
        ;"       number -- the number of the listing to rescan
        ;"      NOTE: This affects Results from a global scope
        ;"              ??? Was this intended ???
        ;"Output:
        ;"results: none

        new DIC,X,Y
        set DIC=50.6
        set DIC(0)="M" ;"multiple index, LAYGO (add if not found)

        set X=$order(Array(Label,number,""))
        if X'="" do
        . do ^DIC
        . if +Y'>0 do
        . . new list
        . . do FindSimGenerics(X,.list)
        . . if $data(list) do
        . . . merge Results("Uncertain Matches",number,X)=list
        . . else  do
        . . . set Results("Should Add",number,X)=""
        . else  set Results(X)=Y

        quit


FindSimGenerics(Generic,Array)
        ;"Purpose: to scan VA GENERIC file and return an array of similar entries.
        ;"Input: Generic: the name of the generic drug name to scan for
        ;"       Array: PASS BY REFERENCE, and OUT PARAMETER -- prior entries are killed
        ;"Result: none (output is in Array)

        new i,i2,s
        kill Array
        new NumRxs
        set NumRxs=$length(Generic,"/")

        set i2=$order(^PSNDF(50.6,0))
        if i2'="" for  do  quit:(i2="")
        . new VAGeneric set VAGeneric=$piece($get(^PSNDF(50.6,i2,0)),"^",1)
        . new IEN set IEN=i2
        . set i2=$order(^PSNDF(50.6,i2))
        . if NumRxs'=$length(VAGeneric,"/") quit
        . new temp set temp=VAGeneric
        . for i=1:1:NumRxs do  quit:(s="")!(temp="")
        . . set s=$piece(Generic,"/",i)
        . . set s=$piece(s," ",1)  ;"get first word of multi-word drug name
        . . if s="" quit
        . . if $extract(VAGeneric,1,$length(s))'=s set temp=""
        . if temp'="" do
        . . set Array(VAGeneric)=IEN_"^"_VAGeneric

        new count
        set count=$$ListCt^TMGMISC("Array")
        if count>1 do
        . do NarrowGenMatches(Generic,.Array)
        . if (($$ListCt^TMGMISC("Array")/count)>0.5)&(count>5) do  ;"i.e. no improvement
        . . kill Array

        quit


NarrowGenMatches(Generic,Array,DivCh)
        ;"Purpose: To take a number of matches, and weed out bad matches (narrow down the list).
        ;"Input: Generic -- Name of Generic name that ideal match should equal
        ;"       Array -- PASS BY REFERENCE, the array that needs trimming.
        ;"       DivCH -- OPTIONAL, default="/"
        ;"Output: Array will be thinned if possible.
        ;"Results: none

        new i,j,result
        new MaxScore set MaxScore=0
        set DivCh=$get(DivCh,"/")

        set i=$order(Array(""))
        if i'="" for  do  quit:(i="")
        . new score set score=0
        . for j=1:1:$length(i,DivCh) do
        . . new GenIgd,ArrayIgd
        . . set GenIgd=$piece(Generic,DivCh,j)
        . . set ArrayIgd=$piece(i,DivCh,j)
        . . set score=score+$$Comp2Strs^TMGSTUTL(GenIgd,ArrayIgd)
        . if score>MaxScore set MaxScore=score
        . if score'<MaxScore do
        . . set result(score,i)=""
        . set i=$order(Array(i))

        new output,count
        set score=0,count=0
        set i=$order(result(""),-1)
        if i'="" for  do  quit:(i="")
        . if (i'<score) do
        . . set j=$order(result(i,""),-1)
        . . if j'="" for  do  quit:(j="")
        . . . set output(j)=$get(Array(j))
        . . . set j=$order(result(i,j),-1)
        . . set score=i
        . set i=$order(result(i),-1)

        kill Array
        merge Array=output

        quit


FindGenContain(name,Array)
        ;"Purpose to scan the VA GENERIC file and return a list off all entries containing name
        ;"Input -- name: the string to scan for
        ;"         Array: PASS BY REFERENCE, and OUT PARAMETER  (prior entries are killed
        ;"Results: none

        kill Array
        new i
        set i=$order(^PSNDF(50.6,0))
        if i'="" for  do  quit:(i="")
        . new VAGeneric set VAGeneric=$piece($get(^PSNDF(50.6,i,0)),"^",1)
        . if VAGeneric[name set Array(VAGeneric)=""
        . set i=$order(^PSNDF(50.6,i))

        quit


Scan4Generics(Array)
        ;"Purpose: To scan TMG FDA IMPORT file and collect all the GENERICS NAME entries into the array
        ;"       It collects all instances were GENERIC NAME is provided, but VAGeneric pointer is NULL
        ;"Input -- Array -- PASS BY REFERENCE.  An Out parameter
        ;"Results -- the Array is filled with names of GENERICS NAME
        ;"              Array(GenericName)=""
        ;"              Array(GenericName)=""
        ;"Note: This will only return GENERICS NAMEs when there is NO entry already in field
        ;"      .08 (VA GENERIC)
        ;"      This will skip records marked to be skipped.

        new name,VAGeneric
        new Itr,IEN
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)
        . if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 quit ;"1=SKIP
        . set name=$piece($get(^TMG(22706.9,IEN,0)),"^",6) ;"get field#.07, GENERIC NAME
        . set VAGeneric=$piece($get(^TMG(22706.9,IEN,1)),"^",3) ;"get field#.08, VA GENERIC
        . if (+name'=name)&(name'="")&(+VAGeneric=0) do
        . . set Array(name)=""
        do ProgressDone^TMGITR(.Itr)

        quit


ScanNoGenerics(Array)
        ;"Purpose: To scan TMG FDA IMPORT file and collect all entries into the array
        ;"         where there is NO GENERIC NAME is provided, and VAGeneric pointer is NULL
        ;"Input -- Array -- PASS BY REFERENCE.  An Out parameter
        ;"Results -- the Array is filled with names of drugs missing GENERICS NAME & VAGeneric Ptr
        ;"      This will skip records marked to be skipped.

        new IEN
        new name,VAGeneric

        set IEN=$order(^TMG(22706.9,""))
        if IEN'="" for  do  quit:(+IEN'>0)
        . new skip set skip=$piece($get(^TMG(22706.9,IEN,1)),"^",4)
        . if skip=0 do
        . . set name=$piece($get(^TMG(22706.9,IEN,0)),"^",6) ;"get field#.07, GENERIC NAME
        . . set VAGeneric=$piece($get(^TMG(22706.9,IEN,1)),"^",3) ;"get field#.08, VA GENERIC
        . . if (name="")&(+VAGeneric=0) do
        . . . if name["ALLERGENIC EXTRACT" quit  ;"skip all these... I don't want them
        . . . new tradeName set tradeName=$piece($get(^TMG(22706.9,IEN,0)),"^",4) ;"get field#.05, TRADENAME
        . . . set Array(tradeName)=""
        . set IEN=$order(^TMG(22706.9,IEN))

        quit



Unlock50dot6
        ;"note: could just set DUZ(0)="^" and not remove this...
        ;"Purpose: to remove the write restrictions for file 50.6

        new Lbl set Lbl="50.6"
        do SavKilRef(Lbl,$name(^DIC(50.6,0,"LAYGO")))
        do SavKilRef(Lbl,$name(^DIC(50.6,0,"WR")))
        do SavKilRef(Lbl,$name(^DIC(50.6,0,"DEL")))
        do SavKilRef(Lbl,$name(^DD(50.6,.01,9)))
        do SavKilRef(Lbl,$name(^DD(50.6,.01,"DEL",.01,0)))
        set XUMF=1  ;"a secret programmer's key
        set XPDGREF=1

        quit


Lock50dot6
        ;"Purpose: to restore the write restrictions for file 50.6

        do RestoreSK("50.6")
        ;"set ^DIC(50.6,0,"LAYGO")="^"
        ;"set ^DIC(50.6,0,"WR")="^"
        ;"set ^DIC(50.6,0,"DEL")="^"
        ;"set ^DD(50.6,.01,9)="^"
        ;"set ^DD(50.6,.01,"DEL",.01,0)="I 1 D EN^DDIOL(""DELETIONS ARE NOT ALLOWED"")"
        kill XUMF
        kill XPDGREF

        quit

SavKilRef(Label,Ref)
        if ($get(Label)="")!($get(Ref)="") quit
        kill ^TMG("BAK",Label,Ref)
        merge ^TMG("BAK",Label,Ref)=@Ref
        kill @Ref
        quit

RestoreSK(Label)
        if ($get(Label)="") quit
        new Ref set Ref=""
        for  set Ref=$order(^TMG("BAK",Label,Ref)) quit:(Ref="")  do
        . merge @Ref=^TMG("BAK",Label,Ref)
        . kill ^TMG("BAK",Label,Ref)
        quit

ShowList(Array,Label)
        ;"Purpose: To display the list generated by CheckGenerics
        ;"Input: Array -- the array containing the data
        ;"       Label -- the name of the node to display

        new count,ingredient,value,first
        new someShown set someShown=0
        set count=$order(Array(Label,""))
        if count'="" for  do  quit:(count="")
        . new TMGGeneric,VAGeneric
        . set TMGGeneric=$order(Array(Label,count,""))
        . set first=1
        . set someShown=1
        . set VAGeneric=$order(Array(Label,count,TMGGeneric,""))
        . if VAGeneric'="" for  do  quit:(VAGeneric="")
        . . new next set next=$order(Array(Label,count,TMGGeneric,VAGeneric))
        . . if first=1 do
        . . . if next'="" do
        . . . . write count,". ",TMGGeneric," ---> (multiple)",!
        . . . . write "                    ---> ",VAGeneric,!
        . . . else  do
        . . . . write count,". ",TMGGeneric," ---> ",VAGeneric,!
        . . . set first=0
        . . else  write "                    ---> ",VAGeneric,!
        . . set VAGeneric=$order(Array(Label,count,TMGGeneric,VAGeneric))
        . else  do
        . . write count,". ",TMGGeneric,!
        . set count=$order(Array(Label,count))

        if someShown=0 do
        . write "  --- (List is Empty) ---",!

        quit

ProcessList(Array)
        ;"Purpose: After list of linkages between GENERIC NAMEs and VA GENERIC names
        ;"      is created by CheckGenerics(), then this function will handle adding those
        ;"      generic names that need adding, and returning a list of linkages to use those
        ;"      cases there an entry already exists that is not exactly the same, but will be
        ;"      used as equivalent.
        ;"Input: Array -- PASS BY REFERENCE  the array generated by CheckGenerics
        ;"              Results are passed back in Array
        ;"              Array(GENERIC NAME)=IEN in VA GENERIC file
        ;"              Array(GENERIC NAME)=IEN in VA GENERIC file
        ;"Results: none

        new datafound,abort
        set abort=0

        for  do  quit:(datafound=0)!(abort=1)
        . set datafound=0
        . if $data(Array("Should Add"))>0 do  quit:(abort=1)
        . . set datafound=1
        . . write !!,"There are entries that should be added to the VA GENERIC file",!
        . . write "Process now (^ to abort)"
        . . new % set %=1 ;"default to YES
        . . do YN^DICN write !
        . . if %=-1 set abort=1 quit
        . . if %=1 do HandleAdds(.Array)
        . if $data(Array("Uncertain Matches"))>0 do
        . . set datafound=1
        . . write !!,"There are presumed linkages that need approval.",!
        . . write "Process now (^ to abort)"
        . . new % set %=1 ;"default to YES
        . . do YN^DICN write !
        . . if %'=1 set abort=1 quit
        . . do HandleQAdds(.Array)

        quit


HandleAdds(Array)
        ;"Purpose: To handle adding those entries in Array that need to be added to VA GENERIC file.
        ;"Input: Array -- PASS BY REFERENCE  the array generated by CheckGenerics
        ;"              Results are passed back in Array
        ;"              Array(GENERIC NAME)=IEN in VA GENERIC file
        ;"              Array(GENERIC NAME)=IEN in VA GENERIC file
        ;"Output: results returned in Array, as above.
        ;"Results: none

        do Unlock50dot6

        new done set done=0
        new input set input="R"

        for  do  quit:(done=1)
        . if input="R" do
        . . write !!
        . . write "-------------------------------------------------------------------",!
        . . write "Specify which GENERIC names are OK for ADDITION to VA GENERIC file",!
        . . write "-------------------------------------------------------------------",!
        . . do ShowList(.Array,"Should Add")
        . . write "-------------------------------------------------------------------",!
        . . write "Specify which GENERIC names are OK for ADDITION to VA GENERIC file",!
        . . write "-------------------------------------------------------------------",!
        . write "  R to refresh, L lookup, ? for instructions",!
        . write "  # or #-#, ^ to continue, X remove from list",!
        . write "Enter number(s) to ACCEPT (or codes listed above): ^//"
        . read input,!
        . if input="" set input="^"
        . set input=$$UP^XLFSTR(input)
        . if input="^" set done=1
        . if (input="?") do
        . . ;"do ShowInstructions
        . . set input="R"
        . if +input=input do
        . . do DoAdds(.Array,"Should Add",+input)
        . . set input="R"
        . if input["-" do
        . . new N1,N2
        . . set N1=$piece(input,"-",1)
        . . set N2=$piece(input,"-",2)
        . . do DoAdds(.Array,"Should Add",N1,N2)
        . . set input="R"
        . if input="L" do
        . . read "Enter number to lookup manually: ",input,!
        . . do CustLookup(.Array,"Should Add",+input)
        . . set input="R"
        . if input="X" do
        . . read "Enter number(s) to REMOVE from list: ",input,!
        . . if +input=input do
        . . . do Remove(.Array,"Should Add",+input)
        . . if input["-" do
        . . . new N1,N2
        . . . set N1=$piece(input,"-",1)
        . . . set N2=$piece(input,"-",2)
        . . . do Remove(.Array,"Should Add",N1,N2)
        . . set input="R"

        do Lock50dot6
        quit


Remove(Array,Label,Num,EndNum)
        ;"Purpose: To remove name(s) from Array of additions to VA GENERIC file
        ;"Input: Array -- PASS BY REFERENCE, array holding data, As created by CheckGenerics()
        ;"       Label -- the section of the array to extract from (i.e. "Already Present", or "Should Add" etc.)
        ;"       Num -- entry number to add
        ;"       EndNum -- OPTIONAL.  If supplied, then range of Num-EndNum are all added.
        ;"Output:  Those values that are removed are changed to a different node, i.e.
        ;"              Array("Should Add",count,Generic)=""
        ;"Results: none

        set EndNum=$get(EndNum,Num)
        new i,Generic,Y

        for i=Num:1:EndNum do
        . set Generic=$order(Array(Label,i,""))
        . if Generic'="" do
        . . ;"set Array("Rescan",i,Generic)=""
        . . set Array("Should Add",i,Generic)=""
        . . kill Array(Label,i)

        quit


CustLookup(Array,Label,Num)
        ;"Purpose: To manually link entry in Array to an existing entry in VA GENERIC file
        ;"Input: Array -- PASS BY REFERENCE, array holding data, As created by CheckGenerics()
        ;"               Results are passed back in Array
        ;"              Array(GENERIC NAME)=IEN in VA GENERIC file^Name
        ;"              Array(GENERIC NAME)=IEN in VA GENERIC file^Name
        ;"       Label -- the section of the array to extract from (i.e. "Already Present", or "Should Add" etc.)
        ;"       Num -- entry number to add
        ;"Results: none

        new DIC,X,Y,Generic
        set DIC=50.6
        set DIC(0)="AEQM"

        set Generic=$order(Array(Label,Num,""))
        if Generic'="" do
        . write !,"Look up an entry to match with: ",Generic
        . do ^DIC
        . if +Y>0 do
        . . kill Array(Label,Num,Generic)
        . . set Array(Generic)=Y

        quit


DoAdds(Array,Label,Num,EndNum)
        ;"Purpose: To extract name(s) from Array and add to VA GENERIC file, via Add1Generic
        ;"Input: Array -- PASS BY REFERENCE, array holding data, As created by CheckGenerics()
        ;"       Results -- PASS BY REFERENCE.  An OUT array to received results
        ;"              Results(GENERIC NAME)=IEN in VA GENERIC file^Name
        ;"              Results(GENERIC NAME)=IEN in VA GENERIC file^Name
        ;"       Label -- the section of the array to extract from (i.e. "Already Present", or "Should Add" etc.)
        ;"       Num -- entry number to add
        ;"       EndNum -- OPTIONAL.  If supplied, then range of Num-EndNum are all added.
        ;"Results: none

        set EndNum=$get(EndNum,Num)
        new i,Generic,Y

        for i=Num:1:EndNum do
        . set Generic=$order(Array(Label,i,""))
        . if Generic'="" do
        . . set Y=$$Add1Generic(Generic)
        . . if +Y>0 do
        . . . set Array(Generic)=Y
        . . . kill Array(Label,i,Generic)
        . . . ;"set Array("Already Present",i,Generic)=Y

        quit


Add1Generic(Name)
        ;"Purpose: To add on entry to the VA GENERIC FILE
        ;"Input: the name of the genric to be added.  Should be 3-64 characters in length
        ;"Results: returns the added entry: IEN^NAME, or -1 if Fileman error
        ;"Note: This function assumes that the file as been UNLOCKED via Unlock50dot6

        new X,DIC
        set DIC=50.6
        set DIC(0)="XL"
        set X=Name
        do ^DIC

        quit Y


 ;"--------------------------------

HandleQAdds(Array)
        ;"Purpose: To review 'Uncertain Matches' node of Array and allow user to specify whether
        ;"      to accept equivilence of match, or to disallow link and add new GENERIC name.
        ;"Input: Array -- PASS BY REFERENCE  the array generated by CheckGenerics
        ;"              Results are passed back in Array
        ;"              Array(GENERIC NAME)=IEN in VA GENERIC file
        ;"              Array(GENERIC NAME)=IEN in VA GENERIC file
        ;"              Array(GENERIC NAME)=IEN in VA GENERIC file
        ;"Output: results returned in Results array, as above.
        ;"Results: none

        do Unlock50dot6

        new done set done=0
        new input set input="R"

        for  do  quit:(done=1)
        . if input="R" do
        . . write !!
        . . write "-------------------------------------------------------------------",!
        . . write "Specify which links between New --> Existing GENERIC names are OK",!
        . . write "-------------------------------------------------------------------",!
        . . do ShowList(.Array,"Uncertain Matches")
        . . write "-------------------------------------------------------------------",!
        . . write "Specify which links between New --> Existing GENERIC names are OK",!
        . . write "-------------------------------------------------------------------",!
        . write "  R to refresh, ? for instructions",!
        . write "  # or #-#, ^ to continue, X remove from list",!
        . write "Enter number(s) to ACCEPT (or codes listed above): ^//"
        . read input,!
        . if input="" set input="^"
        . set input=$$UP^XLFSTR(input)
        . if input="^" set done=1
        . if (input="?") do
        . . ;"do ShowInstructions
        . . set input="R"
        . if +input=input do
        . . do DoLinks(.Array,+input)
        . . set input="R"
        . if input["-" do
        . . new N1,N2
        . . set N1=$piece(input,"-",1)
        . . set N2=$piece(input,"-",2)
        . . do DoLinks(.Array,N1,N2)
        . . set input="R"
        . if input="S" do
        . . read "Enter number to re-SCAN: ",input,!
        . . if +input=input do
        . . . do Rescan(.Array,"Uncertain Matches",+input)
        . if input="X" do
        . . read "Enter number(s) to REMOVE from list: ",input,!
        . . if +input=input do
        . . . do Remove(.Array,"Uncertain Matches",+input)
        . . if input["-" do
        . . . new N1,N2
        . . . set N1=$piece(input,"-",1)
        . . . set N2=$piece(input,"-",2)
        . . . ;"do Remove(.Array,"Uncertain Matches",N1,N2)
        . . set input="R"

        do Lock50dot6
        quit


DoLinks(Array,Num,EndNum)
        ;"Purpose: To change a link from the "Uncertain Matches" node, to a formal link
        ;"Input: Array -- PASS BY REFERENCE  the array generated by CheckGenerics
        ;"              Results are passed back in Array
        ;"              Array(GENERIC NAME)=IEN in VA GENERIC file^Name
        ;"              Array(GENERIC NAME)=IEN in VA GENERIC file^Name
        ;"              Array(GENERIC NAME)=IEN in VA GENERIC file^Name
        ;"       Num -- entry number to add
        ;"       EndNum -- OPTIONAL.  If supplied, then range of Num-EndNum are all added.
        ;"Results: none

        set EndNum=$get(EndNum,Num)
        new i,TMGGeneric,VAGeneric,Y

        for i=Num:1:EndNum do
        . set TMGGeneric=$order(Array("Uncertain Matches",i,""))
        . if TMGGeneric'="" do
        . . if $data(Array("Uncertain Matches",i,TMGGeneric))>0 do
        . . . set VAGeneric=$order(Array("Uncertain Matches",i,TMGGeneric,""))
        . . . set Y=$get(Array("Uncertain Matches",i,TMGGeneric,VAGeneric))
        . . else  do  ;"pick from multiple options.
        . . . set Y=$$DoMltLink(.Array,i,TMGGeneric)
        . . if +Y>0 do
        . . . ;"kill Array("Uncertain Matches",i,TMGGeneric,VAGeneric)
        . . . kill Array("Uncertain Matches",i,TMGGeneric)
        . . . set Array(TMGGeneric)=Y

        quit

DoMltLink(Array,Num,TMGGeneric)
        ;"Purpose: To interact with user and pick which link (amoung multiple)
        ;"Input: Array -- PASS BY REFERENCE. Array as created by CheckGenerics
        ;"       Num -- The number in the "Uncertain Matches" to pick amoung.
        ;"       TMGGeneric -- the Generic Name for to look for a match to
        ;"Results: The selected link: i.e. IEN^Name, or "" if not found


        new VAGeneric,j,tempResults
        new name,input,result
        new NumAnswers set NumAnswers=0

        set VAGeneric=$order(Array("Uncertain Matches",Num,TMGGeneric,""))
        if VAGeneric'="" for j=1:1 do  quit:(VAGeneric="")
        . set tempResults(j)=$get(Array("Uncertain Matches",Num,TMGGeneric,VAGeneric))
        . set NumAnswers=j
        . set VAGeneric=$order(Array("Uncertain Matches",Num,TMGGeneric,VAGeneric))

        if NumAnswers=1 set result=$get(tempResult(1)) goto DMLDone

        write "Please select match for ",TMGGeneric,!
        for j=1:1 do  quit:(name="")
        . set name=$get(tempResult(j))
        . if name="" quit
        . write "   ",j,".  ",$piece(name,"^",2),!

        read "Enter number of match (^ to quit): ^// ",input,!
        set result=$get(tempResult(+input))

DMLDone
        quit result


 ;"===========================================================================

FillCompFile(Array)
        ;"Purpose: To take the list (generated in FillGenerics(), with its linkages
        ;"         between new drug names and existing drug name data, and fill
        ;"         in field .08 in file TMG FDA IMPORT COMPILED
        ;"Input: Array -- PASS BY REFERENCE.  List of linkages between names.
        ;"              Array(GENERIC NAME)=IEN in VA GENERIC file^Name
        ;"              Array(GENERIC NAME)=IEN in VA GENERIC file^Name
        ;"              Array(GENERIC NAME)=IEN in VA GENERIC file^Name
        ;"Output: Data is put into TMG FDA IMPORT COMPILED
        ;"Results: none

        write "Filling field .08 (VA GENERIC) in file TMG FDA IMPORT COMPILED",!
        write "based on data from field .07 (GENERIC NAME)...",!

        new TMGGeneric,VAGeneric
        new IEN,oldval
        new count set count=0

        new Itr,IEN
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)
        . if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 quit ;"1=SKIP
        . set TMGGeneric=$piece($get(^TMG(22706.9,IEN,0)),"^",6)  ;"0;6 --> field .07, GENERIC NAME
        . set oldval=$piece($get(^TMG(22706.9,IEN,1)),"^",3) ;"1;3 --> field .08, VA GENERIC
        . if (+oldval'=0)!(TMGGeneric="") quit
        . set VAGeneric=$get(Array(TMGGeneric))
        . if +VAGeneric>0 do
        . . if +VAGeneric'=oldval do
        . . new TMGFDA,TMGMSG
        . . set TMGFDA(22706.9,IEN_",",.08)=+VAGeneric
        . . do FILE^DIE("K","TMGFDA","TMGMSG")
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . . set count=count+1
        . . ;"write "Stored ",$piece(VAGeneric,"^",2)," in record# ",IEN,!
        . else  do
        . . write !,"Can't find entry for: ",TMGGeneric,!
        do ProgressDone^TMGITR(.Itr)
        write count," records modified.",!

        quit



