TMGNDF3C ;TMG/kst/FDA Import: Create DRUG entries ;03/25/06
         ;;1.0;TMG-LIB;**1**;11/21/06
 
 ;" FDA - NATIONAL DRUG FILES COMPILING FUNCTIONS
 ;"      Creation of records in file 50 (DRUG file)
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"11-21-2006
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"Menu
 
 ;"Refresh1(IEN22706d9,Option) -- Refresh one drug from 22706.9
 ;"RefreshBatch(IENArray,Option) -- Refres batch entries in 22706.9
 
 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 ;"RefreshNonSkips --  Refresh all non-skipped records in 22706.9
 ;"GetAddList(List): get list of entries in VA PRODUCT (50.68) not having corresponding entry in DRUG file (50)
 ;"EnsureFromList(List) -- Add to DRUG file (50) from TMG FDA IMPORT COMPILED
 ;"Update50(IEN50,DrugInfo,Option) -- refresh info in DRUG (50) file, or add if it doesn't exist (or delete if needed)
 ;"GetTMGDrugInfo(fdaIEN,DrugInfo) -- Create a very abbreviated version of the DrugInfo array
 ;"Stuff50(IEN50,DrugInfo,Option) -- synch record(s) in the DRUG file, based on entry from VA PRODUCT file
 ;"SetupFDA(DrugInfo,IENS,TMGFDA) -- setup FDA for data for record in DRUG file
 ;"AddMsg(IEN50,Msg) -- Add a message in the Activity log field
 
 ;"=======================================================================
 ;"=======================================================================
 ;"NOTE: Data mapping:
 ;"      File 50, .01 field (name) is filled with data from file 22706.9, from on
 ;"      of two possible fields:
 ;"         If entry in 50 represents a GENERICNAME drug, then .01 <--- .076
 ;"         If entry in 50 represents a TRADENAME drug, then .01 <--- .056
 ;"=======================================================================
 ;"=======================================================================
 ;"Q:  Where is BatchTo50 (i.e. 50.68-->50)??
 ;"A:  There are many entries in 50.68 that I don't want put into 50, so I need
 ;"      to do this:       22706.9 --> 50.68
 ;"                        22706.9 --> 50
 ;"      instead of this:  22706.9 --> 50.68 --> 50
 ;"=======================================================================
Menu
        ;"Purpose: Provide menu to entry points of main routines
 
        new Menu,UsrSlct
        set Menu(0)="Pick Option for Synchronizing Imports Data to file 50 (3C)"
        set Menu(1)="Synchronize DRUG file with import data"_$char(9)_"RefreshNonSkips"
        set Menu(2)="Verify Synchronization"_$char(9)_"VerifySync"
        set Menu("P")="Prev Stage"_$char(9)_"Prev"
        set Menu("N")="Next Stage"_$char(9)_"Next"
 
MC1     write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
        if UsrSlct="^" goto MCDone
        if UsrSlct=0 set UsrSlct=""
 
        if UsrSlct="RefreshNonSkips" do RefreshNonSkips goto MC1
        if UsrSlct="VerifySync" do VerifySync goto MC1
        if UsrSlct="Prev" goto Menu^TMGNDF3A  ;"quit can occur from there...
        if UsrSlct="Next" goto Menu^TMGNDF3D  ;"quit can occur from there...
        goto MC1
 
MCDone
        quit
 
 
RefreshNonSkips
        ;"Purpose: To work on ALL records in 22706.9 that are not marked to be
        ;"         skipped, and ensure that all is refreshed appropriately
 
        new tempList
 
        new AddCt,OKCt
        set AddCt=0,OKCt=0
        new Itr,IEN
        new abort set abort=0
        write !,"Gathering list of imports to use (those not marked to be skipped)...",!
        set IEN22706d9=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN22706d9")
        if IEN22706d9'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN22706d9)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . if +$piece($get(^TMG(22706.9,IEN22706d9,1)),"^",4)=1 quit ;"1=SKIP
        . new tIEN50 set tIEN50=+$piece($get(^TMG(22706.9,IEN22706d9,7)),"^",1)
        . new gIEN50 set gIEN50=+$piece($get(^TMG(22706.9,IEN22706d9,7)),"^",2)
        . set tempList(IEN22706d9)=""
        . if (tIEN50>0)&(gIEN50>0) set OKCt=OKCt+1
        . else  set AddCt=AddCt+1
        do ProgressDone^TMGITR(.Itr)
 
        write !,AddCt," items may be added to DRUG file (if appropriate).",!
        write OKCt," items will be refreshed in DRUG file.",!
 
        new % set %=1
        write "Proceed" do YN^DICN write !
        if %'=1 goto RNSDone
 
        do EnsureFromList(.tempList)
 
RNSDone
        quit
 
RefreshBatch(IENArray,Option)
        ;"Purpose: To take entries in 22706.9 and refresh them
        ;"Input: IENArray -- PASS BY REFERENCE.  Array of IENs from 22706.9
        ;"              IENArray(IEN22706d9)=""
        ;"              IENArray(IEN22706d9)=""
        ;"       Option -- OPTIONAL. Format:
        ;"                  Option("FIX CHAIN")=1  <--- changes will be propigate forward
        ;"                   to file 50, POI, OI, OQV etc.
        ;"                  Option("QUIET")=1
 
        ;"Results: none
 
        new IEN22706d9,Itr
        new abort set abort=0
        set IEN22706d9=$$ItrAInit^TMGITR("IENArray",.Itr)
        do PrepProgress^TMGITR(.Itr,1,1,"IEN22706d9")
        if IEN22706d9'="" for  do  quit:($$ItrANext^TMGITR(.Itr,.IEN22706d9)="")!abort
        . ;"write !,"Refreshing compiled entry #",IEN227606d9,!
        . do Refresh1(IEN22706d9,.Option)
        quit
 
 
Refresh1(IEN22706d9,Option)
        ;"Purpose: To take one entry in 22706.9 and refresh it
        ;"Input: IEN22706d9 -- IEN from 22706.9
        ;"       Option -- OPTIONAL. Format:
        ;"                  Option("FIX CHAIN")=1  <--- changes will be propigate forward
        ;"                   to file 50, POI, OI, OQV etc.
        ;"Results: none
 
        new gIEN50,tIEN50
        new skip
        set skip=($piece($get(^TMG(22706.9,IEN22706d9,1)),"^",4)=1)
 
        if $get(Option("FIX CHAIN"))=1 do
        . new temp
        . set tIEN50=+$piece($get(^TMG(22706.9,IEN22706d9,7)),"^",1)
        . set Option("IEN50","TRADE")=tIEN50
        . set gIEN50=+$piece($get(^TMG(22706.9,IEN22706d9,7)),"^",2)
        . set Option("IEN50","GENERIC")=gIEN50
        . set Option("FIX CHAIN","IEN22706d9")=IEN22706d9
 
        new List
        if skip set List(IEN22706d9)="S"
        else  set List(IEN22706d9)=""
 
        do EnsureFromList(.List,.Option)
 
        if $get(Option("FIX CHAIN"))=1 do
        . if tIEN50>0 set temp=$$Fix1Drug^TMGNDF3D(tIEN50,IEN22706d9)
        . if gIEN50>0 set temp=$$Fix1Drug^TMGNDF3D(gIEN50,IEN22706d9)
 
        quit
 
 
EnsureFromList(List,Option)
        ;"Purpose: to add entries to, or refresh fields in, DRUG file (50) based on
        ;"         data from TMG FDA IMPORT COMPILED (22706.9),
        ;"         OR to ensure that the linked records are properly refreshed.
        ;"         OR ensure that records liked from a skipped record are deleted
        ;"Input: List -- PASS BY REFERENCE, format:
        ;"               List(IEN22706d9)=""
        ;"               List(IEN22706d9)=""
        ;"               List(IEN22706d9)="S" <-- record now skipped, so ensure linked records are removed
        ;"       Option -- OPTIONAL. Format:
        ;"                  Option("FIX CHAIN")=1  <--- changes will be propigate forward
        ;"                   to file 50, POI, OI, OQV etc.
        ;"                  OPTION("FIX CHAIN","IEN22706d9")=Source IEN
        ;"                  Option("QUIET")=1 <-- supress text output
        ;"Results: none
 
        new IEN22706d9,Itr
        new error set error=0
        new abort set abort=0
        new ChangeCt set ChangeCt=0
        new quiet set quiet=($get(Option("QUIET"))=1)
        do Unlock50^TMGNDFUT
 
        if 'quiet write "Scanning import file, to ensure all records in DRUG file are updated...",!
        set IEN22706d9=$$ItrAInit^TMGITR("List",.Itr)
        if 'quiet do PrepProgress^TMGITR(.Itr,20,0,"IEN22706d9")
        if IEN22706d9>0 for  do  quit:($$ItrANext^TMGITR(.Itr,.IEN22706d9)'>0)!abort
        . new DrugInfo,ndcIEN,tempS,error,temp,vapIEN,temp
        . new skip set skip=($get(List(IEN22706d9))="S")
        . set error=0,temp=0,tempS=""
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . set vapIEN=+$piece($get(^TMG(22706.9,IEN22706d9,6)),"^",2)
        . if skip=0,vapIEN>0,$data(^PSNDF(50.68,vapIEN))=0 do
        . . if 'quiet write "Pointer to VA PRODUCT from File 22709.9, IEN# ",IEN22706d9," is invalid.  Will delete.",!
        . . set vapIEN=0
        . . new TMGMSG,TMGFDA
        . . set TMGFDA(22706.9,fdaIEN_",",5.5)="@"
        . . do FILE^DIE("K","TMGFDA","TMGMSG")
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)  ;"show errors, even if quiet
        . if skip=0,vapIEN'>0 set error=1 quit
        . set temp=$$GetTMGDrugInfo(IEN22706d9,.DrugInfo)
        . if skip=0,temp=0 set error=1 quit
        . if skip=1 set Option("DELETING")=1
        . ;"--- work on Trade Name link ---
        . if ($get(DrugInfo("NAME","TRADE"))=$get(DrugInfo("NAME","GENERIC"))) set DrugInfo("NAME","TRADE")=""
        . new tIEN50 set tIEN50=+$piece($get(^TMG(22706.9,IEN22706d9,7)),"^",1) ;"DRUG TRADENAME LINK
        . set Option("CUR MODE")="TRADE"
        . set temp=$$Update50(tIEN50,.DrugInfo,.Option) ;"may chain forward
        . if temp=1 set ChangeCt=ChangeCt+1
        . else  if temp=-1 set error=1 ;"quit
        . ;"--- work on Generic Name link ---
        . new gIEN50 set gIEN50=+$piece($get(^TMG(22706.9,IEN22706d9,7)),"^",2) ;"DRUG GENERIC LINK
        . if gIEN50=tIEN50 set gIEN50=0
        . set Option("CUR MODE")="GENERIC"
        . set temp=$$Update50(gIEN50,.DrugInfo,.Option) ;"may chain forward
        . if temp=1 set ChangeCt=ChangeCt+1
        . else  if temp=-1 set error=1 ;"quit
        if error write "Error with import : IEN22706d9=",IEN22706d9,!
 
        if 'quiet do
        . write ChangeCt," Records Modified.",!
        . do PressToCont^TMGUSRIF
 
        do Unlock50^TMGNDFUT
        quit
 
 
GetTMGDrugInfo(IEN22706d9,DrugInfo)
        ;"Purpose: Create a very abbreviated version of the DrugInfo array
        ;"      This is because calling GetDrugInfo^TMGNDF1A is unneccesarily SLOW
        ;"      Also, it makes one dependant on FDA primary files.
        ;"Input: IEN22706d9 -- IEN in file 22706.9
        ;"       DrugInfo -- PASS BY REFERENCE.  Format:
        ;"              DrugInfo("NDC")
        ;"Output:  DrugInfo("NAME","TRADE")=.056 field
        ;"         DrugInfo("NAME","GENERIC")=.076 field
        ;"         DrugInfo("SOURCE IEN")=source IEN in 22706.9
        ;"         DrugInfo("IEN 50.68")=field 5.5, a pointer to 50.68 (VA PRODUCT)
        ;"Results: 1=OK to continue, 0=error
        ;"NOTE: 11/5/07  Modifying to make use of fields .055 and .075, where name is
        ;"      prepaired and stored in a previous step.
        ;"NOTE: 11/10/07  Modifying to make use of fields .056 and .076, where name is
        ;"      prepaired and stored in a previous step.
 
        kill DrugInfo
        new result set result=1
        set DrugInfo("NDC")=$piece($get(^TMG(22706.9,IEN22706d9,1)),"^",1)
        if DrugInfo("NDC")="" set result=0
 
        set DrugInfo("SOURCE IEN")=IEN22706d9
        set DrugInfo("IEN 50.68")=+$piece($get(^TMG(22706.9,IEN22706d9,6)),"^",2)
 
        new tempS set tempS=$piece($get(^TMG(22706.9,IEN22706d9,8)),"^",1)  ;".056 TRADENAME FORM DOSE UNIT - 40
        if tempS'="" set DrugInfo("NAME","TRADE")=tempS
 
        new tempS set tempS=$piece($get(^TMG(22706.9,IEN22706d9,8)),"^",2)  ;".076  GENERICNAME FORM DOSE UNT - 40
        if tempS'="" set DrugInfo("NAME","GENERIC")=tempS
 
GDIDone
        quit result
 
 
Update50(IEN50,DrugInfo,Option)
        ;"Purpose: to refresh info in DRUG file, or add if it doesn't exist (or delete if needed)
        ;"Input: IEN50: Target IEN to refresh, or 0 if needs to be added
        ;"       DrugInfo -- PASS BY REFERENCE.  Format:
        ;"              DrugInfo("NDC")
        ;"              DrugInfo("NAME","TRADE")=.056 field
        ;"              DrugInfo("NAME","GENERIC")=.076 field
        ;"              DrugInfo("SOURCE IEN")=source IEN in 22706.9
        ;"              DrugInfo("IEN 50.68")=field 5.5, a pointer to 50.68 (VA PRODUCT)
        ;"       Option -- NON-OPTIONAL part. Format:
        ;"                  Option("CUR MODE")="TRADE"
        ;"       Option -- OPTIONAL part. Format:
        ;"                  Option("FIX CHAIN")=1  <--- changes will be propigate forward
        ;"                   to file 50, POI, OI, OQV etc.
        ;"                  OPTION("FIX CHAIN","IEN22706d9")=Source IEN
        ;"                  Option("QUIET")=1 <-- supress text output
        ;"                  Option("DELETING")=1 <-- deleting chain (not IEN22706d9)
        ;"Result: -1 = error, 0=info refreshed, 1=record added.
 
        new result set result=0
        new quiet set quiet=$get(Option("QUIET"))=1
        new IEN22706d9 set IEN22706d9=+$get(DrugInfo("SOURCE IEN"))
        new mode set mode=$get(Option("CUR MODE"))
        if (mode'="TRADE")&(mode'="GENERIC") set result=-1 goto UDDone
 
        new StoreField,node,pce
        if mode="TRADE" set StoreField=5.6,node=7,pce=1
        else  set StoreField=5.7,node=7,pce=2
 
        new drugName set drugName=$get(DrugInfo("NAME",mode))
        set DrugInfo("NAME",mode)=drugName
        if (drugName="")!(drugName="<DUPLICATE>")!($get(Option("DELETING"))=1) do  goto UDDone
        . do Kill50^TMGNDFUT(IEN50,IEN22706d9,mode,quiet) ;"is OK if IEN50=0
        . set result=-1
 
        if (IEN50>0),$data(^PSDRUG(IEN50))=0 do
        . set IEN50=0  ;"I found case of dangling pointer
 
        if IEN50=0 do   ;"Create stub entry with drug name in .01 field
        . new PSSZ set PSSZ=1  ;"allows code to add entries into DRUG file.
        . new TMGFDA,TMGMSG,TMGIEN,IENS
        . set TMGFDA(50,"+1,",.01)=drugName
        . do UPDATE^DIE("S","TMGFDA","TMGIEN","TMGMSG")
        . do ShowDIERR^TMGDEBUG(.TMGMSG)
        . set IEN50=+$get(TMGIEN(1)) if IEN50=0 quit
        . do AddMsg(IEN50,"TMG AUTOADDED FROM FDA")
        . set Option("IEN50",mode)=IEN50
        . set Option("IEN50",mode,"NAME")=drugName
 
        set DrugInfo("CUR MODE")=mode
        set temp=$$Stuff50(IEN50,.DrugInfo,.Option)  ;"no chain forward
        if temp=0 set result=-1
        if temp=2 set result=1
 
        ;"Ensure pointer to DRUG (50) is stored in 22706.9
        if $piece($get(^TMG(22706.9,IEN22706d9,node)),"^",pce)'=IEN50 do
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.9,IEN22706d9_",",StoreField)=IEN50
        . do FILE^DIE("K","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . set Option("IEN50",mode)=IEN50
 
        if $get(Option("FIX CHAIN"))=1 do
        . new temp set temp=$$POIFromTMG^TMGNDF4A(IEN22706d9,.Option) ;" --> more chain from here
        . ;"if $get(Option("DELETING"))=1 do
        . ;". do Kill50^TMGNDFUT(IEN50,IEN22706d9,mode,quiet) ;"is OK if IEN50=0
 
UDDone
        quit result
 
 
Stuff50(IEN50,DrugInfo,Option)
        ;"Purpose: To synch record(s) in the DRUG file
        ;"Input: IEN50 -- IEN of record in file 50 to update
        ;"       DrugInfo -- PASS BY REFERENCE -- Drug info array.  Format:
        ;"              DrugInfo("NAME","GENERIC")=e.g.   NAME: DILTIAZEM 240MG
        ;"              DrugInfo("NAME","TRADE")=e.g.   NAME: CARDIZEM CD 240MG
        ;"              DrugInfo("NDC")
        ;"              DrugInfo("SOURCE IEN")=source IEN in 22706.9
        ;"              DrugInfo("IEN 50.68")=field 5.5, a pointer to 50.68 (VA PRODUCT)
        ;"       Option -- NON-OPTIONAL part. Format:
        ;"                  Option("CUR MODE")="TRADE"
        ;"       Option -- OPTIONAL. Format:
        ;"                  Option("FIX CHAIN")=1  <--- changes will be propigate forward
        ;"                   to file 50, POI, OI, OQV etc.
        ;"                  OPTION("FIX CHAIN","IEN22706d9")=Source IEN
        ;"                  Option("QUIET")=1 <-- supress text output
        ;"Output: A record will be added to file DRUG (50)
        ;"Result: 1=OK to continue, 2=change made, 0 if error
 
        ;"Note: must set PSSZ=1 to be allowed to enter entries into DRUG file.
 
        new result set result=1 ;"default to success -- don't change.
        new PSSZ set PSSZ=1  ;"allows code to add entries into DRUG file.
 
        ;"Remove any synonyms
RF1     new numSyns
        for  do  quit:(numSyns'>0)
        . set numSyns=+$piece($get(^PSDRUG(IEN50,1,0)),"^",4)  ;"number of records
        . if numSyns=0 quit
RF2     . set subIEN=$order(^PSDRUG(IEN50,1,0))
        . if (subIEN'>0) set numSyns=0 quit
        . new TMGFDA,TMGMSG
        . set TMGFDA(50.1,subIEN_","_IEN50_",",.01)="@"
        . do FILE^DIE("K","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . set result=2
 
        new TMGFDA,TMGMSG,TMGIEN
 
        set result=$$SetupFDA(.DrugInfo,IEN50_",",.TMGFDA)
        if result=0 goto RFDone
        new temp set temp=$$TrimFDA^TMGDBAPI(.TMGFDA)
        if $data(TMGFDA)=0 goto RFDone
 
        do FILE^DIE("KS","TMGFDA","TMGMSG")
        if $data(TMGMSG("DIERR")) do  goto RFDone
        . set result=0
        . if $get(Quiet)=1 quit
        . write !,"Error editing record in file 50",!
        . new PriorErrorFound
        . do ShowDIERR^TMGDEBUG(.TMGMSG,.PriorErrorFound)
 
        do AddMsg(IEN50,"TMG AUTO UPDATED FROM FDA")
        set result=2  ;"update made.
 
RFDone  quit result
 
 
AddMsg(IEN50,Msg)
        ;"Purpose: to Add a message in the Activity log field
        ;"Input: IEN50 -- the IEN in DRUG file
        ;"       Msg -- the Message to add (a string)
        ;"results: none.
 
        ;"Check that record was added, then then add subfile entries:
        set IENS="+1,"_IEN50_","
        kill TMGFDA,TMGMSG,TMGIEN
        ;"       214  ACTIVITY LOG                   <-Mult [50.0214DA]
        ;"          .01   -ACTIVITY LOG                                [D]
        ;"            1   -REASON                                      [S]
        ;"            2   -INITIATOR OF ACTIVITY           <-Pntr  [P200']
        ;"            3   -FIELD EDITED                                [F]
        ;"            4   -NEW VALUE                                   [F]
        ;"            5   -NDF UPDATE                                  [F]
        set TMGFDA(50.0214,IENS,.01)="NOW"
        set TMGFDA(50.0214,IENS,1)="E"
        set TMGFDA(50.0214,IENS,2)="`"_DUZ
        set TMGFDA(50.0214,IENS,3)="ALL FIELDS"
        set TMGFDA(50.0214,IENS,4)=Msg
 
        do UPDATE^DIE("ES","TMGFDA","TMGIEN","TMGMSG")
        if $get(Quiet)'=1 do ShowIfDIERR^TMGDEBUG(.TMGMSG)
 
        quit
 
 
SetupFDA(DrugInfo,IENS,TMGFDA)
        ;"Purpose: To set up the FDA (Filman data array) for the data that will go into
        ;"         a record to the DRUG file, based on entry from VA PRODUCT file
        ;"Input: DrugInfo -- PASS BY REFERENCE -- Drug info from array GetTMGDrugInfo, and
        ;"              as modified by Add2VAProd^TMGNDF3A
        ;"           Fields used are:
        ;"              DrugInfo("CUR MODE")="GENERIC" or "TRADE"
        ;"              DrugInfo("NAME","GENERIC")=e.g.   NAME: DILTIAZEM 240MG
        ;"              DrugInfo("NAME","TRADE")=e.g.   NAME: CARDIZEM CD 240MG
        ;"              DrugInfo("NDC")
        ;"              DrugInfo("SOURCE IEN")=source IEN in 22706.9
        ;"              DrugInfo("IEN 50.68")=field 5.5, a pointer to 50.68 (VA PRODUCT)
        ;"      IENS -- a standard fileman IENS for this FDA to be created with
        ;"      TMGFDA -- PASS BY REFERENCE -- an OUT PARAMETER.  This will be a standard
        ;"               fileman FDA
        ;"Output: TMGFDA will be filled
        ;"Result: 1=OK to continue, 0 if error
 
        ;"NOTE: The FDA that this function contains will contain INTERNAL values
 
        new result set result=1 ;"default to success -- don't change.
        new mode set mode=$get(DrugInfo("CUR MODE"))
        if (mode'="TRADE")&(mode'="GENERIC") set result=0 goto SUFDone
 
        new TMGMSG,TMGIEN
        new tempS,tempIEN
        new IEN22706d9 set IEN22706d9=+$get(DrugInfo("SOURCE IEN"))
 
        ;"Example Entry. (Edited for fields I care about)
        ;"#50  .01  GENERIC NAME: DILTIAZEM CD 120MG CAP
        ;"#50.68   .01  NAME                                        [RFa]
        ;"#50.68              e.g.   NAME: DILTIAZEM (CARDIZEM CD) 240MG SA CAP
        set tempS=$get(DrugInfo("NAME",mode))
        set tempS=$translate(tempS,";",":")  ;" for some reason ';' is not allowed in .01 field
        if $length(tempS)>40 set tempS=$extract(tempS,1,37)_"..."
        set TMGFDA(50,IENS,.01)=tempS
 
        ;"#50   22  PSNDF VA PRODUCT NAME ENTRY: DILTIAZEM (CARDIZEM CD) 120MG SA CAP
        ;"#50.68   .01  NAME                                        [RFa]
        ;"#50.68              e.g.   NAME: DILTIAZEM (CARDIZEM CD) 240MG SA CAP
        new vapIEN set vapIEN=+$get(DrugInfo("IEN 50.68"))
        if +vapIEN>0 DO
        . set TMGFDA(50,IENS,22)=vapIEN
        . new vapName
        . set vapName=$$GET1^DIQ(50.68,vapIEN,.01)
        . ;"#50   21  VA PRODUCT NAME: DILTIAZEM (CARDIZEM CD) 120MG SA CAP
        . ;"#50.68   .01  NAME                                        [RFa]
        . ;"#50.68              e.g.   NAME: DILTIAZEM (CARDIZEM CD) 240MG SA CAP
        . set TMGFDA(50,IENS,21)=vapName
        . ;"set TMGFDA(50,IENS,21)=tempS
 
        ;"#50    5  STANDARD SIG: T1 CAP QD
        ;"      plan "USE AS DIRECTED"
        set TMGFDA(50,IENS,5)="USE AS DIRECTED"
 
        ;"#50   20  NATIONAL DRUG FILE ENTRY: DILTIAZEM   <-Pntr  [P50.6, VA GENERIC]
        set tempIEN=+$piece($get(^TMG(22706.9,IEN22706d9,1)),"^",3) ;"1;3 = field .08 VA GENERIC
        if tempIEN>0 set TMGFDA(50,IENS,20)=tempIEN
 
        ;"#50   25  NATIONAL DRUG CLASS            <-Pntr  [P50.605']
        ;"#50    2  VA CLASSIFICATION                            [FX]
        set tempIEN=+$piece($get(^TMG(22706.9,IEN22706d9,1)),"^",5) ;"1;5 = field .09 VA DRUG CLASS
        set TMGFDA(50,IENS,25)=tempIEN
        set tempClass=$$GET1^DIQ(50.605,tempIEN_",",.01)
        if tempClass'="" set TMGFDA(50,IENS,2)=tempClass
 
        ;"#50   29  NATIONAL FORMULARY INDICATOR: NO
        set TMGFDA(50,IENS,29)=0  ;"0=NO, 1=YES
 
        ;"#50   31  NDC: 0088-1795-30
        new NDC set NDC=$piece($get(^TMG(22706.9,IEN22706d9,1)),"^",1)
        set NDC=$extract(NDC,2,20)  ;"should be in 5-4-2 format, but must be 11 digits, 1st is not significant
        if NDC'="" set TMGFDA(50,IENS,31)=NDC
 
        ;"#50   901 STRENGTH: 120
        new tempStr set tempStr=$piece($get(^TMG(22706.9,IEN22706d9,0)),"^",2) ;"0;2=field 1 STRENGTH
        if tempStr'="" set TMGFDA(50,IENS,901)=tempStr
 
        ;"#50   902 UNIT: MG
        ;"#50.68     3  UNITS                         <-Pntr  [P50.607'a]
        ;"#50.68              e.g.   UNITS: MG
        new tempUnit set tempUnit=$$GET1^DIQ(50.68,vapIEN,3,"I")
        if tempUnit'="" set TMGFDA(50,IENS,902)=tempUnit
 
        ;"#50     62.02  UNIT DOSE MED ROUTE         <-Pntr  [*P51.2']
        ;"#22706.9  3.1  VA ROUTE                    <-Pntr  [P51.2']
        set tempIEN=+$piece($get(^TMG(22706.9,IEN22706d9,7)),"^",7)  ;"7;7   3.1  VA ROUTE
        if tempIEN>0 set TMGFDA(50,IENS,62.02)=tempIEN
 
SUFDone
        quit result
 
 
VerifySync
        ;"To verify the synchronization, i.e. looking for dangling pointers etc.
 
        new ChangeCt set ChangeCt=0
        new Itr,IEN22706d9
        new abort set abort=0
        write !,"Checking Synchronization",!
        set IEN22706d9=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN22706d9")
        if IEN22706d9'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN22706d9)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . ;"if +$piece($get(^TMG(22706.9,IEN22706d9,1)),"^",4)=1 quit ;"1=SKIP
        . new tIEN50 set tIEN50=$piece($get(^TMG(22706.9,IEN22706d9,7)),"^",1)
        . set ChangeCt=ChangeCt+$$Verify1(IEN22706d9,tIEN50,"TRADE")
        . new gIEN50 set gIEN50=$piece($get(^TMG(22706.9,IEN22706d9,7)),"^",2)
        . set ChangeCt=ChangeCt+$$Verify1(IEN22706d9,gIEN50,"GENERIC")
        do ProgressDone^TMGITR(.Itr)
 
        do PressToCont^TMGUSRIF
 
        quit
 
Verify1(IEN22706d9,IEN50,mode)
        ;"To Verify one
        ;"Input: IEN22706d9
        ;"       IEN50 -- link to DRUG file (either for Generic Drug, or Trade Drug)
        ;"       mode - "GENERIC" or "TRADE"
        ;"Result: 0 -- no change, 1= change made
 
        new result set result=0
        new field50 set field50=""
        new fieldName set fieldName=""
        new node,pce set (node,pce)=""
        if mode="GENERIC" do
        . set field50=5.7
        . set fieldName=.076
        . set node=8,pce=2
        else  if mode="TRADE" do
        . set field50=5.6
        . set fieldName=.056
        . set node=8,pce=1
        if (field50="") goto V1Done
        if (IEN50="") goto V1Done
 
        new drugName set drugName=$piece($get(^PSDRUG(IEN50,0)),"^",1)
        new TMGName set TMGName=$piece($get(^TMG(22706.9,IEN22706d9,node)),"^",pce)
        set TMGName=$translate(TMGName,";",":")
 
        if $data(^PSDRUG(+$get(IEN50)))=0 do
        . write "Bad pointer: ",IEN50
        . set IEN50=0
 
        if drugName'=TMGName do
        . write IEN22706d9," (",$extract(mode,1),"): Name mismatch: ",drugName," vs ",TMGName,!
        . if TMGName="" set IEN50=0
 
        if $get(IEN50)=0 do  goto V1Done
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.9,IEN22706d9_",",field50)="@"
        . do UPDATE^DIE("","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . write "  ... fixed.",!
        . set result=1
 
 
V1Done
        quit result
