TMGNDF4F ;TMG/kst/FDA Import -- Explore drugs linked to OQV ;03/25/06
         ;;1.0;TMG-LIB;**1**;01/10/07
 
 ;" FDA - NATIONAL DRUG FILES COMPILING FUNCTIONS
 ;"      Exploration of drugs linked to a selected ORDER QUICK VIEW
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"1-10-2007
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"Menu
 ;"MenuOI(IEN101d43) -- Menu to explore ORDERABLE ITEM
 ;"MenuPOI(OIArray) -- Menu to explore PHARMACY ORDERABLE ITEM
 ;"MenuDrug(IEN50) -- Menu to explore DRUG item.
 ;"MenuFDA(FDA) -- Menu to explore TMG FDA IMPORT COMPILED
 
 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 ;"GetAvail(IEN,Array,sigArray) -- explore the available doses for a given orderable item
 ;"MenuPickRx(IEN50Array,IEN50) -- allow user to pick which linked DRUG entry to explore
 ;"Show1Chain(IENOQV) -- show entire chain, as far back as possible
 ;"ShowAvail(IEN101d43) -- Show available drugs for a given ORDERABLE ITEM (101.43)
 ;"GetAvail(IEN101d43,Array,sigArray) -- explore the available doses for a given ORDERABLE ITEM (101.43)
 ;"$$AskOQV(NameOut) -- ask the user for a ORDER QUICK VIEW drug to view.
 ;"ShowComp(array) -- display all the drugs and sigs for a set of IEN's in 101.43
 ;"DispOI(IEN101d43) -- display the relevent parts of the 101.43 (ORDERABLE ITEM)
 ;"DispPOI(IEN50d7) -- display the relevent parts of the 50.7 (PHARMACY ORDERABLE ITEM)
 ;"DispOQV(IENS) -- display the relevent parts of the 101.44 (ORDER QUICK VIEW)
 ;"DispRx(IEN50) -- display the relevent parts of the 50 (DRUG)
 ;"DispFDA(IEN) -- display the relevent parts of TMG FDA IMPORT COMPILED (22706.9)
 ;"ShowPIa(IEN101d43,RxSet) -- show all links from 101.44 --> 101.43
 ;"PickOI(IENOQV) -- start from a ORDER QUICK VIEW record, and track backwards
 ;"DispDoses(IEN101d43) -- Display possible dosed for a ORDER QUICK VIEW record
 
 
 
 ;"=======================================================================
Menu
        ;"Purpose: Menu for exploring 101.44
 
        new RxSet
        set RxSet=$$GetOQVSet^TMGNDFUT() if RxSet'>0 goto MenuDone
 
        new IENS,IEN101d43,IENOQV,OQVName
        new Menu,UsrSlct,MenuNum
 
M0      kill Menu
        set Menu(0)="Pick Option to explore ORDER QUICK VIEW (4F)"
        if $get(OQVName)'="" set Menu(0)=Menu(0)_": "_OQVName
        set MenuNum=1
        if $data(IENOQV)=0 do
        . set Menu(MenuNum)="Pick ORDER QUICK VIEW"_$char(9)_"PickOQV",MenuNum=MenuNum+1
        else  do
        . set Menu(MenuNum)="Pick *NEW* ORDER QUICK VIEW"_$char(9)_"PickOQV",MenuNum=MenuNum+1
        . set Menu(MenuNum)="Show current ORDER QUICK VIEW"_$char(9)_"ShowOQV",MenuNum=MenuNum+1
        . set Menu(MenuNum)="Show OQV's linked to ORDERABLE ITEM: "_IENOQV("Linked 101.43","Name")_$char(9)_"ShowLinks",MenuNum=MenuNum+1
        . set Menu(MenuNum)="Explore linked ORDERABLE ITEM"_$char(9)_"ExploreOI",MenuNum=MenuNum+1
        . set Menu(MenuNum)="Show Dump of Doses for Current."_$char(9)_"DispOQV",MenuNum=MenuNum+1
        . set Menu(MenuNum)="Show Chain of Linked Files & Entries."_$char(9)_"ShowChain",MenuNum=MenuNum+1
        . set Menu(MenuNum)="Fix current ORDER QUICK VIEW"_$char(9)_"FixCurOQV",MenuNum=MenuNum+1
        set Menu(MenuNum)="Fix Missing ORDER QUICK VIEW."_$char(9)_"FixMissing",MenuNum=MenuNum+1
        set Menu("M")="Show data map"_$char(9)_"Map"
        set Menu("P")="Prev Stage"_$char(9)_"Prev"
        ;"set Menu("N")="Next Stage"_$char(9)_"Next"
 
        write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
 
        if UsrSlct="PickOQV" do  goto M0
        . kill OQVIEN
        . do PickOI(.IENOQV)
        . if $data(IENOQV)=0 quit
        . set OQVName=$$GET1^DIQ(101.442,IENOQV("IENS"),2)
 
        if UsrSlct="ShowOI" do DispOI(IENOQV("Linked 101.43")) goto M0
        if UsrSlct="ShowOQV" do DispOQV(IENOQV("IENS")) goto M0
        if UsrSlct="ShowLinks" do ShowPIa(IENOQV("Linked 101.43"),IENOQV(0)) goto M0
        if UsrSlct="ExploreOI" do MenuOI(IENOQV("Linked 101.43")) goto M0
        if UsrSlct="DispOQV" do DispDoses(IENOQV("Linked 101.43")) goto M0
        if UsrSlct="ShowChain" do Show1Chain(.IENOQV) goto M0
        if UsrSlct="FixMissing" do FixOQVMissing^TMGNDF4G goto M0
        if UsrSlct="FixCurOQV" do FixCurOQV(.IENOQV) goto M0
        if UsrSlct="Map" do  goto M0
        . write "ORDER QUICK VIEW (101.44) --> ORDERABLE ITEM (101.43)",!
        . do PressToCont^TMGUSRIF
        if UsrSlct="Prev" goto Menu^TMGNDF4E  ;"quit can occur from there...
        ;"if UsrSlct="Next" goto Menu^TMGNDF2H  ;"quit can occur from there...
 
        if UsrSlct="^" goto MenuDone
        goto M0
 
MenuDone
        quit
 
MenuOI(IEN101d43)
        ;"Purpose: Menu to explore ORDERABLE ITEM
 
        new OIArray do GetOIInfo^TMGNDFUT(IEN101d43,.OIArray)
        new OIName set OIName=$get(OIArray("IEN 101.43","NAME"))
        if OIName="" goto MBDone
 
        new IEN50d7 set IEN50d7=$get(OIArray("IEN 50.7 from 101.43"))
        new POIName set POIName=$get(OIArray("IEN 50.7 from 101.43","NAME"))
 
        new Menu,UsrSlct
        set Menu(0)="Pick Option to explore ORDERABLE ITEM: "_OIName
        set Menu(1)="Show current ORDERABLE ITEM: "_OIName_$char(9)_"ShowOI"
        set Menu(2)="Explore linked PHARMACY ORDERABLE ITEM: "_POIName_$char(9)_"Explore"
        set Menu(3)="Show CPRS function of all avail doses"_$char(9)_"ShowAvail"
        set Menu(5)="Show Dump of Doses for Current."_$char(9)_"DispOI"
        set Menu("M")="Show data map"_$char(9)_"Map"
 
MB1     write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
 
        if UsrSlct="ShowOI" do DispOI(IEN101d43) goto MB1
        if UsrSlct="Explore" do MenuPOI(.OIArray) goto MB1
        if UsrSlct="ShowAvail" do ShowAvail(IEN101d43) goto MPOI1
        if UsrSlct="DispOI" do DispDoses(IEN101d43) goto MPOI1
 
        if UsrSlct="Map" do  goto MB1
        . write "OQV (101.44) --> ORDERABLE ITEM (101.43) --> PHARMACY ORDERABLE ITEM (50.7)",!
        . do PressToCont^TMGUSRIF
        if UsrSlct="^" goto MBDone
        goto MB1
 
MBDone
        quit
 
 
MenuPOI(Array)
        ;"Purpose: Menu to explore PHARMACY ORDERABLE ITEM
        ;"INPUT:  Array -- PASS BY REFERENCE.  Format:  (as created by GetOIInfo^TMGNDFUT)
        ;"           Array("IEN 50.7 from 101.43")=IEN50d7
        ;"           Array("IEN 50.7 from 101.43","NAME")=Name of 50.7, or "<LINK IS NOT TO A DRUG>" if problem
 
        new IEN50d7 set IEN50d7=$get(Array("IEN 50.7 from 101.43"))
        new POIName set POIName=$get(Array("IEN 50.7 from 101.43","NAME"))
        if POIName="" set POIName=$$GET1^DIQ(50.7,IEN50d7_",",.01)
 
        new IEN50Array
        do GetDRUGs^TMGNDFUT(IEN50d7,.IEN50Array)
        new Menu,UsrSlct
        set Menu(0)="Pick Option to explore PHARMACY ORDERABLE ITEM: "_POIName
        set Menu(1)="Show current PHARMACY ORDERABLE ITEM: "_POIName_$char(9)_"ShowPOI"
        set Menu(2)="Explore a linked DRUG item"_$char(9)_"Explore"
        set Menu("M")="Show data map"_$char(9)_"Map"
 
MPOI1   write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
 
        if UsrSlct="ShowPOI" do DispPOI(IEN50d7) goto MPOI1
        if UsrSlct="Explore" do  goto MB1
        . new IEN50
        . do MenuPickRx(.IEN50Array,.IEN50)
        . if $data(IEN50)=0 quit
        . do MenuDrug(.IEN50)
        if UsrSlct="Map" do  goto MB1
        . write "ORDERABLE ITEM (101.43) --> PHARMACY ORDERABLE ITEM (50.7) --> DRUG (50)",!
        . do PressToCont^TMGUSRIF
 
        if UsrSlct="^" goto MPOIDone
        goto MB1
 
MPOIDone
        quit
 
 
MenuPickRx(IEN50Array,IEN50)
        ;"Purpose: To allow user to pick which linked DRUG entry to explore
        ;"Input: IEN50Array -- PASS BY REFERENCE,  Format:
        ;"              IEN50Array(IEN50)=Name (.01 field) of record
        ;"              IEN50Array(IEN50)=Name (.01 field) of record
 
        ;"       IEN50 -- PASS BY REFERENCE.  An OUT PARAMETER.  Format:
        ;"               IEN50=IEN in 50
        ;"               IEN50("NAME")=Name of 50   -- OPTIONAL
        ;"Results: None
 
        new Menu,UsrSlct
        kill IEN50
        set Menu(0)="Pick DRUG"
        new count set count=1
        new name set name=""
        for  set name=$order(IEN50Array(name)) quit:(name="")  do
        . new IEN set IEN=""
        . for  set IEN=$order(IEN50Array(name,IEN)) quit:(IEN="")  do
        . . set Menu(count)=$get(name)_" #"_IEN_$char(9)_IEN
        . . set count=count+1
 
MPR1    set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
 
        if +UsrSlct=UsrSlct do  goto MPRDone
        . set IEN50=+UsrSlct
        . set IEN50("NAME")=$get(IEN50Array(IEN50))
 
        if UsrSlct="^" goto MPRDone
        goto MPR1
 
MPRDone
        quit
 
 
MenuDrug(IEN50)
       ;"Purpose: Menu to explore DRUG item.
       ;"INPUT:  IEN50 -- PASS BY REFERENCE.  Format:
       ;"           IEN50=IEN in 50
       ;"           IEN50("NAME")=Name of 50   -- OPTIONAL
 
        set IEN50("NAME")=$get(IEN50("NAME"))
        if IEN50("NAME")="" set IEN50("NAME")=$$GET1^DIQ(50,IEN50_",",.01)
 
        new FDA do GetFDA^TMGNDFUT(IEN50,.FDA)
 
        new Menu,UsrSlct
        set Menu(0)="Pick Option to explore DRUG: "_IEN50("NAME")
        set Menu(1)="Show current DRUG item: "_IEN50("NAME")_$char(9)_"ShowDRUG"
        set Menu(2)="Edit current DRUG item: "_IEN50("NAME")_$char(9)_"EditDRUG"
        set Menu(3)="Browse current DRUG item: "_IEN50("NAME")_$char(9)_"Browse"
        set Menu(4)="Explore linked FDA IMPORT: "_FDA("NAME")_$char(9)_"Explore1"
        set Menu("M")="Show data map"_$char(9)_"Map"
        ;"set Menu(2)="Explore linked PHARMACY ORDERABLE ITEM: "_POI("NAME")_$char(9)_"Explore"
 
MRx1    write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
 
        if UsrSlct="ShowDRUG" do DispRx(IEN50) goto MRx1
        if UsrSlct="EditDRUG" do Edit50^TMGNDFUT(IEN50) goto MRx1
        if UsrSlct="Explore1" do MenuFDA(.FDA) goto MRx1
        if UsrSlct="Browse" do Browse^TMGBROWS(50,IEN50,0) goto MRx1
        if UsrSlct="Map" do  goto MRx1
        . write "POI (50.7) --> DRUG (50) --> VA PRODUCT (50.68)",!
        . write "                         --> TMG FDA IMPORT COMPILED (22706.9)",!
        . write "                         --> NATIONAL DRUG FILE ENTRY (50.6)",!
        . write "                         --> TMG FDA IMPORT COMPILED (22706.9)",!
        . do PressToCont^TMGUSRIF
        if UsrSlct="^" goto MRxDone
        goto MB1
 
MRxDone
        quit
 
 
MenuFDA(FDA)
        ;"Purpose: Menu to explore TMG FDA IMPORT COMPILED
        ;"INPUT:  FDA -- PASS BY REFERENCE.  Format:
        ;"           FDA=IEN in 22706.9
        ;"           FDA("NAME")=Name of 22706.9
 
        new Menu,UsrSlct
        set Menu(0)="Pick Option to explore TMG FDA IMPORT COMPILED item."
        set Menu(1)="Show current FDA IMPORT item: "_FDA("NAME")_$char(9)_"ShowFDA"
        set Menu(2)="Browse current FDA IMPORT item: "_FDA("NAME")_$char(9)_"Browse"
        set Menu(3)="Explore a linked DRUG item"_$char(9)_"Explore"
        set Menu("M")="Show data map"_$char(9)_"Map"
 
MF1     write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
 
        if UsrSlct="ShowFDA" do DispFDA(FDA) goto MF1
        if UsrSlct="Browse" do Browse^TMGBROWS(22706.9,FDA,0) goto MF1
        if UsrSlct="Map" do  goto MF1
        . write "DRUG (50) --> TMG FDA IMPORT COMPILED (22706.9)",!
        . do PressToCont^TMGUSRIF
 
        if UsrSlct="^" goto MFDone
        goto MB1
 
MFDone
        quit
 
Show1Chain(IENOQV)
        ;"Purpose: To show entire chain, as far back as possible
        ;"Input: IENOQV -- PASS BY REFERENCE
        ;"                IENOQV(0)=RxSet, i.e. the IEN in 101.44 containing ORWDSET O RX
        ;"                IENOQV=IEN IN 101.442
        ;"                IENOQV("IENS")=IENS
        ;"                IENOQV("Name")=Name of ORDER QUICK VIEW
        ;"                IENOQV("Linked 101.43")=IEN of linked 101.43
        ;"                IENOQV("Linked 101.43","Name")=name
 
        ;"results: none.
 
        new IEN50Array,IEN101d43,indent,OIArray,POIName
        set indent=2
        write "ORDER QUICK VIEW(101.44): ",IENOQV("Name")," #",IENOQV("IENS"),!
        set IEN101d43=IENOQV("Linked 101.43")
        write ?indent,"ORDERABLE ITEM(101.43): ",IENOQV("Linked 101.43","Name")," #",IEN101d43,!
        set indent=indent+5
        do GetOIInfo^TMGNDFUT(IEN101d43,.OIArray)
        set IEN50d7=$get(OIArray("IEN 50.7 from 101.43"))
        set POIName=$get(OIArray("IEN 50.7 from 101.43","NAME"))
        write ?indent,"PHARMACY ORDERABLE ITEM(50.7): ",POIName," #",IEN50d7,!
        set indent=indent+5
        do GetDRUGs^TMGNDFUT(IEN50d7,.IEN50Array)
        new IEN50,Name50 set IEN50="",Name50=""
        for  set Name50=$order(IEN50Array(Name50)) quit:(Name50="")  do
        . set IEN50=$order(IEN50Array(Name50,""))
        . write ?indent,"DRUG(50): ",Name50," #",IEN50,!
        . new TMGIEN set TMGIEN=""
        . for  set TMGIEN=$order(^TMG(22706.9,"DRUG",IEN50,TMGIEN)) quit:(TMGIEN="")  do
        . . new TMGname set TMGname=$$GET1^DIQ(22706.9,TMGIEN_",",.04)
        . . if TMGname'="" write ?(indent+5),"TMG(22706.9): ",TMGname," #",TMGIEN,!
        . set TMGIEN=""
        . for  set TMGIEN=$order(^TMG(22706.9,"DRUGT",IEN50,TMGIEN)) quit:(TMGIEN="")  do
        . . new TMGname set TMGname=$$GET1^DIQ(22706.9,TMGIEN_",",.04)
        . . if TMGname'="" write ?(indent+5),"TMG(212706.9): ",TMGname," #",TMGIEN,!
 
        do PressToCont^TMGUSRIF
 
        quit
 
 
FixCurOQV(IENOQV)
        ;"Purpose: To Fix the current OQV
        ;"Input: IENOQV -- PASS BY REFERENCE
        ;"                IENOQV(0)=RxSet, i.e. the IEN in 101.44 containing ORWDSET O RX
        ;"                IENOQV=IEN IN 101.442
        ;"                IENOQV("IENS")=IENS
        ;"                IENOQV("Name")=Name of ORDER QUICK VIEW
        ;"                IENOQV("Linked 101.43")=IEN of linked 101.43
        ;"                IENOQV("Linked 101.43","Name")=name
 
        ;"results: none.
 
        new IEN50d7,IEN50Array,IEN101d43,chainA
        set IEN101d43=IENOQV("Linked 101.43")
        ;"set IEN50d7=$$GetPOI^TMGNDFUT(IEN101d43)  <-- not working for some reason
        new OIArray
        do GetOIInfo^TMGNDFUT(IEN101d43,.OIArray)
        set IEN50d7=$get(OIArray("IEN 50.7 from 101.43"))
        new POIName set POIName=$get(OIArray("IEN 50.7 from 101.43","NAME"))
        do GetDRUGs^TMGNDFUT(IEN50d7,.IEN50Array)
        new IEN50,Name50 set IEN50="",Name50=""
        for  set Name50=$order(IEN50Array(Name50)) quit:(Name50="")  do
        . set IEN50=$order(IEN50Array(Name50,""))
        . new TMGIEN set TMGIEN=""
        . for  set TMGIEN=$order(^TMG(22706.9,"DRUG",IEN50,TMGIEN)) quit:(TMGIEN="")  do
        . . new TMGname set TMGname=$$GET1^DIQ(22706.9,TMGIEN_",",.04)
        . . set chainA(TMGname,TMGIEN_"^22706.9")=""
        . set TMGIEN=""
        . for  set TMGIEN=$order(^TMG(22706.9,"DRUGT",IEN50,TMGIEN)) quit:(TMGIEN="")  do
        . . new TMGname set TMGname=$$GET1^DIQ(22706.9,TMGIEN_",",.04)
        . . set chainA(TMGname,TMGIEN_"^22706.9")=""
 
        if $data(chainA) do
        . do HandleChain^TMGNDF4G(.chainA)
        else  do
        . write "Sorry, unable to locate sources in file 22706.9",!
        . do PressToCont^TMGUSRIF
 
        quit
 
ShowAvail(IEN101d43)
        ;"Purpose: to Show available drugs for a given ORDERABLE ITEM (101.43),
        ;"         As determined by RPC code used by CPRS
        ;"Input: IEN101d43 -- IEN in 101.43
        ;"results: none.
 
        new i,DrugIEN
        new IEN,Y,DIC,drugsArray,sigArray
 
        kill drugsArray,sigArray
        do GetAvail(IEN101d43,.drugsArray,.sigArray)
        if $data(drugsArray)=0 do  goto SAvDone
        . write "No Drugs to show!",!
        . do PressToCont^TMGUSRIF
 
        ;"write "Here are entries in DRUG file:",!
        ;"write "-------------------------------",!
        ;"new IEN set IEN=""
        ;"for  set IEN=$order(drugsArray(IEN)) quit:(IEN="")  do
        ;". write " #",IEN," in File #50: ",drugsArray(IEN),!
        ;"do PressToCont^TMGUSRIF
 
        write "Here are the different sigs:",!
        write "-------------------------------",!
        new netDose set netDose=""
        for  set netDose=$order(sigArray(netDose)) quit:(netDose="")  do
        . ;"write "Net Dose: ",netDose,!
        . new IEN set IEN=""
        . for  set IEN=$order(sigArray(netDose,IEN)) quit:(IEN="")  do
        . . new name set name=""
        . . for  set name=$order(sigArray(netDose,IEN,name)) quit:(name="")  do
        . . . ;"write "    #",IEN,": ",name,!
        . . . new sig set sig=""
        . . . for  set sig=$order(sigArray(netDose,IEN,name,sig)) quit:(sig="")  do
        . . . . new mult set mult=$get(sigArray(netDose,IEN,name,sig))
        . . . . write " ",sig,?30,"#",IEN,": ",name," --",mult,!
        do PressToCont^TMGUSRIF
SAvDone
        quit
 
 
GetAvail(IEN101d43,Array,sigArray)
        ;"Purpose: To explore the available doses for a given ORDERABLE ITEM (101.43)
        ;"Input: IEN -- the record number for ORDERABLE ITEM (101.43)
        ;"       Array -- pass by REFERENCE, an OUT PARAMETER
        ;"       sigArray -- pass by REFERENCE, an OUT PARAMETER
        ;"Output:  Array format:
        ;"                Array(IEN in 50)=DrugName
        ;"                Array(IEN in 50)=DrugName
        ;"         sigArray format:
        ;"                sigArray(NetDose,IEN in 50,DrugName,sig)=multiplier
        ;"Result: None
 
        new temp,IENs,IENs2
        do OISLCT^ORWDPS2(.temp,IEN101d43,0,1,"Y","Y")
        new i set i=""
        for  set i=$order(temp(i)) quit:(i="")!($get(temp(i))="~Dispense")
        if i'="" for  set i=$order(temp(i)) quit:(i="")!($extract($get(temp(i)),1)="~")  do
        . new s set s=$piece($get(temp(i)),"^",1)
        . new IEN set IEN=+$extract(s,2,999)
        . set Array(IEN)=$piece($get(temp(i)),"^",4)
 
        set i=""
        for  set i=$order(temp(i)) quit:(i="")!($get(temp(i))="~Dosage")
        if i'="" for  set i=$order(temp(i)) quit:(i="")!($extract($get(temp(i)),1)="~")  do
        . new s set s=$piece($get(temp(i)),"^",4)
        . new IEN set IEN=+$piece(s,"&",6)
        . new netDose set netDose=+$piece(s,"&",5)
        . new drug set drug=$extract($piece($get(temp(i)),"^",1),2,999)
        . new sig set sig=$piece($get(temp(i)),"^",5)
        . new mult set mult=$piece(s,"&",3)
        . set sigArray(netDose,IEN,drug,sig)=mult
 
        quit
 
 
AskOQV(NameOut)
        ;"Purpose: To ask the user for a ORDER QUICK VIEW drug to view.
        ;"       Note: this is actually a query in the subfile #101.442
        ;"Input: NameOut -- PASS BY REFERENCE, an OUT PARAMETER
        ;"              returns the name of the ORDER QUICK VIEW selected
        ;"Result: an IENS that can be used to get record, or "" if unsuccessful
        ;"        e.g. set Value=$$GET1^DIQ(101.442,IENS,.01)
 
        new DIC,X,Y,RxSet,DA
        new result set result=""
        set NameOut=""
 
        set RxSet=$$GetOQVSet^TMGNDFUT() if RxSet'>0 goto AOQVDone
 
        if $data(^ORD(101.44,RxSet,20,"B"))=0 do
        . ;"Put code here to reindex "B" index (.01 field of field 20)
 
        new RxName,TMGDATA,TMGERR
        read "DRUG NAME (May be partial name): ",RxName:$get(DTIME,3600),!
 
        do FIND^DIC(101.442,","_RxSet_",","","M",RxName,"*","B","","","TMGDATA","TMGERR")
        if +$get(TMGDATA("DILIST",0))>0 do
AOQV1   . new found,j,IEN,IEN101d43,Menu,Num,Link,UsrSlct
        . set Menu(0)="Pick Drug",Num=1
        . set j=0 for  set j=+$order(TMGDATA("DILIST",2,j)) quit:(j=0)  do
        . . set IEN=$get(TMGDATA("DILIST",2,j))
        . . set IEN101d43=$get(TMGDATA("DILIST",1,j))
        . . if $data(found(IEN101d43))>0 quit
        . . set found(IEN101d43)=1
        . . set Menu(Num)=$$GET1^DIQ(101.442,IEN_","_RxSet_",",".01")_" --> "_$$GET1^DIQ(101.43,IEN101d43_",",".01")_" #"_IEN101d43
        . . set Link(Num)=IEN
        . . set Num=Num+1
        . if Num>2 do
        . . set Menu(Num)="Compare Drugs and Sigs above."_$char(9)_"COMPARE"
        . write #
        . set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
        . if UsrSlct="COMPARE" do  goto AOQV1
        . . do ShowComp(.found)
        . set result=$get(Link(UsrSlct),-1)
        . if result>0 set result=result_","_RxSet_","
        else  do  goto:(Y'>-1) AOQVDone
        . set DA(1)=RxSet
        . set DIC(0)="MAEQ"
        . set DIC("A")="Please enter drug name again: ^//"
        . set DIC="^ORD(101.44,"_DA(1)_",20,"
        . do ^DIC write !
        . if Y'>-1 quit
        . set result=+Y_","_DA(1)_","
 
AOQVDone
        if result'="" set NameOut=$$GET1^DIQ(101.442,result,.01)
        quit result
 
ShowComp(array)
        ;"Purpose: to display all the drugs and sigs for a set of IEN's in 101.43
        ;"Input: array: PASS BY REFERENCE.  Format:
        ;"          array(IEN)=""
        ;"          array(IEN)=""
        ;"          array(IEN)=""
        ;"Output: Will dump out data for all IEN's in list
 
        new IEN101d43
        set IEN101d43="" for  set IEN101d43=$order(array(IEN101d43)) quit:(IEN101d43="")  do
        . do ShowAvail(IEN101d43)
        quit
 
 
DispOI(IEN101d43)
        ;"Purpose: To display the relevent parts of the 101.43 (ORDERABLE ITEM)
        ;"         to allow debug tracing.
        ;"Input: IEN101d43 -- the IEN in file 101.43
        ;"Results: none
 
        new Fields
        set Fields(.01)=""   ;".01 NAME
        set Fields(.1)=""    ;"1  INACTIVATED
        set Fields(1)=""     ;"1  SYNONYMS
        set Fields(1.1)=""   ;"1.1  PACKAGE NAME
        set Fields(2)=""     ;"2  ID
 
        write "File: ORDERABLE ITEM (101.43) "
        do DumpRec2^TMGDEBUG(101.43,IEN101d43,1,.Fields)
        do PressToCont^TMGUSRIF
 
        quit
 
 
DispPOI(IEN50d7)
        ;"Purpose: To display the relevent parts of the 50.7 (PHARMACY ORDERABLE ITEM)
        ;"         to allow debug tracing.
        ;"Input: IEN50d7 -- the IEN in file 50d7
        ;"Results: none
 
        write "File: PHARMACY ORDERABLE ITEM (50.7) "
        do DumpRec2^TMGDEBUG(50.7,IEN50d7,1)
        do PressToCont^TMGUSRIF
 
        quit
 
 
DispOQV(IENS)
        ;"Purpose: To display the relevent parts of the 101.44 (ORDER QUICK VIEW)
        ;"         to allow debug tracing.
        ;"Input: IENS -- the IENS to display 101.442, e.g. "1000,23"
        ;"Results: none
 
        write "File: in ORDER QUICK VIEW (101.442) "
        do DumpRec2^TMGDEBUG(101.442,IENS,1,)
        do PressToCont^TMGUSRIF
 
        quit
 
DispRx(IEN50)
        ;"Purpose: To display the relevent parts of the 50 (DRUG)
        ;"         to allow debug tracing.
        ;"Input: IEN50 -- the IEN to display in 50
        ;"Results: none
 
        write "File: in DRUG (50) "
        do DumpRec2^TMGDEBUG(50,IEN50_",",0)
        do PressToCont^TMGUSRIF
 
        quit
 
 
DispFDA(IEN)
        ;"Purpose: To display the relevent parts of TMG FDA IMPORT COMPILED (22706.9)
        ;"         to allow debug tracing.
        ;"Input: IEN -- the IEN to display in 22706.9
        ;"Results: none
 
        write "File: in TMG FDA IMPORT COMPILED (22706.9) "
        do DumpRec2^TMGDEBUG(22706.9,IEN_",",0)
        do PressToCont^TMGUSRIF
 
        quit
 
 
ShowPIa(IEN101d43,RxSet)
        ;"Purpose: To show all links from 101.44 --> 101.43
        ;"Input: IEN101d43 -- the IEN from 101d43
        ;"       RxSet -the IEN in 101.44 containing ORWDSET O RX
        ;"Results: none
 
        new OQVIndex
        do Index101d44^TMGNDFUT(RxSet,"OQVIndex")
 
        new IENOQV set IENOQV=""
        new someShown set someShown=0
        new pauseCount set pauseCount=0
        write "Here are all the entries in ORDER QUICK VIEW that point to",!
        write "ORDERABLE ITEM: ",$$GET1^DIQ(101.43,IEN101d43_",",.01),!
        write "  <--- (IEN in ORDER QUICK VIEW)  NAME",!
        for  set IENOQV=$order(OQVIndex(IEN101d43,IENOQV)) quit:(IENOQV'>0)  do
        . write "  <--- (#",IENOQV,") "
        . write $$GET1^DIQ(101.442,IENOQV_","_RxSet_",",2),!
        . set someShown=1
        . set pauseCount=pauseCount+1
        . if pauseCount<10 quit
        . do PressToCont^TMGUSRIF
        . set pauseCount=0
        if someShown=0 write "  (None)",!
        do PressToCont^TMGUSRIF
 
        quit
 
 
PickOI(IENOQV)
        ;"Purpose: To start from a ORDER QUICK VIEW record, and track backwards
        ;"Input: IENOQV -- PASS BY REFERENCE.  An OUT PARAMETER.  Format:
        ;"                IENOQV(0)=RxSet, i.e. the IEN in 101.44 containing ORWDSET O RX
        ;"                IENOQV=IEN IN 101.442
        ;"                IENOQV("IENS")=IENS
        ;"                IENOQV("Name")=Name of ORDER QUICK VIEW
        ;"                IENOQV("Linked 101.43")=IEN of linked 101.43
        ;"                IENOQV("Linked 101.43","Name")=name
        ;"Result: none.
 
        new IENS,IEN101d43,OQVName
        set IENS=$$AskOQV(.OQVName) if IENS="" goto POIDone
        ;"write "ORDER QUICK VIEW (",IENS,") -->  ORDERABLE ITEM ",!
        set IEN101d43=$$GET1^DIQ(101.442,IENS,.01,"I")
        set IENOQV=$piece(IENS,",",1)
        set IENOQV(0)=$piece(IENS,",",2)
        set IENOQV("IENS")=IENS
        set IENOQV("Name")=OQVName
        set IENOQV("Linked 101.43")=IEN101d43
        set IENOQV("Linked 101.43","Name")=$$GET1^DIQ(101.43,IEN101d43_",",.01)
 
POIDone
        quit
 
DispDoses(IEN101d43)
        ;"Purpose: To Display possible dosed for a ORDER QUICK VIEW record
        ;"Input: IEN101d43 -- IEN in 101.43
        ;"Output: displays possible doses
        ;"Result: none.
 
        new array
        do OISLCT^ORWDPS2(.array,IEN101d43,"O",0,"Y","N")
        do ArrayDump^TMGDEBUG("array")
        do PressToCont^TMGUSRIF
 
        quit
 
 
