TMGRPC3G ;TMG/kst/Support Functions for GUI_Config ;08/31/08
         ;;1.0;TMG-LIB;**1**;08/31/08
 ;
 ;"TMG RPC FUNCTIONS for a GUI config program
 ;
 ;"Kevin Toppenberg MD
 ;"GNU Lessor General Public License (LGPL) applies
 ;"7/20/08
 ;
 ;"=======================================================================
 ;" RPC -- Public Functions.
 ;"=======================================================================
 ;" <none>
 ;"=======================================================================
 ;"PRIVATE API FUNCTIONS
 ;"=======================================================================
 ;"GETERSTR(TMGEARRAY) -- convert a standard DIERR array into a string for output
 ;"ADDFDA(TMGFDA,TMGOUT,INDX) -- output the TMGFDA into the TMGOUT variable
 ;
 ;"=======================================================================
 ;"=======================================================================
 ;"Dependencies:
 ;"  None, but should be called FROM TMGRPC3* only
 ;
 ;"=======================================================================
 ;"=======================================================================
 ;
GETERSTR(TMGEARRAY) ;
        ;"Purpose: convert a standard DIERR array into a string for output
        ;"Input: TMGEARRAY -- PASS BY REFERENCE.  example:
        ;"      array("DIERR")="1^1"
        ;"      array("DIERR",1)=311
        ;"      array("DIERR",1,"PARAM",0)=3
        ;"      array("DIERR",1,"PARAM","FIELD")=.02
        ;"      array("DIERR",1,"PARAM","FILE")=2
        ;"      array("DIERR",1,"PARAM","IENS")="+1,"
        ;"      array("DIERR",1,"TEXT",1)="The new record '+1,' lacks some required identifiers."
        ;"      array("DIERR","E",311,1)=""
        ;"Results: returns one long equivalent string from above array.
        ;"Note: This is a copy of the function GetErrStr^TMGDEBUG
        ;"      I copied it here so that this file has no TMG* dependencies.
 ;
        NEW TMGESTR,TMGIDX,TMGENUM
        SET TMGESTR=""
        FOR TMGENUM=1:1:+$GET(TMGEARRAY("DIERR")) DO
        . SET TMGESTR=TMGESTR_"Fileman says: '"
        . IF TMGENUM'=1 SET TMGESTR=TMGESTR_"(Error# "_TMGENUM_") "
        . SET TMGIDX=$ORDER(TMGEARRAY("DIERR",TMGENUM,"TEXT",""))
        . IF TMGIDX'="" FOR  DO  QUIT:(TMGIDX="")
        . . SET TMGESTR=TMGESTR_$GET(TMGEARRAY("DIERR",TMGENUM,"TEXT",TMGIDX))_" "
        . . SET TMGIDX=$ORDER(TMGEARRAY("DIERR",TMGENUM,"TEXT",TMGIDX))
        . IF $GET(TMGEARRAY("DIERR",TMGENUM,"PARAM",0))>0 DO
        . . SET TMGIDX=$ORDER(TMGEARRAY("DIERR",TMGENUM,"PARAM",0))
        . . SET TMGESTR=TMGESTR_"Details: "
        . . FOR  DO  QUIT:(TMGIDX="")
        . . . IF TMGIDX="" QUIT
        . . . SET TMGESTR=TMGESTR_"["_TMGIDX_"]="_$GET(TMGEARRAY("DIERR",1,"PARAM",TMGIDX))_"  "
        . . . SET TMGIDX=$ORDER(TMGEARRAY("DIERR",TMGENUM,"PARAM",TMGIDX))
 ;
        QUIT TMGESTR
 ;
ADDFDA(TMGFDA,TMGOUT,INDX) ;
        ;"Purpose: To output the TMGFDA into the TMGOUT variable (so show erroneous
        ;"         FDA.
        ;"Input: TMGFDA -- the FDA as send to fileman.  PASS BY REFERENCE
        ;"       TMGOUT -- the variable that will be passed back as the result of
        ;"                 the RPC call.  PASS BY REFERENCE.
        ;"       INDX -- the index to start adding the TMGFDA at.
        ;"Results: none.
        ;"
        NEW TMGI SET TMGI=""
        FOR  SET TMGI=$ORDER(TMGFDA(TMGI)) QUIT:TMGI=""  DO
        . SET TMGOUT(INDX)="FDA("_TMGI_")="_$GET(TMGFDA(TMGI))
        . SET INDX=INDX+1
        QUIT
        ;