TMGTREE ;TMG/kst/Text tree user interface ;03/25/06
         ;;1.0;TMG-LIB;**1**;09/01/05
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"BrowseBy(CompArray,ByTag)
 ;"ShowBy(CompArray,ByTag,aOpen,bOpen,cOpen,dSelected)
 
 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 
 
 
BrowseBy(CompArray,ByTag)
        ;"Purpose: Allow a user to interact with dynamic text tree
        ;"              that will open and close nodes.
        ;"Input:        CompArray -- array to browse.  Should be in this format
        ;"                      CompArray("opening tag",a,b,c,d)
        ;"               ByTag -- the name to use in for "opening tag")
        ;"Results: returns Batch/job number, or 0 if none selected
 
        new aOpen set aOpen=0
        new bOpen set bOpen=0
        new cOpen set cOpen=0
        new dSelected set dSelected=0
 
        new done set done=0
 
        new input
        new result set result=0
 
        for  do  quit:(done=1)
        . set result=$$ShowBy(.CompArray,ByTag,aOpen,bOpen,cOpen,dSelected)
        . if result>0 set done=1 quit
        . read !,"Enter Number to Browse ([Enter] to backup, ^ to Quit): ",input:$get(DTIME,3600),!
        . if input="" set input=0
        . if +input>0 do
        . . if aOpen=0 do
        . . . set aOpen=input,bOpen=0,cOpen=0
        . . else  if bOpen=0 do
        . . . set bOpen=input,cOpen=0
        . . else  if cOpen=0 set cOpen=input
        . . else  set dSelected=input
        . else  if input=0 do
        . . if cOpen'=0 set cOpen=0,dSelected=0 quit
        . . if bOpen'=0 set bOpen=0 quit
        . . if aOpen'=0 set aOpen=0 quit
        . . if aOpen=0 set input="^"
        . if input="^" set done=1
 
      quit result
 
 
ShowBy(CompArray,ByTag,aOpen,bOpen,cOpen,dSelected)
        ;"Purpose: Draw current state of text tree
        ;"Input:        CompArray -- array to browse.  Should be in this format
        ;"                      CompArray("opening tag",a,b,c,d)
        ;"               ByTag -- the name to use in for "opening tag")
        ;"Result: if aOpen,bOpen, and cOpen,dSelected are valid values, then
        ;"              will return value from CompArray, i.e.
        ;"              CompArray("opening tag",a,b,c,d)="x"  <--- will return "x"
        ;"          otherwise returns 0
 
        new a,b,c,d
        new acount set acount=0
        new bcount set bcount=0
        new ccount set ccount=0
        new dcount set dcount=0
        new result set result=0
 
        write #,!
 
        set a=$order(CompArray(ByTag,""))
        if a'="" for  do  quit:(a="")
        . set acount=acount+1
        . new nexta set nexta=$order(CompArray(ByTag,a))
        . new Aindent
        . if (aOpen=0) do
        . . if acount<10 write "0"
        . . write acount,". "
        . else  write "... "
        . write a,!
        . set b=$order(CompArray(ByTag,a,""))
        . if (aOpen=acount)&(b'="") for  do  quit:(b="")
        . . set bcount=bcount+1
        . . new nextb set nextb=$order(CompArray(ByTag,a,b))
        . . new Bindent
        . . write "    +--"
        . . if (bOpen=0) do
        . . . if bcount<10 write "0"
        . . . write bcount,". "
        . . else  write "... "
        . . write b,!
        . . if nextb'="" set Aindent="    |  "
        . . else  set Aindent="       "
        . . set c=$order(CompArray(ByTag,a,b,""))
        . . if (bOpen=bcount)&(c'="") for  do  quit:(c="")
        . . . set ccount=ccount+1
        . . . new nextc set nextc=$order(CompArray(ByTag,a,b,c))
        . . . if nextc'="" set Bindent="    |  "
        . . . else  set Bindent="       "
        . . . write Aindent,"    +--"
        . . . if (cOpen=0) do
        . . . . if ccount<10 write "0"
        . . . . write ccount,". "
        . . . else  write "... "
        . . . write c,!
        . . . set d=$order(CompArray(ByTag,a,b,c,""))
        . . . if (cOpen=ccount)&(d'="") for  do  quit:(d="")
        . . . . set dcount=dcount+1
        . . . . write Aindent,Bindent,"    +-- "
        . . . . if dcount<10 write "0"
        . . . . write dcount,". "
        . . . . write d,!
        . . . . if dcount=dSelected set result=$get(CompArray(ByTag,a,b,c,d))
        . . . . set d=$order(CompArray(ByTag,a,b,c,d))
        . . . set c=nextc
        . . set b=nextb
        . set a=nexta
 
SBDone
        quit result
 
 
