TMGXDLG ;TMG/kst/M <--> Xdialog Interface ;03/25/06
         ;;1.0;TMG-LIB;**1**;09/21/04
 
 ;"M <--> Xdialog Interface
 
 ;"+------------------------------------------------------------+
 ;"|           O P E N  -  V I S T A   C O D E                  |..
 ;"+------------------------------------------------------------+ :
 ;"|                                                            | :
 ;"| M <--> Xdialog Interface                                   | :
 ;"|                                                            | :
 ;"| Kevin Toppenberg,MD                                        | :
 ;"| Started 9-21-04                                            | :
 ;"| GNU License Applies                                        | :
 ;"|                                                            | :
 ;"| Purpose: Linux command 'Xdialog' (and 'dialog')            | :
 ;"|          provide a convenient graphic interface that       | :
 ;"|          can be accessed in GT.M via the ZSYSTEM command   | :
 ;"|          This library is a wrapper for Xdialog.            | :
 ;"| Note: Xdialog requires the X display system.  This is a    | :
 ;"|       true GIU interface. 'dialog' provides the same       | :
 ;"|       functionality in a character-based environment       | :
 ;"|       The command Xdialog should be in /usr/bin.  If not,  | :
 ;"|       it may simply be copied into place.                  | :
 ;"|       A good web site that documents Xdialog is:           | :
 ;"|       http://xdialog.dyns.net/        and                  | :
 ;"|       http://thgodef.nerim.net/xdialog/doc/index.html      | :
 ;"|       http://linuxgazette.net/101/sunil.html               | :
 ;"+------------------------------------------------------------+ :
 ;"  :............................................................:
 
 ;"Note: Some of the following names are longer than 8 characters.
 ;"      However, the first 8 characters are .  You may leave
 ;"      off all characters > 8 -- but I put them in for 'beauty'
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
 ;"Higher-level Interface (API)
 ;"-------------------------------
 
 ;"SetupConsts()
 ;"KillConsts()
 ;"ChClrScr()
 
 ;"$$YesNo^TMGXDLG(Text,width,height)
 ;"$$Msg^TMGXDLG(Title,Text,width,height,Modal,x,y)
 ;"$$Info^TMGXDLG(Text,width,height,timeout,Modal,x,y)
 ;"$$Edit^TMGXDLG(file,width,height,Results,x,y)
 ;"$$Log^TMGXDLG(file,width,height,Modal,x,y)
 ;"$$Text^TMGXDLG(file,width,height,Modal,x,y)
 ;"$$Tail^TMGXDLG(file,width,height,Modal,x,y)
 ;"$$Input^TMGXDLG(Title,width,height,InitText,Result,x,y)
 ;"$$Input2^TMGXDLG(Title,width,height,Label1,Init1Text,Label2,Init2Text,Result2,x,y)
 ;"$$Input3^TMGXDLG(Title,width,height,Label1,Init1Text,Label2,Init2Text,Label3,Init3Text,Result2,Result3,x,y)
 ;"$$RadioList^TMGXDLG(Text,List,width,height,x,y)
 ;"$$FileSel^TMGXDLG(Title,InitFile,width,height,x,y)
 ;"$$DirSel^TMGXDLG(Title,InitDir,width,height,x,y)
 ;"$$DateSel^TMGXDLG(Text,width,height,InitDay,InitMonth,InitYear,x,y)
 ;"$$TimeSel^TMGXDLG(Text,width,height,InitHour,InitMinute,InitSecond,x,y)
 ;"$$FontSel^TMGXDLG(InitFont,width,height,x,y)
 ;"$$Combo^TMGXDLG(Text,width,height,List,x,y)
 ;"$$Range^TMGXDLG(Text,width,height,min,max,init,x,y)
 ;"$$Range2^TMGXDLG(Text,width,height,label1,min1,max1,init1,label2,min2,max2,init2,Result2,x,y)
 ;"$$Range3^TMGXDLG(Text,width,height,label1,min1,max1,init1,label2,min2,max2,init2,label3,min3,max3,init3,Result2,Result3,x,y)
 ;"$$Spin^TMGXDLG(Text,width,height,min,max,label,init,x,y)
 ;"$$Spin2^TMGXDLG(Text,width,height,label1,min1,max1,init1,label2,min2,max2,init2,Result2,x,y)
 ;"$$Spin3^TMGXDLG(Text,width,height,label1,min1,max1,init1,label2,min2,max2,init2,label3,min3,max3,init3,Result2,Result3,x,y)
 
 
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
 
 ;"Lower-level Interface (API)
 ;"-------------------------------
 ;"xyesno(Options,Results,Modal)
 ;"xmsg(Options,Results,Modal)
 ;"xinfo(Options,Results,Modal)
 ;"xguage(Options,Results,Modal)
 ;"xprogress(Options,Results,Modal)
 ;"xinput(Options,Results,Modal)
 ;"x2inputs(Options,Results,Modal)
 ;"x3inputs(Options,Results,Modal)
 ;"xcombo(Options,Results,Modal)
 ;"xrange(Options,Results,Modal)
 ;"x2range(Options,Results,Modal)
 ;"x3range(Options,Results,Modal)
 ;"xspin(Options,Results,Modal)
 ;"x2spin(Options,Results,Modal)
 ;"x3spin(Options,Results,Modal)
 ;"xlog(Options,Results,Modal)
 ;"xedit(Options,Results,Modal)
 ;"xtext(Options,Results,Modal)
 ;"xtail(Options,Results,Modal)
 ;"xchecklist(Options,Results,Modal)
 ;"xradiolist(Options,Results,Modal)
 ;"xmenu(Options,Results,Modal)
 ;"xtreeview(Options,Results,Modal)
 ;"xfilesel(Options,Results,Modal)
 ;"xdirsel(Options,Results,Modal)
 ;"xcalendarsel(Options,Results,Modal)
 ;"xtimesel(Options,Results,Modal)
 ;"xbuildlist(Options,Results,Modal)
 ;"xcolorsel(Options,Results,Modal)
 ;"xfontsel(Options,Results,Modal)
 
 
 ;"Expected format for Options:
 
 ;"The documentation for these options may be found at:
 ;"http://thgodef.nerim.net/xdialog/doc/index.html
 
 ;"Options should be an array inthe following format:
 ;"
 ;"  Options(xcCommon,xcWMClass)=<name>
 ;"  Options(xcCommon,xcRxcFile)=<gtkrc filename>
 ;"  Options(xcCommon,xcBackTitle)=<backtitle>
 ;"  Options(xcCommon,xcTitle"=<title>
 ;"  Options(xcCommon,xcAllowClose)=1  } A.
 ;"  Options(xcCommon,xcNoClose)=1     } B.   A & B are opposites
 ;"  Options(xcCommon,xcScreenCenter)=1      } A.
 ;"  Options(xcCommon,xcUnderMouse)=1        } B.
 ;"  Options(xcCommon,xcAutoPlacement)=1     } C.  A,B & C are mutually exclusive options
 ;"  Options(xcCommon,xcCenter)=1  } A.
 ;"  Options(xcCommon,xcRight)=1   } B.
 ;"  Options(xcCommon,xcLeft)=1    } C.
 ;"  Options(xcCommon,xcFill)=1    } D.   A,B,C & D are mutually exclusive options
 ;"  Options(xcCommon,xcNoWrap)=1   } A
 ;"  Options(xcCommon,xcWrap)=1      } B   A & B are opposites
 ;"  Options(xcCommon,xcCRWrap)=1       } A.
 ;"  Options(xcCommon,xcNoCRWrap)=1    } B.    A & B are opposites
 ;"  Options(xcCommon,xcStdErr)=1  } A.
 ;"  Options(xcCommon,xcStdOut)=1  } B. A & B are opposites
 ;"  Options(xcCommon,xcSeparator)=<character>    } A.
 ;"  Options(xcCommon,xcSeparateOutput)=1        } B.  A & B are opposites.
 ;"  Options(xcCommon,xcButtonsStyle)="default" or "icon" or  "text" (only one of these three values)
 ;"  Options(xcTransient,xcFixedFont)=1
 ;"  Options(xcTransient,xcPassword)=1
 ;"  Options(xcTransient,xcEditable)=1
 ;"  Options(xcTransient,xcTimeStamp)=1  } A.
 ;"  Options(xcTransient,xcDateStamp)=1  } B. A & B are mutually exclusive
 ;"  Options(xcTransient,xcReverse)=1
 ;"  Options(xcTransient,xcKeepColors)=1
 ;"  Options(xcTransient,xcInterval)=<timeout>
 ;"  Options(xcTransient,xcNotags)=1
 ;"  Options(xcTransient,xxcItemHelp)=1
 ;"  Options(xcTransient,xxcDefaultItem)=<tag>
 ;"  Options(xcTransient,xcIcon)=<xpm filename>
 ;"  Options(xcTransient,xcNook)=1
 ;"  Options(xcTransient,xcNoCancel)=1
 ;"  Options(xcTransient,xcNoButtons)=1
 ;"  Options(xcTransient,xxcDefaultNo)=1
 ;"  Options(xcTransient,xcWizard)=1
 ;"  Options(xcTransient,xcHelp)=<help>
 ;"  Options(xcTransient,xcPrint)=<printer>
 ;"  Options(xcTransient,xcCheck)=<label [<status>]>
 ;"  Options(xcTransient,xcOKLabel)=<label>
 ;"  Options(xcTransient,xcCancelLabel)=<label>
 ;"  Options(xcTransient,xcBeep)=1
 ;"  Options(xcTransient,xcBeepafter)=1
 ;"  Options(xcTransient,xcBegin)= <Yorg Xorg>
 ;"  Options(xcTransient,xcIgnoreEOF)=1
 ;"  Options(xcTransient,xcSmooth)=1
 ;"  Options(xcBox,xcText)=<value>
 ;"  Options(xcBox,xcHeight)=<value>
 ;"  Options(xcBox,xcWidth)=<value>
 ;"  Options(xcBox,xcTimeOut)=<value>
 ;"  Options(xcBox,xcPercent)=<value>
 ;"  Options(xcBox,xxcMaxDots)=<value>
 ;"  Options(xcBox,xcMsgLen)=<value>
 ;"  Options(xcBox,xcInit)=<value>
 ;"  Options(xcBox,xcLabel,N)=<value>
 ;"  Options(xcBox,xcInit,N)=<value>
 ;"  Options(xcBox,xcMin,N)=<value>
 ;"  Options(xcBox,xcMax,N)=<value>
 ;"  Options(xcBox,xcDefault,N)=<value
 ;"  Options(xcBox,xcFile)=<value>
 ;"  Options(xcBox,xcDirectory)=<value>
 ;"  Options(xcBox,xcFontName)=<value>
 ;"  Options(xcBox,xcDay)=<value>
 ;"  Options(xcBox,xcMonth)=<value>
 ;"  Options(xcBox,xcYear)=<value>
 ;"  Options(xcBox,xcHours)=<value>
 ;"  Options(xcBox,xcMinutes)=<value>
 ;"  Options(xcBox,xcSeconds)=<value>
 ;"  Options(xcBox,xcTag,N)=<value>
 ;"  Options(xcBox,xcItem,N)=<value>
 ;"  Options(xcBox,xcHelp,N)=<value>
 ;"  Options(xcBox,xcStatus,N)=<value>  {"on", "off", or "unavailable"}
 ;"  Options(xcBox,xcListHeight)=<value>
 ;"  Options(xcBox,xcItemdepth,N)=<value>
 
 ;"Notes:
 ;" - Not all options will apply to all dialogs, but if the
 ;"   option is desired, it should be in the above format.
 ;" - No syntax checking is performed.  The options are simply
 ;"   passed to the Xdialog command in the proper order.
 ;" - Everything below should be considered CASE-SENSITIVE.
 ;" - Notice that the indexes used are constants (i.e. xcCommon)
 ;"   these are set up by SetupConsts(), and may later be killed
 ;"   via KillConsts().  Their use will avoid spelling errors
 ;"   resulting in a missed parameter.
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
 
SetupConsts()
        set vDialog="Xdialog"
        set xcCommon="common"
        set xcWMClass="wmclass"
        set xcRxcFile="rxcFile"
        set xcBackTitle="backtitle"
        set xcTitle="title"
        set xcAllowClose="allow-close"
        set xcNoClose="no-close"
        set xcScreenCenter="cscreen-center"
        set xcUnderMouse="under-mouse"
        set xcAutoPlacement="autoplacement"
        set xcCenter="center"
        set xcRight="right"
        set xcLeft="left"
        set xcFill="fill"
        set xcNoWrap="no-wrap"
        set xcWrap="wrap"
        set xcCRWrap="cr-wrap"
        set xcNoCRWrap="no-cr-wrap"
        set xcStdErr="stderr"
        set xcStdOut="stdout"
        set xcSeparator="separator"
        set xcSeparateOutput="separate-output"
        set xcButtonsStyle="buttons-style"
        set xcTransient="transient"
        set xcFixedFont="fixed-font"
        set xcPassword="password"
        set xcEditable="editable"
        set xcTimeStamp="time-stamp"
        set xcDateStamp="date-stamp"
        set xcReverse="reverse"
        set xcKeepColors="keep-colors"
        set xcInterval="interval"
        set xcNotags="no-tags"
        set xxcItemHelp="item-help"
        set xxcDefaultItem="default-item"
        set xcIcon="icon"
        set xcNook="no-ok"
        set xcNoCancel="no-cancel"
        set xcNoButtons="no-buttons"
        set xxcDefaultNo="default-no"
        set xcWizard="wizard"
        set xcHelp="help"
        set xcPrint="print"
        set xcCheck="check"
        set xcOKLabel="ok-label"
        set xcCancelLabel="cancel-label"
        set xcBeep="beep"
        set xcBeepafter="beep-after"
        set xcBegin="begin"
        set xcIgnoreEOF="ignore-eof"
        set xcSmooth="smooth"
        set xcBox="box"
        set xcText="text"
        set xcHeight="height"
        set xcWidth="width"
        set xcTimeOut="timeout"
        set xcPercent="percent"
        set xxcMaxDots="maxdots"
        set xcMsgLen="msglen"
        set xcInit="init"
        set xcLabel="label"
        set xcMin="min"
        set xcMax="max"
        set xcDefault="default"
        set xcFile="file"
        set xcDirectory="directory"
        set xcFontName="font name"
        set xcDay="day"
        set xcMonth="month"
        set xcYear="year"
        set xcHours="hours"
        set xcMinutes="minutes"
        set xcSeconds="seconds"
        set xcTag="tag"
        set xcItem="item"
        set xcHelp="help"
        set xcStatus="status"
        set xcListHeight="list height"
        set xcItemdepth="item depth"
        set xcCmdLine="command_line_params"
        set xcCmdArray="Array"
        set xcCmdMaxLine="Max_line"
        set xcDlgResult="Dialog Result"
        set xcDlgOutput="Dialog Output"
        set xcModalMode=1
        set xcNonModal=0
        set xcOptional=1
        set xcNotOptional=0
        set xcAddQuote=1
        set xcNoQuote=0
        set mrYes=0
        set mrOK=0
        set mrNext=0
        set mrNo=1
        set mrCancel=1
        set mrHelp=2
        set mrPrev=3
        set mrError=255
        quit
 
 
KillConstants()
        kill vDialog
        kill xcCommon
        kill xcWMClass
        kill xcRxcFile
        kill xcBackTitle
        kill xcTitle
        kill xcAllowClose
        kill xcNoClose
        kill xcScreenCenter
        kill xcUnderMouse
        kill xcAutoPlacement
        kill xcCenter
        kill xcRight
        kill xcLeft
        kill xcFill
        kill xcNoWrap
        kill xcWrap
        kill xcCRWrap
        kill xcNoCRWrap
        kill xcStdErr
        kill xcStdOut
        kill xcSeparator
        kill xcSeparateOutput
        kill xcButtonsStyle
        kill xcTransient
        kill xcFixedFont
        kill xcPassword
        kill xcEditable
        kill xcTimeStamp
        kill xcDateStamp
        kill xcReverse
        kill xcKeepColors
        kill xcInterval
        kill xcNotags
        kill xxcItemHelp
        kill xxcDefaultItem
        kill xcIcon
        kill xcNook
        kill xcNoCancel
        kill xcNoButtons
        kill xxcDefaultNo
        kill xcWizard
        kill xcHelp
        kill xcPrint
        kill xcCheck
        kill xcOKLabel
        kill xcCancelLabel
        kill xcBeep
        kill xcBeepafter
        kill xcBegin
        kill xcIgnoreEOF
        kill xcSmooth
        kill xcBox
        kill xcText
        kill xcHeight
        kill xcWidth
        kill xcTimeOut
        kill xcPercent
        kill xxcMaxDots
        kill xcMsgLen
        kill xcLabel
        kill xcInit
        kill xcMin
        kill xcMax
        kill xcDefault
        kill xcFile
        kill xcDirectory
        kill xcFontName
        kill xcDay
        kill xcMonth
        kill xcYear
        kill xcHours
        kill xcMinutes
        kill xcSeconds
        kill xcTag
        kill xcItem
        kill xcHelp
        kill xcStatus
        kill xcListHeight
        kill xcItemdepth
        kill xcCmdLine
        kill xcCmdMaxLine
        kill xcCmdArray
        kill xcDlgResult
        kill xcModalMode
        kill xcNonModal
        kill xcOptional
        kill xcNotOptional
        kill xcAddQuote
        kill xcNoQuote
        kill xcDlgOutput
        kill mrYes
        kill mrOK
        kill mrNo
        kill mrAbort
        kill mrCancel
        kill mrNext
        kill mrHelp
        kill mrPrev
        kill mrError
 
        quit
 
SetGUI(UseGUI)
        ;"For those who do not have an X system (i.e. a graphic display for unix/linux)
        ;"  then there is a backup plan that can do most of these functions
        ;"  on a text display (cool, eh?)
        ;"Input: UseGUI --  if 1 (the default), then the graphic method is used
        ;"                  if 0, then the character (text drawing) based method is used
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set UseGUI=$get(UseGUI,1)
        if UseGUI=0 set vDialog="dialog"
        else  set vDialog="Xdialog"
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
YesNo(Text,width,height,x,y)
        ;"Purpose: To provide an easier access to xyesnot
        ;"Input: Text to display
        ;"       height & width of dialog -- [optional]
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: (none)
        ;"Results: returns results of box closure.
        ;"Notes: (none)
 
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcBox,xcText)=Text
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xyesno(.Options,.Results,xcModalMode)  ;"Force won't return until dialog closed.
        set result=Results(xcDlgResult)
 
        quit result;
 
 
xyesno(Options,Results,Modal)
 ;" --yesno       <text> <height> <width>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --yesno ")
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
Msg(Title,Text,width,height,Modal,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"Input: Text to display
        ;"       height & width of dialog -- [optional]
        ;"       x,y -- the display location of the dialog [optional]
        ;"       Modal: if true, function does not return until dialog is closed.
        ;"              if false, function returns immediately, and functions do NOT
        ;"              reflect the user's button press.
        ;"Output: (none)
        ;"Results: Returns results of box closure (see Modal note above)
        ;"Notes: (none)
 
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
        if $data(Title) set Options(xcCommon,xcTitle)=Title
        set Options(xcBox,xcText)=Text
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        set Modal=$get(Modal,xcNonModal)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xmsg(.Options,.Results,Modal)
        set result=Results(xcDlgResult)
 
        quit result;
 
 
xmsg(Options,Results,Modal)
 ;" --msgbox      <text> <height> <width>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --msgbox ")
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
Info(Text,width,height,timeout,Modal,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"Input: Text to display
        ;"       height & width of dialog -- [optional]
        ;"       [timeout]: time (in sec) delay until box automatically closes.
        ;"                      OPTIONAL--default=1
        ;"       [Modal]: if true, function does not return until dialog is closed.
        ;"              if false, function returns immediately, and functions do NOT
        ;"              reflect the user's button press. OPTIONAL -- default=xcNonModal
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: (none)
        ;"Results: Returns results of box closure (see Modal note above)
        ;"Notes: (none)
 
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcBox,xcText)=Text
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        set Modal=$get(Modal,xcNonModal)
        if $data(timeout) set Options(xcBox,xcTimeOut)=timeout*1000
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xinfo(.Options,.Results,Modal)
        set result=Results(xcDlgResult)
 
        quit result;
 
 
xinfo(Options,Results,Modal)
 ;" --infobox     <text> <height> <width> [<timeout>]
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --infobox ")
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
        set Added=$$AddParam(.Options,,xcTimeOut,1)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 ;"NOT WORKING -- SEE NOTES ON GuageUpdate below...
 
Guage(Text,width,height,Percent,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"         This is called to first display a guage dialog.
        ;"Input: Text to display
        ;"       height & width of dialog -- [optional]
        ;"       x,y -- the display location of the dialog [optional]
        ;"       Percent -- Percentage of progress bar to show
        ;"Output: (none)
        ;"Results: Returns a handle that is used in GuageUpdate
        ;"Notes: Box is left open unless Percent is > 100%
 ;"NOTICE: This function is not working.
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcBox,xcText)=$get(Text)
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        set Options(xcBox,xcPercent)=$get(Percent,0)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xguage(.Options,.Results,xcNonModal) ;"note: Xdialog will show box as non-modal regardless (I think)
        set result=$get(Text)_"^"_$get(height)_"^"_$get(width)  ;"This will be used as a handle.
 
        quit result;
 
GuageUpdate(Handle,Percent)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"         This is called to update the percentage on an existing form.
        ;"Input: Handle -- the handle returned from original call to Guage
        ;"       Percent -- Percentage of progress bar to show
        ;"Output: (none)
        ;"Results: 'StillActive' i.e. 1: box still open.  0:box closed
        ;"Notes: Box is left open unless Percent is > 100%
 ;"NOTICE: This function is not working.  To update a guage, the dialog is setup to accept new values
 ;"              on stdin.  I'm not sure how to do this from inside M....
 ;"              Perhaps I could redirect stdin to a file, then write values out to that file...
 ;"              However, when EOF is reached, then box is closed....
 
        new Text
        new height
        new width
        set Handle=$get(Handle)
        set Percent=$get(Percent)
 
        set Text=$piece(Handle,"^",1)
        set height=$piece(Handle,"^",2)
        set width=$piece(Handle,"^",3)
 
        new dump
        set dump=$$Guage(Text,width,height,Percent)
 
        quit '(Percent>100)
 
 
xguage(Options,Results,Modal)
 ;" --gauge       <text> <height> <width> [<percent>]
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --gauge ")
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
        set Added=$$AddParam(.Options,,xcPercent)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 ;"TO BE COMPLETED
 ;"Note: I will have the same problems with this function as I did with Guage...
 ;"      So for now, I WON'T IMPLEMENT THIS...
 
xprogress(Options,Results,Modal)
        ;"Purpose:
        ;"Input:
        ;"Output:
        ;"Results:
        ;"Notes:
 ;" --progress    <text> <height> <width> [<maxdots> [[-]<msglen>]]
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Input(Title,width,height,InitText,Result,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"Input: Title -- text of input prompt to display
        ;"       height & width of dialog -- [optional]
        ;"       InitText -- default value [optional]
        ;"       Result -- a variable to put input into for return. PASS BY REFERENCE
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: The user input value is return in Result
        ;"Results: returns results of box closure.
        ;"Notes: (none)
 
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcBox,xcText)=$get(Title)
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        if $data(InitText) set Options(xcBox,xcInit)=InitText
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xinput(.Options,.Results,xcModalMode)
        set result=Results(xcDlgResult)
 
        ;"zwr Results(*)
 
        set Result=$get(Results(xcDlgOutput,""))
 
        quit result;
 
xinput(Options,Results,Modal)
 ;" --inputbox    <text> <height> <width> [<init>]
 
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --inputbox ")
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
        set Added=$$AddParam(.Options,,xcInit)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Input2(Title,width,height,Label1,Init1Text,Label2,Init2Text,Result1,Result2,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"Input: Title -- text of input prompt to display
        ;"       height & width of dialog -- [optional]
        ;"       Label1 -- text of label for input 1 [optional]
        ;"       Init1Text -- default value [optional]
        ;"       Label2 -- text of label for input 2 [optional]
        ;"       Init2Text -- default value [optional]
        ;"       Result1 -- a variable to put first input into for return. PASS BY REFERENCE
        ;"       Result2 -- a variable to put second input into for return. PASS BY REFERENCE
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: The user input value is return in Result1
        ;"      result of 2nd user-input put into Result2
        ;"Results: returns results of box closure.
        ;"Notes: (none)
 
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcCommon,xcSeparator)="^"
        set Options(xcBox,xcText)=$get(Title)
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        set Options(xcBox,xcLabel,1)=$get(Label1," ")
        set Options(xcBox,xcInit,1)=$get(Init1Text," ")
        set Options(xcBox,xcLabel,2)=$get(Label2," ")
        set Options(xcBox,xcInit,2)=$get(Init2Text," ")
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do x2inputs(.Options,.Results,xcModalMode)
        set result=Results(xcDlgResult)
 
        set Result1=$get(Results(xcDlgOutput,""))
        set Result2=$get(Results(xcDlgOutput,1))
 
        quit result;
 
 
x2inputs(Options,Results,Modal)
 ;" --2inputsbox  <text> <height> <width> <label1> <init1> <label2> <init2>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --2inputsbox ")
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
        set Added=$$AddParam(.Options,1,xcLabel,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,1,xcInit,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,2,xcLabel,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,2,xcInit,xcNotOptional,xcAddQuote)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Input3(Title,width,height,Label1,Init1Text,Label2,Init2Text,Label3,Init3Text,Result1,Result2,Result3,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"Input: Title -- text of input prompt to display
        ;"       height & width of dialog -- [optional]
        ;"       Label1 -- text of label for input 1
        ;"       Init1Text -- default value
        ;"       Label2 -- text of label for input 2
        ;"       Init2Text -- default value
        ;"       Label3 -- text of label for input 3
        ;"       Init3Text -- default value
        ;"       Result1 -- a variable to put first input into for return. PASS BY REFERENCE
        ;"       Result2 -- a variable to put second input into for return. PASS BY REFERENCE
        ;"       Result3 -- a variable to put third input into for return. PASS BY REFERENCE
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: The user input value is return in Result1
        ;"      result of 2nd user-input put into Result2
        ;"      result of 3rd user-input put into Result3
        ;"Results: returns results of box closure.
        ;"Notes: (none)
 
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcCommon,xcSeparator)="^"
        set Options(xcBox,xcText)=$get(Title)
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        set Options(xcBox,xcLabel,1)=$get(Label1," ")
        set Options(xcBox,xcInit,1)=$get(Init1Text," ")
        set Options(xcBox,xcLabel,2)=$get(Label2," ")
        set Options(xcBox,xcInit,2)=$get(Init2Text," ")
        set Options(xcBox,xcLabel,3)=$get(Label3," ")
        set Options(xcBox,xcInit,3)=$get(Init3Text," ")
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do x3inputs(.Options,.Results,xcModalMode)
        set result=Results(xcDlgResult)
 
        set result=$get(Results(xcDlgOutput,""))
        set Result2=$get(Results(xcDlgOutput,1))
        set Result3=$get(Results(xcDlgOutput,2))
 
        quit result;
 
 
x3inputs(Options,Results,Modal)
 ;" --3inputsbox  <text> <height> <width> <label1> <init1> <label2> <init2> <label3> <init3>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --3inputsbox ")
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
        set Added=$$AddParam(.Options,1,xcLabel,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,1,xcInit,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,2,xcLabel,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,2,xcInit,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,3,xcLabel,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,3,xcInit,xcNotOptional,xcAddQuote)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Combo(Text,width,height,List,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"Input: Text -- text of input prompt to display
        ;"       width,height of dialog -- [optional]
        ;"       List -- Best if passed by reference.  Holds list of options to be displayed as follows:
        ;"         List(1)=<Selection Option>
        ;"         List(2)=<Selection Option>
        ;"         List(3)=<Selection Option>
        ;"         ... etc up to any number N
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: (none)
        ;"Results: Returns text of selected option.
        ;"Notes: (none)
 
        new Options
        new Results
        set result=""
        new i,Done
        new status,help
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcBox,xcText)=$get(Text)
 
        set Done=0
        for i=1:1 do  quit:Done
        . if $data(List(i))=0 set Done=1 quit
        . set Options(xcBox,xcItem,i)=$get(List(i))
 
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xcombo(.Options,.Results,xcModalMode)
 
        set result=$get(Results(xcDlgOutput,""))
        quit result;
 
 
xcombo(Options,Results,Modal)
 ;" --combobox    <text> <height> <width> <item1> ... <itemN>
        new Added,GroupAdded
        new N
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --combobox ")
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
        set N=1
xcl1    if $data(Options(xcBox,xcItem,N))=0 goto xcl2
        set GroupAdded=$$AddParam(.Options,N,xcItem,xcNotOptional,xcAddQuote)
        if GroupAdded=0 goto xcl2
        set N=N+1 goto xcl1
xcl2
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Range(Text,width,height,min,max,init,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"      A range dialog presents a horizontal slider bar to user
        ;"Input: Text -- text of input prompt to display
        ;"       width,height of dialog -- [optional]
        ;"       min -- the minimum possible range of input value (default = 0)
        ;"       max -- the minimum possible range of input value (default = 100)
        ;"       init -- the initial input value -- (default = 50)
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: (none)
        ;"Results: Returns input value
        ;"Notes: (none)
 
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcBox,xcText)=$get(Text)
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        set Options(xcBox,xcMin,1)=$get(min,0)
        set Options(xcBox,xcMax,1)=$get(max,100)
        set Options(xcBox,xcDefault,1)=$get(init,50)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xrange(.Options,.Results,xcModalMode)
 
        set result=$get(Results(xcDlgOutput,""))
 
        quit result;
 
 
xrange(Options,Results,Modal)
 ;" --rangebox    <text> <height> <width> <min value> <max value> [<default value>]
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --rangebox ")
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
        set Added=$$AddParam(.Options,1,xcMin,xcNotOptional)
        set Added=$$AddParam(.Options,1,xcMax,xcNotOptional)
        set Added=$$AddParam(.Options,1,xcDefault,xcOptional)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Range2(Text,width,height,label1,min1,max1,init1,label2,min2,max2,init2,Result2,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"Input: Text -- text of input prompt to display
        ;"       width,height of dialog -- [optional]
        ;"       label1 -- the label to show for range
        ;"       min1 -- the minimum possible range of input value (default = 0)
        ;"       max1 -- the minimum possible range of input value (default = 100)
        ;"       init1 -- the initial input value -- (default = 50)
        ;"       label2 -- the label to show for range
        ;"       min2 -- the minimum possible range of input value (default = 0)
        ;"       max2 -- the minimum possible range of input value (default = 100)
        ;"       init2 -- the initial input value -- (default = 50)
        ;"       Result2 -- a variable to put second input into for return. PASS BY REFERENCE
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: (none)
        ;"Results: returns result of 1st user-input.  result of 2nd user-input put into Result2
        ;"Notes: (none)
 
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcCommon,xcSeparator)="^"
        set Options(xcBox,xcText)=$get(Text)
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        set Options(xcBox,xcLabel,1)=$get(label1,"")
        set Options(xcBox,xcMin,1)=$get(min1,0)
        set Options(xcBox,xcMax,1)=$get(max1,100)
        set Options(xcBox,xcMax,1)=$get(max1,100)
        set Options(xcBox,xcDefault,1)=$get(init1,50)
        set Options(xcBox,xcLabel,2)=$get(label2,"")
        set Options(xcBox,xcMin,2)=$get(min2,0)
        set Options(xcBox,xcMax,2)=$get(max2,100)
        set Options(xcBox,xcMax,2)=$get(max2,100)
        set Options(xcBox,xcDefault,2)=$get(init2,50)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do x2range(.Options,.Results,xcModalMode)
 
        set result=$get(Results(xcDlgOutput,""))
        set Result2=$get(Results(xcDlgOutput,1))
 
        quit result;
 
 
x2range(Options,Results,Modal)
 ;" --2rangesbox  <text> <height> <width> <label1> <min1> <max1> <def1> <label2> <min2> <max2> <def2>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --2rangesbox ")
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
        set Added=$$AddParam(.Options,1,xcLabel,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,1,xcMin,xcNotOptional)
        set Added=$$AddParam(.Options,1,xcMax,xcNotOptional)
        set Added=$$AddParam(.Options,1,xcDefault,xcNotOptional)
        set Added=$$AddParam(.Options,2,xcLabel,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,2,xcMin,xcNotOptional)
        set Added=$$AddParam(.Options,2,xcMax,xcNotOptional)
        set Added=$$AddParam(.Options,2,xcDefault,xcNotOptional)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Range3(Text,width,height,label1,min1,max1,init1,label2,min2,max2,init2,label3,min3,max3,init3,Result2,Result3,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"Input: Text -- text of input prompt to display
        ;"       width,height of dialog -- [optional]
        ;"       labelN -- the title to show for the range.
        ;"       minN -- the minimum possible range of input value (default = 0)
        ;"       maxN -- the minimum possible range of input value (default = 100)
        ;"       initN -- the initial input value -- (default = 50)
        ;"       Result2 -- a variable to put second input into for return. PASS BY REFERENCE
        ;"       Result3 -- a variable to put third input into for return. PASS BY REFERENCE
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: (none)
        ;"Results: returns result of 1st user-input.
        ;"      result of 2nd user-input put into Result2
        ;"      result of 3rd user-input put into Result3
        ;"Notes: (none)
 
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcCommon,xcSeparator)="^"
        set Options(xcBox,xcText)=$get(Text)
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        set Options(xcBox,xcLabel,1)=$get(label1,"")
        set Options(xcBox,xcMin,1)=$get(min1,0)
        set Options(xcBox,xcMax,1)=$get(max1,100)
        set Options(xcBox,xcMax,1)=$get(max1,100)
        set Options(xcBox,xcDefault,1)=$get(init1,50)
        set Options(xcBox,xcLabel,2)=$get(label2,"")
        set Options(xcBox,xcMin,2)=$get(min2,0)
        set Options(xcBox,xcMax,2)=$get(max2,100)
        set Options(xcBox,xcMax,2)=$get(max2,100)
        set Options(xcBox,xcDefault,2)=$get(init2,50)
        set Options(xcBox,xcLabel,3)=$get(label3,"")
        set Options(xcBox,xcMin,3)=$get(min3,0)
        set Options(xcBox,xcMax,3)=$get(max3,100)
        set Options(xcBox,xcMax,3)=$get(max3,100)
        set Options(xcBox,xcDefault,3)=$get(init3,50)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do x3range(.Options,.Results,xcModalMode)
 
        set result=$get(Results(xcDlgOutput,""))
        set Result2=$get(Results(xcDlgOutput,1))
        set Result3=$get(Results(xcDlgOutput,2))
 
        quit result;
 
 
x3range(Options,Results,Modal)
 ;" --3rangesbox  <text> <height> <width> <label1> <min1> <max1> <def1> <label2> <min2> <max2> <def2> <label3> <min3> <max3> <def3>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --3rangesbox ")
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
        set Added=$$AddParam(.Options,1,xcLabel,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,1,xcMin,xcNotOptional)
        set Added=$$AddParam(.Options,1,xcMax,xcNotOptional)
        set Added=$$AddParam(.Options,1,xcDefault,xcNotOptional)
        set Added=$$AddParam(.Options,2,xcLabel,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,2,xcMin,xcNotOptional)
        set Added=$$AddParam(.Options,2,xcMax,xcNotOptional)
        set Added=$$AddParam(.Options,2,xcDefault,xcNotOptional)
        set Added=$$AddParam(.Options,3,xcLabel,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,3,xcMin,xcNotOptional)
        set Added=$$AddParam(.Options,3,xcMax,xcNotOptional)
        set Added=$$AddParam(.Options,3,xcDefault,xcNotOptional)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Spin(Text,width,height,label,min,max,init,Result,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"      A spinner is a dialable number input dialog.
        ;"Input: Text -- text of input prompt to display
        ;"       width,height of dialog -- [optional]
        ;"       min -- the minimum possible range of input value (default = 0)
        ;"       max -- the minimum possible range of input value (default = 100)
        ;"       init -- the initial input value -- (default = 50)
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: The user input value is return in Result
        ;"Results: returns results of box closure.
        ;"Notes: (none)
 
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcBox,xcText)=$get(Text)
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        set Options(xcBox,xcMin,1)=$get(min,0)
        set Options(xcBox,xcMax,1)=$get(max,100)
        set Options(xcBox,xcMax,1)=$get(max,100)
        set Options(xcBox,xcLabel,1)=$get(label,"")
        set Options(xcBox,xcDefault,1)=$get(init,50)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xspin(.Options,.Results,xcModalMode)
        set result=Results(xcDlgResult)
 
        set Result=$get(Results(xcDlgOutput,""))
 
        quit result;
 
 
xspin(Options,Results,Modal)
 ;" --spinbox     <text> <height> <width> <min> <max> <def> <label>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --spinbox ")
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
        set Added=$$AddParam(.Options,1,xcMin,xcNotOptional)
        set Added=$$AddParam(.Options,1,xcMax,xcNotOptional)
        set Added=$$AddParam(.Options,1,xcDefault,xcOptional)
        set Added=$$AddParam(.Options,1,xcLabel,xcNotOptional,xcAddQuote)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Spin2(Text,width,height,label1,min1,max1,init1,label2,min2,max2,init2,Result1,Result2,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"Input: Text -- text of input prompt to display
        ;"       width,height of dialog -- [optional]
        ;"       label1 -- the label to show for range
        ;"       min1 -- the minimum possible range of input value (default = 0)
        ;"       max1 -- the minimum possible range of input value (default = 100)
        ;"       init1 -- the initial input value -- (default = 50)
        ;"       label2 -- the label to show for range
        ;"       min2 -- the minimum possible range of input value (default = 0)
        ;"       max2 -- the minimum possible range of input value (default = 100)
        ;"       init2 -- the initial input value -- (default = 50)
        ;"       Result1 -- a variable to put first input into for return. PASS BY REFERENCE
        ;"       Result2 -- a variable to put second input into for return. PASS BY REFERENCE
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: The user input value is return in Result1
        ;"        result of 2nd user-input put into Result2
        ;"Results: returns results of box closure.
        ;"Notes: (none)
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcCommon,xcSeparator)="^"
        set Options(xcBox,xcText)=$get(Text)
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        set Options(xcBox,xcLabel,1)=$get(label1,"")
        set Options(xcBox,xcMin,1)=$get(min1,0)
        set Options(xcBox,xcMax,1)=$get(max1,100)
        set Options(xcBox,xcMax,1)=$get(max1,100)
        set Options(xcBox,xcDefault,1)=$get(init1,50)
        set Options(xcBox,xcLabel,2)=$get(label2,"")
        set Options(xcBox,xcMin,2)=$get(min2,0)
        set Options(xcBox,xcMax,2)=$get(max2,100)
        set Options(xcBox,xcMax,2)=$get(max2,100)
        set Options(xcBox,xcDefault,2)=$get(init2,50)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do x2spin(.Options,.Results,xcModalMode)
        set result=Results(xcDlgResult)
 
        set Result1=$get(Results(xcDlgOutput,""))
        set Result2=$get(Results(xcDlgOutput,1))
 
        quit result;
 
 
x2spin(Options,Results,Modal)
 ;" --2spinsbox   <text> <height> <width> <min1> <max1> <def1> <label1> <min2> <max2> <def2> <label2>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
        set Added=$$AddParam(.Options,1,xcMin,xcNotOptional)
        set Added=$$AddParam(.Options,1,xcMax,xcNotOptional)
        set Added=$$AddParam(.Options,1,xcDefault,xcNotOptional)
        set Added=$$AddParam(.Options,1,xcLabel,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,2,xcMin,xcNotOptional)
        set Added=$$AddParam(.Options,2,xcMax,xcNotOptional)
        set Added=$$AddParam(.Options,2,xcDefault,xcNotOptional)
        set Added=$$AddParam(.Options,2,xcLabel,xcNotOptional,xcAddQuote)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Spin3(Text,width,height,label1,min1,max1,init1,label2,min2,max2,init2,label3,min3,max3,init3,Result1,Result2,Result3,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"Input: Text -- text of input prompt to display
        ;"       width,height of dialog -- [optional]
        ;"       labelN -- the title to show for the range.
        ;"       minN -- the minimum possible range of input value (default = 0)
        ;"       maxN -- the minimum possible range of input value (default = 100)
        ;"       initN -- the initial input value -- (default = 50)
        ;"       Result1 -- a variable to put first input into for return. PASS BY REFERENCE
        ;"       Result2 -- a variable to put second input into for return. PASS BY REFERENCE
        ;"       Result3 -- a variable to put third input into for return. PASS BY REFERENCE
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: The user input value is return in Result1
        ;"      result of 2nd user-input put into Result2
        ;"      result of 3rd user-input put into Result3
        ;"Results: returns results of box closure.
        ;"Notes: (none)
 
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcCommon,xcSeparator)="^"
        set Options(xcBox,xcText)=$get(Text)
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        set Options(xcBox,xcLabel,1)=$get(label1,"")
        set Options(xcBox,xcMin,1)=$get(min1,0)
        set Options(xcBox,xcMax,1)=$get(max1,100)
        set Options(xcBox,xcMax,1)=$get(max1,100)
        set Options(xcBox,xcDefault,1)=$get(init1,50)
        set Options(xcBox,xcLabel,2)=$get(label2,"")
        set Options(xcBox,xcMin,2)=$get(min2,0)
        set Options(xcBox,xcMax,2)=$get(max2,100)
        set Options(xcBox,xcMax,2)=$get(max2,100)
        set Options(xcBox,xcDefault,2)=$get(init2,50)
        set Options(xcBox,xcLabel,3)=$get(label3,"")
        set Options(xcBox,xcMin,3)=$get(min3,0)
        set Options(xcBox,xcMax,3)=$get(max3,100)
        set Options(xcBox,xcMax,3)=$get(max3,100)
        set Options(xcBox,xcDefault,3)=$get(init3,50)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do x3spin(.Options,.Results,xcModalMode)
        set result=Results(xcDlgResult)
 
        set Result1=$get(Results(xcDlgOutput,""))
        set Result2=$get(Results(xcDlgOutput,1))
        set Result3=$get(Results(xcDlgOutput,2))
 
        quit result;
 
 
x3spin(Options,Results,Modal)
 ;" --3spinsbox   <text> <height> <width> <text> <height> <width> <min1> <max1> <def1> <label1> <min2> <max2> <def2> <label2> <min3> <max3> <def3> <label3>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --2spinsbox ")
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
        set Added=$$AddParam(.Options,1,xcMin,xcNotOptional)
        set Added=$$AddParam(.Options,1,xcMax,xcNotOptional)
        set Added=$$AddParam(.Options,1,xcDefault,xcNotOptional)
        set Added=$$AddParam(.Options,1,xcLabel,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,2,xcMin,xcNotOptional)
        set Added=$$AddParam(.Options,2,xcMax,xcNotOptional)
        set Added=$$AddParam(.Options,2,xcDefault,xcNotOptional)
        set Added=$$AddParam(.Options,2,xcLabel,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,3,xcMin,xcNotOptional)
        set Added=$$AddParam(.Options,3,xcMax,xcNotOptional)
        set Added=$$AddParam(.Options,3,xcDefault,xcNotOptional)
        set Added=$$AddParam(.Options,3,xcLabel,xcNotOptional,xcAddQuote)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
Log(file,width,height,Modal,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"Input: file to display
        ;"       height & width of dialog -- [optional]
        ;"       [Modal]: if true, function does not return until dialog is closed.
        ;"              if false, function returns immediately, and functions do NOT
        ;"              reflect the user's button press. OPTIONAL -- default=xcNonModal
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: (none)
        ;"Results: Returns results of box closure (see Modal note above)
        ;"Notes: (none)
 
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcBox,xcFile)=$get(file)
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        set Modal=$get(Modal,xcNonModal)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xlog(.Options,.Results,Modal)
        set result=Results(xcDlgResult)
 
        quit result;
 
 
xlog(Options,Results,Modal)
 ;" --logbox      <file> <height> <width>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --logbox ")
 
 
        set Added=$$AddParam(.Options,,xcFile,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
Edit(file,width,height,Results,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"Input: file to display for editing,
        ;"       height & width of dialog -- [optional]
        ;"       Results -- the array to put results into. MUST BE PASSED BY REFERENCE.
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: The modified text is put into Results
        ;"      Example of returned results after editing a script file.:
        ;"      Results("Dialog Output",1)="<!DOCTYPE INSTALL_SCRIPT>"
        ;"      Results("Dialog Output",2)="<INSTALL_SCRIPT>"
        ;"      Results("Dialog Output",3)="<Script>"
        ;"      Results("Dialog Output",4)="  <Show>This is a test script system.</Show>"
        ;"      Results("Dialog Output",5)="</Script>"
        ;"Results: Returns results of box closure (see Modal note above)
        ;"Notes: If dialog is not closed with an OK, then changes are NOT returned in Results
 
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcBox,xcFile)=$get(file)
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xedit(.Options,.Results,xcModalMode)
        set result=Results(xcDlgResult)
 
        quit result;
 
 
xedit(Options,Results,Modal)
 ;" --editbox     <file> <height> <width>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --editbox ")
 
        set Added=$$AddParam(.Options,,xcFile,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
Text(file,width,height,Modal,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"Input: file to display
        ;"       height & width of dialog -- [optional]
        ;"       [Modal]: if true, function does not return until dialog is closed.
        ;"              if false, function returns immediately, and functions do NOT
        ;"              reflect the user's button press. OPTIONAL -- default=xcNonModal
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: (none)
        ;"Results: Returns results of box closure (see Modal note above)
        ;"Notes: (none)
 
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcBox,xcFile)=$get(file)
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        set Modal=$get(Modal,xcNonModal)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xtext(.Options,.Results,Modal)
        set result=Results(xcDlgResult)
 
        quit result;
 
 
xtext(Options,Results,Modal)
 ;" --textbox     <file> <height> <width>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --textbox ")
 
        set Added=$$AddParam(.Options,,xcFile,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
Tail(file,width,height,Modal,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"         A tailbox is one that keeps at the bottom, updating as the file is updated.
        ;"Input: file to display
        ;"       height & width of dialog -- [optional]
        ;"       [Modal]: if true, function does not return until dialog is closed.
        ;"              if false, function returns immediately, and functions do NOT
        ;"              reflect the user's button press. OPTIONAL -- default=xcNonModal
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: (none)
        ;"Results: Returns results of box closure (see Modal note above)
        ;"Notes: (none)
 
        new Options
        new Results,result
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcBox,xcFile)=$get(file)
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        set Modal=$get(Modal,xcNonModal)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xtail(.Options,.Results,Modal)
        set result=Results(xcDlgResult)
 
        quit result;
 
 
xtail(Options,Results,Modal)
 ;" --tailbox     <file> <height> <width>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --tailbox ")
 
        set Added=$$AddParam(.Options,,xcFile,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 ;"TO BE COMPLETED
 
xchecklist(Options,Results,Modal)
 ;" --checklist   <text> <height> <width> <list height> <tag1> <item1> <status1> {<help1>}...
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
RadioList(Text,List,width,height,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"         A tailbox is one that keeps at the bottom, updating as the file is updated.
        ;"Input: Text -- title text.
        ;"       List -- Best if passed by reference.  Holds radio list as follows:
        ;"         List(1,xcTag)=<return value>  -- the output the be returned if selected.
        ;"         List(1,xcItem)=<text of radio item>
        ;"         List(1,xcStatus)=<status> must be: {"on", "off", or "unavailable"}
        ;"         List(1,xcHelp)=<hover tip> -- [optional]
        ;"         List(2,xcTag)=<return value>  -- the output the be returned if selected.
        ;"         List(2,xcItem)=<text of radio item>
        ;"         List(2,xcStatus)=<status> must be: {"on", "off", or "unavailable"}
        ;"         List(2,xcHelp)=<hover tip> -- [optional]
        ;"         ... etc up to any number N
        ;"       height & width of dialog -- [optional]
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output: (none)
        ;"Results: Returns selected 'tag'. If cancel pressed, then returns ""
        ;"Notes: (none)
 
        new Options
        new Results
        set result=""
        new i,Done
        new status,help
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcBox,xcText)=$get(Text)
 
        set Done=0
        for i=1:1 do  quit:Done
        . if $data(List(i,xcTag))=0 set Done=1 quit
        . set Options(xcBox,xcTag,i)=$get(List(i,xcTag))
        . set Options(xcBox,xcItem,i)=$get(List(i,xcItem))
        . set status=$get(List(i,xcStatus))
        . if (status'="on")&(status'="unavailable") set status="off"
        . set Options(xcBox,xcStatus,i)=status
        . set help=$get(List(i,xcHelp,i))
        . if help'="" set Options(xcTransient,xxcItemHelp)=1
        . set help=($get(Options(xcTransient,xxcItemHelp))=1)
        . if help set Options(xcBox,xcHelp,i)=$get(List(i,xcHelp))
 
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xradiolist(.Options,.Results,xcModalMode)
 
        set result=$get(Results(xcDlgOutput,""))
        quit result;
 
 
xradiolist(Options,Results,Modal)
 ;" --radiolist   <text> <height> <width> <list height> <tag1> <item1> <status1> {<help1>}...
        new Added,GroupAdded
        new N
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --radiolist ")
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
        set Added=$$AddParam(.Options,,xcListHeight)
        set N=1
xrl1    set GroupAdded=$$AddParam(.Options,N,xcTag,xcNotOptional,xcAddQuote)
        if GroupAdded=0 goto xrl2
        set Added=$$AddParam(.Options,N,xcItem,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,N,xcStatus,xcNotOptional,xcAddQuote)
        if (Added=1)&($get(Option(xcTransient,xxcItemHelp))=1) do
        . set Added=$$AddParam(.Options,N,xcHelp,xcNotOptional,xcAddQuote)
        set N=N+1 goto xrl1
xrl2
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 ;"TO BE COMPLETED
 
xmenu(Options,Results,Modal)
 ;" --menubox     <text> <height> <width> <menu height> <tag1> <item1> {<help1>}...
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 ;"TO BE COMPLETED
 
xtreeview(Options,Results,Modal)
 ;" --treeview    <text> <height> <width> <list height> <tag1> <item1> <status1> <item_depth1> {<help1>}...
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
FileSel(Title,InitFile,width,height,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"         A tailbox is one that keeps at the bottom, updating as the file is updated.
        ;"Input: InitFile.  The initial file to select, and the default file. [optional]
        ;"       width,height -- the initial size of box.  [Optional]
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output:(none)
        ;"Results: returns the selected filename
        ;"Notes: (none)
 
        new Options
        new Results
        new result set result=""
 
        if $data(xcCommon)=0 do SetupConsts()
        if $data(Title) set Options(xcCommon,xcTitle)=Title
        set Options(xcBox,xcFile)=$get(InitFile,"")
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xfilesel(.Options,.Results,xcModalMode)
 
        if Results(xcDlgResult)=0 set result=$get(Results(xcDlgOutput,""))
 
        quit result;
 
xfilesel(Options,Results,Modal)
 ;" --fselect     <file> <height> <width>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --fselect ")
 
        set Added=$$AddParam(.Options,,xcFile,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
DirSel(Title,InitDir,width,height,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"         A tailbox is one that keeps at the bottom, updating as the file is updated.
        ;"Input: InitDir:  The initial file to select, and the default file. [optional]
        ;"       width,height -- the initial size of box.  [Optional]
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output:(none)
        ;"Results: returns the selected directory
        ;"Notes: (none)
 
        new Options
        new Results
        new result set result=""
 
        if $data(xcCommon)=0 do SetupConsts()
        if $data(Title) set Options(xcCommon,xcTitle)=Title
        set Options(xcBox,xcDirectory)=$get(InitDir,"")
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xdirsel(.Options,.Results,xcModalMode)
 
        if Results(xcDlgResult)=0 set result=$get(Results(xcDlgOutput,""))
 
        quit result;
 
 
xdirsel(Options,Results,Modal)
 ;" --dselect     <directory> <height> <width>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --dselect ")
 
 
        set Added=$$AddParam(.Options,,xcDirectory,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
DateSel(Text,width,height,InitDay,InitMonth,InitYear,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"         Shows a calendar and allows user to select date.
        ;"Input: Text -- a title / msg to show.
        ;"       width,height -- the initial size of box.  [Optional]
        ;"       InitDay/Month/Year -- Initial date to show.
        ;"         NOTE: These three variables are optional BUT if InitDay given all 3 should be present.
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output:(none)
        ;"Results: returns the selected date
        ;"Notes: (none)
 
        new Options
        new Results
        new result set result=""
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcBox,xcText)=$get(Text,"")
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        if $data(InitDay) do
        . set Options(xcBox,xcDay)=InitDay
        . set Options(xcBox,xcMonth)=$get(InitMonth,0)
        . set Options(xcBox,xcYear)=$get(InitYear,0)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xcalendarsel(.Options,.Results,xcModalMode)
 
        if Results(xcDlgResult)=0 set result=$get(Results(xcDlgOutput,""))
 
        quit result;
 
xcalendarsel(Options,Results,Modal)
 ;" --calendar    <text> <height> <width> [<day> <month> <year>]
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --calendar ")
 
        set Added=$$AddParam(.Options,,xcText,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
        if $data(Options(xcDay)) do
        . set Added=$$AddParam(.Options,,xcDay,xcNotOptional)
        . set Added=$$AddParam(.Options,,xcMonth,xcNotOptional)
        . set Added=$$AddParam(.Options,,xcYear,xcNotOptional)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
TimeSel(Text,width,height,InitHour,InitMinute,InitSecond,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"         Shows a calendar and allows user to select date.
        ;"Input: Text -- a title / msg to show.
        ;"       width,height -- the initial size of box.  [Optional]
        ;"       InitHour/Minute/Second -- Initial time to show.
        ;"         NOTE: These three variables are optional BUT if InitDay given all 3 should be present.
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output:(none)
        ;"Results: returns the selected date
        ;"Notes: (none)
 
        new Options
        new Results
        new result set result=""
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcBox,xcText)=$get(Text,"")
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        if $data(InitHour) do
        . set Options(xcBox,xcHours)=InitDay
        . set Options(xcBox,xcMinutes)=$get(InitMinute,0)
        . set Options(xcBox,xcSeconds)=$get(InitSecond,0)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xtimesel(.Options,.Results,xcModalMode)
 
        if Results(xcDlgResult)=0 set result=$get(Results(xcDlgOutput,""))
 
        quit result;
 
xtimesel(Options,Results,Modal)
 ;" --timebox     <text> <height> <width> [<hours> <minutes> <seconds>]
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --timebox ")
 
        set Added=$$AddParam(.Options,,xcText,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
        if $data(Options(xcHours)) do
        . set Added=$$AddParam(.Options,,xcHours,xcNotOptional)
        . set Added=$$AddParam(.Options,,xcMinutes,xcNotOptional)
        . set Added=$$AddParam(.Options,,xcSeconds,xcNotOptional)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 ;"TO BE COMPLETED
 
xbuildlist(Options,Results,Modal)
 ;" --buildlist   <text> <height> <width> <list height> <tag1> <item1> <status1> {<help1>}...
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 ;"TO BE COMPLETED
 
xcolorsel(Options,Results,Modal)
 ;" --colorsel    <text> <height> <width>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --colorsel ")
 
        set Added=$$AddParam(.Options,,xcText,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
FontSel(InitFont,width,height,x,y)
        ;"Purpose: To provide an easier access to Xdialog function
        ;"         Shows a font-pick
        ;"Input: InitFont -- name of initial font to show [Optional]
        ;"       width,height -- the initial size of box.  [Optional]
        ;"       x,y -- the display location of the dialog [optional]
        ;"Output:(none)
        ;"Results: returns the selected date
        ;"Notes: (none)
 
        new Options
        new Results
        new result set result=""
 
        if $data(xcCommon)=0 do SetupConsts()
 
        set Options(xcBox,xcFontName)=$get(InitFont,"")
        set Options(xcBox,xcHeight)=$get(height,0)
        set Options(xcBox,xcWidth)=$get(width,0)
        if $data(x) set Options(xcTransient,xcBegin)=x_" "_$get(y,0)
 
        do xfontsel(.Options,.Results,xcModalMode)
 
        if Results(xcDlgResult)=0 set result=$get(Results(xcDlgOutput,""))
 
        quit result;
 
 
xfontsel(Options,Results,Modal)
 ;" --fontsel     <font name> <height> <width>
        new Added
 
        do ParamTextAdd(.Options,vDialog)
        do SetCommons(.Options)
        do SetTrans(.Options)
        do ParamTextAdd(.Options," --fontsel ")
 
        set Added=$$AddParam(.Options,,xcFontName,xcNotOptional,xcAddQuote)
        set Added=$$AddParam(.Options,,xcHeight)
        set Added=$$AddParam(.Options,,xcWidth)
 
        do LaunchCmd(.Options,.Results,.Modal)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
ChClrScr()
        ;"Purpose: When working with text menus, after the dialog exits,
        ;"         it leaves the drawing of the menu on the text screen.
        ;"         So I'll have a function that clears the screen.
        ;"Note:    I can't depend on the VistA system to have set up
        ;"         variables that will clear the screen.  So I'll do it quick and dirty
        ;"         by many newline characters.
 
        new count
 
        for count=1:1:50 write !
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
SetCommons(Options)
        ;"Purpose: to put common options into a parameter string that will be sent to Xdialog
        ;"Input: Options -- MUST BE PASSED BY REFERENCE
        ;"       See docs re. Options above.
        ;"Output: The Options array will contain an entry containing output string:
        ;"        Options(xcCmdLine)=<composite options>
 
        new i
        new s set s=" "
        new AddQuote set AddQuote=0
 
        if $data(xcCommon)=0 do SetupConsts()  ;"Ensure constants created.
 
 
        set i=$order(Options(xcCommon,""))
        for  do  q:i=""
        . if i=xcCmdLine quit
        . if (i'=xcCmdLine)&($data(Options(xcCommon,i))'=0) do
        . . set s=s_"--"_i_" "
        . . if $get(Options(xcCommon,i))'=1 do
        . . . set s=s_""""_Options(xcCommon,i)_""" "
        . set i=$order(Options(xcCommon,i))
 
        ;"set Options(xcCmdLine)=s
        do ParamTextAdd(.Options,s)
 
        quit
 
 
SetTrans(Options)
        ;"Purpose: to put transient options into a parameter string that will be sent to Xdialog
        ;"Input: Options -- MUST BE PASSED BY REFERENCE
        ;"       See docs re. Options above.
        ;"Output: The Options array will contain an entry containing output string:
        ;"        Options(xcCmdLine)=<composite options>
        ;"Note: This function should be called AFTER SetCommons()
 
        new i
        ;"new s set s=$get(Options(xcCmdLine))
        new s set s=" "
 
        set i=$order(Options(xcTransient,""))
        for  do  q:i=""
        . if i=xcCmdLine quit
        . if (i'=xcCmdLine)&($data(Options(xcTransient,i))'=0) do
        . . set s=s_"--"_i_" "
        . . if $get(Options(xcTransient,i))'=1 set s=s_Options(xcTransient,i)_" "
        . set i=$order(Options(xcTransient,i))
 
        ;"set Options(xcCmdLine)=$get(Options(xcCmdLine))_s
        do ParamTextAdd(.Options,s)
 
        quit
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
AddParam(Options,N,index,optional,AddQuote)
        ;"Purpose: to add index'd box parameter to the composite parameters
        ;"Input: Options -- see above. MUST BE PASSED BY REFERENCE
        ;"       N -- should NOT be passed, unless index item has a 'subscript', i.e.:
        ;"              Options(xcBox,xcItem,1)="Bill"
        ;"              Options(xcBox,xcItem,2)="Bill"
        ;"              Options(xcBox,xcItem,3)="Bill"
        ;"       index -- specifies which parameter to add (if found)
        ;"       optional -- specifies if parameter is optional
        ;"                    default=not optional (0).  Value of 1=is optional
        ;"       AddQuote -- if parameter should be in quotes -- default is 0 / no
        ;"results: returns if data was added. (1=added, 0=not added)
 
        new result set result=0
        new s,sCurrent
        new CurLine
        new Param
 
        set optional=$get(optional,xcNotOptional)
        if optional'=xcNotOptional set optional=xcOptional
        set AddQuote=$get(AddQuote,xcNoQuote)
 
        ;"write "Starting AddParam",!
 
        set s=""
 
        if $data(N) do  ;"i.e. user is looking for a subscripted element...
        . set Param=$get(Options(xcBox,index,N))
        else  do        ;"i.e. user is NOT looking for a subscripted element...
        . set Param=$get(Options(xcBox,index))
 
        if Param'="" do  ;"Parameter found.
        . if AddQuote set s=s_""""
        . set s=s_Param
        . set result=1
        else  do   ;"There has not been any parameter found.
        . if $data(N) quit   ;"If user was looking for (absent) subscripted param, then ignore NotOptional
        . if (optional=xcNotOptional) do
        . . if AddQuote set s=s_""""
        . . set s=s_"0"  ;"put in a 0 for non-optional values.
        . . set result=1
 
        if result=1 do
        . if (AddQuote=xcAddQuote) set s=s_""" "
        . else  set s=s_" "
 
        do ParamTextAdd(.Options,s)
 
 
        quit result
 
ParamTextAdd(Options,Text)
        ;"Purpose: to actually add the text of the new parameter etc
        ;"         into the Options variable
        ;"Input: Options .. same as variable used everywhere else
        ;"              MUST BE PASSED BY REFERENCE
        ;"      Text -- the text to add
 
        new sCurrent
        new CurLine
 
        ;"First the simple way -- with max of ~230 characters
        set Options(xcCmdLine)=$get(Options(xcCmdLine))_Text
 
        ;"Next, array method, with unlimited length.
        set CurLine=$get(Options(xcCmdLine,xcCmdArray,xcCmdMaxLine),0)
        set sCurrent=$get(Options(xcCmdLine,xcCmdArray,CurLine))
        if $length(sCurrent)>80 do
        . set CurLine=CurLine+1
        . set sCurrent=""
 
        set sCurrent=sCurrent_Text
        ;"write "After additions, sCurrent=",sCurrent,!
        set Options(xcCmdLine,xcCmdArray,CurLine)=sCurrent
        set Options(xcCmdLine,xcCmdArray,xcCmdMaxLine)=CurLine
        quit
 
 
LaunchCmd(Options,Results,Modal)
        ;"Purpose: To actually launch the dialog, and to retrieve results
        ;"Input:  Options -- see Docs above.  The only part of the Options array
        ;"                that is used here is Options(xcCmdLine)
        ;"        Results -- an array to pass results back in.
        ;"        Modal -- if =xcModalMode, then execution does not continue until dialog is closed
        ;"                 if xcNonModal, then execution immediately continues.  Note in this
        ;"                   case the result of the execution will be 0 (unless an error
        ;"                   occurs creating the dialog.)  It will NOT be the result of
        ;"                   the user's button press.
 
        new Cmd,HookCmd
        new FileHandle
        new CommFPath set CommFPath="/tmp/"
        new CommFName set CommFName="M_xdialog_comm_"_$J_".tmp"
        new CommFile set CommFile=CommFPath_CommFName
 
        ;"set Cmd=vDialog_" "_$get(Options(xcCmdLine))
        ;"set Cmd=Cmd_" 2>"_CommFile
        do ParamTextAdd(.Options," 2>"_CommFile)
 
        set Modal=$get(Modal,xcNonModal)
        if (Modal=xcNonModal) do
        . do ParamTextAdd(.Options," & ")
 
        new result,killme
        new FRef
        ;"write "--------------------------------------------------",!
        ;"zwr Options(xcCmdLine,xcCmdArray,*)
        set FRef=$name(Options(xcCmdLine,xcCmdArray,0))
        set result=$$GTF^%ZISH(FRef,3,CommFPath,CommFName)
 
        ;"set HookCmd="cat "_CommFile
        ;"write "Here is hook command",!,!,HookCmd,!,!
        ;"zsystem HookCmd
 
        ;"Explaination of following line:
        ;"I can't always pass the command in one string, because of limitation of string length
        ;"So I am writing out the command as a text file (to CommFile)--which will have the long
        ;"string divided up into multiple lines.  However, the bash command shell
        ;"can't deal with the command split up like this.
        ;"I have researched to find this method of stripping newlines from the end of
        ;"a line--there are probably 8 other ways to do this too. :-)
        ;"    echo `<file` >file
        ;"I then execute the file by typing:
        ;"   sh file
        ;"And the two commands are separated on the line by a ";"
        ;"So the composite is:
        ;"   echo `<file` >file ; sh file
        ;"Note that the instructions contained in 'file' include an instruction to put
        ;"  the output from the dialog back into 'file'.  This is ok, because it won't
        ;"  be overwriten until after the command has started to execute.
 
        ;"set HookCmd="echo `<"_CommFile_"` >"_CommFile_" ; sh "_CommFile
        ;"write "Here is hook command",!,!,HookCmd,!,!
        ;"zsystem HookCmd
 
        set HookCmd="echo `<"_CommFile_"` >"_CommFile
        ;"write "Here is hook command",!,!,HookCmd,!,!
        zsystem HookCmd
 
        ;"set HookCmd="cat "_CommFile
        ;"write "Here is hook command",!,!,HookCmd,!,!
        ;"zsystem HookCmd
 
        set HookCmd="sh "_CommFile
        ;"write "Here is hook command",!,!,HookCmd,!,!
        zsystem HookCmd
 
 
        set Results(xcDlgResult)=$ZSYSTEM&255  ;"get result of execution. (low byte only)
 
        ;"Read output info Results
        ;"set HookCmd="cat "_CommFile
        ;"write "Here is hook command",!,!,HookCmd,!,!
        ;"zsystem HookCmd
        set FileHandle=$$FTG^%ZISH(CommFPath,CommFName,$name(Results(xcDlgOutput)),3)
        ;"zwr Results(*)
 
        ;"Now kill the communication file... no longer needed.
        new FileSpec
        set FileSpec(CommFile)=""
        set result=$$DEL^%ZISH(CommFPath,$name(FileSpec))
 
        quit
 
 
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 
Demo
        ;"Purpose: To show the functionality of the library, and
        ;"         to give a programming demo.
 
 
        new result
        new Feedback
        new s
        new UserPick,filename
        new UseGUI
 
        set UseGUI=0
 
        do SetupConsts()
 
        do SetGUI(UseGUI)
 
        new List
        set List(1,xcTag)="Graphic"
        set List(1,xcItem)="Select this for full X-system GUI"
        set List(1,xcStatus)="on"
        set List(2,xcTag)="Text"
        set List(2,xcItem)="Select this for character interface"
        set List(2,xcStatus)="off"
        set UserPick=$$RadioList("Which type of boxes would you like to use?",.List)
 
        do ChClrScr^TMGXDLG()
 
        if UserPick="Graphic" do
        . set UseGUI=1
        . do SetGUI(UseGUI)
 
        if UseGUI=0 goto l1
 
        set s="Welcome to the Xdialog Demo \nThis box is 'non-modal' "
        set s=s_"so its program can continue without"
        set s=s_"waiting for a user response."
        set result=$$Msg("Welcome",s,0,0,xcNonModal,1,2)  ;"height&width of 0,0 means "auto size"
 
l1
        set result=$$YesNo^TMGXDLG("Do you want to see a demo \n of this Xdialog wrapper library?")
        if result'=mrYes goto DemoDone
 
        ;"Note: This don't seem to work in character mode...
        set s="OK, Check out this 'Info' box.  It will auto close in 6 seconds"
        set result=$$Info(s,0,0,6,xcModalMode)
 
        new List
        set List(1,xcTag)="Edit box"
        set List(1,xcItem)="Select this for an Edit Box"
        set List(1,xcStatus)="on"
        set List(2,xcTag)="Log box"
        set List(2,xcItem)="Select this for a Log Box"
        set List(2,xcStatus)="off"
        set List(3,xcTag)="Text box"
        set List(3,xcItem)="Select this for a Text Box"
        set List(3,xcStatus)="off"
        set List(4,xcTag)="Tail box"
        set List(4,xcItem)="Select this for a Tail Box"
        set List(4,xcStatus)="off"
        set UserPick=$$RadioList("Select Tool to See",.List)
 
        write "You selected: ",UserPick,!
 
        ;"Note: This don't seem to work in character mode...
        if UserPick'="" do
        . set filename=$$FileSel("Select a file to load")
        . if UserPick="Edit box" do  quit
        . . set result=$$Edit(filename,0,0,.Feedback)
        . if UserPick="Log box" do  quit
        . . set result=$$Log(filename,0,0,xcModalMode)
        . if UserPick="Text box" do  quit
        . . set result=$$Text(filename,0,0,xcModalMode)
        . if UserPick="Tail box" do  quit
        . . set result=$$Tail(filename,0,0,xcModalMode)
 
        new FName,LName,Zip
        new DumpVar
 
        set result=$$Input("Enter Name",0,0,"John",.FName)
        if result=mrCancel goto GBye
        write "Here is name:",FName,!
        ;"read "Press any key to coninue",*DumpVar,!
 
        ;"Note: This not supported in character mode...
        set result=$$Input2("Enter Name",0,0,"First","John","Last","Smith",.FName,.LName)
        if result=mrCancel goto GBye
        write "Here is name:",FName," ",LName,!
        ;"read "Press any key to coninue",*DumpVar,!
 
        ;"Note: This not supported in character mode...
        set result=$$Input3("Enter Name",0,0,"First","John","Last","Smith","Zip","12345",.FName,.LName,.Zip)
        if result=mrCancel goto GBye
        write "Here is name:",FName," ",LName,!
        write "zip: ",Zip,!
 
        ;"Note: This not supported in character mode...
        kill List
        set List(1)="Cookies"
        set List(2)="Ice Cream"
        set List(3)="Cake"
        set result=$$Combo("Pick your favorite dessert:",0,0,.List)
        write "You picked: ",result,!
 
        new Result1,Result2,Result3
 
        ;"Note: This not supported in character mode...
        set result=$$Range("Enter some numbers",0,0,25,250,100,.Result1)
        if result=mrCancel goto GBye
        write "$=",Result1,!
 
        ;"Note: This not supported in character mode...
        set result=$$Range2("Enter some numbers",0,0,"$",25,250,100,"%",33,66,44,.Result1,.Result2)
        if result=mrCancel goto GBye
        write "$=",Result1," and %=",Result2,!
 
        ;"Note: This not supported in character mode...
        set result=$$Range3("Enter some numbers",0,0,"$",25,250,100,"%",33,66,44,"#",1000,2000,1500,.Result1,.Result2,.Result3)
        if result=mrCancel goto GBye
        write "$=",Result1," and %=",Result2," and #=",Result3,!
 
        ;"Note: This not supported in character mode...
        set result=$$Spin("Enter a number",0,0,"$",25,250,100,.Result1)
        if result=mrCancel goto GBye
        write "$=",Result1,!
 
        ;"Note: This not supported in character mode...
        set result=$$Spin2("Enter some numbers",0,0,"$",25,250,100,"%",33,66,44,.Result1,.Result2)
        if result=mrCancel goto GBye
        write "$=",Result1," and %=",Result2,!
 
        ;"Note: This not supported in character mode...
        set result=$$Spin3("Enter some numbers",0,0,"$",25,250,100,"%",33,66,44,"#",1000,2000,1500,.Result1,.Result2,.Result3)
        if result=mrCancel goto GBye
        write "$=",Result1," and %=",Result2," and #=",Result3,!
 
GBye
        set result=$$Msg("Goodbye","That''s all for now folks!",0,0,xcModalMode)
 
        if UseGUI=0 do ChClrScr^TMGXDLG()
 
DemoDone
        quit
 
 
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
 ;"Progress Notes:
 ;"9-26-04       On my server, Xdialog was missing. I had to simply copy the
 ;"              Xdialog file into /usr/bin ...  I ought to have some way to
 ;"              check for existance of file and give message if it is absent.
 ;"=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
