TMGNDF4E ;TMG/kst/FDA Import -- Copy Orderable --> OQV ;03/25/06
         ;;1.0;TMG-LIB;**1**;11/21/07
 
 ;" FDA - NATIONAL DRUG FILES COMPILING FUNCTIONS
 ;"      Copy of ORDERABLE ITEMS into ORDER QUICK VIEW file
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"11-21-2006
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"Menu
 
 ;"Sync2OQV -- ensure ALL ORDERABLE ITEMS (101.43) items are added to the ORDER QUICK VIEW (101.44)
 ;"Fix1OQV(IEN101d43,Option) -- alter one entry in OQV file to reflect changes in ORDERABLE ITEM file (101.43)
 
 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 ;"MakeNewQOVS -- save the old QUICK ORDER VIEW set, and create a new one.
 ;"Add(RxSet,pOI) -- add 'name' to ORWDSET O RX record in ORDER QUICK VIEW file
 ;"KillPrior(RxSet) -- kill ALL records in the RxSet in 101.44
 ;"Check4BadOQV -- Scan through all ORDER QUICK VIEWS cheking fro pointers to bad records
 
 ;"=======================================================================
 
Menu
        new Menu,UsrSlct
        set Menu(0)="Pick Option to Sync ORDER QUICK VIEW (OQV) (4E)"
        set Menu(1)="Sync imports to ORDER QUICK VIEW."_$char(9)_"Sync2OQV"
        set Menu(2)="Check for BAD entries in ORDER QUICK VIEW file"_$char(9)_"Check4BadOQV"
        set Menu("P")="Prev Stage"_$char(9)_"Prev"
        set Menu("N")="Next Stage"_$char(9)_"Next"
 
M1      write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
 
        if UsrSlct="Sync2OQV" do Sync2OQV goto M1
        if UsrSlct="Check4BadOQV" do Check4BadOQV goto M1
        if UsrSlct="Prev" goto Menu^TMGNDF4C  ;"quit can occur from there...
        if UsrSlct="Next" goto Menu^TMGNDF4F  ;"quit can occur from there...
        if UsrSlct="^" goto MenuDone
        goto M1
 
MenuDone
        quit
 
 
Sync2OQV
        ;"Purpose: To cycle through all items in the ORDERABLE ITEMS (101.43) file and
        ;"         ensure that they have been added to the ORDER QUICK VIEW (101.44) file
        ;"Result: none.
 
        ;"NOTE: This function will KILL prior entries in ORWD O RX record
        ;"      There are no pointers IN to this file, so deleting will not
        ;"      leave dangling pointers.
 
        ;"NOTE: this function must ensure that the drugs are put into 101.44
        ;"      in alphabetical order
        ;"      ALSO, drugs should be added both with their generic and brand names.
 
        ;"Here is an example of drugs that have been added 'properly'
        ;"  1) ^ORD(101.44,16,20,0) = ^101.442PA^20^20
        ;"  2) ^ORD(101.44,16,20,1,0) = 49^AMITRIPTYLINE TAB
        ;"  3) ^ORD(101.44,16,20,2,0) = 53^CHLORPROMAZINE TAB
        ;"  4) ^ORD(101.44,16,20,3,0) = 50^DIGOXIN TAB
        ;"  5) ^ORD(101.44,16,20,4,0) = 44^DILTIAZEM TAB
        ;"  6) ^ORD(101.44,16,20,5,0) = 49^ELAVIL     <AMITRIPTYLINE TAB >
        ;"  7) ^ORD(101.44,16,20,6,0) = 49^ENDEP     <AMITRIPTYLINE TAB >
        ;"  8) ^ORD(101.44,16,20,7,0) = 47^HCTZ     <HYDROCHLOROTHIZIDE TAB >
        ;"  9) ^ORD(101.44,16,20,8,0) = 47^HYDROCHLOROTHIZIDE TAB
        ;" 10) ^ORD(101.44,16,20,9,0) = 50^LANOXIN     <DIGOXIN TAB >
        ;" 11) ^ORD(101.44,16,20,10,0) = 54^LEVOTHYROXINE TAB
        ;" 12) ^ORD(101.44,16,20,11,0) = 54^LEVOXYL     <LEVOTHYROXINE TAB >
        ;" 13) ^ORD(101.44,16,20,12,0) = 46^LISINOPRIL TAB
        ;" 14) ^ORD(101.44,16,20,13,0) = 52^PRAZOSIN CAP,ORAL
        ;" 15) ^ORD(101.44,16,20,14,0) = 46^PRINIVIL     <LISINOPRIL TAB >
        ;" 16) ^ORD(101.44,16,20,15,0) = 48^SILDENAFIL TAB
        ;" 17) ^ORD(101.44,16,20,16,0) = 54^SYNTHROID     <LEVOTHYROXINE TAB >
        ;" 18) ^ORD(101.44,16,20,17,0) = 48^VIAGRA     <SILDENAFIL TAB >
        ;" 19) ^ORD(101.44,16,20,18,0) = 46^ZESTRIL     <LISINOPRIL TAB >
        ;" 20) ^ORD(101.44,16,20,19,0) = 20
        ;"21) ^ORD(101.44,16,20,20,0) = 54
        ;"22) ^ORD(101.44,16,20,"B",20,19) =
        ;"23) ^ORD(101.44,16,20,"B",54,20) =
        ;"24) ^ORD(101.44,16,20,"C","AMITRIPTYLINE TAB ",1) =
        ;"25) ^ORD(101.44,16,20,"C","CHLORPROMAZINE TAB ",2) =
        ;"26) ^ORD(101.44,16,20,"C","DIGOXIN TAB ",3) =
        ;"27) ^ORD(101.44,16,20,"C","DILTIAZEM TAB ",4) =
        ;"28) ^ORD(101.44,16,20,"C","ELAVIL     <AMITRIPTYLINE TAB >",5) =
        ;"29) ^ORD(101.44,16,20,"C","ENDEP     <AMITRIPTYLINE TAB >",6) =
        ;"30) ^ORD(101.44,16,20,"C","HCTZ     <HYDROCHLOROTHIZIDE TAB >",7) =
        ;"31) ^ORD(101.44,16,20,"C","HYDROCHLOROTHIZIDE TAB ",8) =
        ;"32) ^ORD(101.44,16,20,"C","LANOXIN     <DIGOXIN TAB >",9) =
        ;"33) ^ORD(101.44,16,20,"C","LEVOTHYROXINE TAB ",10) =
        ;"34) ^ORD(101.44,16,20,"C","LEVOXYL     <LEVOTHYROXINE TAB >",11) =
        ;"35) ^ORD(101.44,16,20,"C","LISINOPRIL TAB ",12) =
        ;"36) ^ORD(101.44,16,20,"C","PRAZOSIN CAP,ORAL ",13) =
        ;"37) ^ORD(101.44,16,20,"C","PRINIVIL     <LISINOPRIL TAB >",14) =
        ;"38) ^ORD(101.44,16,20,"C","SILDENAFIL TAB ",15) =
        ;"39) ^ORD(101.44,16,20,"C","SYNTHROID     <LEVOTHYROXINE TAB >",16) =
 
        do MakeNewQOVS ;"Get a fresh order set to work in.
 
        set RxSet=$$GetOQVSet^TMGNDFUT
        if RxSet'>0 do  goto AADone
        . write "Can't find record 'ORWDSET O RX' in ORDER QUICK VIEW (101.44) file.",!
        . write "Aborting.",!
 
        ;"Kill all prior display data in ORDER QUICK VIEW file: ORWDSET O RX record
        do KillPrior(RxSet)
 
        new pAddArray set pAddArray=$name(^TMG("TMP","KILL","Add 101.44 Temp"))
        kill @pAddArray
 
        write "Organizing drugs for addition to ORDER QUICK VIEW...",!
        new Itr,IEN22706d9
        new abort set abort=0
        set IEN22706d9=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN22706d9")
        if IEN22706d9'="" for  do  quit:(+$$ItrNext^TMGITR(.Itr,.IEN22706d9)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . if $piece($get(^TMG(22706.9,IEN22706d9,1)),"^",4)=1 quit ;" 1=skip
        . new tIEN101d43,gIEN101d43
        . set tIEN101d43=+$piece($get(^TMG(22706.9,IEN22706d9,8)),"^",5)
        . set gIEN101d43=+$piece($get(^TMG(22706.9,IEN22706d9,8)),"^",6)
        . if tIEN101d43>0 do
        . . new name set name=$piece($get(^ORD(101.43,tIEN101d43,0)),"^",1)
        . . if (name="")!(name="<DUPLICATE>") do KillOI^TMGNDFUT(tIEN101d43) quit
        . . set @pAddArray@(name,tIEN101d43)=""
        . . new SynIEN set SynIEN=0
        . . for  set SynIEN=$order(^ORD(101.43,tIEN101d43,2,SynIEN)) quit:(+SynIEN'>0)  do
        . . . new SynName set SynName=$get(^ORD(101.43,tIEN101d43,2,SynIEN,0))
        . . . set SynName=$$Trim^TMGSTUTL(SynName)
        . . . set SynName=SynName_" <"_name_">"
        . . . set @pAddArray@(SynName,tIEN101d43)=""
        . if gIEN101d43>0 do
        . . new name set name=$piece($get(^ORD(101.43,gIEN101d43,0)),"^",1)
        . . if (name="")!(name="<DUPLICATE>") do KillOI^TMGNDFUT(gIEN101d43) quit
        . . set @pAddArray@(name,gIEN101d43)=""
        . . new SynIEN set SynIEN=0
        . . for  set SynIEN=$order(^ORD(101.43,gIEN101d43,2,SynIEN)) quit:(+SynIEN'>0)  do
        . . . new SynName set SynName=$get(^ORD(101.43,gIEN101d43,2,SynIEN,0))
        . . . set SynName=$$Trim^TMGSTUTL(SynName)
        . . . set SynName=SynName_" <"_name_">"
        . . . set @pAddArray@(SynName,gIEN101d43)=""
        do ProgressDone^TMGITR(.Itr)
        if abort=1 goto AADone
 
        ;"Now add all drugs
        write "Adding drugs to ORDER QUICK VIEW...",!
        new Itr,DispName
        set abort=0
        set DispName=$$ItrAInit^TMGITR(pAddArray,.Itr)
        do PrepProgress^TMGITR(.Itr,20,1,"DispName")
        if DispName'="" for  do  quit:($$ItrANext^TMGITR(.Itr,.DispName)="")!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . new IEN set IEN=$order(@pAddArray@(DispName,""))
        . set pOQV=$$Add(RxSet,IEN,DispName)
        do ProgressDone^TMGITR(.Itr)
 
AADone
        write "Done.",!
        do PressToCont^TMGUSRIF
        quit
 
 
MakeNewQOVS
        ;"Purpose: To save the old QUICK ORDER VIEW set, and create a new one.
        ;"Note: Because the drugs have to be added to the file in alphabetical order,
        ;"      it is required to create a NEW order set.  I will save the old one
        ;"      for future reference.
 
        new DIC,X,Y,%,RxSet
 
        set RxSet=$$GetOQVSet^TMGNDFUT
        if RxSet'>0 do  goto MNQSDone
        . write "Can't find record 'ORWDSET O RX' in ORDER QUICK VIEW (101.44) file.",!
        . write "Aborting.",!
 
        new nowS
        do NOW^%DTC
        S Y=X  ;"% current fileman date returned in X (no time)
        D DD^%DT  ;"convert to external format.
        set nowS=Y
 
        new newName set newName="ORWDSET O RX -- "_nowS
        write "Saving old ORDER QUICK VIEW set as: ",newName,!
        new TMGFDA,TMGMSG,TMGIEN
        set TMGFDA(101.44,RxSet_",",.01)=newName
        do FILE^DIE("K","TMGFDA","TMGMSG")
        do ShowIfDIERR^TMGDEBUG(.TMGMSG)
 
        set TMGFDA(101.44,"+1,",.01)="ORWDSET O RX"
        set TMGFDA(101.44,"+1,",6)="NOW"
        do UPDATE^DIE("EK","TMGFDA","TMGIEN","TMGMSG")
        do ShowIfDIERR^TMGDEBUG(.TMGMSG)
 
MNQSDone
        quit
 
 
Add(RxSet,pOI,RxName)
        ;"Purpose: to add 'name' to ORWDSET O RX record in ORDER QUICK VIEW ('OQV')file
        ;"Input: RxSet -- the record number in OQV to add records to.
        ;"       pOI -- a pointer to (i.e. the IEN of) record in ORDERABLE ITEM (101.43) file
        ;"       RxName -- The name to display in CPRS
        ;"Results: returns the IEN of the new record.
 
        new TMGFDA,TMGMSG,TMGIEN,PriorErrorFound
        new result set result=0
 
        if pOI=0 do  goto AdDone
        . write !,"Skipping addition of ",RxName," because it doesn't",!
        . write "seem linked to a PHARMACY ORDERABLE ITEM.",!
        set TMGFDA(101.442,"+1,"_RxSet_",",.01)=pOI
        set TMGFDA(101.442,"+1,"_RxSet_",",2)=RxName
 
        new $etrap set $etrap="write !,""ERROR TRAPPED."",! quit"
Ad1     do UPDATE^DIE("S","TMGFDA","TMGIEN","TMGMSG")
        if $$ShowIfError^TMGDBAPI(.TMGMSG,.PriorErrorFound) goto AdDone
        set result=+$get(TMGIEN(1))
 
AdDone
        quit result
 
 
KillPrior(RxSet)
        ;"Purpose: To kill ALL records in the RxSet in 101.44
        ;"Note: I am fairly certain that no other files point to this file
        ;"      (there are no pointers IN).  So I can just kill.
        ;"      CAUTION: this might not be the right thing to do in another system.
 
        new temp merge temp=^ORD(101.44,RxSet,20,0)
        kill ^ORD(101.44,RxSet,20)
        merge ^ORD(101.44,RxSet,20,0)=temp
        set $piece(^ORD(101.44,RxSet,20,0),"^",3)=0 ;"most recently assigned IEN
        set $piece(^ORD(101.44,RxSet,20,0),"^",4)=0 ;"current total number of records
 
        quit
 
 
 ;"==============================
Fix1OQV(IEN101d43,Option)
        ;"Purpose: to alter one entry in OQV file to reflect changes
        ;"         in ORDERABLE ITEM file (101.43)
        ;"Input: IEN101d43 -- IEN in ORDERABLE ITEM file (101.43)
        ;"       Option -- OPTIONAL. Format:
        ;"                  Option("FIX CHAIN")=1  <--- changes will be propigate forward
        ;"                   to file POI, OI, OQV etc.
        ;"                  OPTION("FIX CHAIN","IEN22706d9")=Source IEN
        ;"                  Option("QUIET")=1 <-- supress text output
        ;"                  Option("IEN50","TRADE")=IEN50 for Trade Name
        ;"                  Option("IEN50","GENERIC")=IEN50 for Generic Name
        ;"                  Option("DRUG NAME AND FORM","TRADE")=tradeNameAF
        ;"                  Option("DRUG NAME AND FORM","GENERIC")=genericNameAF
        ;"                  Option("IEN50.7","TRADE")=IEN50d7
        ;"                  Option("IEN50.7","GENERIC")=IEN50d7
        ;"                  Option("IEN101.43","TRADE")=IEN101d43
        ;"                  Option("IEN101.43","GENERIC")=IEN101d43
        ;"                  Option("DELETING")=1 <-- deleting chain (not IEN22706d9)
        ;"NOTE: The entries in the OQV file have to be set up in ALPHABETICAL order.
        ;"      This function will NOT reorder these.  If name is completely changed, then
        ;"      it will likely appear out of alphabetical order.  This may hinder finding it.
        ;"      -- Such a problem could be fixed by runnin: Sync2OQV^TMGNDF4E
        ;"Result: 1 if error, 0 if OK.
 
        new result set result=0
        new RxSet,quiet
        set quiet=$get(Option("QUIET"))=1
        set RxSet=$$GetOQVSet^TMGNDFUT(quiet)
        if RxSet=0 goto F1OQVDone
 
        new OQVIENS set OQVIENS=$$GetOQVIENS^TMGNDFUT(IEN101d43,RxSet)
        if OQVIENS=0 do   goto F1OQVDone
        . if quiet quit
        . write "Can't find link ORDERABLE ITEM--> ORDER QUICK VIEW (OQV).",!
        . write "Try do a batch add of imports into OQV.",!
        . write "Can't insert OQV with out reordering...",!
 
        new drugName set drugName=$piece($get(^ORD(101.43,IEN101d43,0)),"^",1)
        if ($get(Option("DELETING"))=1)!(drugName="") set drugName="<DELETED>"
 
        new TMGFDA,TMGMSG
        set TMGFDA(101.442,OQVIENS,2)=drugName
        new temp set temp=$$TrimFDA^TMGDBAPI(.TMGFDA)
        if $data(TMGFDA) do
        . do FILE^DIE("KS","TMGFDA","TMGMSG")
        . set result=$$ShowIfError^TMGDBAPI(.TMGMSG)  ;"show FM errors, even if quiet.
 
F1OQVDone
        quit result
 
 
Check4BadOQV
        ;"Purpose: Scan through all ORDER QUICK VIEWS and see if any are pointing
        ;"         to bad records
 
        new RxSet set RxSet=$$GetOQVSet^TMGNDFUT
        if RxSet=0 goto C4BOQVDone
        new totalCt set totalCt=0
        new count set count=0
 
        new index set index=0
        for  set index=$order(^ORD(101.44,RxSet,20,index)) quit:(+index'>0)  do
        . set totalCt=totalCt+1
        . new s set s=$get(^ORD(101.44,RxSet,20,index,0))
        . new ptr set ptr=+s
        . if ptr=0 quit
        . new name set name=$piece(s,"^",2)
        . if $piece($get(^ORD(101.43,ptr,0)),"^",1)'="" quit
        . write !,"BAD: ",name,!
        . write "OQV 101.44:#",index,",",RxSet,",  --> OI 101.43:#",ptr," which is empty",!
        . do KillOQV^TMGNDFUT(index_","_RxSet_",")
        . write "  ... deleted.",!
        . set count=count+1
 
        write !,totalCt," entries scanned.",!
        write count," bad entries found.",!
        do PressToCont^TMGUSRIF
 
C4BOQVDone
        quit
 
