TMGRPC1A ;TMG/kst-RPC Functions ;2/11/10, 6/19/10
         ;;1.0;TMG-LIB;**1**;2/11/10
 ;
 ;"TMG RPC FUNCTIONS
 ;
 ;"Copyright Kevin Toppenberg MD
 ;"Released under GNU General Public License (GPL)
 ;"
 ;"=======================================================================
 ;" RPC -- Public Functions.
 ;"=======================================================================
 ;"SETINIVL(RESULT,SECTION,KEY,VALUE) ;Entry point for TMG INIFILE SET
 ;"GETINIVL(RESULT,SECTION,KEY,DEFAULT) ;Entry point for TMG INIFILE GET
 ;
 ;"=======================================================================
 ;"PRIVATE API FUNCTIONS
 ;"=======================================================================
 ;
 ;"=======================================================================
 ;"=======================================================================
 ;"Dependencies:
 ;" DIC, TMGDEBUG
 ;"=======================================================================
 ;"=======================================================================
 ;
SETINIVL(RESULT,SECTION,KEY,VALUE) ;
        ;"SCOPE: Public
        ;"RPC that calls this: TMG INIFILE SET
        ;"Purpose: To provide an entry point for a RPC call from a client.  The client
        ;"         will use this instead of TIniFile object in Delphi.
        ;"         Note: Since all data are of type string in Mumps, this will work only with strings.
        ;"               and type casting will have to take place in client.
        ;"Input: RESULT  -- an OUT PARAMETER.  See output below.
        ;"       SECTION -- String of 'Section' to store setting in (corresponds to section in TIniFile)
        ;"       KEY     -- String of Key value.  (corresponds to Ident/Key in TIniFile)
        ;"       VALUE   -- String of Value to set
        ;"Note: Because this is a shared resource, it is expected that the client will use
        ;"      User.Name as the Section value.
        ;"      Also, any prior value will be overwritten.
        ;"Output: Will return RESULT="1^Success", or -1^Error Message"
        SET RESULT="1^Success"
        IF $GET(SECTION)="" SET RESULT="-1^No value passed for SECTION" QUIT
        IF $GET(KEY)="" SET RESULT="-1^No value passed for KEY" QUIT
        SET VALUE=$GET(VALUE)
        NEW X,Y,DIC,IEN,IEN2
        SET DIC=22710,DIC(0)="LM" ;"Find SECTION if previously added.
        SET X=SECTION
        DO ^DIC SET IEN=+Y
        IF IEN'>0 DO  ;"For some reason LAYGO doesn't work when called by RPC
        . NEW TMGFDA,TMGIEN,TMGMSG
        . SET TMGFDA(22710,"+1,",.01)=SECTION
        . DO UPDATE^DIE("E","TMGFDA","TMGIEN","TMGMSG")
        . IF $DATA(TMGMSG("DIERR")) DO  QUIT
        . . SET RESULT="-1^"_$$GetErrStr^TMGDEBUG(.TMGMSG)
        . SET IEN=+$GET(TMGIEN(1))
        IF +RESULT=-1 GOTO SIDN
        IF IEN'>0 SET RESULT="-1^Error establishing SECTION: ["_SECTION_"]" QUIT
        SET DA(1)=IEN,DIC(0)="LM",DIC="^TMG(22710,"_IEN_",1,"
        SET X=KEY
        DO ^DIC SET IEN2=+Y
        IF IEN2'>0 DO  ;"For some reason LAYGO sometimes doesn't work when called by RPC
        . NEW TMGFDA,TMGIEN,TMGMSG
        . SET TMGFDA(22710.01,"+1,"_IEN_",",.01)=KEY
        . DO UPDATE^DIE("E","TMGFDA","TMGIEN","TMGMSG")
        . IF $DATA(TMGMSG("DIERR")) DO  QUIT
        . . SET RESULT="-1^"_$$GetErrStr^TMGDEBUG(.TMGMSG)
        . SET IEN2=+$GET(TMGIEN(1))
        IF +RESULT=-1 GOTO SIDN
        IF IEN2'>0 SET RESULT="-1^Error establishing KEY: ["_KEY_"]" QUIT
        NEW TMGFDA,TMGMSG
        IF VALUE="" SET VALUE="@"
        SET TMGFDA(22710.01,IEN2_","_IEN_",",1)=VALUE
        DO FILE^DIE("E","TMGFDA","TMGMSG")
        IF $DATA(TMGMSG("DIERR")) DO  GOTO SIDN
        . SET RESULT="-1^"_$$GetErrStr^TMGDEBUG(.TMGMSG)
SIDN    QUIT
 ;
 ;
GETINIVL(RESULT,SECTION,KEY,DEFAULT) ;
        ;"SCOPE: Public
        ;"RPC that calls this: TMG INIFILE GET
        ;"Purpose: To provide an entry point for a RPC call from a client.  The client
        ;"         will use this instead of TIniFile object in Delphi.
        ;"         Note: Since all data are of type string in Mumps, this will work only with strings.
        ;"               and type casting will have to take place in client.
        ;"Input: RESULT  -- an OUT PARAMETER.  See output below.
        ;"       SECTION -- String of 'Section' to store setting in (corresponds to section in TIniFile)
        ;"       KEY     -- String of Key value.  (corresponds to Ident/Key in TIniFile)
        ;"       DEFAULT -- The value to be returned, if no value found.
        ;"Note: Because this is a shared resource, it is expected that the client will use
        ;"      User.Name as the Section value.
        ;"      Also, any prior value will be overwritten.
        ;"Output: Will return RESULT="1^<Value>", or -1^Error Message"
        IF $GET(SECTION)="" SET RESULT="-1^No value passed for SECTION" QUIT
        IF $GET(KEY)="" SET RESULT="-1^No value passed for KEY" QUIT
        SET DEFAULT=$GET(DEFAULT)
        NEW X,Y,DIC,IEN,IEN2
        SET DIC=22710,X=SECTION
        DO ^DIC SET IEN=+Y
        IF IEN'>0 SET RESULT="1^"_DEFAULT QUIT
        SET DA(1)=IEN,DIC="^TMG(22710,"_IEN_",1,"
        SET X=KEY
        DO ^DIC SET IEN2=+Y
        IF IEN2'>0 SET RESULT="1^"_DEFAULT QUIT
        NEW VALUE SET VALUE=$GET(^TMG(22710,IEN,1,IEN2,1),DEFAULT)
        IF VALUE'=DEFAULT SET VALUE=$PIECE(VALUE,"^",1)
        SET RESULT="1^"_VALUE
        QUIT
 ;
 ;
CONVERT
        ;"Purpose: A temp function to convert between the old storage method and the new.
        ;"Data was stored in: ^TMG("INIDATA",Section,Key,Vaue)
        NEW SECTION,KEY,VALUE
        SET SECTION=""
        FOR  SET SECTION=$ORDER(^TMG("INIDATA",SECTION)) QUIT:(SECTION="")  DO
        . SET KEY=""
        . FOR  SET KEY=$ORDER(^TMG("INIDATA",SECTION,KEY)) QUIT:(KEY="")  DO
        . . SET VALUE=$GET(^TMG("INIDATA",SECTION,KEY))
        . . NEW RESULT
        . . DO SETINIVL(.RESULT,SECTION,KEY,VALUE) ;
        . . IF +RESULT>0 KILL ^TMG("INIDATA",SECTION,KEY) QUIT
        . . WRITE "Error trying to store SECTION=",SECTION,"; KEY=",KEY,"; VALUE=",VALUE,!
        . . WRITE " -- ",$PIECE(RESULT,"^",2),!
        QUIT
;
;
INSTALL ;
        ;"Purpose: to add the RPC's to the OPTION record OR CPRS GUI CHART
        NEW DIC,X,Y,DA
        SET DIC="^DIC(19,",DIC(0)="M"
        SET X="OR CPRS GUI CHART"
        DO ^DIC
        IF +Y'>0 DO  QUIT
        . WRITE "ERROR.  Unable to find [OR CPRS GUI CHART] in file OPTION (#19)",!
        . NEW TEMP READ "Press [ENTER] to continue...",TEMP:($GET(DTIME,3600))
        . WRITE !
        SET DA(1)=+Y
        SET DIC=DIC_DA(1)_",""RPC"","
        SET DIC(0)="ML" ;"LAYGO --> add entry if not found
        SET X="TMG INIFILE GET"
        DO ^DIC
        IF +Y'>0 DO
        . WRITE "ERROR.  Unable to add or find TMG INIFILE GET for subfile RPC in record",!
        . WRITE "OR CPRS GUI CHART in file OPTION (#19)",!
        . NEW TEMP READ "Press [ENTER] to continue...",TEMP:($GET(DTIME,3600))
        . WRITE !
        SET X="TMG INIFILE SET"
        DO ^DIC
        IF +Y'>0 DO
        . WRITE "ERROR.  Unable to add or find TMG INIFILE SET for subfile RPC in record",!
        . WRITE "OR CPRS GUI CHART in file OPTION (#19)",!
        . NEW TEMP READ "Press [ENTER] to continue...",TEMP:($GET(DTIME,3600))
        . WRITE !
        QUIT
 ;