TMGSEQL2 ;TMG/kst/Interface with SequelSystems PMS (Error Hndlng) ;03/25/06
         ;;1.0;TMG-LIB;**1**;01/09/06
 
 ;"TMG SEQUEL IMPORT ERROR-HANDLING FUNCTIONS
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"1-9-2006
 
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"AlertError(OneLine,.PtInfo,.OneErrArray,DUZ)
 ;"HANDLE
 
 
 ;"=======================================================================
 ;"PRIVATE API FUNCTIONS
 ;"=======================================================================
 ;"EditOneLine(LineIn,LineOut)
 ;"MakeErrAlert(IEN,User,PtInfo)
 ;"$$StoreError(OneLine,PtInfo,ErrArray)
 ;"ErrRefile(OneLine,PtInfo,OneErrArray,DUZ)
 
 ;"$$FixRegProblem(PtInfo,OneLine,DelError)
 ;"$$FixGenProblem(PtInfo,ErrMsg,OneLine,ErrIEN,DelError)
 ;"$$FixSSNProblem(PtInfo,ErrMsg,OneLine,DelError)
 ;"$$FixDOBProblem(.PtInfo,ErrMsg,.OneLine,.DelError)
 
 ;"$$GetSex(Name)
 ;"$$SetSex(Name,Sex)
 ;"$$NameError(OneErrArray)
 
 ;"$$IsMissingSex(ErrArray)
 ;"$$GetSexMissing(PtInfo)
 
 ;"=======================================================================
 ;"DEPENDENCIES
 ;"TMGSEQL1
 ;"TMGSTUTL
 ;"TMGDEBUG
 ;"=======================================================================
 ;"=======================================================================
 
 
EditOneLine(LineIn,LineOut)
        ;"Purpose: To allow modification of a line to allow filing.
        ;"Input: LineIn -- The CSV line to modify.
        ;"       LineOut -- PASS BY REFERENCE, the variable to receive changes
        ;"Result: 1 if changes made, 0 if no changes made, -1 if abort
 
        new tempArray
        new done set done=0
        new abort set abort=0
        set LineOut=$get(LineIn)
        new SavedInput set SavedInput=LineIn
        new result set result=0
        new temp
 
        if $get(LineIn)="" do  goto EOLDone
        . write !,"?? No data supplied to edit!",!
 
        for  do  quit:(done)!(abort)
        . write !,"CSV Line Editor:",!
        . write "------------------",!
        . write "1. Show raw CSV line data.",!
        . write "2. Show resulting parsed array from data.",!
        . write "3. Modify a specified piece (part) of data.",!
        . write "4. Display number of pieces, and current values.",!
        . write "5. Quit.",!
        . write "^. Abort changes.",!
        . read !,"Enter Choice:  ^// ",temp:$get(DTIME,3600),!
        . if temp="" set temp="^"
        . if temp=1 do
        . . write OneLine,!
        . else  if temp=2 do
        . . new Array,prsResult
        . . set prsResult=$$ParseLine^TMGSEQL1(LineOut,.Array)
        . . if prsResult'=0 do ArrayDump^TMGDEBUG("Array")
        . . ;"else  if prsResult=0 write "There was either a problem parsing this info",!
        . . ;"else  if prsResult-1 write "This patient is inactive, and should be ignored",!
        . else  if temp=3 do
        . . new P,value
        . . write "Which piece do you want to edit?  (i.e. 1 for first CSV value, 2 for the second etc.)",!
        . . read "Which piece?: ",P:$get(DTIME,3600),!
        . . if P="^" set abort=1 quit
        . . if +P=0 write "Please enter a numeric value.",! quit
        . . write "The current value for this piece is: ",$piece(LineOut,",",P),!
        . . read "Enter new value (^ to abort): ",value,!
        . . if value="^" quit
        . . set $piece(LineOut,",",P)=value
        . . set result=1
        . else  if temp=4 do
        . . new i for i=1:1:20 do
        . . . write "Piece #",i," = ",$piece(LineOut,",",i),!
        . else  if temp=5 do
        . . set done=1
        . else  if temp="^" do
        . . set abort=1
        . else  do  quit
        . . write "Please enter a valid choice, or ^ to abort.",!
 
 
EOLDone
        if abort do
        . set result=-1
        . set LineOut=SavedInput
 
        quit result
 
 
AlertError(OneLine,PtInfo,OneErrArray,DUZ)
        ;"Purpose: To put the error information info into TMG DEMOGRAPHICS IMPORT ERRORS (22706)
        ;"         and to create a corresponding alert
        ;"Input: OneLine -- The original CVS format data line
        ;"       PtInfo -- PASS BY REFERENCE.  an array containing patient info, as created by ParseLine()
        ;"       ErrArray -- PASS BY REFERENCE.  The Array containing the error information,
        ;"          with following format:
        ;"          ErrArray(0)=local message (if any)
        ;"          ErrArray("DIERR")=Standard fileman DIERR array.
        ;"       User -- the IEN in file 200 (i.e. DUZ) of user to receive alert.
        ;"Output: new record is created in file 22706
        ;"Result: none
 
        new IEN,Msg
        set IEN=$$StoreError^TMGSEQL2(OneLine,.PtInfo,.OneErrArray)
        set Msg=$get(OneErrArray(0),"Problem with upload of Sequel data for:")
        set Msg=$piece(Msg,":",1)
        set Msg=Msg_" "_$get(PtInfo("FULL NAME"))
        do MakeErrAlert^TMGSEQL2(IEN,DUZ,Msg)
 
        quit
 
 
StoreError(OneLine,PtInfo,ErrArray)
        ;"Purpose: To put the error information info into TMG DEMOGRAPHICS IMPORT ERRORS (22706)
        ;"Input: OneLine -- The original CVS format data line
        ;"       PtInfo -- PASS BY REFERENCE.  an array containing patient info, as created by ParseLine()
        ;"       ErrArray -- PASS BY REFERENCE.  The Array containing the error information,
        ;"          with following format:
        ;"          ErrArray(0)=local message (if any)
        ;"          ErrArray("DIERR")=Standard fileman DIERR array.
        ;"Output: new record is created in file 22706
        ;"Result: IEN of newly created record (or 0 if error).
 
        new result set result=0
        new TMGFDA,Name
        set Name=$get(PtInfo("FULL NAME3"))
        set Msg=$get(ErrArray(0))
 
        set TMGFDA(22706,"+1,",.01)=$get(PtInfo("SEQUEL ACCOUNT NUM"))   ;".01=ACCOUNT NUMBER
        set TMGFDA(22706,"+1,",.02)="NOW"                                ;".02=CREATION DATE
        set TMGFDA(22706,"+1,",.03)=Name                                 ;".03=PATIENT NAME
        if Msg'="" set TMGFDA(22706,"+1,",1)=Msg                         ;"1=MESSAGE
        new TMGIENA,TMGERR
        do UPDATE^DIE("E","TMGFDA","TMGIENA","TMGERR")
        new IEN set IEN=$get(TMGIENA(1))
 
        new TMGWP
        new TMGDIERR merge TMGDIERR("DIERR")=ErrArray("DIERR")
        new ErrStr set ErrStr=$$GetErrStr^TMGDEBUG(.TMGDIERR)
        if ErrStr'="" do
        . do StrToWP^TMGSTUTL(ErrStr,"TMGWP",60," ")
        . if +IEN>0 do
        . . do WP^DIE(22706,IEN_",",3,,"TMGWP","TMGERR")                          ;"3=DIERR MESSAGE
        . . new PriorErrorFound set PriorErrorFound=0
        . . if $data(TMGERR("DIERR")) do ShowDIERR^TMGDEBUG(.TMGERR,.PriorErrorFound)
 
        kill TMGWP
        do StrToWP^TMGSTUTL(OneLine,"TMGWP",60,",")
        if +IEN>0 do
        . do WP^DIE(22706,IEN_",",2,,"TMGWP","TMGERR")                          ;"2=IMPORT DATA
        . new PriorErrorFound set PriorErrorFound=0
        . if $data(TMGERR("DIERR")) do ShowDIERR^TMGDEBUG(.TMGERR,.PriorErrorFound)
 
        set result=IEN
 
        quit result
 
 
MakeErrAlert(IEN,User,Message)
        ;"Purpose: To create an alert regarding upload error
        ;"Input: IEN -- The IEN of the error, stored in file 22706
        ;"       User -- the IEN in file 200 (i.e. DUZ) of user to receive alert.
        ;"       Message -- the Message of the alert
        ;"Output: An alert will be created in send to User
        ;"Result: none
 
        new XQA,XQAMSG,XQAID
        new XQAOPT ;" ensure no residual menu option specified
 
        set XQA(User)=""
        set XQAMSG=Message
        set XQAID="TMGSQLIMPORT"
        set XQADATA=IEN
        set XQAROU="HANDLE^TMGSEQL2"
 
        do SETUP^XQALERT
 
        quit
 
ErrRefile(OneLine,PtInfo,OneErrArray,DUZ)
        ;"Purpose: A common point to process errors encountering errors on refilling
        ;"Input: OneLine -- the originial CSV data line.
        ;"       PtInfo -- PASS BY REFERENCE -- the Patient Info array, as created by ParseLine^TMGSEQL1
        ;"       OneErrArray -- PASS BY REFERENCE -- The error array encountered, returned from Fileman
        ;"       DUZ -- the user IEN (from file 2) to recieve alert
        ;"Output: A new alert will be created, and messages written to screen
        ;"Result : none
 
        write "There is still an error:",!
        zwr OneErrArray(*)
        write "A new alert will be made to handle this new error.",!
        set OneErrArray(0)=$$NameError(.OneErrArray)
        write OneErrArray(0),!
        do AlertError^TMGSEQL2(.OneLine,.PtInfo,.OneErrArray,DUZ)
 
        quit
 
HANDLE
        ;"Purpose: This is called by the alert system to handle the error alert
        ;"Input: All the inputs are via variables with global scope.  Details below
        ;"       XQADATA-- the IEN in file 22706
        ;"       XQAKILL-- 1 --> kill when done.  To alter behavior, this function can change
        ;"              (to prevent deletion when done, then KILL XQAKILL)
        ;"Output: Allows user to edit data and reattempt filing of data
        ;"Result: none.
 
 
        new Fixed set Fixed=0
 
        new OneLine,PtInfo
        new TMGWP,TMGMSG
        new tempResult
        new ErrIEN
        new DelError set DelError=0
 
        if $get(XQADATA)'>0 do  goto HndDone
        . write !!,"No value in XQADATA, so quitting.",!
        . write "(Deleting alert.)",!
        . set Fixed=1,DelError=1
        set ErrIEN=XQADATA
 
        write !!,"Problem with upload of Sequel data.  ",!
 
        ;"temp
        write "IEN in file# 22706=",ErrIEN,!
 
        new x set x=$$GET1^DIQ(22706,ErrIEN_",",2,"","TMGWP","TMGMSG")
        if $data(TMGMSG("DIERR"))'=0 do  goto HndDone
        . new PriorErrorFound
        . do ShowDIERR^TMGDEBUG(.TMGMSG,.PriorErrorFound)
        . set Fixed=1,DelError=1
        set OneLine=$$WPToStr^TMGSTUTL("TMGWP","")
        if $$ParseLine^TMGSEQL1(OneLine,.PtInfo)=0 do  goto HndDone
        . write "Error parsing Alert data into patient data.",!
        write $get(PtInfo("FULL NAME")),!
 
        new ErrMsg set ErrMsg=$$GET1^DIQ(22706,ErrIEN_",",1)
        write ErrMsg,!
 
        kill TMGWP,TMGMSG
        new x set x=$$GET1^DIQ(22706,ErrIEN_",",3,"","TMGWP","TMGMSG")
        if $data(TMGMSG("DIERR"))'=0 do  goto HndDone
        . new PriorErrorFound
        . do ShowDIERR^TMGDEBUG(.TMGMsg,.PriorErrorFound)
        . set Fixed=1,DelError=1
        if $data(TMGWP) do
        . do WriteWP^TMGSTUTL("TMGWP")
 
        if ErrMsg["PATIENT NOT IN DATABASE" do
        . set Fixed=$$FixRegProblem(.PtInfo,.OneLine,.DelError)
        else  if ErrMsg["INVALID/MISSING GENDER" do
        . set Fixed=$$FixRegProblem(.PtInfo,.OneLine,.DelError)
        else  if ErrMsg["CONFLICTING SS-NUMBERS" do
        . set Fixed=$$FixSSNProblem(.PtInfo,ErrMsg,.OneLine,.DelError)
        else  if ErrMsg["INVALID DOB ERROR" do
        . write "Date of birth (DOB) is incorrect for this patient.",!
        . write "Note:  The recommended method of correcting this problem is",!
        . write "       to fix the problem in Sequel, not here.  Otherwise",!
        . write "       the same error will be encountered with each demographics",!
        . write "       upload.",!!
        . set Fixed=$$FixGenProblem(.PtInfo,ErrMsg,.OneLine,.DelError)
        else  do
        . set Fixed=$$FixGenProblem(.PtInfo,ErrMsg,.OneLine,.DelError,ErrIEN)
 
        if DelError=1 do
        . new temp,ErrArray
        . set temp=$$DelIEN^TMGDBAPI(22706,ErrIEN,.ErrArray) ;"success, so kill error entry in 22706
 
HndDone
        ;"if Fixed=1 write !,"SUCCESS!"
 
        if (Fixed=0)!(DelError=0) do     ;"<------------- this logic may be off...
        . kill XQAKILL ;"--> don't delete alert
        . write "(Saving alert...)",!
 
        quit
 
 
FixRegProblem(PtInfo,OneLine,DelError)
        ;"Purpose: To fix problems where patient couldn't be added to the database
        ;"Input: PtInfo -- PASS BY REFERENCE -- the Patient Info array, as created by ParseLine^TMGSEQL1
        ;"       OneLine -- the originial CSV data line.  Passed to this function in case a new Alert
        ;"                  must be created, in which case it is stored in the new error message.
        ;"       DelError -- and OUT parameter.  Set to 1 will signal the deletion of the error
        ;"              record in file 22706
        ;"Output: Patient may be added to FILE 2, or file updated.  If succesfull, record of error
        ;"      in file 22706 will deleted
        ;"Result: 1=problem fixed, 0=not fixed.
 
        new Fixed set Fixed=0
        set DelError=0
        new TMGRemSex,InitRemSex
        set TMGRemSex=+$$GET1^DIQ(22711,"1,","PICK GENDER FROM NAME?","I")
        set InitRemSex=TMGRemSex
 
        new AutoRegister set AutoRegister=1  ;"automatically add patient to database if not found
        new OneErrArray,ChgLog
        new done set done=0
        for  do  quit:(done=1)
        . kill OneErrArray,ChgLog
        . new tempResult
        . set tempResult=$$UpdateDB^TMGSEQL1(.PtInfo,AutoRegister,.OneErrArray,.ChgLog) ;"0=error
        . set DelError=1
        . set Fixed=1
        . set done=1
        . if tempResult=0 do
        . . if $$IsMissingSex(.OneErrArray)=1 do
        . . . if $$GetSexMissing(.PtInfo,.TMGRemSex)=0 do
        . . . . set done=1  ;"0=failed
        . . . . set Fixed=0
        . . else  do
        . . . write "There is still an error:",!
        . . . ;"zwr OneErrArray(*)
        . . . write "A new alert will be made to handle this new error.",!
        . . . do ErrRefile(.OneLine,.PtInfo,.OneErrArray,DUZ)
        . . . ;"set OneErrArray(0)=$$NameError(.OneErrArray)
        . . . ;"write OneErrArray(0),!
        . . . ;"do AlertError^TMGSEQL2(.OneLine,.PtInfo,.OneErrArray,DUZ)
 
        if TMGRemSex'=InitRemSex do   ;"if status of auto-pick gender was changed in GetSexMissing, store in settings.
        . new TMGFDA,TMGMSG
        . set TMGFDA(22711,"1,",6)=TMGRemSex ;"field# 6='PICK GENDER FROM NAME?'
        . do FILE^DIE("E","TMGFDA","TMGMSG")  ;"note TMGMSG is ignored here...
 
        quit Fixed
 
IsMissingSex(ErrArray)
        ;"Purpose: To analyze a Fileman error array and see if field .02 (SEX) is missing, causing problem
        ;"Input: ErrArray -- PASS BY REFERENCE, an error message, as created by Fileman while adding patient.
        ;"Result: 1=missing sex (.02 field), other 0
        ;"Note: this only reviews error #1 (ignores other errors, if present.  So, if missing sex error
        ;"      was in position #2, this function WOULD RETURN AN ERRORONEOUS ANSWER.
 
        new result set result=0
 
        if $data(ErrArray("DIERR","E",311,1)) do  ;"311=The record lacks some required identifiers.
        . if $get(ErrArray("DIERR",1,"PARAM","FIELD"))'=.02 quit
        . if $get(ErrArray("DIERR",1,"PARAM","FILE"))'=2 quit
        . set result=1
 
        quit result
 
 
 
 
GetSexMissing(PtInfo,TMGRemSex)
        ;"Purpose: To correct the PtInfo Array so that SEX is supplied answer.
        ;"Input: PtInfo -- PASS BY REFERENCE -- the Patient Info array, as created by ParseLine^TMGSEQL1
        ;"       TMGRemSex --PASS BY REFERENCE -- 1 if OK to automatically pick sex based on gender of name
        ;"Output: PtInfo should be filled with SEX of patient
        ;"Result: 1=OK to continue, 0=failed to get SEX
 
        new result set result=0  ;"default to failure
        new temp set temp=""
        new Abort set Abort=0
 
        if $get(PtInfo("SEX"))'="" set result=1 goto GSMDone
        if $get(PtInfo("FULL NAME"))="" goto GSMDone
        new FName set FName=$get(PtInfo("FIRST NAME"))
        if FName="" goto GSMDone
 
        for  do  quit:(temp'="")!(Abort=1)
        . new presumedSex,RemName
        . set CurrentSex=""
        . set TMGRemSex=$get(TMGRemSex,0)
        . write "Trying to determine the SEX of: ",PtInfo("FULL NAME"),!!
        . write "OPTIONS:",!
        . write "-----------------",!
        . write "M  or MALE    --> Name is MALE",!
        . write "M! or MALE!   --> ALWAYS consider this name as MALE",!
        . write "F  or FEMALE  --> Name is FEMALE",!
        . write "F! or FEMALE! --> ALWAYS consider this name as FEMALE",!
        . write "AUTO          --> Turn auto-pick-gender: ",$select(TMGRemSex=1:"OFF",1:"ON"),!
        . write "^   Abort",!
        . set presumedSex=$$GetSex(FName)
        . write "Is ",FName," MALE or FEMALE? ",presumedSex,"//"
        . if (TMGRemSex=1)&(presumedSex'="") set temp=presumedSex
        . else  read temp:$get(DTIME,3600)
        . if temp="" set temp=presumedSex
        . set RemName=(temp["!")
        . set temp=$translate(temp,"!","")
        . set temp=$$UP^XLFSTR(temp)
        . if (temp="M")!(temp="MALE") set CurrentSex="MALE"
        . else  if (temp="F")!(temp="FEMALE") set CurrentSex="FEMALE"
        . else  if temp="^" do  quit
        . . write "aborting..",!
        . . set Abort=1
        . else  if temp="AUTO" do
        . . set TMGRemSex='(TMGRemSex)
        . if CurrentSex'="" do  quit
        . . write "  ",CurrentSex,!
        . . set PtInfo("SEX")=CurrentSex
        . . set result=1
        . . if RemName do
        . . . new temp set temp=$$SetSex(FName,CurrentSex)
        . set temp="" ;" a signal to try again.
 
GSMDone
        quit result
 
 
FixSSNProblem(PtInfo,ErrMsg,OneLine,DelError)
        ;"Purpose: To fix problems of conflicting SS numbers
        ;"Input: PtInfo -- PASS BY REFERENCE -- the Patient Info array, as created by ParseLine^TMGSEQL1
        ;"       ErrMsg -- the message that holds the conflicting SSNums
        ;"       OneLine -- the originial CSV data line.  Passed to this function in case a new Alert
        ;"                  must be created, in which case it is stored in the new error message.
        ;"       DelError -- and OUT parameter.  Set to 1 will signal the deletion of the error
        ;"              record in file 22706
        ;"Output: Patient may be added to FILE 2, or file updated.  If succesfull, record of error
        ;"      in file 22706 will deleted
        ;"Result: 1=problem fixed, 0=not fixed.
 
        new sqSSNum,vSSNum
        new Fixed set Fixed=0
        new done set done=0
        set DelError=0
 
        if $get(ErrMsg)="" goto FSNPDone
 
        if ErrMsg["(Sequel#)" do  ;"old format
        . set sqSSN=$piece(ErrMsg,"SS-NUMBERS: ",2)
        . set sqSSN=$piece(sqSSN," ",1)
        . set vSSN=$piece(ErrMsg,"vs. ",2)
        . set vSSN=$piece(vSSN," ",1)
        else  do
        . set sqSSN=$piece(ErrMsg,"Sequel#=",2)
        . set sqSSN=$piece(sqSSN," ",1)
        . set vSSN=$piece(ErrMsg,"VistA#=",2)
        . set vSSN=$piece(vSSN," ",1)
 
        new vFullName
        do  ;"get actual full name & DOB for VistA SSN
        . new vName,vDOB
        . new tempDFN set tempDFN=$$SSNumLookup^TMGGDFN(vSSN)
        . new TMGMSG,TMGERR,IENS
        . set IENS=+tempDFN_","
        . do GETS^DIQ(2,IENS,".01;.03","E","TMGMSG","TMGERR")
        . if $data(TMGERR("DIERR")) do
        . . new PriorErrorFound
        . . do ShowDIERR^TMGDEBUG(.TMGMSG,.PriorErrorFound)
        . set vName=$get(TMGMSG(2,IENS,.01,"E"))
        . set vDOB=$get(TMGMSG(2,IENS,.03,"E"))
        . set vFullName=vName_" ("_vDOB_")"
 
        write !
 
        for  do  quit:(done=1)
        . write "There is a conflict between Social Security Numbers (SSN):",!
        . write "1.  ",sqSSN," is the Sequel SSN for: ",$get(PtInfo("FULL NAME2")),!
        . write "2.  ",vSSN," is the VistA SSN for:  ",$get(vFullName),!
        . write "3.  (Don't change either one, but remove alert)",!
        . write !,"Which SSN is correct? (1, 2, 3, or ^ to abort)? // "
        . new temp read temp:$get(DTIME,3600),!
        . if temp="^" set done=1 quit  ;"quit, error unfixed.
        . if temp=3 do  quit  ;"keep both
        . . write "OK, no data changes made.  Will delete alert.",!
        . . set Fixed=1,done=1
        . if temp=2 do  quit  ;"keep VistA, advice manual fix in Sequel database, delete alert.
        . . write "OK.  Please manually alter the SSN in the Sequel Database.  This should then be",!
        . . write "reflected in the next demographic data upload cycle.",!
        . . set Fixed=1 ;"This will signal the deletion of the alert
        . . set done=1
        . if temp=1 do  ;"keep Sequel, delete VistA SSN
        . . set done=1
        . . set Fixed=1
        . . set DelError=1
        . . new DFN set DFN=$$GetDFN^TMGSEQL1(.PtInfo)
        . . new TMGFDA,TMGMSG,tempResult
        . . set TMGFDA(2,DFN_",",.09)="@"  ;"delete .09 field (SSN)
        . . set tempResult=$$dbWrite^TMGDBAPI(.TMGFDA,1,,,.TMGMSG)
        . . if tempResult=0 quit ;"error found, so quit
        . . ;"Now try filing again.
        . . new OneErrErray,ChgLog
        . . new AutoRegister set AutoRegister=0  ;"should need to add patient, as must exist to confilict in first place!
        . . set tempResult=$$UpdateDB^TMGSEQL1(.PtInfo,AutoRegister,.OneErrArray,.ChgLog) ;"0=error
        . . if tempResult=0 do
        . . . do ErrRefile(.OneLine,.PtInfo,.OneErrArray,DUZ)
        . . . ;"write "There is still an error:",!
        . . . ;"zwr OneErrArray(*)
        . . . ;"write "A new alert will be made to handle this new error.",!
        . . . ;"set OneErrArray(0)=$$NameError(.OneErrArray)
        . . . ;"write OneErrArray(0),!
        . . . ;"do AlertError^TMGSEQL2(.OneLine,.PtInfo,.OneErrArray,DUZ)
 
FSNPDone
        quit Fixed
 
 
 
GetSex(Name)
        ;"Purpose: To return gender of Name, as stored in file 22707
        ;"Input: Name -  a FIRST name
        ;"Result: Returns MALE, FEMALE, or "" if not found
 
        new result set result=""
        if $get(Name)="" goto GSDone
        new DIC,X,Y
        set DIC=22707
        set DIC(0)="M"
        set X=Name
        do ^DIC
        if +Y'>0 goto GSDone
        set result=$$GET1^DIQ(22707,+Y_",",1)
 
GSDone
        quit result
 
 
 
SetSex(Name,Sex)
        ;"Purpose: To create a new record in file 22707 to store gender of name
        ;"Input: Name -- a FIRST name to store gender for
        ;"       Sex -- should be "MALE", or "FEMALE"
        ;"Note: Will not do anything if a record for name already exists
        ;"Result: 1=OK to continue  0=some error
 
        new result set result=1
        if '$data(Name)!'$data(Sex) goto SSxDone
        if $$GetSex(Name)'="" goto SSxDone
        new TMGFDA
        set TMGFDA(22707,"+1,",.01)=Name
        set TMGFDA(22707,"+1,",1)=Sex
        set result=$$dbWrite^TMGDBAPI(.TMGFDA,0)
 
SSxDone
        quit result
 
 
NameError(OneErrArray)
        ;"Purpose: to review a fileman "DIERR" array and pick out common problems
        ;"Input: OneErrArray -- a fileman array containing "DIERR" message
        ;"Result: return a name for error
 
        new result set result=""
 
        new Array
        if $data(OneErrArray("DIERR"))>1 do
        . merge Array=OneErrArray("DIERR")
        else  do
        . merge Array=OneErrArray
 
        new field set field=$get(Array(1,"PARAM","FIELD"))
 
        if $data(Array)>0 do
        . new FileNum set FileNum=+$get(Array(1,"PARAM","FILE"))
        . if (FileNum>0)&(FileNum'=2) quit
        . if field>0 set result="FILEMAN ERROR:"
        . if field=.03 do
        . . set result="INVALID DOB ERROR:"
        . if field=.02 do
        . . set result="INVALID/MISSING GENDER:"
        . if $data(Array(1,"TEXT")) do
        . . new s set s=$get(Array(1,"TEXT",1))
        . . set result=result_$extract(s,1,80)_"..."
        . if result["CONFLICTING SS-NUMBERS" do
        . . set result="CONFLICTING SS-NUMBERS: "
 
        if result="" set result=$get(Array(0),"Sequel Import Error:")
 
        quit result
 
 
FixGenProblem(PtInfo,ErrMsg,OneLine,DelError,ErrIEN)
        ;"Purpose: To fix a generic (no specified) error
        ;"Input: PtInfo -- PASS BY REFERENCE -- the Patient Info array, as created by ParseLine^TMGSEQL1
        ;"       ErrMsg -- the message that holds the conflicting SSNums
        ;"       OneLine -- the originial CSV data line.  Passed to this function in case a new Alert
        ;"                  must be created, in which case it is stored in the new error message.
        ;"       DelError -- and OUT parameter.  Set to 1 will signal the deletion of the error
        ;"              record in file 22706
        ;"       ErrIEN -- the IEN in file 22706 containing full error info.
        ;"Output: Patient may be added to FILE 2, or file updated.  If succesfull, record of error
        ;"      in file 22706 will deleted
        ;"Result: 1=problem fixed, 0=not fixed.
 
        new Fixed set Fixed=0
        new done set done=0
        set DelError=0
        new done set done=0
        new AutoRegister set AutoRegister=1  ;"automatically add patient to database if not found
 
        new temp
        set temp="?"
        for  do  quit:(done=1)
        . if temp="?" do  quit
        . . write "Options:",!
        . . write "-----------------",!
        . . write "D   Show the data line from the other computer (Sequel)",!
        . . write "E   Edit data line.",!
        . . write "R   Retry filing data into database to get more information.",!
        . . write "S   Show parsed patient information.",!
        . . write "X   Delete this Alert.",!
        . . write "Q   Query the database to see existing entries.",!
        . . write "^   Abort.",!
        . . set temp=""
        . else  if temp="Q" do  quit
        . . new DIC set DIC=2
        . . set DIC(0)="AEQM"
        . . do ^DIC
        . . set temp=""
        . else  if temp="D" do  quit
        . . write !,OneLine,!
        . . set temp=""
        . else  if temp="S" do  quit
        . . zwr PtInfo(*)
        . . set temp=""
        . else  if temp="E" do  quit
        . . new r,NewLine
        . . set r=$$EditOneLine(OneLine,.NewLine)
        . . if r=1 set OneLine=NewLine ;"NOTE: later I will save old line to keep from having to process each update cycle
        . . kill PtInfo
        . . if $$ParseLine^TMGSEQL1(OneLine,.PtInfo)=0 do  quit
        . . . write "There was a problem processing this line after your edit.  Sorry!",!
        . . write "OK, now try refilling data into database.",!
        . . set temp="?"
        . else  if temp="^" do  quit
        . . write "aborting..",!
        . . set done=1
        . else  if temp="X" do  quit
        . . write "OK, will delete this alert.",!
        . . ;"Note: do something to delete alert.
        . . set done=1,DelError=1,Fixed=1
        . else  if temp="R" do  quit
        . . new OneErrErray,ChgLog
        . . set tempResult=$$UpdateDB^TMGSEQL1(.PtInfo,AutoRegister,.OneErrArray,.ChgLog) ;"0=error
        . . set DelError=1
        . . set Fixed=1 ;"consider 'fixed' so alert will be deleted
        . . set done=1
        . . if tempResult=0 do
        . . . do ErrRefile(.OneLine,.PtInfo,.OneErrArray,DUZ)
        . . . ;"write "There is still an error:",!
        . . . ;"zwr OneErrArray(*)
        . . . ;"write "A new alert will be made to handle this new error.",!
        . . . ;"set OneErrArray(0)=$$NameError(.OneErrArray)
        . . . ;"write OneErrArray(0),!
        . . . ;"do AlertError^TMGSEQL2(.OneLine,.PtInfo,.OneErrArray,DUZ)
        . read !,"Enter Option: ?//",temp:$get(DTIME,3600),!
        . if temp="" set temp="?"
        . set temp=$$UP^XLFSTR(temp)
        . quit
 
FGPDone
        quit Fixed
 
 
 
