TMGDELPT	;TMG/kst/Low-level Patient Deletion Utilities ;08/13/08
	        ;;1.0;TMG-LIB;**1**;08/12/08
	

DelPt
        ;"Purpose: to try to safely delete a patient
        ;"NOTICE: Deleting could be a violation of laws regulating the maintanance
        ;"        of patient records.  I.e. if you delete who a patient is, then 
        ;"        you destroy all records associated with that patient.
        ;"        SO, only delete a patient if you are sure that you what you are
        ;"        doing, and are sure that you are not causing perminant injury!

        new DFN,DIC,X,Y,PtIEN
Loop1
        set DIC=2,DIC(0)="MAEQ"
        do ^DIC write !
        if +Y=-1 do  goto DPDone
        . write "Goodbye.",!
        set PtIEN=+Y

	do DelOne(PtIEN,0)

        write "Delete another patient (caution!)" do YN^DICN write !
        if %=1 goto Loop1
	quit


DelOne(PtIEN,Quiet)
        ;"Purpose: to try to safely delete a patient
        ;"NOTICE: Deleting could be a violation of laws regulating the maintanance
        ;"        of patient records.  I.e. if you delete who a patient is, then 
        ;"        you destroy all records associated with that patient.
        ;"        SO, only delete a patient if you are sure that you what you are
        ;"        doing, and are sure that you are not causing perminant injury!
	;"Input: PtIEN -- the IEN in file 2
	;"       Quiet -- OPTIONAL.  If 1, then user is not prompted.
	;
	set Quiet=+$get(Quiet,0)
        new PtrsIn
        new File,Field,A,GL,Q,ERR 
        set Qt="""",ERR=0,File=0  
        for  SET File=$O(^DD(2,0,"PT",File)) quit:'File  do
        . SET Field=0
        . for  S Field=$O(^DD(2,0,"PT",File,Field)) quit:'Field  do
        . . SET K=0
        . . for  S K=$O(^DD(File,+Field,1,K)) quit:'K  DO
        . . . SET A=$G(^DD(File,+Field,1,K,0))
        . . . if '$L($P(A,U,2)) quit
        . . . if $L($P(A,U,3)) quit 
        . . . set GL=$G(^DIC(+File,0,"GL"))
        . . . quit:'$L(GL)  
        . . . set GL=GL_Qt_$P(A,U,2)_Qt_","_PtIEN_")"
        . . . if $D(@GL) D
        . . . . new IEN set IEN=$O(@GL@(""))
        . . . . set PtrsIn(File,IEN)=""

        set File="",Field=""
        for  set File=$order(PtrsIn(File)) quit:(File="")  do
        . set IEN=""
        . for  set IEN=$order(PtrsIn(File,IEN)) quit:(IEN="")  do
	. . if Quiet'=1 do
        . . . write "Entry #",IEN," in file ",$piece($get(^DIC(File,0)),"^",1)," (",File,") "
        . . . write "points to this patient.",!
        . . new % set %=2
	. . if Quiet=1 set %=1 
        . . else  write "Delete this entry" do YN^DICN write !
        . . if %'=1 quit        
        . . new TMGFDA,TMGMSG
        . . set TMGFDA(File,IEN_",",.01)="@"
        . . do FILE^DIE("","TMGFDA","TMGMSG")
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)

        new % set %=2
	if Quiet=1 set %=1
        else  write "Delete ",$piece(Y,"^",2) do YN^DICN write !
        if %'=1 goto DPDone
                        
        new TMGFDA,TMGMSG
        set TMGFDA(2,PtIEN_",",.01)="@"
        do FILE^DIE("","TMGFDA","TMGMSG")
        do ShowIfDIERR^TMGDEBUG(.TMGMSG)

DPDone
        quit



TempDel
	;"Purpose: to delete all TMG-* named patients (testing only...)

	new IEN,name
	set name=""
	for  set name=$order(^DPT("B",name)) quit:(name="")  do
	. if 'name["TMG-" quit
	. set IEN=$order(^DPT("B",name,""))
	. write "Deleting: ",name,"..."
	. do DelOne(IEN,1)
	. write !

	quit