TMGNDF0B ;TMG/kst/FDA Import: Display FDA files ;03/25/06
         ;;1.0;TMG-LIB;**1**;11/21/06
 
 ;" FDA - NATIONAL DRUG FILES DISPLAY FUNCTIONS
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"11-21-2006
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"ShowDrug
 ;"ShowAll
 ;"CountAll
 ;"Show1Drug(IEN,Index)
 
 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 ;"AskCompile
 ;"CompByTemplate
 ;"ShowTemplate
 
 ;"ShowNDCConflict(Array,IEN2)
 ;"FormatDrug(Array)
 ;"Format2Drug(Array)
 ;"Format3Drug(Array)
 
 
 ;"=======================================================================
 ;"=======================================================================
Menu
        ;"Purpose: To give an interactive menu
 
        new Menu,UsrSlct
        set Menu(0)="Pick Option for Optional Utilities (0B)"
        set Menu(1)="Show Drugs from FDA Tables"_$char(9)_"ShowAll"
        set Menu(3)="Show ONE Drug from FDA Tables"_$char(9)_"ShowOne"
        set Menu(2)="Count Drugs from FDA Tables"_$char(9)_"CountAll"
        set Menu("P")="Prev Stage"_$char(9)_"Prev"
        set Menu("N")="Next Stage"_$char(9)_"Next"
 
CD1
        write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
        if UsrSlct="^" goto CDDone
        if UsrSlct=0 set UsrSlct=""
 
        if UsrSlct="Prev" goto Menu^TMGNDF0A  ;"quit can occur from there...
        if UsrSlct="Next" goto Menu^TMGNDF0C  ;"quit can occur from there...
        if UsrSlct="ShowAll" do ShowAll goto CD1
        if UsrSlct="ShowOne" do ShowDrug goto CD1
        if UsrSlct="CountAll" do CountAll goto CD1
        goto CD1
CDDone
        quit
 
 ;"=======================================================================
 
ShowDrug
        ;"Purpose: to ask for an IEN, and then show drug
        ;"      i.e. IEN from TMG FDA LISTING
 
        new IEN,pIndex
        set pIndex=$$GetpVAPIndex^TMGNDF1A()
 
loop    read "Enter IEN number (^ to quit) ^// ",IEN:$get(DTIME,3600),!
        if IEN="" set IEN="^"
        if IEN="^" goto SDDone
        do Show1Drug(IEN,.Index)
        goto loop
 
SDDone
        quit
 
 
Show1Drug(IEN,pIndex)
        ;"Purpose: to show drug from TMG FDA LISTING
        ;"Input: IEN -- IEN from TMG FDA LISTING file
        ;"       Index -- PASS BY NAME -- OPTIONAL
        ;"               This is an index as returned by IndexVAProd^TMGNDF1A("Index")
        ;"               If not passed, then it will be filled here.
        ;"Results: none
 
        new Array,result
        if $get(pIndex)="" set pIndex=$$GetpVAPIndex^TMGNDF1A()
 
        set result=$$GetDrugInfo^TMGNDF1A(IEN,.Array,pIndex)
        if (result=1)&($data(Array)'=0) do
        . write !,"-----------------------------------------",!
        . zwr Array(*)
        quit
 
 
ShowAll
        ;"Purpose: to show all drugs
 
        new count set count=1
        new Array
        new temp set temp=" "
        new result set result=1
        new Matches
 
        new pIndex set pIndex=$$GetpVAPIndex^TMGNDF1A()
 
SADloop
        kill Array
 
        ;"2/13/07 note: the call to GetDrugInfo below looks wrong.  I have made changes
        ;"      to the location of functions.  I think this needs to be reassessed...
        if $$GetDrugInfo^TMGNDF1A(count,.Array,pIndex) do
        . new numMatch set numMatch=+$get(Array("FILE 50.68 IEN","COUNT"))
        . new numPMatch set numPMatch=+$get(Array("FILE 50.68 IEN","POSS MATCH","COUNT"))
        . set Matches(numMatch,numPMatch)=$get(Matches(numMatch,numPMatch))+1
        . write count,": "
        . do Format2Drug(.Array)
        . quit
        . write "Type ^ to abort, <SPACE> to pause",!
        . if +$get(Array("FILE 50.68 IEN","COUNT"))=0 do
        . . write "No MATCH in VA PRODUCT file",!
        . else  if +$get(Array("FILE 50.68 IEN","COUNT"))>1 do
        . . write "MULTIPLE matches found in VA PRODUCT file",!
        . . zwr Array("FILE 50.68 IEN",*)
        . else  if +$get(Array("FILE 50.68 IEN","COUNT"))>1 do
        . . write "1 match found.",!
        else  set temp="^"
 
        read temp:0.25
        if temp=" " do
        . read "Press <ENTER> to continue (or ^ to abort) ",temp,!
        set count=count+1
        if temp="^" goto SD2Done
 
        goto SADloop
 
SD2Done
        write "Here is the cumulative results of couting matches",!
        write "Matches(Matches,PossMatches)=count",!
        zwr Matches(*)
        quit
 
 
CountAll
        ;"Purpose: to ask for an IEN, and then show drug
 
        new count set count=20000
        new Array
        new temp set temp=" "
        new result set result=1
        new Matches
        new showCount set showCount=0
        new MaxIEN set MaxIEN=$piece($get(^TMG(22706.5,0)),"^",3)
        new abort set abort=0
 
CADloop
        for count=1:1:MaxIEN do  quit:(abort=1)
        . kill Array
        . if $$GetDrugInfo^TMGNDF1A(count,.Array)=1 do
        . . new numMatch set numMatch=+$get(Array("FILE 50.68 IEN","COUNT"))
        . . new numPMatch set numPMatch=+$get(Array("FILE 50.68 IEN","POSS MATCH","COUNT"))
        . . set Matches(numMatch,numPMatch)=$get(Matches(numMatch,numPMatch))+1
        . . if $get(Array("NDC","NOTE"))'="" do
        . . . write count,"--> ",Array("NDC","NOTE"),!
        . . . new badIEN set badIEN=+$piece(Array("NDC","NOTE"),"=",2)
        . . . do ShowNDCConflict(.Array,badIEN)
        . . . read temp:0.25
        . . . if temp=" " do
        . . . . read "Press <ENTER> to continue (or ^ to abort) ",temp,!
        . . . . if temp="^" set abort=1
        . . set showCount=showCount+1
        . . if showCount=100 do
        . . . set showCount=0
        . . . write count,": "
        . . . do Format2Drug(.Array)
 
CADDone
        write "Here is the cumulative results of couting matches",!
        write "Matches(Matches,PossMatches)=count",!
        zwr Matches(*)
        quit
 
 
 
FormatDrug(Array)
 
        if '$data(Array) quit
        new i
        write $get(Array("TRADENAME")),"; "
        write $get(Array("STRENGTH")),"; "
        write $get(Array("UNIT")),"; "
        set i=$order(Array("DOSE",""))
        if +i>0 for  do  quit:(+i'>0)
        . write $get(Array("DOSE",i,"DOSAGE NAME"))," "
        . set i=$order(Array("DOSE",i))
        write !
        set i=$order(Array("FORMULATION",""))
        if +i>0 for  do  quit:(+i'>0)
        . write "   ingredients: ",$get(Array("FORMULATION",i,"INGREDIENT NAME")),"; "
        . write $get(Array("FORMULATION",i,"STRENGTH")),"; "
        . write $get(Array("FORMULATION",i,"UNIT")),!
        . set i=$order(Array("FORMULATION",i))
 
        quit
 
Format2Drug(Array)
 
        new s
        if '$data(Array) quit
        new i
 
        set s="m="_$get(Array("FILE 50.68 IEN","COUNT"),0)_";"
        set s=s_"lm="_$get(Array("FILE 50.68 IEN","POSS MATCH","COUNT"),0)_" "
        ;"Array("FILE 50.68 IEN","LOOSE MATCH","COUNT")=1
        set s=s_$get(Array("TRADENAME"))_" "
        set s=s_$get(Array("STRENGTH"))_" "
        set s=s_$get(Array("UNIT"))_" "
        set i=$order(Array("DOSE",""))
        if +i>0 for  do  quit:(+i'>0)
        . set s=s_$get(Array("DOSE",i,"DOSAGE NAME"))_" "
        . set i=$order(Array("DOSE",i))
 
        write $extract(s,1,60),!
 
 
        if $get(Array("FORMULATION",1,"STRENGTH"))="" do
        . if $get(Array("STRENGTH"))'="" do
        . . write "Note: Ingredient #1 strength is empty, but Overall strength="
        . . write $get(Array("STRENGTH")),!
 
        quit
 
 
Format3Drug(Array)
        ;"Purpose: show match, only if 0 matches and >0 possible matches
 
        new s
        if '$data(Array) quit
        new i
        if $get(Array("FILE 50.68 IEN","COUNT"),0)'=0 quit
        if $get(Array("FILE 50.68 IEN","POSS MATCH","COUNT"),0)'>0 quit
 
        do Format2Drug(.Array)
 
        set i=$order(Array("FILE 50.68 IEN","POSS MATCH",""))
        if +i>0 for  do  quit:(+i'>0)
        . new Msg set Msg=$get(Array("FILE 50.68 IEN","POSS MATCH",i,"MSG"))
        . new Problem set Problem=$get(Array("FILE 50.68 IEN","POSS MATCH",i,"PROBLEM"))
        . new IEN set IEN=$get(Array("FILE 50.68 IEN","POSS MATCH",i))
        . write IEN,": ",Problem,"(",Msg,")",!
        . set i=$order(Array("FILE 50.68 IEN","POSS MATCH",i))
 
        quit
 
 
ShowNDCConflict(Array,IEN2)
        ;"Purpose: show two drug entries that have same NDC's, but differing drug properties
        ;"Input: Array -- PASS BY REFERENECE -- data with DrugIfno (from GetDrugInfo)
        ;"       IEN2: the IEN from file VA PRODUCT (50.68)
 
 
        write "Here is TMG FDA* data:",!
        do FormatDrug(.Array)
        write !
 
        write "Here is VA Product data:",!
        new VAArray
        do GetVADrugInfo^TMGNDF1C(IEN2,.VAArray)
        do FormatDrug(.VAArray)
 
        write !!
        quit
 
 
AskCompile
        ;"Purpose: To ask for an Entry number from 22706.5 and add drug to compiled file
 
        new IEN
 
        for  do  quit:(+IEN'=IEN)
        . read "Type in Entry Number (^ to abort): ",IEN:$get(DTIME,3600),!
        . if +IEN'=IEN quit
        . do CompileOne^TMGNDF1C(IEN)
 
        quit
 
CompByTemplate
        ;"Purpose: To ask for a SORT TEMPLATE, and compile the records for IENs stored there.
 
        new pIndex set pIndex=$$GetpVAPIndex^TMGNDF1A()
 
        new IEN,Template
        new DIC,X,Y
        set DIC=.401
        set DIC("A")="Enter a SORT TEMPLATE to compile FDA entries from: "
        set DIC(0)="AEQM"
        do ^DIC
        if +Y'>0 goto CBTDone
        set Template=+Y
 
        new TMGTOTAL set TMGTOTAL=$$CtTemplate^TMGMISC(Template)
        new StartTime set StartTime=$H
        new ProgressFn
        set ProgressFn="if count#10=1 do ProgressBar^TMGUSRIF(count,""Progress"",0,TMGTOTAL,,StartTime)"
        set IEN=""
        new count set count=0
        for  do  quit:(+IEN'>0)
        . set IEN=$$IterTemplate^TMGMISC(Template,IEN)
        . if +IEN'>0 quit
        . ;"write IEN,!
        . do CompileOne^TMGNDF1C(IEN,0,pIndex)
        . set count=count+1
        . if $get(ProgressFn)'="" do
        . . new $etrap set $etrap="w ""??Progress function -- error trapped??"",!"
        . . xecute ProgressFn
 
CBTDone
        quit
 
 
MkGenAll
        ;"Purpose: To fill in the GENERIC NAME field for record for all records in file
        ;"Input: none
        ;"Output: The file 22706.9 (TMG FDA IMPORT COMPILED) has records added.
        ;"Result: none
 
        new IEN set IEN=0
        new Array,result,temp
        new Interval set Interval=0
        new abort set abort=0
        new TMGTOTAL set TMGTOTAL=$piece($get(^TMG(22706.5,0)),"^",3)
        new StartTime set StartTime=$H
        new ProgressFn
        set ProgressFn="if IEN#10=1 do ProgressBar^TMGUSRIF(IEN,""Progress"",0,TMGTOTAL,,StartTime)"
 
        for  do  quit:(IEN'>0)!(abort=1)
        . set IEN=$order(^TMG(22706.5,IEN))
        . if +IEN'>0 quit
        . do FillGenericName^TMGNDF1C(IEN)
        . if $get(ProgressFn)'="" do
        . . new $etrap set $etrap="w ""??Progress function -- error trapped??"",!"
        . . xecute ProgressFn
 
        quit
 
 
MkGenByTemplate
        ;"Purpose: To ask for a SORT TEMPLATE, and fill in the GENERIC NAME field for record
        ;"      -- for all records listed in the template
        ;"Output: The file 22706.9 (TMG FDA IMPORT COMPILED) has GENERIC NAME firecords added.
 
        new pIndex set pIndex=$$GetpVAPIndex^TMGNDF1A()
 
        new IEN,Template
        new DIC,X,Y
        set DIC=.401
        set DIC("A")="Enter a SORT TEMPLATE to compile FDA entries from: "
        set DIC(0)="AEQM"
        do ^DIC
        if +Y'>0 goto MGBTDone
        set Template=+Y
 
        new TMGTOTAL set TMGTOTAL=$$CtTemplate^TMGMISC(Template)
        new StartTime set StartTime=$H
        new ProgressFn
        set ProgressFn="if count#10=1 do ProgressBar^TMGUSRIF(count,""Progress"",0,TMGTOTAL,,StartTime)"
        set IEN=""
        new count set count=0
        for  do  quit:(+IEN'>0)
        . set IEN=$$IterTemplate^TMGMISC(Template,IEN)
        . if +IEN'>0 quit
        . ;"write IEN,!
        . do FillGenericName^TMGNDF1C(IEN)
        . set count=count+1
        . if $get(ProgressFn)'="" do
        . . new $etrap set $etrap="w ""??Progress function -- error trapped??"",!"
        . . xecute ProgressFn
 
MGBTDone
        quit
 
 
ShowTemplate
        ;"Purpose: To ask for a SORT TEMPLATE, and show the records for IENs stored there.
 
        new IEN,Template
        new DIC,X,Y
        set DIC=.401
        set DIC("A")="Enter a SORT TEMPLATE to compile FDA entries from: "
        set DIC(0)="AEQM"
        do ^DIC
        if +Y'>0 goto STDone
        set Template=+Y
 
        set IEN=""
        new result,Array
 
        for  do  quit:(+IEN'>0)
        . set IEN=$$IterTemplate^TMGMISC(Template,IEN)
        . if +IEN'>0 quit
        . write "IEN: ",IEN,!
        . set result=$$GetDrugInfo^TMGNDF1A(IEN,.Array)
        . do Format2Drug(.Array)
 
STDone
        quit
 
 
CheckPtrs
        ;"Purpose: check import files for 0 values for pointers.
 
        new Info
        set Info(22706.1,.01)="0;1"
        set Info(22706.2,.01)="0;1"
        set Info(22706.2,3)="1;2"
        set Info(22706.4,.01)="0;1"
        set Info(22706.5,6)="0;7"
        set Info(22706.5,8)="0;9"
        set Info(22706.6,.01)="0;1"
        set Info(22706.7,.01)="0;1"
 
        set Info(22706.8,1)="0;2"
        set Info(22706.8,2)="0;3"
        set Info(22706.82,1)="0;2"
        ;"set Info(22703,.01)="0;1"  ;"no pointers
        ;"set Info(22707,.01)="0;1"  ;"no pointers
        ;"set Info(22705,.01)="0;1"  ;"ignore this one
        ;"set Info(22711,.01)="0;1"
 
        new abort set abort=0
        new file set file=""
        for  set file=$order(Info(file)) quit:(file="")!abort  do
        . new field set field=""
        . for  set field=$order(Info(file,field)) quit:(field="")!abort  do
        . . new node,pce
        . . set node=$piece($get(Info(file,field)),";",1)
        . . set pce=$piece($get(Info(file,field)),";",2)
        . . if (node="")!(pce="") quit
        . . new Itr,IEN
        . . write !,"Scanning file ",file,!
        . . set IEN=$$ItrInit^TMGITR(file,.Itr)
        . . do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        . . if IEN'="" for  do  quit:(+$$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . . . if $$UserAborted^TMGUSRIF set abort=1 quit
        . . . if $piece($get(^TMG(file,IEN,node)),"^",pce)=0 do
        . . . . write !,file,", IEN: #",IEN," has 0 pointer for the ",field,"field.",!
 
 
        quit
