TMGNDF4C ;TMG/kst/FDA Import: Move drugs from 50.7 --> 101.43 ;03/25/06
         ;;1.0;TMG-LIB;**1**;11/21/06
 
 ;" FDA - NATIONAL DRUG FILES COMPILING FUNCTIONS
 ;"      Move drugs from 50.7 --> 101.43
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"11-21-2006
 
 ;"Note: The database itself tries to create entries in 101.43 when a drug
 ;"      is added to file 50.7.  But I am not happy with the job it does.
 ;"      There are missing records, and it combines various IR, SR, XR
 ;"      into one entry.  So I am going to delete the auto-created records
 ;"      and create my own.
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"Menu
 ;"=======================================================================
 ;"AddAllTMG -- Add/Refresh all relevent TMG entries into OI
 ;"OIFromTMG(IEN,Option)  -- Add/Update ONE entry in ORDERABLE ITEM (101.43) file
 
 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 ;"VerifySync -- verify correct links PHARMACY ORDERABLE ITEM --> ORDERABLE ITEM
 ;"OIFromTMG(IEN22706d9,Option)
 ;"EnsureOI(IEN50d7,Name,Synonyms,Option)  -- make sure that there is a corresponding entry
 ;"               in 101.43.  If one doesn't already exist, then it will be added.
 ;"InactivateOI -- cycle through 101.43 and ensure needed records are inactivated.
 ;"NewOI(Name) -- add one record to file 101.43--stub in an empty record for later stuffing
 ;"StuffOI(IEN101d43,Name,Synonyms,IEN50d7) -- fill one record to file 101.43 with data
 
 
 ;"ResetFiles -- For debugging purposes, this will reset two files: 101.44, 101.43
 
 
 ;"=======================================================================
 
Menu
 
        new Menu,UsrSlct
        set Menu(0)="Pick Option to Sync ORDERABLE ITEMS (4C)"
        set Menu(1)="Sync imports to ORDERABLE ITEMS."_$char(9)_"Sync2OI"
        ;"set Menu(2)="Inactivate non-FDA-drug-OI's"_$char(9)_"InactivateOI"
        set Menu(2)="Ensure Activation Status of Import OI's"_$char(9)_"SyncActivOI"
        set Menu(3)="Verify Sync of PHARMACY ORDERABLE ITEMS --> OI's"_$char(9)_"VerifySync"
        ;"set Menu(4)="Check for duplicate ORDABLE ITEMS records"_$char(9)_"Check4Dups"
        set Menu(4)="Check for dangling ORDERABLE ITEMS records"_$char(9)_"CheckDangle"
        set Menu("P")="Prev Stage"_$char(9)_"Prev"
        set Menu("N")="Next Stage"_$char(9)_"Next"
 
M1      write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
 
        if UsrSlct="Sync2OI" do AddAllTMG goto M1
        ;"if UsrSlct="Sync2OI" do Sync2OI goto M1
        ;"if UsrSlct="InactivateOI" do InactivateOI goto M1
        if UsrSlct="SyncActivOI" do SyncActivOI goto M1
        if UsrSlct="VerifySync" do VerifySync goto M1
        ;"if UsrSlct="Check4Dups" do Check4Dups goto M1
        if UsrSlct="CheckDangle" do CheckDangle goto M1
 
        if UsrSlct="Prev" goto Menu^TMGNDF4B  ;"quit can occur from there...
        if UsrSlct="Next" goto Menu^TMGNDF4E  ;"quit can occur from there...
 
        if UsrSlct="^" goto MenuDone
        goto M1
 
MenuDone
        quit
 
 ;"=============================================================================
 
AddAllTMG
        ;"Purpose: Add/Refresh all relevent TMG entries into OI
        ;"Input:none
        ;"results: none
 
        new IEN,Itr
        new abort set abort=0
        new result set result=0
        write "Scanning all imports to ensure ORDERABLE ITEMS are set up.",!
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)!(abort=1)
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . new Option
        . set Option("CUR MODE")="TRADE"
        . set result=$$OIFromTMG(IEN,.Option)  ;"screen for skip will occur in function
        . set Option("CUR MODE")="GENERIC"
        . set result=$$OIFromTMG(IEN,.Option)  ;"screen for skip will occur in function
        quit
 
 
OIFromTMG(IEN22706d9,Option,Synonyms)
        ;"Purpose: to Add/Update ONE entry in ORDERABLE ITEM (101.43) file
        ;"Input:  IEN22706d9 -- IEN in 22706.9
        ;"        Option -- NON-OPTIONAL part. Format:
        ;"                  Option("CUR MODE")="TRADE"
        ;"        Option -- OPTIONAL. Format:
        ;"                  Option("IEN50.7","TRADE")=IEN50d7
        ;"                  Option("IEN50.7","GENERIC")=IEN50d7
        ;"                  Option("IEN101.43","TRADE")=IEN101.43 for Trade Name.  May be 0
        ;"                  Option("IEN101.43","GENERIC")=IEN101.43 for Generic Name. May be 0
        ;"                  Option("FIX CHAIN")=1  <--- changes will be propigate forward
        ;"                   to file POI, OI, OQV etc.
        ;"                  OPTION("FIX CHAIN","IEN22706d9")=Source IEN
        ;"                  Option("QUIET")=1 <-- supress text output
        ;"                  Option("IEN50","TRADE")=IEN50 for Trade Name
        ;"                  Option("IEN50","GENERIC")=IEN50 for Generic Name
        ;"                  Option("DRUG NAME AND FORM","TRADE")=Trade Name and Form
        ;"                  Option("DRUG NAME AND FORM","GENERIC")=Generic Name and Form
        ;"                  Option("CUR MODE")="TRADE" or "GENERIC"
        ;"                  Option("DELETING")=1 <-- deleting chain (not IEN22706d9)
        ;"       Synonyms --OPTIONAL.  PASS BY REFERENCE.  Expected format:
        ;"                  Synonyms(Name)=""
        ;"                  Synonyms(Name)=""
        ;"NOTE: This function DOES screen for skipped entries, and skips
        ;"      proccessing. BUT, if Deleting, then it is NOT skipped
        ;"Output: OI records will be added or refreshed, or deleted.
        ;"Result: 1=Modified, 0=not modified
 
        new result set result=0
        if $get(Option("DELETING"))'=1,$piece($get(^TMG(22706.9,IEN22706d9,1)),"^",4)=1 goto EOIDone  ;"1=SKIP
        if +$get(IEN22706d9)=0 goto EOIDone
        new quiet set quiet=+$get(Option("QUIET"))
        do LoadOption(IEN22706d9,.Option)
 
        new mode set mode=$get(Option("CUR MODE")) if mode="" goto EOIDone
        new IEN50d7 set IEN50d7=+$get(Option("IEN50.7",mode)) if IEN50d7=0 goto EOIDone
        new DrugNAF set DrugNAF=$get(Option("DRUG NAME AND FORM",mode)) if DrugNAF="" goto EOIDone
 
        new IEN101d43 set IEN101d43=+$get(Option("IEN101.43",mode))
 
        if $get(Option("DELETING"))=1 do  goto EOIDone
        . do KillOI^TMGNDFUT(IEN101d43)
        . set Option("IEN101.43",mode)=""
 
        if (IEN101d43>0),$data(^ORD(101.43,IEN101d43))=0 do
        . set IEN101d43=0   ;"I found a dangling pointer
        ;"I am taking line below out because there is supposed to be a 1:1
        ;"  connection between POI<-->OI.  Below might cause cross link of chains
        ;"if IEN101d43=0 set IEN101d43=$$FindOI^TMGNDFUT(DrugNAF)
        if IEN101d43=0 do
        . set IEN101d43=$$NewOI(DrugNAF)
        . set Option("IEN101.43",mode)=IEN101d43
        . set result=1
        if IEN101d43=0 set result=0 goto EOIDone
 
        set result=$$StuffOI(IEN101d43,DrugNAF,.Synonyms,IEN50d7) ;"result 1=modified
 
        ;"Ensure pointer to 101.43 stored in TMG IMPORT COMPILED records
        if mode="TRADE" do
        . new IEN22706d9 set IEN22706d9=""
        . for  set IEN22706d9=$order(^TMG(22706.9,"POIT",IEN50d7,IEN22706d9)) quit:(IEN22706d9="")  do
        . . if +$piece($get(^TMG(22706.9,IEN22706d9,8)),"^",5)=IEN101d43 quit
        . . new TMGFDA,TMGMSG
        . . set TMGFDA(22706.9,IEN22706d9_",",5.611)=IEN101d43
        . . do FILE^DIE("","TMGFDA","TMGMSG")
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        if mode="GENERIC" do
        . new IEN22706d9 set IEN22706d9=""
        . for  set IEN22706d9=$order(^TMG(22706.9,"POIG",IEN50d7,IEN22706d9)) quit:(IEN22706d9="")  do
        . . if +$piece($get(^TMG(22706.9,IEN22706d9,8)),"^",6)=IEN101d43 quit
        . . new TMGFDA,TMGMSG
        . . set TMGFDA(22706.9,IEN22706d9_",",5.711)=IEN101d43
        . . do FILE^DIE("","TMGFDA","TMGMSG")
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
 
        ;"Ensure just 1 link 50.7 --> 101.43  (actually pointer is the other way: 101.43-->50.7)
        new all,temp
        set temp=$$GetOI^TMGNDFUT(IEN50d7,.all)
OI1     if $$ListCt^TMGMISC("all")>0 do
        . new IEN set IEN=""
        . for  set IEN=$order(all(IEN)) quit:(IEN="")  do
        . . if IEN=IEN101d43 quit
        . . if 'quiet write "?? Mult pointers 101.43 --> 50.7 ??.  Deleting 101.43 #",IEN,!
        . . do KillOI^TMGNDFUT(IEN)
 
        if $get(Option("FIX CHAIN"))=1 do
        . ;"pass message forward for fix
        . if result=1 do
        . . new temp set temp=$$Fix1OQV^TMGNDF4E(IEN101d43,.Option)
        . ;"Delete AFTER above so chain is deleted 101.44-->101.43-->50.7-->50
        . ;"if $get(Option("DELETING"))=1 do
        . ;". do KillOI^TMGNDFUT(IEN101d43)
EOIDone
        quit result
 
 
LoadOption(IEN22706d9,Option)
        ;"Purpose: To load up Option array with info
        ;"Input: IEN22706d9 -- IEN in 22706.9
        ;"       Option -- PASS BY REFERENCE.  An OUT PARAMETER. Format:
        ;"                  Option("IEN50.7","TRADE")=IEN50.7 for Trade Name
        ;"                  Option("IEN50.7","GENERIC")=IEN50.7 for Generic Name
        ;"                  Option("DRUG NAME AND FORM","TRADE")=Trade Name and Form
        ;"                  Option("DRUG NAME AND FORM","GENERIC")=Generic Name and Form
        ;"                  Option("IEN50","TRADE")=IEN50 for Trade Name
        ;"                  Option("IEN50","GENERIC")=IEN50 for Generic Name
        ;"                  Option("IEN101.43","TRADE")=IEN50 for Trade Name
        ;"                  Option("IEN101.43","GENERIC")=IEN50 for Generic Name
        ;"Note: May sync pointers in various records
        ;"Results: none
 
        new node7 set node7=$get(^TMG(22706.9,IEN22706d9,7))
        set Option("DRUG NAME AND FORM","TRADE")=$piece(node7,"^",3)
        set Option("DRUG NAME AND FORM","GENERIC")=$piece(node7,"^",4)
 
        new tIEN50 set tIEN50=+$get(Option("IEN50","TRADE"))
        if tIEN50=0 do
        . new tIEN50 set tIEN50=+$piece(node7,"^",1)
        . set Option("IEN50","TRADE")=tIEN50
        if tIEN50>0 set Option("IEN50","TRADE","NAME")=$piece($get(^PSDRUG(tIEN50,0)),"^",1)
 
        new gIEN50 set gIEN50=+$get(Option("IEN50","GENERIC"))
        if gIEN50=0 do
        . set gIEN50=+$piece(node7,"^",2)
        . set Option("IEN50","GENERIC")=gIEN50
        if gIEN50>0 set Option("IEN50","GENERIC","NAME")=$piece($get(^PSDRUG(gIEN50,0)),"^",1)
 
        new tIEN50d7 set tIEN50d7=+$piece($get(^TMG(22706.9,IEN22706d9,8)),"^",3)
        if tIEN50'=0 do
        . if tIEN50d7=0 do
        . . set tIEN50d7=+$piece($get(^PSDRUG(tIEN50,2)),"^",1)
        . . new TMGFDA,TMGIEN,TMGMSG
        . . set TMGFDA(22706.9,IEN22706d9_",",5.61)=tIEN50d7
        . . do FILE^DIE("S","TMGFDA","TMGMSG")
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . else  do  ;"sync 50 to match TMG COMPILED
        . . if tIEN50d7=+$piece($get(^PSDRUG(tIEN50,2)),"^",1) quit
        . . new TMGFDA,TMGIEN,TMGMSG
        . . set TMGFDA(50,tIEN50_",",2.1)=tIEN50d7
        . . do FILE^DIE("S","TMGFDA","TMGMSG")
        . . if $data(TMGMSG("DIERR")) do
        . . . if $data(TMGMSG("DIERR","E",120))>0 quit  ;"ignore error if #120 (hook) present.
        . . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        set Option("IEN50.7","TRADE")=tIEN50d7  ;"may be 0 at this point
        if tIEN50d7>0 set Option("IEN50.7","TRADE","NAME")=$piece($get(^PS(50.7,tIEN50d7,0)),"^",1)
 
        new gIEN50d7 set gIEN50d7=+$piece($get(^TMG(22706.9,IEN22706d9,8)),"^",4)
        if gIEN50'=0 do
        . if gIEN50d7=0 do
        . . set gIEN50d7=+$piece($get(^PSDRUG(gIEN50,2)),"^",1)
        . . new TMGFDA,TMGIEN,TMGMSG
        . . set TMGFDA(22706.9,IEN22706d9_",",5.71)=gIEN50d7
        . . do FILE^DIE("S","TMGFDA","TMGMSG")
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . else  do  ;"sync 50 to match TMG COMPILED
        . . if gIEN50d7=+$piece($get(^PSDRUG(gIEN50,2)),"^",1) quit
        . . new TMGFDA,TMGIEN,TMGMSG
        . . set TMGFDA(50,gIEN50_",",2.1)=gIEN50d7
        . . do FILE^DIE("S","TMGFDA","TMGMSG")
        . . if $data(TMGMSG("DIERR")) do
        . . . if $data(TMGMSG("DIERR","E",120))>0 quit  ;"ignore error if #120 (hook) present.
        . . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        set Option("IEN50.7","GENERIC")=gIEN50d7 ;"may be 0 at this point
        if gIEN50d7>0 set Option("IEN50.7","GENERIC","NAME")=$piece($get(^PS(50.7,gIEN50d7,0)),"^",1)
 
        new tradeNameAF set tradeNameAF=$get(Option("DRUG NAME AND FORM","TRADE"))
        if tradeNameAF="" do
        . set tradeNameAF=$piece($get(^TMG(22706.9,IEN22706d9,7)),"^",3)
        . set Option("DRUG NAME AND FORM","TRADE")=tradeNameAF
 
        new genericNameAF set genericNameAF=$get(Option("DRUG NAME AND FORM","GENERIC"))
        if genericNameAF="" do
        . set genericNameAF=$piece($get(^TMG(22706.9,IEN22706d9,7)),"^",4)
        . set Option("DRUG NAME AND FORM","GENERIC")=genericNameAF
 
        new tIEN101d43 set tIEN101d43=+$piece($get(^TMG(22706.9,IEN22706d9,8)),"^",5)
        if (tIEN101d43=0)&(tIEN50d7'=0) do
        . set tIEN101d43=$$GetOI^TMGNDFUT(tIEN50d7)
        . if tIEN101d43'>0 quit
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.9,IEN22706d9_",",5.611)=tIEN101d43
        . do FILE^DIE("S","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        set Option("IEN101.43","TRADE")=tIEN101d43 ;"could be 0 at this point
        if tIEN101d43>0 set Option("IEN101.43","TRADE","NAME")=$piece($get(^ORD(101.43,tIEN101d43,0)),"^",1)
 
        new gIEN101d43 set gIEN101d43=+$piece($get(^TMG(22706.9,IEN22706d9,8)),"^",6)
        if (gIEN101d43=0)&(gIEN50d7'=0) do
        . set gIEN101d43=$$GetOI^TMGNDFUT(gIEN50d7)
        . if gIEN101d43=0 quit
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.9,IEN22706d9_",",5.711)=gIEN101d43
        . do FILE^DIE("S","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        set Option("IEN101.43","GENERIC")=gIEN101d43 ;"could be 0 at this point
        if gIEN101d43>0 set Option("IEN101.43","GENERIC","NAME")=$piece($get(^ORD(101.43,gIEN101d43,0)),"^",1)
 
        quit
 
 
NewOI(Name)
        ;"Purpose: to add one record to file 101.43--stub in an empty record for later stuffing
        ;"Input: Name -- the text of the ORDERABLE ITEM (i.e. drug name) to add
        ;"Results: returns new IEN of added record
 
        new newIEN set newIEN=0
        new TMGFDA,TMGMSG,TMGIEN
        set TMGFDA(101.43,"+1,",.01)=Name
        do UPDATE^DIE("K","TMGFDA","TMGIEN","TMGMSG")  ;"ADD RECORD
        if $$ShowIfError^TMGDBAPI(.TMGMSG) goto NOIDone
        set newIEN=+$get(TMGIEN(1))  ;"GET BACK ADDED RECORD NUMBER
NOIDone
        quit newIEN
 
 
StuffOI(IEN101d43,Name,Synonyms,IEN50d7)
        ;"Purpose: to fill one record to file 101.43 with data
        ;"Input: IEN110d43 -- IEN in 101.43 to stuff
        ;"       Name -- the text of the drug name to add
        ;"       Synonyms -- PASS BY REFERENCE.  Expected format:
        ;"             Synonyms(Name)=""
        ;"             Synonyms(Name)=""
        ;"       IEN50d7 -- IEN in 50.7 -- the record in PHARMACY ORDERABLE ITEM (50.7) to link to
        ;"Results: 1 if modified, 0 if not modified
 
        ;"Here is an example of a drug that was stuff
        ;"   .01-NAME : BUPROPION TAB
        ;"     1-SYNONYMS :
        ;"        Multiple Entry #1  .01-SYNONYM : BUDEPRION SR EXT REL TABS
        ;"        Multiple Entry #2  .01-SYNONYM : BUDEPRION SR TABS
        ;"        Multiple Entry #3  .01-SYNONYM : BUPROPION HCL EXT REL TABS
        ;"        Multiple Entry #4  .01-SYNONYM : BUPROPION HCL SR TABS
        ;"   1.1-PACKAGE NAME : BUPROPION TAB
        ;"     2-ID : 3267;99PSP   <--- 3267 is IEN in 50.7 to link to
        ;"     5-DISPLAY GROUP : PHARMACY
        ;"     9-SET MEMBERSHIP :
        ;"        Multiple Entry #1   .01-SET : RX
        ;"  50.1-INPATIENT MED : NO
        ;"  50.2-OUTPATIENT MED : NO
        ;"  50.3-IV BASE : NO
        ;"  50.4-IV ADDITIVE : NO
        ;"  50.5-SUPPLY : NO
        ;"  50.6-NON-FORMULARY : NO
        ;"  50.7-NON-VA MEDS : NO
 
        new result set result=0
        new TMGFDA,TMGMSG,TMGIEN
        new IENS set IENS=IEN101d43_","
        set TMGFDA(101.43,IEN101d43_",",.01)=Name
        if $piece($get(^ORD(101.43,IEN101d43,.1)),"^",1)'="" do
        . set TMGFDA(101.43,IENS,.1)="@"  ;"delete any inactivation date.
        set TMGFDA(101.43,IENS,1.1)=Name
        set TMGFDA(101.43,IENS,2)=IEN50d7_";99PSP"
        set TMGFDA(101.43,IENS,5)="PHARMACY"
        set TMGFDA(101.43,IENS,50.1)="NO"
        set TMGFDA(101.43,IENS,50.2)="YES"
        set TMGFDA(101.43,IENS,50.3)="NO"
        set TMGFDA(101.43,IENS,50.4)="NO"
        set TMGFDA(101.43,IENS,50.5)="NO"
        set TMGFDA(101.43,IENS,50.6)="NO"
        set TMGFDA(101.43,IENS,50.7)="NO"
 
        new temp set temp=$$TrimFDA^TMGDBAPI(.TMGFDA)
        if $data(TMGFDA)=0 goto SOI2
 
        ;"UPDATE RECORD
        do FILE^DIE("EK","TMGFDA","TMGMSG")
        new PriorErrorFound,newIEN
        if $$ShowIfError^TMGDBAPI(.TMGMSG,.PriorErrorFound) goto SOIDone
        set result=1
 
        ;"ADD SET MEMBERSHIP ENTRIES
        ;"NOTE: It seems that the database adds these automatically
        ;"kill TMGFDA,TMGMSG,TMGIEN
        ;"set TMGFDA(101.439,"+1,"_newIEN_",",.01)="RX"
        ;"set TMGFDA(101.439,"+2,"_newIEN_",",.01)="O RX"
        ;"do UPDATE^DIE("ES","TMGFDA","TMGIEN","TMGMSG")
        ;"if $$ShowIfError^TMGDBAPI(.TMGMSG,.PriorErrorFound) quit
SOI2
        new subIEN set subIEN=0
        for  set subIEN=$order(^ORD(101.43,IEN101d43,2,subIEN)) quit:(+subIEN'>0)  do
        . new syn set syn=$piece($get(^ORD(101.43,IEN101d43,2,subIEN,0)),"^",1)
        . if $data(Synonyms(syn))'=0 kill Synonyms(syn) quit ;"no need to add, already present
        . new TMGFDA,TMGMSG
        . set TMGFDA(101.432,subIEN_","_IEN101d43_",",.01)="@" ;"kill unwanted synonyms
        . do FILE^DIE("KE","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
 
        ;"ADD ANY MISSING SYONYMS
        new SynName set SynName=""
        for  set SynName=$order(Synonyms(SynName)) quit:(SynName="")  do
        . kill TMGIEN,TMGFDA,TMGMSG
        . set TMGFDA(101.432,"+1,"_IEN101d43_",",.01)=SynName  ;"was newIEN, change --> IEN101d43
        . do UPDATE^DIE("EKS","TMGFDA","TMGIEN","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . set result=1
SOIDone
        quit result
 
 
InactivateOI
        ;"Purpose: To cycle through records in 101.43 and ensure needed records are
        ;"         inactivated.
 
        write "Scanning entries to ensure inactivation status is synchronized...",!
        new Itr,IEN50d7
        new count set count=0
        new abort set abort=0
        set IEN101d43=$$ItrInit^TMGITR(101.43,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN101d43")
        if IEN101d43'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN101d43)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . new IEN50d7 set IEN50d7=$$GetPOI^TMGNDFUT(IEN101d43)  ;"(will fix bad records)
        . if IEN50d7'>0 quit ;"was bad record, non pharmacy item
        . new date set date=$piece($get(^ORD(101.43,IEN101d43,.1)),"^",1) quit:(date'="") ;"already inactivated
        . if $$IsImport^TMGNDFUT(IEN50d7)=1 quit  ;"is active import --> don't inactivate
        . new TMGFDA,TMGMSG,X,Y
        . set X="NOW" do ^%DT  ;"results return in Y
        . set TMGFDA(101.43,IEN101d43_",",.1)=Y
        . do FILE^DIE("K","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . set count=count+1
        do ProgressDone^TMGITR(.Itr)
 
        write count," entries modified.",!
        do PressToCont^TMGUSRIF
        quit
 
 
SyncActivOI
        ;"Purpose: To cycle through records in 101.43 and ensure needed records are
        ;"         Activated or Inactivation.
 
        write "Scanning entries to ensure activation/inactivation status is synchronized...",!
        new Itr,IEN50d7
        new count set count=0
        new abort set abort=0
        set IEN101d43=$$ItrInit^TMGITR(101.43,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN101d43")
        if IEN101d43'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN101d43)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . new IEN50d7 set IEN50d7=$$GetPOI^TMGNDFUT(IEN101d43)  ;"(will fix bad records)
        . if IEN50d7'>0 quit ;"was bad record, non pharmacy item
        . new date set date=$piece($get(^ORD(101.43,IEN101d43,.1)),"^",1)
        . new pastInactiveDate set pastInactiveDate=0
        . if date'="" do
        . . new X,Y set X="NOW" do ^%DT ;"results in Y
        . . new X1,X2
        . . set X1=Y,X2=date
        . . do ^%DTC  ;"result is X=X1-X2   (X=NOW-InactiveDate) X>-1 means past inactive date
        . . set pastInactiveDate=(X>-1)
        . if $$IsImport^TMGNDFUT(IEN50d7)=1 do
        . . if date="" quit
        . . if 'pastInactiveDate quit
        . . new TMGFDA,TMGMSG,X,Y
        . . set TMGFDA(101.43,IEN101d43_",",.1)="@"
        . . do FILE^DIE("K","TMGFDA","TMGMSG")
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . . set count=count+1
        . else  do  ;"is NOT an active import, so ensure inactivated
        . . if pastInactiveDate quit
        . . new TMGFDA,TMGMSG,X,Y
        . . set X="NOW" do ^%DT  ;"results return in Y
        . . set TMGFDA(101.43,IEN101d43_",",.1)=Y
        . . do FILE^DIE("K","TMGFDA","TMGMSG")
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . . set count=count+1
        do ProgressDone^TMGITR(.Itr)
 
        write count," entries modified.",!
        do PressToCont^TMGUSRIF
        quit
 
 
ResetFiles
        ;"Purpose: For debugging purposes, this will reset two files:
        ;"              101.44, 101.43
 
        ;"CAUTION: make sure you have saved data in the locations below FIRST...
        ;"ALSO: There are many pointers IN to file 101.43.  So if this function is run
        ;"      in a production system (containing valid patient data), then corruption
        ;"      will be introduced.
 
        kill ^TMG("TMP","TEMP BACKUP","^ORD(101.43, 10-16-06")
        merge ^TMG("TMP","TEMP BACKUP","^ORD(101.43, 10-16-06")=^ORD(101.43)
        kill ^ORD(101.43)
        merge ^ORD(101.43)=^TMG("TMP","^ORD(101.43, 10-16-06")
 
        kill ^TMG("TMP","TEMP BACKUP","^ORD(101.44, 10-16-06")
        merge ^TMG("TMP","TEMP BACKUP","^ORD(101.44, 10-16-06")=^ORD(101.44)
        kill ^ORD(101.44)
        merge ^ORD(101.44)=^TMG("TMP","^ORD(101.44, 10-16-06")
 
        quit
 
 ;"-----------------------------------
VerifySync
        ;"Purpose: to verify that links PHARMACY ORDERABLE ITEM --> ORDERABLE ITEM
        ;"      are correct.  Link is based on a text pointer (and I think less likely
        ;"      to have been fixed with multiple runs...)
 
        new fixArray
 
        write "Scanning entries to ensure link is correctly synchronized...",!
        new Itr,IEN50d7
        new abort set abort=0
        set IEN101d43=$$ItrInit^TMGITR(101.43,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN101d43")
        if IEN101d43'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN101d43)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . new date set date=$piece($get(^ORD(101.43,IEN101d43,.1)),"^",1)
        . if $$OIInactive^TMGNDFUT(IEN101d43) quit  ;"ignore inactivate entries
        . set IEN50d7=$$GetPOI^TMGNDFUT(IEN101d43)  ;"(will fix bad records)
        . if IEN50d7'>0 quit ;"was bad record, non pharmacy item
        . new OIName set OIName=$piece($get(^ORD(101.43,IEN101d43,0)),"^",1)
        . new POIName set POIName=$piece($get(^PS(50.7,IEN50d7,0)),"^",1)
        . if (OIName'=POIName) do
        . . write !,OIName," (OI #",IEN101d43,") <-- ",POIName," (POI #",IEN50d7,") ??",!
        . . set fixArray(IEN50d7,IEN101d43)=""
        . if (OIName="") do
        . . write !,"NULL NAME.  (OI #",IEN101d43,") <-- ",POIName," (POI #",IEN50d7,") ??",!
        . . set fixArray(IEN50d7,IEN101d43)=""
        . if $$IsImport^TMGNDFUT(IEN50d7)=0 do
        . . write "   50.7 #",IEN50d7,"  ",POIName," is not an active import!",!
        . . set fixArray(IEN50d7,IEN101d43)="@"
        do ProgressDone^TMGITR(.Itr)
 
        new IEN50d7 set IEN50d7=""
        for  set IEN50d7=$order(fixArray(IEN50d7)) quit:(IEN50d7="")  do
        . new POIName set POIName=$piece($get(^PS(50.7,IEN50d7,0)),"^",1)
        . new IEN50Array
        . do GetDRUGs^TMGNDFUT(IEN50d7,.IEN50Array,1)
        . new Name50 set Name50=""
        . for  set Name50=$order(IEN50Array(Name50)) quit:(Name50="")  do
        . . new IEN50 set IEN50=""
        . . for  set IEN50=$order(IEN50Array(Name50,IEN50)) quit:(IEN50="")  do
        . . . write "File 50, #",IEN50,": ",Name50,"  ",$piece($get(^PSDRUG(IEN50,0)),"^",1)," -->",!
        . write "  POI Name=",POIName," --> ",!
        . new IEN101d43 set IEN101d43=""
        . for  set IEN101d43=$order(fixArray(IEN50d7,IEN101d43)) quit:(IEN101d43="")  do
        . . if $get(fixArray(IEN50d7,IEN101d43))="@" do  quit
        . . . new TMGFDA,TMGMSG,PSEDITNM
        . . . set PSEDITNM=1
        . . . set TMGFDA(50.7,IEN50d7_",",.01)="@"
        . . . do FILE^DIE("","TMGFDA","TMGMSG")
        . . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . . . kill TMGFDA,TMGMSG
        . . . set TMGFDA(101.43,IEN101d43_",",.01)="@"
        . . . do FILE^DIE("","TMGFDA","TMGMSG")
        . . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . . new OIName set OIName=$piece($get(^ORD(101.43,IEN101d43,0)),"^",1)
        . . write "    OI Name=",OIName,!
        . . new result
        . . set result=$$StuffOI(IEN101d43,POIName,,IEN50d7) ;"result 1=modified
 
        ;"Now verify ID cross reference
 
 
        do PressToCont^TMGUSRIF
        quit
 
 
Check4Dups ;"DON'T USE.  There are times when the "TRADE" name will actually be a generic
           ;"name, and then the chains between generic and trade name drugs get crossed.
           ;"An OI can only point to 1 POI, so one could cause a situation whereby
           ;"Trade POI --> OI, but OI --> Generic POI (and Trade POI gets lost)
 
        ;"Purpose: to ensure that there are not two entries in the ORDERABLE ITEM
        ;"         file with the same name.
 
        new array,dupArray
 
        new Itr,IEN
        new abort set abort=0
        new count set count=0
        set IEN=$$ItrInit^TMGITR(101.43,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:(+$$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . new name set name=$piece($get(^ORD(101.43,IEN,0)),"^",1)
        . new priorIEN set priorIEN=+$order(array(name,""))
        . if priorIEN'=0 do
        . . write !,name," previously found...",!
        . . set dupArray(name,priorIEN)=""
        . . set dupArray(name,IEN)=""
        . set array(name,IEN)=""
        do ProgressDone^TMGITR(.Itr)
        if abort=1 goto C4DDone
 
        new Itr,fixName
        set fixName=$$ItrAInit^TMGITR("dupArray",.Itr)
        do PrepProgress^TMGITR(.Itr,1,1,"fixName")
        if fixName'="" for  do  quit:($$ItrANext^TMGITR(.Itr,.fixName)="")!abort
        . new IEN101d43 set IEN101d43=""
        . new keepIEN set keepIEN=""
        . for  set IEN101d43=$order(dupArray(fixName,IEN101d43)) quit:(IEN101d43="")  do
        . . if keepIEN="" set keepIEN=IEN101d43 quit ;"use first record as one to keep.
        . . do RedirOI^TMGNDFUT(IEN101d43,keepIEN)
        . . do KillOI^TMGNDFUT(IEN101d43)
        . . set count=count+1
        do ProgressDone^TMGITR(.Itr)
 
C4DDone
        write !,count," Modifications Made.",!
        do PressToCont^TMGUSRIF
        quit
 
 
 
 
CheckDangle
        ;"Purpose: to verify that ORDERABLE ITEM records are not dangling records
 
        new delArray
 
        write "Scanning entries checking for dangling records...",!
        new Itr,IEN50d7,TMGArray,ID,Info
        new abort set abort=0
        set IEN101d43=$$ItrInit^TMGITR(101.43,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN101d43")
        if IEN101d43'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN101d43)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . new OIArray
        . do GetOIInfo^TMGNDFUT(IEN101d43,.OIArray)
        . if $get(OIArray("IEN 101.43","INACTIVE"))=1 quit  ;"ignore inactivated records
        . new pkg set pkg=$get(OIArray("IEN 101.43","PACKAGE"))
        . if (pkg'="")&(pkg'["PSP") quit  ;" -- not a pharmacy item, so ignore
        . set IEN50d7=+$get(OIArray("IEN 50.7 from 101.43"))
        . new OIName set OIName=$get(OIArray("IEN 101.43","NAME"))
        . ;"if OIName'="<DUPLICATE>" quit  ;"temporary....
        . new POIName set POIName=$get(OIArray("IEN 50.7 from 101.43","NAME"))
        . if IEN50d7=0 do
        . . write !,"Record 101.43 #",IEN101d43," (",OIName,") doesn't point to any PHARMACY ORDERABLE ITEM",!
        . . set delArray(IEN101d43)=""
        . else  if $$IsImport^TMGNDFUT(IEN50d7)=0 do
        . . write !,"Record 101.43 #",IEN101d43," (",OIName,") points to PHARMACY ORDERABLE ITEM (50.7)#",IEN50d7,!
        . . write "  But 50.7 #",IEN50d7,"  (",POIName,") is not an active import!",!
        do ProgressDone^TMGITR(.Itr)
 
        new count set count=$$ListCt^TMGMISC("delArray")
        write count," records to be deleted.",!
 
        if count>0 do
        . new % set %=1
        . write "Delete records now" do YN^DICN write !
        . if %'=1 quit
        . set IEN101d43=""
        . for  set IEN101d43=$order(delArray(IEN101d43)) quit:(IEN101d43="")  do
        . . do KillOI^TMGNDFUT(IEN101d43)
        . write "Done.",!
        . do PressToCont^TMGUSRIF
        else  do PressToCont^TMGUSRIF
 
        quit
 
 
 
