TMGNDF0A ;TMG/kst/FDA Import: Load FDA data files ;03/25/06
         ;;1.0;TMG-LIB;**1**;11/21/06

 ;" FDA - NATIONAL DRUG FILES IMPORT FUNCTIONS
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"11-21-2006

 ;"Purpose: to import the National Drug Files, as distributed by:
 ;"      http://www.fda.gov/cder/ndc/  in format as of 10/17/2005
 ;"      List of files imported:
 ;"              TMG FDA APPLICATION (22706.1) <--> applicat.TXT
 ;"              TMG FDA DOSAGE FORM (22706.2) <--> dosform.TXT
 ;"              TMG FDA FIRMS (22706.3) <--> FIRMS.TXT ;was firms.txt
 ;"              TMG FDA FORMULATION (22706.4) <--> FORMULAT.TXT
 ;"              TMG FDA LISTING (22706.5) <--> listings.TXT ;was listings.txt
 ;"              TMG FDA PACKAGES (22706.6) <--> packages.txt
 ;"              TMG FDA ROUTES (22706.7) <--> ROUTES.TXT ;was routes.txt
 ;"              TMG FDA UNIT ABBREVIATIONS (22706.8) <--> TBLUNIT.TXT ; was tblunit.txt

 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"Menu -- The starting menu for the import process

 ;"=======================================================================
 ;" API -- Semi-Public Functions.
 ;"=======================================================================
 ;"ImportNDF
 ;"$$DataImport(Info,ProgressFN)
 ;"Backup

 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 ;"SetLoadDir(LoadDir)
 ;"$$LoadApplication(LoadDir)
 ;"$$LoadDosageForm(LoadDir)
 ;"$$LoadFirms(LoadDir)
 ;"$$LoadFormulation(LoadDir)
 ;"$$LoadListing(LoadDir)
 ;"$$LoadPackages(LoadDir)
 ;"$$LoadRoutes(LoadDir)
 ;"$$LoadUnitAbbr(LoadDir)
 ;"SetSkipFlag

 ;"=======================================================================
 ;"=======================================================================
Menu
        ;"Purpose: To give an interactive menu

        new Menu,UsrSlct
        set Menu(0)="Pick Option for Parsing FDA Tables (0A)"
        set Menu(1)="Review instructions"_$char(9)_"Instructions"
        set Menu(2)="Parse FDA tables into corresponding Fileman Tables"_$char(9)_"ParseAll"
        ;"set Menu("P")="Prev Stage"_$char(9)_"Prev"
        set Menu("N")="Next Stage"_$char(9)_"Next"

CD1
        write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
        if UsrSlct="^" goto CDDone
        if UsrSlct=0 set UsrSlct=""

        ;"if UsrSlct="Prev" goto Menu^TMGNDF1D  ;"quit can occur from there...
        if UsrSlct="Next" goto Menu^TMGNDF0B  ;"quit can occur from there...
        if UsrSlct="Instructions" do Instructions goto CD1
        if UsrSlct="ParseAll" do ImportNDF goto CD1
        goto CD1
CDDone
        quit

 ;"=======================================================================

Instructions
        ;"Purpose: to show some instructions

        write !!
        write "The individual tables from the FDA should be downloaded from: ",!
        write " www.fda.gov/cder/ndc",!
        write !
        write "Reloading these files will NOT immediately overwrite changes made",!
        write "the COMPILED import data.  It will simply get the FDA tables",!
        write "into a format for later compilation.",!
        write "The choices made later (or perhaps on a previous cycle) will NOT",!
        write "be lost by reloading these files.  There really is no need to",!
        write "be cautious on this step.",!
        write !
        write "Note: the instructions on the FDA website should be compared to the",!
        write "parsing code in TMGNDF0A.m to ensure that the FDA table format has",!
        write "not changed.",!,!

        do PressToCont^TMGUSRIF
        quit

 ;"=======================================================================
 ;"Note: these files were downloaded from:
 ;"      www.fda.gov/cder/ndc

ImportNDF
        ;"Purpose: to import the National Drug Files, as distributed by:
        ;"      http://www.fda.gov/cder/ndc/, in format as of 10/17/2005
        ;"      List of files imported:
        ;"              TMG FDA APPLICATION <--> applicat.TXT
        ;"              TMG FDA DOSAGE FORM <--> dosform.TXT
        ;"              TMG FDA FIRMS <--> FIRMS.TXT ;was firms.txt
        ;"              TMG FDA FORMULATION <--> FORMULAT.TXT
        ;"              TMG FDA LISTING <--> listings.TXT ;was listings.txt
        ;"              TMG FDA PACKAGES <--> packages.txt
        ;"              TMG FDA ROUTES <--> ROUTES.TXT ;was routes.txt
        ;"              TMG FDA UNIT ABBREVIATIONS <--> TBLUNIT.TXT ; was tblunit.txt
        ;"Prerequisites: Must have Fileman files created to import into

        new LoadDir
        new PriorErrorFound
        new ProgressFn
        set ProgressFn="if TMGCUR#100=1 do ProgressBar^TMGUSRIF(TMGCUR,""Progress"",0,TMGTOTAL,,StartTime)"

        write "Custom FDA Drug Files Importer",!!
        write "This will DELETE all exsting entries in TMG FDA * files,",!
        write "and then reload them from source text files.",!
        write "These are temporary files, not VistA files.",!
        write "Do you want to proceed? "
        set %=2 ;"2=NO default
        do YN^DICN
        write !
        if %'=1 goto INDFError
        if $$SetLoadDir(.LoadDir)=0 goto INDFError

        new skip set skip=0
        write "Loading TMG FDA APPLICATIONS",!
        if 'skip if $$LoadApplication(LoadDir)=0 goto INDFError
        write "Loading TMG FDA DOSAGE FORMS",!
        if 'skip if $$LoadDosageForm(LoadDir)=0 goto INDFError
        write "Loading TMG FDA firms",!
        if 'skip if $$LoadFirms(LoadDir)=0 goto INDFError
        write "Loading TMG FDA FORMULATIONS",!
        if 'skip if $$LoadFormulation(LoadDir)=0 goto INDFError
        write "Loading TMG FDA PACKAGES",!
        if 'skip if $$LoadPackages(LoadDir)=0 goto INDFError
        write "Loading TMG FDA ROUTES",!
        if 'skip if $$LoadRoutes(LoadDir)=0 goto INDFError
        write "Loading TMG FDA UNIT ABBREVIATIONS",!
        if 'skip if $$LoadUnitAbbr(LoadDir)=0 goto INDFError
        write "Loading TMG FDA LISTINGS",!
        if 'skip if $$LoadListing(LoadDir)=0 goto INDFError

        write "All done.  Import Successful.",!
        goto INDFDone

INDFError
        Write "Import was NOT successful.  Quitting.",!

INDFDone
        quit


SetLoadDir(LoadDir)
        ;"Purpose to ensure that LoadDir is set properly
        ;"LoadDir -- PASS BY REFERENCE, an OUT parameter
        ;"Result: 1=success, 0=error

        new Msg
        new result set result=1
        set Msg="Please Pick ANY file in the directory containing NDF files"
        new defDir set defDir="/home/kdt0p/downloads/FDA-NDC-Files/"
        if $$GetFName^TMGIOUTL(Msg,defDir,,,.LoadDir)="" do
        . set result=0

        quit result


LoadApplication(LoadDir)
        ;"Purpose: to load  from applicat.TXT
        ;"Input: LoadDir -- the directory in HFS to get files from
        ;"Output: Kills any prior entries in TMG FDA APPLICATION
        ;"NOTICE: any pointers to this fill might me made invalid via kills
        ;"Result: 1=success, 0=error

        ;"      Info("HFS DIR")=<directory name in HFS to load from>
        ;"      Info("HFS FILE")=<file name in HFS to load from>
        ;"      Info("DEST FILE")=<file name or number>
        ;"      Info(x)=field#  (or "IEN" if data should be used to determine record number
        ;"      Info(x,"START")=starting column
        ;"      Info(x,"END")=ending column

        ;"FDA documentation for 9/12/2007,4/6/09 file:
        ;"=====================================
        ;"MAY OCCUR MORE THAN ONCE PER LISTING SEQ NO.
        ;"LISTING_SEQ_NO NOT NULL NUM(7) COL:1-7
        ;"   Linking field to LISTINGS.
        ;"APPL_NO NULL CHAR(6) COL:9-14
        ;"   Number of New Drug Application if applicable. If none has been
        ;"   provided by the firm then the value ‘Other’ is used.
        ;"PROD_NO NULL CHAR(3) COL:16-18
        ;"  Number used to identify the products of a New Drug Application.
        ;"=====================================
        ;"Log:
        ;" 10/20/07 -- modified for 9/12/07 database
        ;" 4/8/09 -- no changes needed for 4/6/09 version of file

        new Info
        new result

        ;"Note: should Kill all prior records...
        ;"Note: This will blow away ALL records, cross references etc.
        ;"       This is not considered good programming practice!
        new temp set temp=$get(^TMG(22706.1,0))
        kill ^TMG(22706.1)
        set $piece(temp,"^",3)=""
        set $piece(temp,"^",4)=0
        set ^TMG(22706.1,0)=temp  ;"fix up the 0 node

        set Info("HFS DIR")=$get(LoadDir)
        set Info("HFS FILE")="applicat.txt"  ;" was applicat.TXT before
        set Info("DEST FILE")="TMG FDA APPLICATION"

        new tempFile set tempFile=Info("HFS DIR")_Info("HFS FILE")
        set result=$$Dos2Unix^TMGIOUTL(tempFile)
        if result>0 set result=0 goto LADone

        ;"LISTING_SEQ_NO NOT NULL NUM(7) COL:1-7
        ;"Linking field to LISTINGS.
        set Info(.01)=.01  ;"Listing, pointer to 22706.5
        set Info(.01,"START")=1  ;"was 1
        set Info(.01,"END")=7    ;"was 8

        ;"APPL_NO NULL CHAR(6) COL:10-15
        ;"Number of New Drug Application if applicable.
        ;"If none has been provided by the firm then the value ‘Other’ is used.
        set Info(1)=1  ;"Application
        set Info(1,"START")=9  ;"was 10 <-- was 9
        set Info(1,"END")=14   ;"was 15 <-- was 15

        ;"PROD_NO NULL CHAR(3) COL:17-19
        ;"Number used to identify the products of a New Drug Application. .
        set Info(2)=2  ;"Product Number
        set Info(2,"START")=16  ;"was 17 <-- was 16
        set Info(2,"END")=18    ;"was 19 <-- was 22

        new StartTime set StartTime=$H
        set result=$$DataImport(.Info,ProgressFn)
        do ProgressBar^TMGUSRIF(100,"Progress",0,100)

LADone
        quit result


LoadDosageForm(LoadDir)
        ;"Purpose: to load TMG FDA DOSAGE FORM <--> doseform.TXT
        ;"Input: LoadDir -- the directory in HFS to get files from
        ;"Output: Kills any prior entries in TMG FDA DOSAGE FORM
        ;"NOTICE: any pointers to this fill might me made invalid via kills
        ;"Result: 1=success, 0=error

        ;"FDA documentation for 9/12/2007,4/6/09 file:
        ;"=====================================
        ;"MAY OCCUR MULTIPLE TIMES PER LISTING SEQ NO.
        ;"LISTING_SEQ_NO NOT NULL NUM(7) COL:1-7
        ;"   Linking field to LISTINGS.
        ;"DOSEFORM NULL CHAR(3) COL:9-11
        ;"   The code for the route of administration. File will allow all assigned values for this element.
        ;"DOSAGE_NAME NULL CHAR(240) COL:13-252
        ;"   The translation for the route of administration code.
        ;"=====================================
        ;"Log:
        ;" 10/20/07 -- no modification needed for 9/12/07 database
        ;" 4/8/09 -- no changes needed for 4/6/09 version of file

        new Info
        new result

        ;"Note: should Kill all prior records...
        ;"Note: This will blow away ALL records, cross references etc.
        ;"       This is not considered good programming practice!
        new temp set temp=$get(^TMG(22706.2,0))
        kill ^TMG(22706.2)
        set $piece(temp,"^",3)=""
        set $piece(temp,"^",4)=0
        set ^TMG(22706.2,0)=temp  ;"fix up the 0 node

        set Info("HFS DIR")=$get(LoadDir)
        set Info("HFS FILE")="doseform.TXT"
        set Info("DEST FILE")="TMG FDA DOSAGE FORM"

        new tempFile set tempFile=Info("HFS DIR")_Info("HFS FILE")
        set result=$$Dos2Unix^TMGKERNL(tempFile)
        if result>0 set result=0 goto LDsDone

        ;"LISTING_SEQ_NO NOT NULL NUM(7) COL:1-7
        ;"Linking field to LISTINGS.
        set Info(.01)=.01  ;"Listing, pointer to 22706.5
        set Info(.01,"START")=1  ;"was 1
        set Info(.01,"END")=7    ;"was 8

        ;"DOSEFORM NULL CHAR(3) COL:9-11
        ;"The code for the route of administration. File will allow all assigned values for this element.
        set Info(1)=1  ;"Dosage form
        set Info(1,"START")=9   ;"was 9
        set Info(1,"END")=11    ;"was 12

        ;"DOSAGE_NAME NULL CHAR(240) COL:13-252
        ;"The translation for the route of administration code.
        set Info(2)=2  ;"Dosage Name
        set Info(2,"START")=13  ;"was 13
        set Info(2,"END")=252   ;"was 128

LDL2
        new StartTime set StartTime=$H
        set result=$$DataImport(.Info,ProgressFn)
        do ProgressBar^TMGUSRIF(100,"Progress",0,100)

LDsDone
        quit result


LoadFirms(LoadDir)
        ;"Purpose: to load TMG FDA FIRMS <--> FIRMS.TXT ;was firms.txt
        ;"Input: LoadDir -- the directory in HFS to get files from
        ;"Output: Kills any prior entries in TMG FDA FIRMS
        ;"NOTICE: any pointers to this fill might me made invalid via kills
        ;"Result: 1=success, 0=error

        ;"FDA documentation for 9/12/2007,4/6/09 file:
        ;"=====================================
        ;"EACH FIRM HAS A UNIQUE FIRM SEQ NO WHICH CAN OCCUR MULTIPLE TIMES IN THE LISTINGS FILE.
        ;"Contains the firm's full name, and compliance address. The compliance address is the mailing address where the FDA sends listing information to the firm.
        ;"LBLCODE  NOT NULL NUM(6) COL:1-6
        ;"  FDA generated identification number for each firm. The number is padded to the left with zeroes to fill out to length 6.
        ;"FIRM_NAME NOT NULL CHAR(65) COL:8-72
        ;"  Firm name as reported by the firm.
        ;"ADDR_HEADER NULL CHAR(40) COL:74-113
        ;"  Address Heading as reported by the firm.
        ;"STREET NULL CHAR(40) COL:115-154
        ;"  Street Address as reported by firm.
        ;"PO_BOX NULL CHAR(9) COL:156-164
        ;"  Post office box number as reported by firm.
        ;"FOREIGN_ADDR NULL CHAR(40) COL:166-205
        ;"  Address information report by firm for foreign countries that does not fit the U.S. Postal service configuration.
        ;"CITY NULL CHAR(30) COL:207-236
        ;"STATE NULL CHAR(2) COL:238-239
        ;"ZIP NULL CHAR(9) COL:241-249
        ;"USPS Zip code.
        ;"PROVINCE NULL CHAR(30) COL:251-280
        ;"  Province of Foreign country if appropriate.
        ;"COUNTRY_NAME NOT NULL CHAR(40) COL:282-321
        ;"=====================================
        ;"Log:
        ;" 10/20/07 -- no modification needed for 9/12/07 database
        ;" 4/8/09 -- no changes needed for 4/6/09 version of file

        new Info
        new result

        ;"Note: should Kill all prior records...
        ;"Note: This will blow away ALL records, cross references etc.
        ;"       This is not considered good programming practice!
        new temp set temp=$get(^TMG(22706.3,0))
        kill ^TMG(22706.3)
        set $piece(temp,"^",3)=""
        set $piece(temp,"^",4)=0
        set ^TMG(22706.3,0)=temp  ;"fix up the 0 node

        set Info("HFS DIR")=$get(LoadDir)
        set Info("HFS FILE")="FIRMS.TXT"  ;"was firms.txt
        set Info("DEST FILE")="TMG FDA FIRMS"

        new tempFile set tempFile=Info("HFS DIR")_Info("HFS FILE")
        set result=$$Dos2Unix^TMGIOUTL(tempFile)
        if result>0 set result=0 goto LFrDone

        ;"LBLCODE  NOT NULL NUM(6) COL:1-6
        ;"FDA generated identification number for each firm.
        ;"The number is padded to the left with zeroes to fill out to length 6.
        set Info(1)=1  ;"Label Code
        set Info(1,"START")=1
        set Info(1,"END")=6

        ;"FIRM_NAME NOT NULL CHAR(65) COL:8-72
        ;"Firm name as reported by the firm.
        set Info(.01)=.01  ;"Name
        set Info(.01,"START")=8
        set Info(.01,"END")=72

        ;"ADDR_HEADER NULL CHAR(40) COL:74-113
        ;"Address Heading as reported by the firm.
        set Info(2)=2  ;"Address Header
        set Info(2,"START")=74
        set Info(2,"END")=113

        ;"STREET NULL CHAR(40) COL:115-154
        ;"Street Address as reported by firm.
        set Info(3)=3  ;"Street
        set Info(3,"START")=115
        set Info(3,"END")=154

        ;"PO_BOX NULL CHAR(9) COL:156-164
        ;"Post office box number as reported by firm.
        set Info(4)=4  ;"PO Box
        set Info(4,"START")=156
        set Info(4,"END")=164

        ;"FOREIGN_ADDR NULL CHAR(40) COL:166-205
        ;"Address information report by firm for foreign
        ;"countries that does not fit the U.S. Postal service configuration.
        set Info(5)=5  ;"Foreign Address
        set Info(5,"START")=166
        set Info(5,"END")=205

        ;"CITY NULL CHAR(30) COL:207-236
        set Info(6)=6  ;"City
        set Info(6,"START")=207
        set Info(6,"END")=236

        ;"STATE NULL CHAR(2) COL:238-239
        set Info(7)=7  ;"State
        set Info(7,"START")=238
        set Info(7,"END")=239

        ;"ZIP NULL CHAR(9) COL:241-249
        ;"USPS Zip code.
        set Info(8)=8  ;"ZIP
        set Info(8,"START")=241
        set Info(8,"END")=249

        ;"PROVINCE NULL CHAR(30) COL:251-280
        ;"Province of Foreign country if appropriate.
        set Info(9)=9  ;"Province
        set Info(9,"START")=251
        set Info(9,"END")=280

        ;"COUNTRY_NAME NOT NULL CHAR(40) COL:282-321
        set Info(10)=10  ;"Country
        set Info(10,"START")=282
        set Info(10,"END")=321

        new StartTime set StartTime=$H
        set result=$$DataImport(.Info,ProgressFn)
        do ProgressBar^TMGUSRIF(100,"Progress",0,100)

LFrDone
        quit result


LoadFormulation(LoadDir)
        ;"Purpose: to load TMG FDA FORMULATION <--> FORMULAT.TXT
        ;"Input: LoadDir -- the directory in HFS to get files from
        ;"Output: Kills any prior entries in TMG FDA FIRMS
        ;"NOTICE: any pointers to this fill might me made invalid via kills
        ;"Result: 1=success, 0=error

        ;"FDA documentation for 9/12/2007,4/6/09 file:
        ;"=====================================
        ;"MAY OCCUR MULTIPLE TIMES PER LISTING SEQ NO.
        ;"Lists active ingredients contained in product's formulation.
        ;"LISTING_SEQ_NO NOT NULL NUM(7) COL: 1-7
        ;"  Linking field to LISTINGS.
        ;"STRENGTH NULL CHAR(10) COL: 9-18
        ;"  This is the potency of the active ingredient.
        ;"UNIT NULL CHAR(5) COL: 20-24
        ;"  Unit of measure corresponding to strength.
        ;"INGREDIENT_NAME NOT NULL CHAR(100) COL: 26-125
        ;"  Truncated preferred term for the active ingredient.
        ;"=====================================
        ;"Log:
        ;" 10/20/07 -- no modification needed for 9/12/07 database
        ;" 4/8/09 -- no changes needed for 4/6/09 version of file

        new Info
        new result

        ;"Note: should Kill all prior records...
        ;"Note: This will blow away ALL records, cross references etc.
        ;"       This is not considered good programming practice!
        new temp set temp=$get(^TMG(22706.4,0))
        kill ^TMG(22706.4)
        set $piece(temp,"^",3)=""
        set $piece(temp,"^",4)=0
        set ^TMG(22706.4,0)=temp  ;"fix up the 0 node

        set Info("HFS DIR")=$get(LoadDir)
        set Info("HFS FILE")="FORMULAT.TXT"
        set Info("DEST FILE")="TMG FDA FORMULATION"

        new tempFile set tempFile=Info("HFS DIR")_Info("HFS FILE")
        set result=$$Dos2Unix^TMGIOUTL(tempFile)
        if result>0 set result=0 goto LFmDone

        ;"LISTING_SEQ_NO NOT NULL NUM(7) COL: 1-7
        ;"Linking field to LISTINGS.
        set Info(.01)=.01  ;"Listing
        set Info(.01,"START")=1
        set Info(.01,"END")=7

        ;"STRENGTH NULL CHAR(10) COL: 9-18
        ;"This is the potency of the active ingredient.
        set Info(1)=1  ;"Strength
        set Info(1,"START")=9
        set Info(1,"END")=18

        ;"UNIT NULL CHAR(5) COL: 20-24
        ;"Unit of measure corresponding to strength.
        set Info(2)=2  ;"Unit
        set Info(2,"START")=20
        set Info(2,"END")=24

        ;"INGREDIENT_NAME NOT NULL CHAR(100) COL: 26-125
        ;"Truncated preferred term for the active ingredient.
        set Info(3)=3  ;"Ingredient Name
        set Info(3,"START")=26
        set Info(3,"END")=125

        new StartTime set StartTime=$H
        set result=$$DataImport(.Info,ProgressFn)
        do ProgressBar^TMGUSRIF(100,"Progress",0,100)

LFmDone
        quit result


LoadPackages(LoadDir)
        ;"Purpose: to load TMG FDA PACKAGES <--> packages.txt
        ;"Input: LoadDir -- the directory in HFS to get files from
        ;"Output: Kills any prior entries in TMG FDA FIRMS
        ;"NOTICE: any pointers to this fill might me made invalid via kills
        ;"Result: 1=success, 0=error

        ;"FDA documentation for 9/12/2007,4/6/09 file:
        ;"=====================================
        ;"MAY OCCUR MULTIPLE TIMES PER LISTING SEQ NO
        ;"Stores packages for an individual listing. The packages table includes all packages for a corresponding listing. The PKGCODE field contains the last one or two digit segment of the NDC.
        ;"LISTING_SEQ_NO NOT NULL NUM(7) COL: 1-7
        ;"  Linking field to LISTINGS.
        ;"PKGCODE NULL CHAR(2) COL: 9-10
        ;"  The package code portion of NDC code. The package code is the last segment of the NDC.
        ;"PACKSIZE NOT NULL CHAR(25) COL: 12-36
        ;"  The unit or number of units which make up a package.
        ;"PACKTYPE NOT NULL CHAR(25) COL: 38-62
        ;"  Package type, i.e., box, bottle, vial, plastic, or glass.
        ;"=====================================
        ;"Log:
        ;" 10/20/07 -- no modification needed for 9/12/07 database
        ;" 4/8/09 -- no changes needed for 4/6/09 version of file

        new Info
        new result

        ;"Note: should Kill all prior records...
        ;"Note: This will blow away ALL records, cross references etc.
        ;"       This is not considered good programming practice!
        new temp set temp=$get(^TMG(22706.6,0))
        kill ^TMG(22706.6)
        set $piece(temp,"^",3)=""
        set $piece(temp,"^",4)=0
        set ^TMG(22706.6,0)=temp  ;"fix up the 0 node

        set Info("HFS DIR")=$get(LoadDir)
        set Info("HFS FILE")="packages.txt"
        set Info("DEST FILE")="TMG FDA PACKAGES"

        new tempFile set tempFile=Info("HFS DIR")_Info("HFS FILE")
        set result=$$Dos2Unix^TMGIOUTL(tempFile)
        if result>0 set result=0 goto LPkDone

        ;"LISTING_SEQ_NO NOT NULL NUM(7) COL: 1-7
        ;"Linking field to LISTINGS.
        set Info(.01)=.01  ;"Listing
        set Info(.01,"START")=1
        set Info(.01,"END")=7

        ;"PKGCODE NULL CHAR(2) COL: 9-10
        ;"The package code portion of NDC code. The package
        ;"code is the last segment of the NDC.
        set Info(1)=1  ;"Code
        set Info(1,"START")=9
        set Info(1,"END")=10

        ;"PACKSIZE NOT NULL CHAR(25) COL: 12-36
        ;"The unit or number of units which make up a package.
        set Info(2)=2  ;"Size
        set Info(2,"START")=12
        set Info(2,"END")=36

        ;"PACKTYPE NOT NULL CHAR(25) COL: 38-62
        ;"Package type, i.e., box, bottle, vial, plastic, or glass.
        set Info(3)=3  ;"Type
        set Info(3,"START")=38
        set Info(3,"END")=62

        new StartTime set StartTime=$H
        set result=$$DataImport(.Info,ProgressFn)
        do ProgressBar^TMGUSRIF(100,"Progress",0,100)

LPkDone
        quit result


LoadRoutes(LoadDir)
        ;"Purpose: to load TMG FDA ROUTES <--> ROUTES.TXT ;was routes.txt
        ;"Input: LoadDir -- the directory in HFS to get files from
        ;"Output: Kills any prior entries in TMG FDA FIRMS
        ;"NOTICE: any pointers to this fill might me made invalid via kills
        ;"Result: 1=success, 0=error

        ;"FDA documentation for 9/12/2007,4/6/09 file:
        ;"=====================================
        ;"LISTING_SEQ_NO NOT NULL NUM(7) COL:1-7
        ;"  Linking field to LISTINGS.
        ;"ROUTE_CODE NULL CHAR(3) COL:9-11
        ;"  The code for the route of administration. File will allow all assigned values for this element.
        ;"ROUTE_NAME NULL CHAR(240) COL:13-252
        ;"  The translation for the route of administration code.
        ;"=====================================
        ;"Log:
        ;" 10/20/07 -- no modification needed for 9/12/07 database
        ;" 4/8/09 -- no changes needed for 4/6/09 version of file

        new Info
        new result

        ;"Note: should Kill all prior records...
        ;"Note: This will blow away ALL records, cross references etc.
        ;"       This is not considered good programming practice!
        new temp set temp=$get(^TMG(22706.7,0))
        kill ^TMG(22706.7)
        set $piece(temp,"^",3)=""
        set $piece(temp,"^",4)=0
        set ^TMG(22706.7,0)=temp  ;"fix up the 0 node

        set Info("HFS DIR")=$get(LoadDir)
        set Info("HFS FILE")="ROUTES.TXT"  ;"was routes.txt
        set Info("DEST FILE")="TMG FDA ROUTES"

        new tempFile set tempFile=Info("HFS DIR")_Info("HFS FILE")
        set result=$$Dos2Unix^TMGIOUTL(tempFile)
        if result>0 set result=0 goto LRtDone

        ;"LISTING_SEQ_NO NOT NULL NUM(7) COL:1-7
        ;"Linking field to LISTINGS.
        set Info(.01)=.01  ;"Listing
        set Info(.01,"START")=1
        set Info(.01,"END")=7

        ;"ROUTE_CODE NULL CHAR(3) COL:9-11
        ;"The code for the route of administration.
        ;"File will allow all assigned values for this element.
        set Info(1)=1  ;"Code
        set Info(1,"START")=9
        set Info(1,"END")=11

        ;"ROUTE_NAME NULL CHAR(240) COL:13-252
        ;"The translation for the route of administration code.
        set Info(2)=2  ;"Name
        set Info(2,"START")=13
        set Info(2,"END")=252

        new StartTime set StartTime=$H
        set result=$$DataImport(.Info,ProgressFn)
        do ProgressBar^TMGUSRIF(100,"Progress",0,100)

LRtDone
        quit result


LoadUnitAbbr(LoadDir)
        ;"Purpose: to load FDA UNIT ABBREVIATIONS <--> TBLUNIT.TXT ; was tblunit.txt
        ;"Input: LoadDir -- the directory in HFS to get files from
        ;"Output: Kills any prior entries in TMG FDA FIRMS
        ;"NOTICE: any pointers to this fill might me made invalid via kills
        ;"Result: 1=success, 0=error

        ;"FDA documentation for 9/12/2007,4/6/09 file:
        ;"=====================================
        ;"THIS FILE CONTAINS A COMPLETE LIST OF THE POTENCY UNIT ABBREVIATIONS USED IN THE DIRECTORY.
        ;"UNIT CHAR(15) COL:1-15
        ;"  The potency unit abbreviations used in the directory.
        ;"TRANSLATION CHAR(100) COL:17-115
        ;"  The translation for the UNIT abbreviations.
        ;"=====================================
        ;"Log:
        ;" 10/20/07 -- no modification needed for 9/12/07 database

        new Info
        new result

        ;"Note: should Kill all prior records...
        ;"Note: This will blow away ALL records, cross references etc.
        ;"       This is not considered good programming practice!
        new temp set temp=$get(^TMG(22706.8,0))
        kill ^TMG(22706.8)
        set $piece(temp,"^",3)=""
        set $piece(temp,"^",4)=0
        set ^TMG(22706.8,0)=temp  ;"fix up the 0 node

        set Info("HFS DIR")=$get(LoadDir)
        set Info("HFS FILE")="TBLUNIT.TXT"  ;"was tblunit.txt
        set Info("DEST FILE")="FDA UNIT ABBREVIATIONS"

        new tempFile set tempFile=Info("HFS DIR")_Info("HFS FILE")
        set result=$$Dos2Unix^TMGIOUTL(tempFile)
        if result>0 set result=0 goto LUADone

        ;"UNIT CHAR(15) COL:1-15
        ;"The potency unit abbreviations used in the directory.
        set Info(.01)=.01  ;"Abbreviation
        set Info(.01,"START")=1
        set Info(.01,"END")=15

        ;"TRANSLATION CHAR(100) COL:17-115
        ;"The translation for the UNIT abbreviations.
        set Info(1)=1  ;"Description
        set Info(1,"START")=17
        set Info(1,"END")=115   ;"was 250 before

        new StartTime set StartTime=$H
        set result=$$DataImport(.Info,ProgressFn)
        do ProgressBar^TMGUSRIF(100,"Progress",0,100)

LUADone
        quit result


LoadListing(LoadDir)
        ;"Purpose: to load TMG FDA LISTING <--> listings.TXT ;was listings.txt
        ;"Input: LoadDir -- the directory in HFS to get files from
        ;"Output: Kills any prior entries in TMG FDA FIRMS
        ;"NOTICE: any pointers to this fill might me made invalid via kills
        ;"Result: 1=success, 0=error

        ;"FDA documentation for 9/12/2007,4/6/09 file:
        ;"=====================================
        ;"EACH PRODUCT HAS A UNIQUE LISTING SEQ NO;
        ;"  EACH FIRM SEQ NO CAN HAVE MULTIPLE LISTING SEQ NO'S.
        ;"  Each line in this file represents a product for an individual firm.
        ;"  The listing includes such information as the product's name, firm's
        ;"    seq number, dose form(s), and Rx/OTC.
        ;"LISTING_SEQ_NO   NOT NULL   NUM(7)  COL: 1-7
        ;"  FDA generated unique identification number for each product.
        ;"LBLCODE          NOT NULL   CHAR(6) COL: 9-14
        ;"  Labeler code portion of NDC; assigned by FDA to firm.
        ;"  The labeler code is the first segment of the National Drug Code.
        ;"  While always displayed as 6 digits in this file; for labeler codes 2 through 9999,
        ;"  some systems display it as 4 digits; for labeler codes 10,000 through 99,999 it is 5 digits.
        ;"  Can be used to link to the FIRMS.TXT file to obtain firm name.
        ;"PRODCODE NOT NULL CHAR(4) COL: 16-19
        ;"  Product code assigned by firm. The prodcode is the second segment of the National
        ;"  Drug Code. It may be a 3-digit or 4-digit code depending upon the NDC configuration
        ;"  selected by the firm.
        ;"STRENGTH NULL CHAR(10) COL: 21-30
        ;"  For single entity products, this is the potency of the active ingredient. For combination
        ;"  products, it may be null or a number or combination of numbers, e.g., Inderide 40/25.
        ;"UNIT NULL CHAR(10) COL: 32-41
        ;"  Unit of measure corresponding to strength. This non-mandatory field contains the unit
        ;"  code for a single entity product, e.g., MG, %VV.
        ;"RX_OTC NOT NULL CHAR(1) COL: 43
        ;"  Indicates whether product is labeled for Rx or OTC use (R/O).
        ;"TRADENAME NOT NULL CHAR(100) COL: 45-144
        ;"  Product's name as it appears on the labeling.
        ;"=====================================
        ;"Log:
        ;" 10/20/07 -- no modification needed for 9/12/07 database
        ;" 4/8/09 -- no changes needed for 4/6/09 version of file

        new Info
        new result

        ;"Note: should Kill all prior records...
        ;"Note: This will blow away ALL records, cross references etc.
        ;"       This is not considered good programming practice!
        new temp set temp=$get(^TMG(22706.5,0))
        kill ^TMG(22706.5)
        set $piece(temp,"^",3)=""
        set $piece(temp,"^",4)=0
        set ^TMG(22706.5,0)=temp  ;"fix up the 0 node

        set Info("HFS DIR")=$get(LoadDir)
        set Info("HFS FILE")="listings.TXT" ;"was listings.txt
        set Info("DEST FILE")="TMG FDA LISTING"

        new tempFile set tempFile=Info("HFS DIR")_Info("HFS FILE")
        set result=$$Dos2Unix^TMGIOUTL(tempFile)
        if result>0 set result=0 goto LLsDone

        ;"LISTING_SEQ_NO   NOT NULL   NUM(7)  COL: 1-7
        ;"FDA generated unique identification number for each product.
        set Info(.001)="IEN"  ;"Sequence number
        set Info(.001,"START")=1
        set Info(.001,"END")=7

        set Info(.01)=.01  ;"Sequence number
        set Info(.01,"START")=1
        set Info(.01,"END")=7

        ;"LBLCODE          NOT NULL   CHAR(6) COL: 9-14
        ;"Labeler code portion of NDC; assigned by FDA to firm.
        ;"The labeler code is the first segment of the National
        ;"Drug Code. While always displayed as 6 digits in this file;
        ;"for labeler codes 2 through 9999, some systems display it as
        ;"4 digits; for labeler codes 10,000 through 99,999 it is 5 digits.
        ;"Can be used to link to the FIRMS.TXT file to obtain firm name.
        set Info(1)=1  ;"Label Code
        set Info(1,"START")=9
        set Info(1,"END")=14

        ;"PRODCODE NOT NULL CHAR(4) COL: 16-19
        ;"Product code assigned by firm. The prodcode is the second segment
        ;"of the National Drug Code (NDC). It may be a 3-digit or 4-digit
        ;"code depending upon the NDC configuration selected by the firm.
        set Info(2)=2  ;"Product Code
        set Info(2,"START")=16
        set Info(2,"END")=19

        ;"STRENGTH NULL CHAR(10) COL: 21-30
        ;"For single entity products, this is the potency of the active ingredient.
        ;"For combination products, it may be null or a number or combination of
        ;"numbers, e.g., Inderide 40/25.
        set Info(3)=3  ;"Strength
        set Info(3,"START")=21
        set Info(3,"END")=30

        ;"UNIT NULL CHAR(10) COL: 32-41
        ;"Unit of measure corresponding to strength. This non-mandatory field
        ;"contains the unit code for a single entity product, e.g., MG, %VV.
        set Info(4)=4  ;"Unit
        set Info(4,"START")=32
        set Info(4,"END")=41

        ;"RX_OTC NOT NULL CHAR(1) COL: 43
        ;"Indicates whether product is labeled for Rx or OTC use (R/O).
        set Info(5)=5  ;"Rx or OTC
        set Info(5,"START")=43
        set Info(5,"END")=43

        ;"TRADENAME NOT NULL CHAR(100) COL: 45-144
        ;"Product's name as it appears on the labeling.
        set Info(7)=7  ;"Trade name
        set Info(7,"START")=45
        set Info(7,"END")=144

        ;"NOTE: This field will be left blank, as it is not included in FDA
        ;"      file here.  It is really the same info as LBLCODE, i.e. the
        ;"      Firm that makes drug can be determined from LBL code.
        ;"set Info(6)=6  ;"Firm
        ;"set Info(6,"START")=45
        ;"set Info(6,"END")=51

        new StartTime set StartTime=$H
        set result=$$DataImport(.Info,ProgressFn)
        do ProgressBar^TMGUSRIF(100,"Progress",0,100)

LLL3
        ;"Fix Firms Pointer
        ;"Note: the latest FDA export does not explicitly specify the Firm,
        ;"      and only gives the label code.  Thus the label code must be
        ;"      used to look up the IEN for the firm, and this put into the
        ;"      FIRM fiels (#6)

        new Itr,IEN
        set IEN=$$ItrInit^TMGITR(22706.5,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)
        . new lblCode
        . set lblCode=$piece($get(^TMG(22706.5,IEN,0)),"^",2)
        . if lblCode="" quit
        . set lblCode=$$RJ^XLFSTR(lblCode,6,"0")
        . new IEN2 set IEN2=+$order(^TMG(22706.3,"C",lblCode,""))
        . if IEN2'>0 quit
        . set $piece(^TMG(22706.5,IEN,0),"^",7)=IEN2

LLsDone
        quit result


DataImport(Info,ProgressFN)
        ;"Purpose: to provide a generic loading utility, for importing data from a text file.
        ;"     Note: this is more specific than code found in DDMP.m
        ;"Assumptions: that all data for one record is found on one line, with a given
        ;"              number of columns for each field (i.e. not Comma-Separated-Values).
        ;"Input:  Info, an array with relevent info.  PASS BY REFERENCE
        ;"              Format as follows:
        ;"              Info("HFS DIR")=<directory name in HFS to load from>
        ;"              Info("HFS FILE")=<file name in HFS to load from>
        ;"              Info("DEST FILE")=<file name or number>
        ;"              Info(x)=field#  (or "IEN" if data should be used to determine record number
        ;"              Info(x,"START")=starting column
        ;"              Info(x,"END")=ending column
        ;"      ProgressFN: optional.  If not "", then this will be XECUTED after each line
        ;"                The following variables will be defined:
        ;"                      TMGTOTAL -- total number of records
        ;"                      TMGCUR -- current index of record being processed
        ;"Result: 1 if OK to continue, 0 if error

        ;"Note: input Data array will be formated like this:
        ;"                Data(0,cFile)="1234.1" <-- "NEW PERSON" Note conversion
        ;"                Data(0,cFile,cGlobal)="^DIC(200)"  <-- note, NOT "^DIC(200,"
        ;"                Data(0,cRecNum)=2  <-- only if user-specified.
        ;"                Data(0,cEntries)=1
        ;"                Data(1,".01")="MyData1"
        ;"                Data(1,".01",cMatchValue)="MyData1"
        ;"                Data(1,".02")="Bill"
        ;"                Data(1,".02",cMatchValue)="John"
        ;"                Data(1,".03")="MyData3"
        ;"                Data(1,".04")="MyData4"
        ;"                Data(1,".06")="MyData5"  <-- note "NAME" was converted to ".06"
        ;"                Data(1,".07",0,cEntries)=2    <-- "ITEM" converted to ".07"
        ;"                Data(1,".07",1,".01")="SubEntry1"
        ;"                Data(1,".07",1,".02")="SE1"
        ;"                Data(1,".07",1,".03")="'Some Info'"
        ;"                Data(1,".07",2,".01")="SubEntry2"
        ;"                Data(1,".07",2,".02")="SE2"
        ;"                Data(1,".07",2,".04",0,cEntries)=1    ;"TEXT converted to .04
        ;"                Data(1,".07",2,".04",1,".01")="JD"
        ;"                Data(1,".07",2,".04",1,".02")="DOE,JOHN"
        ;"                ADDENDUM
        ;"                Data(1,".01",cFlags)=any flags specified for given field.
        ;"                        only present if user specified.

        new cFile set cFile="FILE"
        new cRecNum set cRecNum="RECNUM"
        new result set result=1
        new TMGTOTAL,TMGCUR

        new GRef set GRef=$name(^TMP("TMG","DATAIMPORT",$J))
        new GRef1 set GRef1=$name(@GRef@(1))  ;"I have to use this to load file
        kill @GRef

        new result
        new dir set dir=$get(Info("HFS DIR"))
        new HFSfile set HFSfile=$get(Info("HFS FILE"))
        set result=$$FTG^%ZISH(dir,HFSfile,GRef1,4)
        if result=0 goto DIDone
        set TMGTOTAL=$order(@GRef@(""),-1)
        new file set file=$get(Info("DEST FILE"))
        if +file=0 set file=$$GetFileNum^TMGDBAPI(file)

        new index
        set index=$order(@GRef@(""))
        for  do  quit:(+index=0)!(result=0)
        . new RecData,TMGFDA
        . set RecData(0,cFile)=file
        . new line set line=$get(@GRef@(index))
        . if $data(@GRef@(index,"OVF")) do
        . . new i set i=$order(@GRef@(index,"OVF",""))
        . . for  do  quit:(+i=0)
        . . . set line=line_$get(@GRef@(index,"OVF",i))  ;"note strings can be longer than 255 now
        . . . set i=$order(@GRef@(index,"OVF",i))
        . new fields set fields=$order(Info(""))
        . new IEN set IEN=""
        . for  do  quit:(+fields=0)!(result=0)
        . . new fieldNum set fieldNum=$get(Info(fields)) ;"could be number or 'IEN'
        . . new oneField
        . . set oneField=$extract(line,$get(Info(fields,"START")),$get(Info(fields,"END")))
        . . set oneField=$$Trim^TMGSTUTL(oneField)
        . . if fieldNum="IEN" do
        . . . set RecData(0,cRecNum)=oneField
        . . . set IEN=oneField
        . . else  do
        . . . set RecData(1,fieldNum)=oneField
        . . set fields=$order(Info(fields))
        . new MarkNum set MarkNum=0
        . new MsgArray
        . set result=$$SetupFDA^TMGDBAPI(.RecData,.TMGFDA,,"+",.MarkNum,.MsgArray)
        . if result=0 quit
        . new TMGIEN
        . if IEN'=0 do
        . . if +IEN>0 set TMGIEN(1)=IEN
        . . set result=$$dbWrite^TMGDBAPI(.TMGFDA,0,.TMGIEN," ")
        . if result=0 quit
        . if $get(ProgressFN)'="" do
        . . set TMGCUR=index
        . . new $etrap set $etrap="w ""??Progress function -- error trapped??"",!"
        . . xecute ProgressFN
       . set index=$order(@GRef@(index))

DIDone
        kill @GRef
        quit result


SetSkipFlag
        ;"Purpose: To review entries in TMG FDA IMPORT COMPILED and determine which
        ;"      of those need to have the SKIP THIS RECORD flag set.
        ;"      The following records will be SKIPPED:
        ;"        -- If there is an entry in the VA PRODUCT MATCHES field.  This would
        ;"              mean that there is ALREADY an entry in the database for this
        ;"              drug, and it will not need to be added.
        ;"        -- If there are no entries in the INGREDIENTS field.  This is because if
        ;"              the FDA database does not list ingredients for a drug, I believe it
        ;"              is because it is not an active drug (otherwise the FDA would require
        ;"              full information), and there is very likely another drug entry for
        ;"              this same drug that DOES have the ingredients.
        ;"Note: This function is planned to be run after CompileAll^TMGNDF2AA

        new IEN
        new NumSkipped,NumNotSkipped,NoIngreds
        set NumSkipped=0,NumNotSkipped=0,NoIngreds=0

        set IEN=$order(^TMG(22706.9,0))
        if +IEN>0 for  do  quit:(+IEN'>0)
        . new name set name=$piece($get(^TMG(22706.9,IEN,0)),"^",4)
        . new NumIngreds set NumIngreds=0
        . new SkipThisOne set SkipThisOne=0
        . ;"See if there are entries in the VA PRODUCT MATCHES field (node 2)
        . new ProdMatches set ProdMatches=+$piece($get(^TMG(22706.9,IEN,2,0)),"^",4)  ;"piece 4 of 0 node is number of entries.
        . if ProdMatches>0 set SkipThisOne=1
        . ;"See if there are NO entries in the INGREDIENTS field (node 4)
        . set NumIngreds=+$piece($get(^TMG(22706.9,IEN,4,0)),"^",4)   ;"piece 4 of 0 node is number of entries.
        . if NumIngreds=0 set SkipThisOne=1,NoIngreds=NoIngreds+1
        . if SkipThisOne set NumSkipped=NumSkipped+1
        . else  set NumNotSkipped=NumNotSkipped+1
        . set $piece(^TMG(22706.9,IEN,1),"^",4)=SkipThisOne
        . ;"write " matches=",ProdMatches," ingredients=",NumIngreds,"  ",name,!
        . set IEN=$order(^TMG(22706.9,IEN))

        write !,"There are ",NumSkipped," entries that are will be skipped.",!
        write "    (",NoIngreds," with no ingredients)",!
        write "    (",NumSkipped-NoIngreds," already in the database)",!
        write "There are ",NumNotSkipped," new entries to be added.",!

        quit


Backup
        ;"Purpose: To backup files to a temporary global

        new dateCode set dateCode="1/15/07"

        new src,dest,i

        for i=1:1:8 do
        . set src="^TMG(22706."_i_")"
        . set dest=$name(^TMG("TMP",src_" "_dateCode))
        . write "merging ",src," into ",dest,!
        . merge @dest=@src

        quit
