TMGNDF2A ;TMG/kst/FDA Import: Work with Drug Forms ;03/25/06
         ;;1.0;TMG-LIB;**1**;11/21/06
 
 ;" FDA - NATIONAL DRUG FILES COMPILING FUNCTIONS
 ;"      -- Working with Dosage Forms
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"11-21-2006
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"Menu
 
 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 ;"FillRxFormRoute  -- ensure that there is a dosage form in all records in TMG FDA IMPORT COMPILED
 ;"              (that are not marked to be skipped)
 ;"GetRxForms(Array) -- scan file 22706.2 (TMG FDA DOSAGE FORMS) and compile a list of all dosage forms
 ;"DisplayForms(Answers) -- display the list of Dosage forms that don't have a corresponding VA DOSE FORM
 ;"HandleLinks -- interact with user and find a link between FDA dosage forms, and VA dosage forms
 ;"ShowHelp
 ;"DoLink(InputNum,Answers) -- try to establish a link between 1 FDA Dosage form and a VA DOSAGE form
 ;"Unlock50dot606
 ;"Lock50dot606
 ;"DoRemove(InputNum,Answers) -- remove an unwanted item from list.
 ;"ShowExamples(InputNum,Answers) -- show all entries using dosage form specified
 ;"FormatDrug(Array)
 ;"SelEditForms -- use the Selector to browse and edit the DOSAGE FORM
 
 
 ;"=======================================================================
 ;"=======================================================================
 
Menu
        ;"Purpose: To give an interactive menu of tools to clean up data.
 
        new Menu,UsrSlct
        set Menu(0)="Pick Option for Managing Import Dosage FORMS (2A)"
        new i set i=1
        set Menu(i)="Find new FDA dosage FORMS"_$char(9)_"FINDNEW" set i=i+1
        set Menu(i)="Match import FORMS --> VA FORMS"_$char(9)_"MATCH" set i=i+1
        set Menu(i)="Fix Tradenames with MISSING FORMS"_$char(9)_"FixTrade" set i=i+1
        set Menu(i)="Screen ALL imports for INCORRECT FORM (IF NEEDED)"_$char(9)_"MANUAL" set i=i+1
        set Menu(i)="Preselect missing and manually edit FORMS"_$char(9)_"MANUAL3" set i=i+1
        set Menu(i)="Manually edit match file (IF NEEDED)"_$char(9)_"MANUAL2" set i=i+1
        set Menu(i)="Edit VA forms (file 50.606) (ONLY IF NEEDED)"_$char(9)_"EDITVA" set i=i+1
        set Menu(i)="USE links for import FORM --> VA FORM (DO THIS LAST)"_$char(9)_"FILL" set i=i+1
        set Menu("P")="Prev Stage"_$char(9)_"Prev"
        set Menu("N")="Next Stage"_$char(9)_"Next"
 
        set Menu("?")="HELP"_$char(9)_"?"
 
CD1
        write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
        if UsrSlct="^" goto CDDone
        if UsrSlct=0 set UsrSlct=""
 
        if UsrSlct="Prev" goto Menu^TMGNDF1F  ;"quit can occur from there...
        if UsrSlct="Next" goto Menu^TMGNDF2C  ;"quit can occur from there...
        if UsrSlct="FILL" do FillRxFormRoute goto CD1
        if UsrSlct="FixTrade" do FixNoForm goto CD1
        if UsrSlct="FINDNEW" do FindUnmatched goto CD1
        if UsrSlct="MATCH" do HandleLinks goto CD1
        if UsrSlct="MANUAL" do SelEditForms() goto CD1
        if UsrSlct="MANUAL2" do SelFormMap goto CD1
        if UsrSlct="MANUAL3" do SelMissing goto CD1
        if UsrSlct="EDITVA" do EditForms goto CD1
        if UsrSlct="?" do ShowHelp goto CD1
        goto CD1
CDDone
        quit
 
 
 
FillRxFormRoute
        ;"Purpose: To ensure that there is a dosage form and route
        ;"         in all records in TMG FDA IMPORT COMPILED
        ;"              (that are not marked to be skipped)
 
        new % set %=2
        ;"write !,"Fill all TMG FDA IMPORT COMPILED records using current"
        ;"write "mapping FDA dosage forms <--> VA dosage forms"
        ;"do YN^DICN write !
        ;"if %'=1 goto FRFDone
 
        new Itr,IEN,abort,count
        set abort=0,count=0
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 quit  ;"1=SKIP
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . new currentIEN set currentIEN=+$piece($get(^TMG(22706.9,IEN,0)),"^",7) ;"0;7 = VA DOSAGE FORM, file 50.606
        . new FDAForm set FDAForm=$piece($get(^TMG(22706.9,IEN,6)),"^",1) ;"text field
        . if FDAForm="" do  quit
        . . if currentIEN'=0 quit
        . . write !,"No FDA dose form found for drug in record #",IEN,!
        . new mapIEN set mapIEN=+$order(^TMG(22706.8,"B",$extract(FDAForm,1,30),""))
        . new VistaIEN set VistaIEN=+$piece($get(^TMG(22706.8,mapIEN,0)),"^",2)
        . if (currentIEN=VistaIEN)&(VistaIEN'=0) quit
        . if VistaIEN=0 do  quit
        . . write !,"Mapping to VA FORM incomplete:  ",FDAForm," --> ??.  Edit Match File.",!
        . new VistaRouteIEN set VistaRouteIEN=+$piece($get(^TMG(22706.8,mapIEN,0)),"^",3)
        . if VistaIEN=0 do  quit
        . . write !,"Mapping to VA ROUTE incomplete:  ",FDAForm," --> ??.  Edit Match File.",!
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.9,IEN_",",3.5)=VistaIEN
        . do FILE^DIE("K","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . ;"write !,IEN," field 3.5 set to `",VistaIEN,!
        . set count=count+1
 
        write !,count," records changed",!
        do PressToCont^TMGUSRIF
 
FRFDone
        quit
 
 
FindUnmatched
        ;"Purpose: Find new, unhandled, FDA dosage forms, and create a new record in
        ;"         TMG NDF FORMS VISTA EQUIVALENTS
 
        new Array
        write !,"Checking compiled FDA import records for new FDA drug FORMS...",!
        do GetFDARxForms(.Array)
        do TrimFoundForms(.Array)
        if $data(Array) do
        . do StubInNewRec(.Array)
        . do HandleLinks
        else  do
        . write !,"No new FDA drug FORMS found",!
 
        do PressToCont^TMGUSRIF
 
        quit
 
 
GetFDARxForms(Array)
        ;"Purpose: to scan file 22706.9 (TMG FDA IMPORT COMPILED) and compile a list of all dosage forms
        ;"Input: Array -- PASS BY REFERENCE.  An OUT PARAMETER.  Prior entries will be killed
        ;"Results: Data passed back as follows:
        ;"              Array(DosageForm)=""
        ;"              Array(DosageForm)=""
        ;"Result: none.
 
        new Itr,IEN
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)
        . if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 quit  ;"1=SKIP
        . new DosageForm
        . set DosageForm=$piece($get(^TMG(22706.9,IEN,6)),"^",1)
        . if DosageForm="" quit
        . set Array(DosageForm)=IEN
 
        quit
 
 
TrimFoundForms(Array)
        ;"Purpose: To remove entries from Array, for which mapping to a VistA equivilent
        ;"         has already ben created
        ;"Input: Array -- PASS BY REFERENCE.  Array as created by GetFDARxForms
        new Form set Form=""
        for  set Form=$order(Array(Form)) quit:(Form="")  do
        . new shortForm set shortForm=$extract(Form,1,30)
        . if $order(^TMG(22706.8,"B",shortForm,""))'="" kill Array(Form)
        quit
 
 
StubInNewRec(Array)
        ;"Purpose: To create new entries in 22706.8 for FDA forms not yet added.
        ;"Input: Array -- PASS BY REFERENCE.  An array of Forms to be added, as created
        ;"                by GetFDARxForms.
        ;"NOTE: ALL entries in Array will be added as new records.  Thus, screening for
        ;"      prior entries must be performed, such as through TrimFoundForms()
 
        new TMGFDA,TMGMSG,TMGIEN
        new Form set Form=""
        for  set Form=$order(Array(Form)) quit:(Form="")  do
        . set TMGFDA(22706.8,"+1,",.01)=Form
        . kill TMGMSG,TMGIEN
        . do UPDATE^DIE("K","TMGFDA","TMGIEN","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        quit
 
 
 
DisplayForms(Answers)
        ;"Purpose: to display the list of Dosage forms that don't have a corresponding VA DOSE FORM
        ;"Input: Answers -- PASS BY REFERENCE, and OUT PARAMETER. Old values killed.
        ;"Output: Answers filled in as follows:
        ;"      Answers(n)=DosageForm^IEN in 22706.8
        ;"      Answers(n)=DosageForm^IEN in 22706.8
        ;"Results: None
 
        kill Answers
        new count set count=0
        new Itr,IEN
        set IEN=$$ItrInit^TMGITR(22706.8,.Itr)
        ;"do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)
        . new VADoseFormIEN set VADoseFormIEN=+$piece($get(^TMG(22706.8,IEN,0)),"^",2)
        . if VADoseFormIEN'=0 quit
        . new DoseForm set DoseForm=$piece($get(^TMG(22706.8,IEN,0)),"^",1)
        . set count=count+1
        . write count,".    ",DoseForm," --> ??",!
        . set Answers(count)=DoseForm_"^"_IEN
        if count=0 do
        . write " -- List is Empty --",!
 
        quit
 
 
HandleLinks
        ;"Purpose: To interact with user and find a link between FDA dosage forms, and VA dosage forms
        ;"Input: none
        ;"Output: results are stored in 22706.8
        ;"Results: none
 
        new Answers
        new done set done=0
        new input set input="R"
        do Unlock50dot606
        new LastNum
        new VAPIndex
 
        for  do  quit:(done=1)
        . if input="R" do
        . . write !!
        . . write "-------------------------------------------------------------------",!
        . . write "Specify which Dosage form to Look up",!
        . . write "-------------------------------------------------------------------",!
        . . do DisplayForms(.Answers)
        . . set LastNum=$order(Answers(""),-1)
        . . if LastNum="" set LastNum="^"
        . . write "-------------------------------------------------------------------",!
        . . write "Specify which Dosage form to Look up",!
        . . write "-------------------------------------------------------------------",!
        . write "  R to refresh, ? for instructions, E show Examples",!
        . write "  ^ to continue",!
        . write "Enter number to Lookup (or codes listed above): ",LastNum,"//"
        . read input
        . if input="" set input=LastNum write LastNum
        . write !
        . ;"if input="" set input="^"
        . if input="" set input=LastNum write LastNum
        . set input=$$UP^XLFSTR(input)
        . if input="^" set done=1
        . if (input="?") do
        . . do ShowHelp,ShowHlp2
        . . set input="R"
        . if +input=input do
        . . do DoLink(input,.Answers)
        . . set input="R"
        . if input="E" do
        . . read "...Enter number to show examples for: ",input,!
        . . do ShowExamples(+input,.Answers,.VAPIndex)
        . . set input="R"
 
        do Lock50dot606
        quit
 
 
ShowHelp
        ;"Purpose: to write out instructions
 
        write #,!
        write "Drugs in the FDA database have drug 'forms', such as 'TABLET', 'CAPSULE' etc.",!
        write "In the VistA database, drugs also will have a drug form specified.  However",!
        write "the classification systems don't exctly match.  Sometimes the difference",!
        write "is just a matter of formatting, e.g. INJ,SUSP <--> INJECTION FOR SUSPENSION.",!
        write "But other times the exact concepts are different.  For example, when the FDA",!
        write "data specified: 'CAPSULE, DELAYED RELEASE PELLETS', I could not find an exact",!
        write "match, and chose: 'CAP,SPRINKLE,SA'.  A appropriately trained person should",!
        write "make such determinations.",!
        write !
        write "This program does allow additions of NEW drug forms to the VistA database.",!
        write "However, this may be against VA policy and should be done only if no possible",!
        write "match can be found.  Also, if a new drug form is added, this new entry in file",!
        write "DOSAGE FORM (50.606) should be completed via a Fileman edit to fill in all",!
        write "other fields such as VERB, NOUN etc. for the new dosage form.",!
        write !
        do PressToCont^TMGUSRIF
        quit
 
ShowHlp2
        write #,!
        write "To link a FDA drug form to a VA drug form, enter its number, then type in a",!
        write "name to search for in the VistA database.  It is best to only type in PART of",!
        write "the name.  For example, 'CAP' instead of 'CAPSULE'.",!
        write !
        write "To see examples of drugs that use a particular drug form, enter 'E'.",!
        write !
        do PressToCont^TMGUSRIF
        quit
 
DoLink(InputNum,Answers)
        ;"Purpose: To try to establish a link between 1 FDA Dosage form and a VA DOSAGE form
        ;"Input:  InputNum -- the number that the user chose to fix.
        ;"         Answers -- PASS BY REFERENCE.  Array as put out by DisplayForms
        ;"Output:  if link is established then it will be store in 22706.8
        ;"Results: none
 
        new DosageForm,IEN
        set DosageForm=$piece($get(Answers(InputNum)),"^",1)
        set IEN=$piece($get(Answers(InputNum)),"^",2)
        if DosageForm="" goto DLDone
        new done set done=0
 
        new VistaIEN set VistaIEN=0
        new DIC,X,Y
        set DIC=50.606
        set X=DosageForm
        set DIC(0)="M"
        do ^DIC
        if +Y>0 do
        . write !,"Match automatically found...",!
        . write "Use '",$piece(Y,"^",2),"' for '",DosageForm,"'"
        . new % set %=1 do YN^DICN
        . if %'=1 quit
        . set VistaIEN=+Y
        if VistaIEN'=0 goto DL2
 
        set DIC(0)="AEQML"
        set DIC("A")="Enter VA DOSE FORM name: // "
        write !,"Enter name to match '"_DosageForm_"'"
        do ^DIC write !
        if +Y>0 do
        . write "Use '",$piece(Y,"^",2),"' for '",DosageForm,"'"
        . new % set %=1 do YN^DICN
        . if %'=1 quit
        . set VistaIEN=+Y
 
DL2     if VistaIEN'=0 do
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.8,IEN_",",1)=VistaIEN
        . do FILE^DIE("K","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
 
DLDone
        quit
 
 
Unlock50dot606
        ;"Purpose: to enable addition of dosage form to file DOSAGE FORM
        set $piece(^DD(50.606,.01,0),"^",5)="K:$L(X)>30!($L(X)<3) X"
        kill ^DD(50.606,.01,"LAYGO",.01,0)
 
        quit
 
Lock50dot606
        ;"NOTE: could just set XPDGREF=1 and not change this....
 
        ;"Purpose: to restore locks on file DOSAGE FORM
        set $piece(^DD(50.606,.01,0),"^",5)="K:$L(X)>30!($L(X)<3)!'(X'?1P.E)!(X'?.ANP) X"
        set ^DD(50.606,.01,"LAYGO",.01,0)="D:'$D(XPDGREF) EN^DDIOL(""ADDITIONS ARE NOT ALLOWED"") I $D(XPDGREF)"
        quit
 
 
ShowExamples(InputNum,Answers,Index)
        ;"Purpose: To show all entries using dosage form specified
        ;"Input: InputNum -- the input number from user to show
        ;"       Answers -- PASS BY REFERENCE, array as put out by DisplayForms
        ;"       Index -- OPTIONAL.  An index of VAProduct
 
        new DosageForm
        set DosageForm=$piece($get(Answers(InputNum)),"^",1)
        if DosageForm="" goto SEDone
 
        if $data(Index)=0 do
        . do IndexVAProd^TMGNDF1C("Index")
 
        new count set count=0
        new IEN set IEN=0
        for  do  quit:(+IEN'>0)
        . set IEN=$order(^TMG(22706.2,"C",DosageForm,IEN))
        . if +IEN'>0 quit
        . new Array,result,ListingIEN,CompIEN
        . set ListingIEN=$piece($get(^TMG(22706.2,IEN,0)),"^",1)
        . set CompIEN=$piece($get(^TMG(22706.5,ListingIEN,0)),"^",9)
        . if +CompIEN>0,$piece($get(^TMG(22706.9,CompIEN,1)),"^",4)=1 quit  ;"check if skip field true
        . set result=$$GetDrugInfo^TMGNDF1C(ListingIEN,.Array,"Index")
        . if result do
        . . write "#",IEN,": "
        . . do FormatDrug(.Array)
        . . set count=count+1
        . . if count>10 do
        . . . new input
        . . . read "Press ENTER to continue (^ to quit)",input:$get(DTIME,3600),!
        . . . if input="^" set IEN=0
        . . . set count=0
        . else  do
        . . ;"write !,"Couldn't find any examples (error occurred).",!
 
        do PressToCont^TMGUSRIF
SEDone
        quit
 
 
FormatDrug(Array)
 
        new s
        if '$data(Array) quit
        new i
 
        set s=$get(Array("TRADENAME"))_" "
        set s=s_$get(Array("STRENGTH"))_" "
        set s=s_$get(Array("UNIT"))_" "
        set i=$order(Array("DOSE",""))
        if +i>0 for  do  quit:(+i'>0)
        . set s=s_$get(Array("DOSE",i,"DOSAGE NAME"))_" "
        . set i=$order(Array("DOSE",i))
 
        write $extract(s,1,60),!
 
        quit
 
 
 ;"========================================
SelEditForms(SelArray,JustSelected)
        ;"Purpose: to use the Selector to browse and edit the TMG FDA IMPORT COMPILED,
        ;"         specifically fields 3.4 (FDA DOSAGE FORM) and 3.5 (DOSAGE FORM)
        ;"Input: SelArray: Optional.  PASS BY REFERENCE.  An array of preselected IEN's
        ;"               Format:  SelArray(IEN in 22706.9)="" <-- IEN preselected
        ;"       JustSelected: Optional.  if 1, then ONLY IENs from SelArray shown.
        ;"Output: User may alter the value of SKIP THIS RECORD field for all records
        ;"Results: none
 
        new Options,IEN
        set Options("FIELDS",1)=".05^TRADENAME^30"
        set Options("FIELDS",1,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",2)="2^UNIT^9"
        if +$get(editUnit)=0 set Options("FIELDS",2,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",3)="3.4^FDA DOSAGE FORM^20"
        set Options("FIELDS",4)="3.5^DOSAGE FORM^21"
        set Options("FIELDS","MAX NUM")=4
        set Options("FILE")="22706.9^TMG FDA IMPORT COMPILED"
 
        if +$get(JustSelected)=0 do
        . ;"Get all records with SKIP THIS RECORD = 0 (KEEP)
        . do GetFldValue^TMGSELED(22706.9,6,0,$name(Options("IEN LIST")))
        else  do
        . merge Options("IEN LIST")=SelArray
 
SE1     if $data(SelArray) do
        . set IEN=""
        . for  set IEN=$order(SelArray(IEN)) quit:(IEN="")  do
        . . if $data(Options("IEN LIST",IEN))>0 do
        . . . set Options("IEN LIST",IEN,"SEL")=""
 
        if $$SELED^TMGSELED(.Options)'=2 goto SEKDone
        if $$GetIENs^TMGSELED(.Options)=0 goto SEKDone
        goto SE1
 
SEKDone quit
 
 
SelFormMap
        ;"Purpose: use Selector to browse and edit TMG FDA FORMS VISTA EQUIVALENTS
 
        new Options,IEN
        set Options("FIELDS",1)=".01^FDA FORM^35"
        set Options("FIELDS",1,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",2)="1^VISTA FORM^25"
        ;"set Options("FIELDS",3)="2^VISTA ROUTE^20"
        ;"set Options("FIELDS","MAX NUM")=3
        set Options("FIELDS","MAX NUM")=2
        set Options("FILE")="22706.8^TMG FDA FORMS VISTA EQUIVALENTS"
 
        do GetFldValue^TMGSELED(22706.8,.01,"ALL",$name(Options("IEN LIST")))
 
SFM1
        if $$SELED^TMGSELED(.Options)'=2 goto SFMDone
        if $$GetIENs^TMGSELED(.Options)=0 goto SFMDone
        goto SFM1
 
SFMDone quit
 
 
SelMissing
        ;"Purpose: To preselect those entries with a missing VISTA FORMS
 
        new PreSelArray
 
        write "Scanning for entries with no VA FORM...",!
        do GetFldValue^TMGSELED(22706.9,3.5,"@","PreSelArray")
        write "Now scanning for the rest of the entries (ignoring skips)...",!
        do SelEditForms(.PreSelArray)
 
        quit
 
EditForms
       ;"Purpose: To edit Vista drug forms in file 50.606
 
        new Options,IEN
        set Options("FIELDS",1)=".01^NAME^17"
        set Options("FIELDS",1,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",2)="3^VERB^8"
        set Options("FIELDS",3)="5^PEPOSITION^12"
        set Options("FIELDS",4)="10^CONJUNCTION^12"
        set Options("FIELDS",5)="22706.8^DIVIDABLE^10"
        set Options("FIELDS","MAX NUM")=5
        set Options("FILE")="50.606^DOSAGE FORM"
 
        do GetFldValue^TMGSELED(50.606,.01,"ALL",$name(Options("IEN LIST")))
 
EF1
        if $$SELED^TMGSELED(.Options)'=2 goto EFDone
        if $$GetIENs^TMGSELED(.Options)=0 goto EFDone
        goto EF1
 
EFDone quit
 
 ;"==========================================================
FixNoForm
        ;"Purpose: To scan through the TRADENAME fields (.05) and fix
        ;"         drugs that don't have a drug FORM in the name.
 
        new IEN,Itr,abort,IgnoreList
        new quickMem
        new Suggestions
        set abort=0
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . if $$UserAborted^TMGUSRIF() set abort=1 quit
        . if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 quit  ;"1=SKIP
        . new tradeName,nameArray
        . set tradeName=$piece($get(^TMG(22706.9,IEN,0)),"^",4)
        . if tradeName="" write !,"No TRADENAME found for record#: ",IEN,! quit
        . new result set result=$$HandleNameArray(IEN,tradeName,.IgnoreList,1)
        . if result="^" set abort=1
        . if +result=0 do
        . . set Suggestions(IEN)=$piece(result,"^",2)
 
        if $data(Suggestions) do HndlSuggestions(.Suggestions,.IgnoreList)
        else  do
        . write "No changes needed.  Great!",!
        . do PressToCont^TMGUSRIF
 
        quit
 
 
 
HandleNameArray(IEN,tradeName,IgnoreList,Quiet)
        ;"Purpose: To handle a name array, looking for a form.
        ;"Input: IEN -- IEN in 22706.9 of current drug
        ;"       tradeName -- current TRADENAME
        ;"       IgnoreList -- OPTIONAL -- a list of forms to be ignored (not perminant).
        ;"              Format: IgnoreList(FormName)=""
        ;"       Quiet -- OPTIONAL.  If =1 then will not ask, but prepair suggested answer.
        ;"NOTE: Makes use of variable with global scope quickMem.  Format:
        ;"          quickMem(FormNameFound)=""
        ;"          quickMem(FormNameFound)=""
        ;"Results: 1=drug FORM found,
        ;"         0 if not found, OR 0^SuggestedNewName
        ;"         ^=abort
 
        new Array
        do CleaveToArray^TMGSTUTL(tradeName," ",.Array)
        ;"Returns Array in format:
        ;"        Array(1)="This"
        ;"        Array(2)="Is"
        ;"        Array(3)="A"
        ;"        Array(4)="Test"
        ;"        Array(MAXNODE)=4
 
HNA0    new index,tempS
        new found set found=0
        new result set result=0
        set Quiet=+$get(Quiet,0)
        new suggestedName set suggestedName=""
        set tempS=""
        new DIC,X,Y
        new menu,menuIndex,UsrSlct
        new drugForm
        set menuIndex=1
        new lastWord set lastWord=""
        for index=$get(Array("MAXNODE")):-1:1 do  quit:(found=1)!(result="^")
        . new thisWord set thisWord=$get(Array(index))
        . if thisWord="" quit
        . new % set %=2
        . if thisWord=lastWord do  quit:(result="^")!(%=1)
        . . if Quiet=1 quit
        . . write "Word '",thisWord,"' found more than once",!
        . . write " in '",tradeName,".'",!
        . . write " Delete one of these "
        . . set %=1 do YN^DICN write !
        . . if %=-1 set result="^" quit
        . . if %=2 quit
        . . if %=1 kill Array(index) quit
        . set lastWord=thisWord
        . if tempS'="" set tempS=" "_tempS
        . set tempS=thisWord_tempS
        . set menuIndex=menuIndex+1
        . set menu(menuIndex)=tempS
        . new TMGA,TMGMSG
        . if $data(quickMem(tempS)) set found=1 quit
        . do FIND^DIC(22706.8,"",".01","M",tempS,"1","B","","","TMGA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . if +$get(TMGA("DILIST",0))>0 do  quit
        . . set found=1
        . . set quickMem(tempS)=""
        . if $data(quickMem(thisWord)) set found=1 quit
        . do FIND^DIC(22706.8,"",".01","MC",thisWord,"1","","","","TMGA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . if +$get(TMGA("DILIST",0))>0 do  quit
        . . set found=1
        . . set quickMem(tempS)=""
        if found goto MCDone
 
        set drugForm=$$GET1^DIQ(22706.9,IEN_",","3.5:.01")
        if $data(IgnoreList(drugForm)) goto MCDone  ;" marked to be ignored.
 
        set menu(0)="Which option best shows the drug FORM? (Record #"_IEN_")"
        set menu(1)="None below.  Use linked FORM: "_drugForm_$char(9)_"NONE"
        set menuIndex=menuIndex+1
        set menu(menuIndex)="Manually enter a NEW FULL TRADENAME + FORM for this drug"_$char(9)_"EDIT"
        set menuIndex=menuIndex+1
        set menu(menuIndex)="Manually change LINKED drug FORM for this drug"_$char(9)_"ChangeForm"
        set menuIndex=menuIndex+1
        set menu(menuIndex)="Ignore this drug and continue"_$char(9)_"Ignore"
 
        if Quiet=1 set UsrSlct="QUIET" goto MC2
 
        ;"At this point, no drug form was found.
MC1     write !
        set UsrSlct=$$Menu^TMGUSRIF(.menu,menuIndex)
        write !
        if UsrSlct="^" set result="^" goto MCDone
        if UsrSlct="Ignore" do  goto MCDone
        . write "Ignore all drugs with linked drug form of: ",drugForm," "
        . new % set %=2 do YN^DICN write !
        . if %=-1 set result="^" quit
        . if %=2 quit
        . set IgnoreList(drugForm)=""
 
MC2     if UsrSlct=0 set UsrSlct=""
 
        if UsrSlct>0 do  goto MCDone
        . new newForm set newForm=$get(menu(UsrSlct))
        . new DIC,X,Y set DIC=22706.8
        . set DIC(0)="MAEQL"
        . set DIC("A")="Select drug FORM to match with '"_newForm_"' ^//"
        . do ^DIC write !
        . if +Y'>0 quit
        . new vistaForm,vistaRoute
        . set vistaForm=$piece($get(^TMG(22706.8,+Y,0)),"^",2)
        . set vistaRoute=$piece($get(^TMG(22706.8,+Y,0)),"^",3)
        . new TMGFDA,TMGMSG,TMGIEN
        . set TMGFDA(22706.8,"+1,",.01)=newForm
        . set TMGFDA(22706.8,"+1,",1)=vistaForm
        . set TMGFDA(22706.8,"+1,",2)=vistaRoute
        . do UPDATE^DIE("S","TMGFDA","TMGIEN","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . set found=1
 
        set Y=-1
        if UsrSlct="ChangeForm" do  goto MCDone:(Y=-1),HNA0
        . new DIC,X,Y
        . set DIC=50.606,DIC(0)="MAEQ"
        . set DIC("A")="Select drug FORM to use: ^// "
        . write "For '",tradeName,"',",!
        . do ^DIC
        . if Y=-1 quit
        . new newForm set newForm=$piece(Y,"^",2)
        . new origName set origName=$$GET1^DIQ(22706.9,IEN_",",.05)
        . set tradeName=origName_" "_newForm
        . if tradeName="" write "?? tradeName=''",! quit
        . new TMGFDA,TMGMSG,TMGA
        . set TMGFDA(22706.9,IEN_",",3.5)=+Y
        . set TMGFDA(22706.9,IEN_",",.05)=tradeName
        . do FILE^DIE("K","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . do FIND^DIC(22706.8,"",".01","M",newForm,"1","B","","","TMGA","TMGMSG")
        . if +$get(TMGA("DILIST",0))'>0 do
        . . kill TMGFDA,TMGMSG new TMGIEN
        . . set TMGFDA(22706.8,"+1,",.01)=newForm
        . . do UPDATE^DIE("E","TMGFDA","TMGIDE","TMGMSG")
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . set result="0^"_tradeName
 
        if UsrSlct="QUIET" do  goto MCDone
        . set suggestedName=tradeName_" "_drugForm
        . set result="0^"_suggestedName
 
        if UsrSlct="NONE" do  goto MCDone
        . new newName
        . if drugForm="" do  quit
        . . write "No drug FORM found in field 3.5 for record#: ",IEN,! quit
        . set newName=tradeName_" "_drugForm
        . write "Change TRADENAME to: ",newName," "
        . new % set %=1 do YN^DICN write !
        . if %=-1 set result="^" quit
        . if %=2 quit
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.9,IEN_",",.05)=newName
        . do UPDATE^DIE("ES","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . set found=1
 
        if UsrSlct="EDIT" do  goto MCDone
        . write "Enter NEW TRADENAME for drug (^ to abort): "
        . new newName read newName:$get(DTIME,3600),!
        . if newName="^" quit
        . write !,"Change TRADENAME from:",!
        . write tradeName," "
        . write "  ----->",!
        . write newName,!
        . new % set Y=1
        . do YN^DICN write !
        . if %=-1 set result="^" quit
        . if %='1 quit
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.9,IEN_",",.05)=newName
        . do UPDATE^DIE("ES","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . set result="0^"_newName
 
MCDone
        if (found=1)&(result'="^") set result=1
        quit result
 
 
HndlSuggestions(Suggestions,IgnoreList)
        ;"Purpose: to interact with user about accepting or editing suggestions
        ;"Input:  Suggestions -- PASS BY REFERENCE.  Format:
        ;"              Suggestions(IEN)=SuggestedNameForTradeName
        ;"              Suggestions(IEN)=SuggestedNameForTradeName
        ;"        IgnoreList -- PASS BY REFERENCE.  A list of words/forms to be ignored
 
        new Answers
        new done set done=0
        new input set input="R"
        new CompactMode set CompactMode=0
        new Cancelled set Cancelled=0
        new LastNum set LastNum=0
        new EntryList,EntryS
 
        for  do  quit:(done=1)
        . if input="R" do
        . . write !!
        . . write "-------------------------------------------------------------------",!
        . . write "Specify which New TRADENAMES to accept",!
        . . write "-------------------------------------------------------------------",!
        . . do DispSuggestions(.Suggestions,.Answers,CompactMode)
        . . set LastNum=$order(Answers(""),-1)
        . . if LastNum="" set LastNum="^"
        . . write "-------------------------------------------------------------------",!
        . . write "Specify which New TRADENAMES to accept",!
        . . write "-------------------------------------------------------------------",!
        . write " R to refresh, I to Ignore some; M to manually edit",!
        . write " C=set Compact ",$select((CompactMode=1):"OFF",1:"ON"),", "
        . write " S to Screen names for a given form to Ignore.",!
        . write " A to show ALTERNATE drugs similar to shown",!
        . write " O to show sOurce (from FDA) for drug; K to mark drug sKipped.",!
        . write " # or #-# or #,#-#,# etc.,  ^ done, ",!
        . ;"write "Enter number(s) to Accept (or codes listed above): ",LastNum,"//"
        . write "Enter number(s) to Accept (or codes listed above): ^//"
        . read input:$get(DTIME,3600),!
        . ;"if input="" set input=LastNum write LastNum
        . if input="" set input="^" write "^"
        . set input=$$UP^XLFSTR(input)
        . if input="^" set done=1 quit
        . if input="A" do  ;"--- show alternatives
        . . new valid set valid=1
        . . if $get(EntryS)="" do  quit:(valid=0)
        . . . read "...Enter number(s) to show ALTERNATIVES for from list: ^// ",input,!
        . . . set valid=$$MkMultList^TMGMISC(input,.EntryList)
        . . . if valid set EntryS=input
        . . set Cancelled=0
        . . do ShowAlts(.Suggestions,.Answers,.EntryList,.Cancelled)
        . . if Cancelled=0 kill EntryList,EntryS
        . . set input="R"
        . if input="I" do  ;"--- ignore entries.
        . . new valid set valid=1
        . . if $get(EntryS)="" do  quit:(valid=0)
        . . . read "...Enter number(s) to IGNORE from list: ^// ",input,!
        . . . set valid=$$MkMultList^TMGMISC(input,.EntryList)
        . . . if valid set EntryS=input
        . . set Cancelled=0
        . . do KillSugg(.Suggestions,.Answers,.EntryList,.Cancelled)
        . . if Cancelled=0 kill EntryList,EntryS
        . . set input="R"
        . else  if input="K" do  ;"--- Set to SKIP
        . . new valid set valid=1
        . . if $get(EntryS)="" do  quit:(valid=0)
        . . . read "...Enter number(s) to PERMINANTLY SKIP from list: ^// ",input,!
        . . . set valid=$$MkMultList^TMGMISC(input,.EntryList)
        . . . if valid set EntryS=input
        . . set Cancelled=0
        . . do SetSkip(.Suggestions,.Answers,.EntryList,.Cancelled)
        . . if Cancelled=0 kill EntryList,EntryS
        . . set input="R"
        . else  if input="C" do  ;"--- toggle compact mode
        . . set CompactMode='CompactMode
        . . set input="R"
        . else  if input="M" do  ;"--- manually handle entry
        . . new valid set valid=1
        . . if $get(EntryS)="" do  quit:(valid=0)
        . . . read "...Enter number(s) to MANUALLY EDIT from list: ^// ",input,!
        . . . set valid=$$MkMultList^TMGMISC(input,.EntryList)
        . . . if valid set EntryS=input
        . . set Cancelled=0
        . . do ManualEdit(.Suggestions,.Answers,.EntryList,.Cancelled)
        . . if Cancelled=0 kill EntryList,EntryS
        . . set input="R"
        . else  if input="O" do  ;"--- show FDA source
        . . new valid set valid=1
        . . if $get(EntryS)="" do  quit:(valid=0)
        . . . read "...Enter number(s) to show FDA SOURCE for from list: ^// ",input,!
        . . . set valid=$$MkMultList^TMGMISC(input,.EntryList)
        . . . if valid set EntryS=input
        . . set Cancelled=0
        . . do ShowSrc(.Suggestions,.Answers,.EntryList,.Cancelled)
        . . if Cancelled=0 kill EntryList,EntryS
        . . set input="R"
        . else  if input="S" do  ;"--- screen for those to ignore
        . . new scrnForm
        . . read "Enter Form to screen for.  All entries with this form will be ignored: ",scrnForm,!
        . . if scrnForm="^" quit
        . . kill EntryList,EntryS
        . . new num set num=""
        . . for  set num=$order(Answers(num)) quit:(num="")  do
        . . . new newName set newName=$piece($get(Answers(num)),"^",2)
        . . . if newName[scrnForm set EntryList(num)=""
        . . do KillSugg(.Suggestions,.Answers,.EntryList,.Cancelled)
        . . set input="R"
        . else  if input'="R" do
        . . if $$MkMultList^TMGMISC(input,.EntryList)=0 quit
        . . set EntryS=input
        . . set Cancelled=0
        . . do AcceptSugg(.Suggestions,.Answers,.EntryList,.Cancelled)
        . . if Cancelled=0 kill EntryList,EntryS
        . . set input="R"
 
        quit
 
 
AcceptSugg(Array,Answers,EntryList,Cancelled)
        ;"Purpose: To accept new suggested name from Array
        ;"Input: Array -- PASS BY REFERENCE, array holding data,
        ;"              Array(IEN)=SuggestedNewTradeName
        ;"              Array(IEN)=SuggestedNewTradeName
        ;"       Answers -- PASS BY REFERENCE, an array linking display number to IENS.
        ;"              Array should be the one created by DispSuggestions()
        ;"              Answers(DispNum)=IEN^SuggestedNameForTradeName
        ;"              Answers(DispNum)=IEN^SuggestedNameForTradeName
        ;"       List -- PASS BY REFERENCE -- an array of entries (user input values) to process.
        ;"              Format as follows.
        ;"                      List(Entry number)=""
        ;"                      List(Entry number)=""
        ;"       Cancelled -- OPTIONAL, PASS BY REFERENCE, will be set to 1 if user cancelled.
        ;"Results: none
 
        new num set num=""
        for  set num=$order(EntryList(num)) quit:(num="")  do
        . new IEN,newName
        . set IEN=$piece($get(Answers(num)),"^",1)
        . if IEN="" quit
        . set newName=$piece($get(Answers(num)),"^",2)
        . if $length(newName)>64 do  quit:(newName="^")
        . . set newName=$$ShortName^TMGSHORT(newName,64,1," ")
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.9,IEN_",",.05)=newName
        . do UPDATE^DIE("ES","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
 
        do KillSugg(.Array,.Answers,.EntryList,.Cancelled)
 
        quit
 
ManualEdit(Suggestions,Answers,EntryList,Cancelled,IgnoreList)
        ;"Purpose: To accept manually edit suggestions from Array
        ;"Input: Array -- PASS BY REFERENCE, array holding data,
        ;"              Array(IEN)=SuggestedNewTradeName
        ;"              Array(IEN)=SuggestedNewTradeName
        ;"       Answers -- PASS BY REFERENCE, an array linking display number to IENS.
        ;"              Array should be the one created by DispSuggestions()
        ;"              Answers(DispNum)=IEN^SuggestedNameForTradeName
        ;"              Answers(DispNum)=IEN^SuggestedNameForTradeName
        ;"       List -- PASS BY REFERENCE -- an array of entries (user input values) to process.
        ;"              Format as follows.
        ;"                      List(Entry number)=""
        ;"                      List(Entry number)=""
        ;"       Cancelled -- OPTIONAL, PASS BY REFERENCE, will be set to 1 if user cancelled.
        ;"       IgnoreList -- PASS BY REFERENCE.  A list of words/forms to ignore.
        ;"NOTE: function HandleNameArray (called here) uses variable with global
        ;"      scope: quickMem
        ;"Results: none
 
        new num set num=""
        set Cancelled=$get(Cancelled,0)
        for  set num=$order(EntryList(num)) quit:(num="")!(Cancelled=1)  do
        . new IEN,newName
        . set IEN=$piece($get(Answers(num)),"^",1)
        . if IEN="" quit
        . ;"set newName=$piece($get(Answers(num)),"^",2)
        . set newName=$$GET1^DIQ(22706.9,IEN_",",.05)
        . new result set result=$$HandleNameArray(IEN,newName,.IgnoreList,0)
        . if +result=0 do
        . . set $piece(Answers(num),"^",2)=$piece(result,"^",2)
        . . set Suggestions(IEN)=$piece(result,"^",2)
        . if result="^" set Cancelled=1
        . if result=1 do  quit
        . . write "Entry handled and removed from list.",!
        . . do PressToContinue^TMGUSRIF
        . . kill Answers(num),Suggestions(IEN),EntryList(num)
 
        quit
 
 
ShowSrc(Suggestions,Answers,EntryList,Cancelled)
        ;"Purpose: To show FDA source for drugs in Array
        ;"Input: Array -- PASS BY REFERENCE, array holding data,
        ;"              Array(IEN)=SuggestedNewTradeName
        ;"              Array(IEN)=SuggestedNewTradeName
        ;"       Answers -- PASS BY REFERENCE, an array linking display number to IENS.
        ;"              Array should be the one created by DispSuggestions()
        ;"              Answers(DispNum)=IEN^SuggestedNameForTradeName
        ;"              Answers(DispNum)=IEN^SuggestedNameForTradeName
        ;"       List -- PASS BY REFERENCE -- an array of entries (user input values) to process.
        ;"              Format as follows.
        ;"                      List(Entry number)=""
        ;"                      List(Entry number)=""
        ;"       Cancelled -- OPTIONAL, PASS BY REFERENCE, will be set to 1 if user cancelled.
        ;"Results: none
 
        new num set num=""
        set Cancelled=$get(Cancelled,0)
        for  set num=$order(EntryList(num)) quit:(num="")!(Cancelled=1)  do
        . new IEN,newName
        . set IEN=$piece($get(Answers(num)),"^",1)
        . if IEN="" quit
        . set newName=$piece($get(Answers(num)),"^",2)
        . do Show1Source^TMGNDF1A(IEN)
        . do PressToCont^TMGUSRIF
 
        quit
 
 
SetSkip(Suggestions,Answers,EntryList,Cancelled,Quiet)
        ;"Purpose: To set the drugs in the Array as perminantly skipped.
        ;"Input: Array -- PASS BY REFERENCE, array holding data,
        ;"              Array(IEN)=SuggestedNewTradeName
        ;"              Array(IEN)=SuggestedNewTradeName
        ;"       Answers -- PASS BY REFERENCE, an array linking display number to IENS.
        ;"              Array should be the one created by DispSuggestions()
        ;"              Answers(DispNum)=IEN^SuggestedNameForTradeName
        ;"              Answers(DispNum)=IEN^SuggestedNameForTradeName
        ;"       List -- PASS BY REFERENCE -- an array of entries (user input values) to process.
        ;"              Format as follows.
        ;"                      List(Entry number)=""
        ;"                      List(Entry number)=""
        ;"       Cancelled -- OPTIONAL, PASS BY REFERENCE, will be set to 1 if user cancelled.
        ;"       Quiet -- OPTIONAL.  if 1, then user is not asked.  Default=0
        ;"Results: none
 
        new num set num=""
        set Cancelled=$get(Cancelled,0)
        if $get(Quiet)=1 goto SK1
        write "For this list of drug TRADENAME:",!
        write "--------------------------------",!
        for  set num=$order(EntryList(num)) quit:(num="")!(Cancelled=1)  do
        . new IEN,newName
        . set IEN=$piece($get(Answers(num)),"^",1)
        . if IEN="" quit
        . set newName=$piece($get(Answers(num)),"^",2)
        . write " ",newName," (#",IEN,")",!
        write "--------------------------------",!
        write "Set these drugs to be PERMINANTLY SKIPPED"
        new % set %=2 do YN^DICN write !
        if %=-1 set Cancelled=1 goto SSDone
        if %=2 goto SSDone
        if %=1 do
SK1     for  set num=$order(EntryList(num)) quit:(num="")!(Cancelled=1)  do
        . new IEN,newName
        . set IEN=$piece($get(Answers(num)),"^",1)
        . if IEN="" quit
        . set $piece(^TMG(22706.9,IEN,1),"^",4)=1  ;"1=SKIP
        do KillSugg(.Suggestions,.Answers,.EntryList,.Cancelled)
 
SSDone
        quit
 
 
ShowAlts(Suggestions,Answers,EntryList,Cancelled)
        ;"Purpose: To show alternate drugs from drugs in Array
        ;"Input: Array -- PASS BY REFERENCE, array holding data,
        ;"              Array(IEN)=SuggestedNewTradeName
        ;"              Array(IEN)=SuggestedNewTradeName
        ;"       Answers -- PASS BY REFERENCE, an array linking display number to IENS.
        ;"              Array should be the one created by DispSuggestions()
        ;"              Answers(DispNum)=IEN^SuggestedNameForTradeName
        ;"              Answers(DispNum)=IEN^SuggestedNameForTradeName
        ;"       List -- PASS BY REFERENCE -- an array of entries (user input values) to process.
        ;"              Format as follows.
        ;"                      List(Entry number)=""
        ;"                      List(Entry number)=""
        ;"       Cancelled -- OPTIONAL, PASS BY REFERENCE, will be set to 1 if user cancelled.
        ;"Results: none
 
        new num set num=""
        set Cancelled=$get(Cancelled,0)
        new skipList
        for  set num=$order(EntryList(num)) quit:(num="")!(Cancelled=1)  do
        . new IEN,newName,foundList
        . set IEN=$piece($get(Answers(num)),"^",1)
        . if IEN="" quit
        . set newName=$piece($get(Answers(num)),"^",2)
        . do GETS^DIQ(22706.9,IEN_",",".04;.05;.07;1;3.5","","TMGA","TMGMSG")
        . new origName set origName=$get(TMGA(22706.9,IEN_",",.05))
        . if origName="" quit
        . new NameDose set NameDose=origName_" ("_$get(TMGA(22706.9,IEN_",",.07))_") "_$get(TMGA(22706.9,IEN_",",1))
        . write !,!,"For drug '",NameDose,"', below are alternatives...",!
        . do FIND^DIC(22706.9,"",".05","M",origName,"30","B","","","TMGA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . if +$get(TMGA("DILIST",0))=1 do
        . . do FIND^DIC(22706.9,"",".05","M",$piece(origName," ",1),"30","B","","","TMGA","TMGMSG")
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . merge foundList=TMGA("DILIST",2)  ;"format foundList(seq#)=IEN22706d9
SAL1    . new numShown set numShown=0
        . write "--------------------------",!
        . if $data(foundList) do
        . . new seqNum set seqNum=""
        . . for  set seqNum=$order(foundList(seqNum)) quit:(seqNum="")  do
        . . . new TMGA,TMGMSG,IEN2
        . . . set IEN2=$get(foundList(seqNum))
        . . . if (+IEN2'>0)!(IEN2=IEN) quit
        . . . if $piece($get(^TMG(22706.9,IEN2,1)),"^",4)=1 quit  ;"1=SKIP
        . . . do GETS^DIQ(22706.9,IEN2_",",".04;.07;1;3.5","","TMGA","TMGMSG")
        . . . write " ",$get(TMGA(22706.9,IEN2_",",.07))
        . . . write " ",$get(TMGA(22706.9,IEN2_",",1))
        . . . write " ",$get(TMGA(22706.9,IEN2_",",3.5))," ; "
        . . . write " ",$get(TMGA(22706.9,IEN2_",",.04)),!
        . . . set numShown=numShown+1
        . if numShown=0 do
        . . write " -- List is empty --",!
        . write "--------------------------",!
        . write "For drug '",NameDose,"', above alternatives were found:",!
        . write !,"If a similar drug is seen in list above, then SKIP is OK",!
        . write "Set '",NameDose,"'",!
        . write "  to be PERMINANTLY SKIPPED"
        . new % set %=2 do YN^DICN write !
        . if %=-1 set Cancelled=1 quit
        . if %=1 set skipList(num)="" quit
        . set %=2
        . write "Lookup a comparison manually" do YN^DICN write !
        . if %=-1 set Cancelled=1 quit
        . if %=2 quit
        . if %=1 do  goto SAL1
        . . new DIC,X,Y
        . . set DIC=22706.9,DIC(0)="MAEQ"
        . . do ^DIC write !
        . . if Y=-1 write !,"NO MATCH.",!,!
 
 
        if $data(skipList) do
        . do SetSkip(.Suggestions,.Answers,.skipList,.Cancelled,1)
 
        do PressToCont^TMGUSRIF
 
        quit
 
 
KillSugg(Array,Answers,EntryList,Cancelled)
        ;"Purpose: To accept new suggested name from Array
        ;"Input: Array -- PASS BY REFERENCE, array holding data,
        ;"              Array(IEN)=SuggestedNewTradeName
        ;"              Array(IEN)=SuggestedNewTradeName
        ;"       Answers -- PASS BY REFERENCE, an array linking display number to IENS.
        ;"              Array should be the one created by DispSuggestions()
        ;"              Answers(DispNum)=IEN^SuggestedNameForTradeName
        ;"              Answers(DispNum)=IEN^SuggestedNameForTradeName
        ;"       List -- PASS BY REFERENCE -- an array of entries (user input values) to process.
        ;"              Format as follows.
        ;"                      List(Entry number)=""
        ;"                      List(Entry number)=""
        ;"       Cancelled -- OPTIONAL, PASS BY REFERENCE, will be set to 1 if user cancelled.
        ;"Results: none
 
        new num set num=""
        for  set num=$order(EntryList(num)) quit:(num="")  do
        . new IEN set IEN=$piece($get(Answers(num)),"^",1)
        . kill Answers(num)
        . kill Array(IEN)
 
        quit
 
 
DispSuggestions(Suggestions,Answers,Compact)
        ;"Purpose: to display list of Suggested name changes
        ;"Input:  Suggestions -- PASS BY REFERENCE.  Format:
        ;"              Suggestions(IEN)=SuggestedNameForTradeName
        ;"              Suggestions(IEN)=SuggestedNameForTradeName
        ;"        Answers -- PASS BY REFERENCE.  Format:
        ;"              Answers(DispNum)=IEN^SuggestedNameForTradeName
        ;"              Answers(DispNum)=IEN^SuggestedNameForTradeName
        ;"        Compact -- OPTIONAL, Default=0.  If 1, only first part of list shown.
        ;"Results: None
 
        kill Answers
        new count set count=0
        set Compact=+$get(Compact)
        new IEN set IEN=""
        for  set IEN=$order(Suggestions(IEN)) quit:(IEN="")!((Compact=1)&(count>10))  do
        . new newName set newName=$get(Suggestions(IEN))
        . set count=count+1
        . write count,".    ",newName,!
        . set Answers(count)=IEN_"^"_newName
        if count=0 do
        . write " -- List is Empty --",!
 
        quit
 
