TMGNDF3E ;TMG/kst/FDA Import: Inactivate unwanted DRUGs ;03/25/06
         ;;1.0;TMG-LIB;**1**;11/21/06
 
 ;" FDA - NATIONAL DRUG FILES COMPILING FUNCTIONS
 ;"      Inactivate DRUG entries not linked to import.
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"11-21-2006
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"Menu
 ;"=======================================================================
 
 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 
Menu
        ;"Purpose: Provide menu to entry points of main routines
 
        new Menu,UsrSlct
        set Menu(0)="Pick Option for Inactivate unused DRUG file entries (3E)"
        set Menu(1)="Inactivate DRUG entries not linked to import"_$char(9)_"InactivateUnused"
        set Menu(2)="Kill DRUG entries not linked to import (CAUTION!)"_$char(9)_"KillUnused"
        set Menu(3)="View DRUG entries that ARE linked to import"_$char(9)_"BrowseUsed"
        set Menu(4)="Review DRUG entries for bad imports"_$char(9)_"CheckForBad"
        set Menu("P")="Prev Stage"_$char(9)_"Prev"
        set Menu("N")="Next Stage"_$char(9)_"Next"
 
MC1     write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
        if UsrSlct="^" goto MCDone
        if UsrSlct=0 set UsrSlct=""
 
        if UsrSlct="InactivateUnused" do InactivateUnused goto MC1
        if UsrSlct="KillUnused" do KillUnused goto MC1
        if UsrSlct="BrowseUsed" do BrowseUsed goto MC1
        if UsrSlct="CheckForBad" do ReviewForBad goto MC1
        if UsrSlct="Prev" goto Menu^TMGNDF3D  ;"quit can occur from there...
        if UsrSlct="Next" goto Menu^TMGNDF4A  ;"quit can occur from there...
        goto MC1
 
MCDone
        quit
 
 ;"=======================================================================
 
InactivateUnused
        ;"Purpose: To cycle through all DRUG entries and inactivate those
        ;"      not linked to a non-skipped entry in 22706.9 (TMG FDA IMPORT COMPILED)
        ;"Input: none
        ;"Results: none.
 
        new count set count=0
        new OnlyTMG set OnlyTMG=1
        new % set %=1
        write !,!,"When scanning through records in the DRUG file,",!
        write "should just entries that this FDA import process",!
        write "has added (for example, on a previous run), or ",!
        write "should ALL entries be considered for inactivation?",!
        write "Inactivate ONLY former FDA imports" do YN^DICN write !
        if %=-1 goto IUDone
        if %=1 goto IU2
        set %=1
        write "Inactivate ALL DRUG entries" do YN^DICN write !
        if %'=1 goto IUDone
        set OnlyTMG=0
 
IU2     new Itr,IEN
        new abort set abort=0
        set IEN=$$ItrInit^TMGITR(50,.Itr)
        write !,"Scanning DRUG entries to find entries to inactivate...",!
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . if (OnlyTMG=1),($$TMGAdded(IEN)=0) quit
        . new fdaIEN set fdaIEN=+$$GetfdaIEN^TMGNDFUT(IEN)
        . if (fdaIEN'>0)&(OnlyTMG=1) quit
        . if (fdaIEN>0),($piece($get(^TMG(22706.9,fdaIEN,1)),"^",4)'=1) quit ;" 1=SKIP
        . new InactiveDate set InactiveDate=$$GET1^DIQ(50,IEN_",",100)
        . if InactiveDate'="" quit ;"already inactivated.
        . ;"write "Inactivate-->",$$GET1^DIQ(50,IEN_",",.01),!
        . do AddMsg^TMGNDF3C(IEN,"TMG INACTIV D/T NO FDA")  ;"Add a message in the Activity log field
        . new TMGFDA,TMGMSG
        . set TMGFDA(50,IEN_",",100)="NOW"
        . do FILE^DIE("KE","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . set count=count+1
        do ProgressDone^TMGITR(.Itr)
 
IUDone
        write count," entries inactivated.",!
        do PressToCont^TMGUSRIF
        quit
 
 
KillUnused
        ;"Purpose: To cycle through all DRUG entries and kill those
        ;"      not linked to a non-skipped entry in 22706.9 (TMG FDA IMPORT COMPILED)
        ;"Input: none
        ;"Results: none.
 
        new count set count=0
 
        write !,!
        write "**********************************************************",!
        write "NOTICE:         * IMPORTANT *",!
        write "This process could delete drugs that are referenced",!
        write "by an active medical record.  As such that would be",!
        write "an alteration of a record (i.e. illegal).",!,!
        write "This process should only be used during initial",!
        write "installation of the drug files (i.e. during debugging etc.)",!,!
        write "**********************************************************",!
        write "If you want to continue, type: 'I UNDERSTAND'",!
        new temp
        read "> ",temp:($get(DTIME,3600)),!
        if temp'="I UNDERSTAND" goto KUDone
 
        new Itr,IEN
        new abort set abort=0
        set IEN=$$ItrInit^TMGITR(50,.Itr)
        write !,"Scanning DRUG entries to find unused entries to delete...",!
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . new fdaIEN set fdaIEN=+$$GetfdaIEN^TMGNDFUT(IEN)
        . if (fdaIEN>0),($piece($get(^TMG(22706.9,fdaIEN,1)),"^",4)'=1) quit ;" 1=SKIP
        . new TMGFDA,TMGMSG
        . set TMGFDA(50,IEN_",",.01)="@"  ;"delete record
        . do FILE^DIE("KE","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . set count=count+1
        do ProgressDone^TMGITR(.Itr)
 
KUDone
        write count," unlinked entries deleted.",!
        do PressToCont^TMGUSRIF
        quit
 
 
 
TMGAdded(IEN50)
        ;"Purpose: to determine if the record in 50 is one that this TMG code added.
        ;"Input: IEN50 -- IEN in file 50
        ;"Results: 1 if TMG added, 0 otherwise.
 
        new result set result=0
        new idx set idx=0
        for  set idx=$order(^PSDRUG(IEN50,4,idx)) quit:(idx="")!(result=1)  do
        . new msg set msg=$piece($get(^PSDRUG(IEN50,4,idx,0)),"^",5)
        . if $extract(msg,1,3)="TMG" set result=1
        quit result
 
 ;"========================
GetUsed(pList,pSource)
        ;"Purpose: to Get a list of DRUG entries that are linked to from an import that is not SKIPPED
        ;"Input: pList -- PASS BY NAME.  An OUT PARAMETER. Format:
        ;"              @pList@(IEN50)=""
        ;"              @pList@(IEN50)=""
        ;"       pSource -- OPTIONAL.  PASS BY NAME. an OUT PARAMETER. Format:
        ;"              @pSource@(IEN50,IEN22706d9)=""
        ;"              @pSource@(IEN50,IEN22706d9)=""
        ;"Results: None
 
        new Itr,IEN
        new temp
        set pSource=$get(pSource,"temp")
        new abort set abort=0
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        write !,"Scanning DRUG entries to Browse/View...",!
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 quit ;" 1=SKIP
        . new gIEN,tIEN
        . set tIEN=+$piece($get(^TMG(22706.9,IEN,7)),"^",1)
        . set gIEN=+$piece($get(^TMG(22706.9,IEN,7)),"^",1)
        . if tIEN>0 set @pList@(tIEN)="",@pSource@(tIEN,IEN)=""
        . if gIEN>0 set @pList@(gIEN)="",@pSource@(gIEN,IEN)=""
 
        quit
 
BrowseUsed
        ;"Purpose: To Browse DRUG entries that are linked to a used import (not skipped)
 
        new List
        new Options,IEN
 
        set Options("FIELDS",1)=".01^GENERIC NAME^41"
        set Options("FIELDS",1,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",2)="31^NDC^16"
        set Options("FIELDS",2,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS","MAX NUM")=2
        set Options("FILE")="50^DRUG"
 
        do GetUsed($name(Options("IEN LIST")))
 
        new temp
        set temp=$$SELED^TMGSELED(.Options)
 
BUDone quit
 
 
 ;"=======================================
ReviewForBad
        ;"Purpose: To review DRUG entries for bad imports
        ;"Input: none
        ;"Output: ...
 
        ;"Results: None
 
        new List
        new IEN50List,IEN50,IEN22706d9,SrcList
        new IENTMGList
        new resultList
 
        do GetUsed("IEN50List","SrcList")
 
        do IENSelector^TMGUSRIF("IEN50List","resultList",50,".01",40,"Select any bad names to investigate them. [ESC][ESC] to exit",".01")
 
        new Options
 
        set IEN50=""
        for  set IEN50=$order(resultList(IEN50)) quit:(IEN50="")  do
        . set IEN22706d9=$order(^TMG(22706.9,"DRUGT",IEN50,""))
        . if IEN22706d9'="" set Options("IEN LIST",IEN22706d9)=""
        . set IEN22706d9=$order(^TMG(22706.9,"DRUG",IEN50,""))
        . if IEN22706d9'="" set Options("IEN LIST",IEN22706d9)=""
 
        set Options("FIELDS",1)=".055^TRADE NAME & FORM - 40^35"
        set Options("FIELDS",1,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",2)=".075^,@pSource@(tIEN,IEN)=""^35"
        set Options("FIELDS",2,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",3)="6^SKIP THIS RECORD^5"
        set Options("FIELDS","MAX NUM")=3
        set Options("FILE")="22706.9^TMG FDA IMPORT COMPILED"
 
        new temp
        set temp=$$SELED^TMGSELED(.Options)
 
        quit
