TMGNDF4A ;TMG/kst/FDA Import: Create POI's from DRUGs ;03/25/06
         ;;1.0;TMG-LIB;**1**;11/21/06
 
 ;" FDA - NATIONAL DRUG FILES COMPILING FUNCTIONS
 ;"      Creation of records in file 50.7 (PHARMACY ORDERABLE ITEM file)
 ;"      from all records stored in file 50 (DRUG file)
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"11-21-2006
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"Menu
 
 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 ;"InactivatePOIs -- inactivate all POI (entries in PHARMACY ORDERABLE ITEMS)
 ;"ActivatePOI(IEN50d7) -- remove the inactivation date that is automatically added
 ;"HandlePOIErr -- error handler for ActivatePOI
 
 ;"SyncAllTMG -- Add all relevent TMG entries into POI
 ;"AddFromTMG(IEN) -- Add/Update ONE entry in POI file
 ;"Do1POI(DrugNAF,IEN50,IEN50d606,IEN51d2) -- add/refresh one POI entry.
 
 ;"=============================================================================
 ;"=============================================================================
 
Menu
        new Menu,UsrSlct
        set Menu(0)="Pick Option to Sync to PHARMACY ORDERABLE ITEMS (4A)"
        set Menu(1)="Sync Non-Skipped Imports to PHARMACY ORDERABLE ITEMS."_$char(9)_"SyncDRUGs"
        ;"set Menu(2)="Activate all PHARMACY ORDERABLE ITEMS (do after syncing)"_$char(9)_"ActivateAll"
        set Menu(3)="Kill all previous PHARMACY ORDERABLE ITEMS (only if needed!)"_$char(9)_"KillAll"
        set Menu("P")="Prev Stage"_$char(9)_"Prev"
        set Menu("N")="Next Stage"_$char(9)_"Next"
 
M1      write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
 
        if UsrSlct="SyncDRUGs" do SyncAllTMG goto M1
        ;"if UsrSlct="ActivateAll" do ActivAll goto M1
        if UsrSlct="KillAll" do KillPOIs goto M1
        if UsrSlct="Prev" goto Menu^TMGNDF3E  ;"quit can occur from there...
        if UsrSlct="Next" goto Menu^TMGNDF4B  ;"quit can occur from there...
        if UsrSlct="^" goto MenuDone
        goto M1
 
MenuDone
        quit
 
 
 ;"=============================================================================
 ;"File 50.7 (PHARMACY ORDERABLE ITEM):
 ;"
 ;" **A record in 50.7 should be created first.
 ;" .01 field should be the generic name of the drug.
 ;" When the record is created, an entry in fle 101.43 (ORDERABLE ITEM) will automatically be made.
 ;" Also, a record in in ORDER QUICK VIEW will also be created (but it is incomplete--see below.)
 ;" Note: new drugs may not be added unless PSEDITNM>0.  So to setup a drug in fileman,
 ;"       set PSEDITNM=1 from the command-line, then DO D^DI to get into Fileman with vars intact.
 ;" In the MED ROUTE field, the input transform does not allow an input of "ORAL".  (If left
 ;" blank ORAL will be shown in CPRS)
 ;" This file can hold the synonyms of a drug etc.
 ;" When this record is created, for some reason it is automatically given the current
 ;"   date in the INACTIVE DAT
        ;"Purpose: to Ask E field--meaning it is created in an inactive state.  One must
 ;"   go back and edit the record a second time to remove the entry from this field.
 ;" File 101.43 (ORDERABLE ITEM), field ID holds a text pointer to this file, e.g.
 ;" '10;99PSP' <---- 10 is IEN in file #50.7
 ;" There is no pointer field from file 50.7 up to file 50.  The link is FROM file #50
 ;" TO #50.7 (via file #50's field 2.1(PHARMACY ORDERABLE ITEM)).  HOWEVER, File #50.7's
 ;" "ASP" cross-reference for the field "PHARMACY ORDERABLE ITEM (#2.1) i.e.
 ;" ^PSDRUG("ASP",+ID,*), contains list of linked records in file #50
 
 ;"=================================================================
 
SyncAllTMG
        ;"Purpose: Sync/Add all relevent TMG entries into POI
        ;"Input:none
        ;"results: none
 
        new IEN,Itr
        new abort set abort=0
        new result set result=0
        new repeatNeeded set repeatNeeded=0
 
SATL1   set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)!(abort=1)
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . new Option
        . set Option("CUR MODE")="TRADE"
        . set result=$$POIFromTMG(IEN,.Option)  ;"screen for skip will occur in function
        . if result=-1 set repeatNeeded=1
        . set Option("CUR MODE")="GENERIC"
        . set result=$$POIFromTMG(IEN,.Option)  ;"screen for skip will occur in function
        . if result=-1 set repeatNeeded=1
 
        new % set %=2
        if repeatNeeded do
        . write !,"Error found and repeat scan needed.",!
        . write "Repeat scan now" do YN^DICN write !
        else  do
        . write !
        . do PressToCont^TMGUSRIF
        if %=1 goto SATL1
 
        quit
 
 
POIFromTMG(IEN22706d9,Option)
        ;"Purpose: to Add/Update/(or delete) ONE entry in POI (50.7) file
        ;"Input:  IEN22706d9 -- IEN in 22706.9
        ;"       Option -- NON-OPTIONAL part. Format:
        ;"                  Option("CUR MODE")="TRADE" or "GENERIC"
        ;"        Option -- OPTIONAL. Format:
        ;"                  Option("FIX CHAIN")=1  <--- changes will be propigate forward
        ;"                   to file POI, OI, OQV etc.
        ;"                  OPTION("FIX CHAIN","IEN22706d9")=Source IEN
        ;"                  Option("IEN50","TRADE")=IEN50 for Trade Name
        ;"                  Option("IEN50","GENERIC")=IEN50 for Generic Name
        ;"                  Option("CUR MODE")="TRADE" or "GENERIC"
        ;"                  Option("QUIET")=1 <-- supress text output
        ;"                  Option("DELETING")=1 <-- deleting chain (not IEN22706d9)
 
        ;"NOTE: This function does DOES screen for skipped entries, and skips
        ;"      proccessing. BUT, if Deleting, then it is NOT skipped
        ;"Output: POI records will be added or refreshed (or deleted)
        ;"Result: 1=OK, 0=Error, -1 process repeat requested
 
        new result set result=1
        new repeatNeeded set repeatNeeded=0
        new TMGA,TMGMSG
        new IEN50d606,IEN51d2,IEN50d7
 
        if $get(Option("DELETING"))'=1,$piece($get(^TMG(22706.9,IEN22706d9,1)),"^",4)=1 goto AFTMGDone  ;"1=SKIP
        if +$get(IEN22706d9)=0 goto AFTMGDone
 
        new mode set mode=$get(Option("CUR MODE"))
        if mode="" set result=0 goto AFTMGDone
        new field,node,pce
        if mode="GENERIC" set field=5.71,node=8,pce=4  ;"5.71= POI ptr Generic
        else  if mode="TRADE" set field=5.61,node=8,pce=3  ;"5.61 = POI ptr Trade
 
        do LoadOption^TMGNDF4C(IEN22706d9,.Option)
 
        set IEN50d606=$piece($get(^TMG(22706.9,IEN22706d9,0)),"^",7)
        set IEN51d2=$piece($get(^TMG(22706.9,IEN22706d9,7)),"^",7)
        new IEN50 set IEN50=+$get(Option("IEN50",mode))
        if IEN50=0 set result=0 goto AFTM2
 
        new DrugNAF set DrugNAF=$get(Option("DRUG NAME AND FORM",mode))
        if (DrugNAF="<DUPLICATE>")!(DrugNAF="") goto AFTM2  ;"skip these...
 
        set IEN50d7=+$get(Option("IEN50.7",mode))
 
        if $get(Option("DELETING"))=1 do  goto AFTMGDone
        . do KillPOI^TMGNDFUT(IEN50d7)
        . set Option("IEN50.7",mode)=""
 
        if IEN50d7=0 set IEN50d7=$$FindPOI^TMGNDFUT(DrugNAF)
        if IEN50d7=0 do  if IEN50d7=0 set result=0 goto AFTM2
        . new TMGFDA,TMGIEN,TMGMSG
        . new PSEDITNM set PSEDITNM=1 ;"a key to allow editing data
        . set TMGFDA(50.7,"+1,",.01)=DrugNAF
        . set TMGFDA(50.7,"+1,",.02)=IEN50d606
        . set TMGFDA(50.7,"+1,",.06)=IEN51d2
        . set TMGFDA(50.7,"+1,",.07)="R"
        . do UPDATE^DIE("","TMGFDA","TMGIEN","TMGMSG")
        . if $data(TMGMSG("DIERR")) do
        . . set result=0
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . else  set IEN50d7=+$get(TMGIEN(1))
        else  do
        . new TMGFDA,TMGIEN,TMGMSG
        . new PSEDITNM set PSEDITNM=1 ;"a key to allow editing data
        . set TMGFDA(50.7,IEN50d7_",",.01)=DrugNAF
        . set TMGFDA(50.7,IEN50d7_",",.02)=IEN50d606
        . set TMGFDA(50.7,IEN50d7_",",.06)=IEN51d2
        . set TMGFDA(50.7,IEN50d7_",",.07)="R"
        . new temp set temp=$$TrimFDA^TMGDBAPI(.TMGFDA)
        . if $data(TMGFDA)=0 quit
        . do FILE^DIE("S","TMGFDA","TMGMSG")
        . if $data(TMGMSG("DIERR")) do
        . . set result=0
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . . if $get(TMGMSG("DIERR",1))=601 do  ;"601 --> [record doesn't exist]
        . . . write "Dangling pointer found & removed.  ** RUN ENTIRE PROCESS AGAIN **",!
        . . . set IEN50d7=0
        . . . new TMGFDA,TMGMSG
        . . . set TMGFDA(22706.9,IEN22706d9_",",field)="@"
        . . . do FILE^DIE("S","TMGFDA","TMGMSG")
        . . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . . . kill TMGFDA,TMGMSG
        . . . set TMGFDA(50,IEN50_",",2.1)="@"
        . . . do FILE^DIE("S","TMGFDA","TMGMSG")
        . . . set repeatNeeded=1
        . . . set result=-1
        . . . if $data(TMGMSG("DIERR")) do
        . . . . if $data(TMGMSG("DIERR","E",120))>0 set result="" quit  ;"ignore error if #120 (hook) present.
        . . . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
 
        set Option("IEN50.7",mode)=IEN50d7
 
        ;"Ensure pointer to POI stored in TMG IMPORT COMPILED
        if +$piece($get(^TMG(22706.9,IEN22706d9,node)),"^",pce)'=IEN50d7 do
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.9,IEN22706d9_",",field)=IEN50d7
        . do FILE^DIE("","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . set Option("IEN50.7",mode)=IEN50d7
 
        ;"Ensure pointer to POI stored in DRUG file, field 2.1
        if +$piece($get(^PSDRUG(IEN50,2)),"^",1)'=IEN50d7 do
        . new TMGFDA,TMGMSG
        . set TMGFDA(50,IEN50_",",2.1)=IEN50d7
        . do FILE^DIE("S","TMGFDA","TMGMSG")
        . set result=0
        . if $data(TMGMSG("DIERR")) do
        . . if $data(TMGMSG("DIERR","E",120))>0 set result="" quit  ;"ignore error if #120 (hook) present.
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
 
AFTM2
        if $get(Option("FIX CHAIN"))=1 do   ;"pass message forward for fix
        . do Activ1TMG^TMGNDF4B(IEN22706d9)
        . new temp set temp=$$OIFromTMG^TMGNDF4C(IEN22706d9,.Option) ;" <-- more chaining from this
        . ;"if $get(Option("DELETING"))=1 do
        . ;". new IEN50 set IEN50=+$get(Option("IEN50",mode))
        . ;". if IEN50=0 write "?? 1 -- In POIFromTMG^TMGNDF4A.",! quit
        . ;". new IEN50d7 set IEN50d7=+$get(Option("IEN50d7",mode))
        . ;". if IEN50d7=0 set IEN50d7=+$piece(^PSDRUG(IEN50,2),"^",1) ;"try a second way
        . ;". if IEN50d7=0 write "?? 2 -- In POIFromTMG^TMGNDF4A.",! quit
        . ;". new numRef set numRef=$$ListCt^TMGMISC($name(^PSDRUG("ASP",IEN50d7)))
        . ;". if numRef>1 quit ;"don't kill POI if another drug in 50 points to it
        . ;". new TMGFDA,TMGMSG,TMGIEN
        . ;". new PSEDITNM set PSEDITNM=1 ;"a key to allow editing data
        . ;". set TMGFDA(50.7,IEN50d7_",",.01)="@"  ;"delete pointer from file 50
        . ;". do FILE^DIE("EK","TMGFDA","TMGMSG")
        . ;". if $$ShowIfError^TMGDBAPI(.TMGMSG) quit
        . ;". ;"Now delete from TMG IMPORT COMPILED
        . ;". new field
        . ;". if mode="GENERIC" set field=5.71
        . ;". else  if mode="TRADE" set field=5.61
        . ;". else  write "Can't delete pointer to 50.7 from 22706.9.",!,"Can't determine if GENERIC or TRADE mode.",! quit
        . ;". set TMGFDA(22706.9,IEN22706d9_",",field)="@"  ;"delete pointer from TMG IMPORT COMPILED
        . ;". do FILE^DIE("EK","TMGFDA","TMGMSG")
        . ;". if $$ShowIfError^TMGDBAPI(.TMGMSG) quit
 
AFTMGDone
        if repeatNeeded=1 set result=-1
        quit result
 
 ;" === Do1POI is old -- delete later...
Do1POI(IEN22706d9,IEN50d606,IEN51d2,Option)
        ;"Purpose: add/refresh one PHARMACY ORDERABLE ITEM (POI) entry.
        ;"Input: IEN22706d9 -- IEN in 22706.9
        ;"       IEN50d606 -- IEN in 50.606
        ;"       IEN51d2 -- IEN in 51.2
        ;"       Option -- NON-OPTIONAL PART. Format:
        ;"                  Option("CUR MODE")="TRADE" or "GENERIC"
        ;"                  Option("IEN50.7","TRADE")=IEN50.7 for Trade Name
        ;"                  Option("IEN50.7","GENERIC")=IEN50.7 for Generic Name
        ;"                  Option("DRUG NAME AND FORM","TRADE")=Trade Name and Form
        ;"                  Option("DRUG NAME AND FORM","GENERIC")=Generic Name and Form
        ;"                  Option("IEN50","TRADE")=IEN50 for Trade Name
        ;"                  Option("IEN50","GENERIC")=IEN50 for Generic Name
        ;"       Option -- OPTIONAL. Format:
        ;"                  Option("FIX CHAIN")=1  <--- changes will be propigate forward
        ;"                   to file POI, OI, OQV etc.
        ;"                  OPTION("FIX CHAIN","IEN22706d9")=Source IEN
        ;"                  Option("QUIET")=1 <-- supress text output
        ;"                  Option("DELETING")=1 <-- deleting chain (not IEN22706d9)
        ;"Result: IEN50d7 if OK, -1 =Error, -2 process repeat requested
 
        new result set result=""  ;"default to null
        new TMGA,TMGMSG
        new IEN50d7 set IEN50d7=-1 ;"default to error
        new mode set mode=$get(Option("CUR MODE"))
        if mode="" write "ERROR: in Do1POI^TMGNDF4A.  Mode not supplied.",! goto D1PDone
        new DrugNAF set DrugNAF=$get(Option("DRUG NAME AND FORM",mode))
        if (DrugNAF="<DUPLICATE>")!(DrugNAF="") goto D1PDone  ;"skip these...
        new IEN50 set IEN50=+$get(Option("IEN50",mode)) if IEN50=0 set result=-1 goto D1PDone
        new IEN50d7 set IEN50d7=+$get(Option("IEN50.7",mode))
        new field,node,pce
        if mode="GENERIC" set field=5.71,node=8,pce=4  ;"5.71= POI ptr Generic
        else  if mode="TRADE" set field=5.61,node=8,pce=3  ;"5.61 = POI ptr Trade
 
        if IEN50d7=0 set IEN50d7=$$FindPOI^TMGNDFUT(DrugNAF)
        if IEN50d7=0 do
        . new TMGFDA,TMGIEN,TMGMSG
        . new PSEDITNM set PSEDITNM=1 ;"a key to allow editing data
        . set TMGFDA(50.7,"+1,",.01)=DrugNAF
        . set TMGFDA(50.7,"+1,",.02)=IEN50d606
        . set TMGFDA(50.7,"+1,",.06)=IEN51d2
        . set TMGFDA(50.7,"+1,",.07)="R"
        . do UPDATE^DIE("","TMGFDA","TMGIEN","TMGMSG")
        . if $data(TMGMSG("DIERR")) do
        . . set result=-1
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . else  set IEN50d7=+$get(TMGIEN(1))
        else  do
        . new TMGFDA,TMGIEN,TMGMSG
        . new PSEDITNM set PSEDITNM=1 ;"a key to allow editing data
        . set TMGFDA(50.7,IEN50d7_",",.01)=DrugNAF
        . set TMGFDA(50.7,IEN50d7_",",.02)=IEN50d606
        . set TMGFDA(50.7,IEN50d7_",",.06)=IEN51d2
        . set TMGFDA(50.7,IEN50d7_",",.07)="R"
        . new temp set temp=$$TrimFDA^TMGDBAPI(.TMGFDA)
        . if $data(TMGFDA)=0 quit
        . do FILE^DIE("S","TMGFDA","TMGMSG")
        . if $data(TMGMSG("DIERR")) do
        . . set result=-1
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . . if $get(TMGMSG("DIERR",1))=601 do  ;"601 --> [record doesn't exist]
        . . . write "Dangling pointer found & removed.  ** RUN ENTIRE PROCESS AGAIN **",!
        . . . set IEN50d7=0
        . . . new TMGFDA,TMGMSG
        . . . set TMGFDA(22706.9,IEN22706d9_",",field)="@"
        . . . do FILE^DIE("S","TMGFDA","TMGMSG")
        . . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . . . kill TMGFDA,TMGMSG
        . . . set TMGFDA(50,IEN50_",",2.1)="@"
        . . . do FILE^DIE("S","TMGFDA","TMGMSG")
        . . . set result=-1
        . . . if $data(TMGMSG("DIERR")) do
        . . . . if $data(TMGMSG("DIERR","E",120))>0 set result="" quit  ;"ignore error if #120 (hook) present.
        . . . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
 
        if +IEN50d7=0 set result=-1 goto D1PDone
 
        ;"if +$get(Option("IEN50.7",mode))=0 do
        ;". new TMGFDA,TMGMSG
        ;". set TMGFDA(22706.9,IEN22706d9_",",field)=IEN50d7
        ;". do FILE^DIE("S","TMGFDA","TMGMSG")
        ;". do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        ;". set Option("IEN50.7",mode)=IEN50d7
 
        ;"Store pointer to POI in TMG IMPORT COMPILED
        if +$piece($get(^TMG(22706.9,IEN22706d9,node)),"^",pce)'=IEN50d7 do
        . new TMGFDA,TMGMSG
        . set TMGFDA(22706.9,IEN22706d9_",",field)=IEN50d7
        . do FILE^DIE("","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . set Option("IEN50.7",mode)=IEN50d7
 
        if +$piece($get(^PSDRUG(IEN50,2)),"^",1)'=IEN50d7 do
        . new TMGFDA,TMGMSG
        . set TMGFDA(50,IEN50_",",2.1)=IEN50d7
        . do FILE^DIE("S","TMGFDA","TMGMSG")
        . set result=-1
        . if $data(TMGMSG("DIERR")) do
        . . if $data(TMGMSG("DIERR","E",120))>0 set result="" quit  ;"ignore error if #120 (hook) present.
        . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
 
D1PDone
        if result="" set result=IEN50d7
        quit result
 
 ;"=================================================================
 ;"=================================================================
 
 
InactivatePOIs
        ;"Purpose: To inactivate all POI (entries in PHARMACY ORDERABLE ITEMS)
        ;"          This will prevent left-over entries from a prior run to cause problems
 
        new Itr,IEN
        new abort set abort=0
        write "Inactivating all prior PHARMACY ORDERABLE ITEMS...",!
        set IEN=$$ItrInit^TMGITR(50.7,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . new TMGFDA,TMGMSG
        . set TMGFDA(50.7,IEN_",",.04)="NOW"
        . do FILE^DIE("KE","TMGFDA","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        do ProgressDone^TMGITR(.Itr)
 
        quit
 
 
ActivAll
        ;"DISABLED... THIS SHOULD BE DONE IN TMENDF4B...
 
        ;"Purpose: to activate all POI's
 
        new Itr,IEN
        new abort set abort=0
        set IEN=$$ItrInit^TMGITR(50.7,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:(+$$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . new temp
        . set temp=$$ActivatePOI(IEN)
        do ProgressDone^TMGITR(.Itr)
 
        quit
 
 
 
ActivatePOI(IEN50d7)
        ;"Purpose: to remove the inactivation date that is automatically
        ;"         added with editing of the POI record
        ;"result: 1 = OK, 0=error
 
        new result set result=1
 
        new TMGFDA,TMGMSG
        set TMGFDA(50.7,IEN50d7_",",.04)="@"  ;"delete inactivation date field value
        do
        . new $etrap set $etrap="do HandlePOIErr^TMGNDF4A quit"
        . do FILE^DIE("ES","TMGFDA","TMGMSG")
        if $data(TMGMSG("DIERR"))'=0 do  goto APOIDone
        . do ShowDIERR^TMGDEBUG(.TMGMSG,.PriorErrorFound)
        . set result=0
        . write "Error occurred in function ActivatePOI",!
        . zwr TMGFDA
APOIDone
        quit result
 
 
HandlePOIErr
        ;"Purpose: An error handler for ActivatePOI
        set $ECODE=""
        if result=0 quit
        set result=0
        write "Error encountered activating Pharmacy Orderable Item: "
        write $piece($get(^PS(50.7,IEN50d7,0)),"^",1)," (#",IEN50d7,")",!
        ;"Note: below won't set needed xrefs etc.
        ;"set $piece(^PS(50.7,IEN50d7,0),"^",4)=""
        ;"write "Fixed with low-level removal of inactivation date.",!
        quit
 
 
 
KillPOIs
        ;"Purpose: to kill all POI's, do allow fresh start (after errors)
 
        new % set %=2
        write "Are you sure you want to perminantly KILL all PHARMACY ORDERABLE ITEMS"
        do YN^DICN
        if %'=1 goto KPOIDone
 
        new Itr,IEN50d7
        new abort set abort=0
        set IEN50d7=$$ItrInit^TMGITR(50.7,.Itr)
        do PrepProgress^TMGITR(.Itr,2,0,"IEN50d7")
        if IEN50d7'="" for  do  quit:(+$$ItrNext^TMGITR(.Itr,.IEN50d7)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . do KillPOI^TMGNDFUT(IEN50d7)
        do ProgressDone^TMGITR(.Itr)
 
KPOIDone
        quit
