TMGTERM ;TMG/kst/Terminal interface (ANSI sequences) ;03/25/06
         ;;1.0;TMG-LIB;**1**;09/01/05

 ;"Terminal interface
 ;"ANSI Standard (X3.64) Control Sequences for Video Terminals and Peripherals
 ;"      in alphabetic order by mnemonic

 ;"Terminal interface
 ;"ANSI Standard (X3.64) Control Sequences for Video Terminals and Peripherals
 ;"      in alphabetic order by mnemonic

 ;"CBT(Pn)    ;CBT  Cursor Backward Tab  Esc [ Pn Z
 ;"CCH        ;Cancel Previous Character Esc T
 ;"CHA(Pn)    ;Cursor Horzntal Absolute  Esc [ Pn G
 ;"CHT(Pn)    ;Cursor Horizontal Tab     Esc [ Pn I
 ;"CNL(Pn)    ;Cursor Next Line          Esc [ Pn E
 ;"CPL(Pn)    ;Cursor Preceding Line     Esc [ Pn F
 ;"CPR(Pn,P2) ;Cursor Position Report Esc [ Pn ; Pn R     VT100
 ;"CTC(Pn)    ;Cursor Tab Control        Esc [ Ps W
 ;"CUB(Pn)    ;Cursor Backward           Esc [ Pn D          VT100
 ;"CUD(Pn)    ;Cursor Down               Esc [ Pn B          VT100
 ;"CUF(Pn)    ;Cursor Forward            Esc [ Pn C          VT100
 ;"CUP(X,Y)   ;Cursor Position        Esc [ Pn ; Pn H     VT100
 ;"HOME       ;Cursor Home               Esc [ H     ('home' is top left)
 ;"CUU(Pn)    ;Cursor Up                 Esc [ Pn A          VT100
 ;"CVT(Pn)    ;Cursor Vertical Tab       Esc [ Pn Y
 ;"DCH(Pn)    ;Delete Character          Esc [ Pn P
 ;"DL(Pn)     ;Delete Line               Esc [ Pn M
 ;"EA(Pn)     ;Erase in Area             Esc [ Ps O
 ;"ECH(Pn)    ;Erase Character           Esc [ Pn X
 ;"ED(Pn)     ;Erase in Display          Esc [ Ps J         VT100
 ;"EF(Pn)     ;Erase in Field            Esc [ Ps N
 ;"EL(Pn)     ;Erase in Line             Esc [ Ps K         VT100
 ;"EPA        ;End of Protected Area     Esc W
 ;"ESA        ;End of Selected Area      Esc G
 ;"FNT(Pn,P2) ;Font Selection            Esc [ Pn ; Pn Space D
 ;"GSM(Pn,P2) ;Graphic Size Modify       Esc [ Pn ; Pn Space B
 ;"GSS(Pn)    ;Graphic Size Selection    Esc [ Pn Space C
 ;"HPA(Pn)    ;Horz Position Absolute    Esc [ Pn `
 ;"HPR(Pn)    ;Horz Position Relative    Esc [ Pn a
 ;"HTJ        ;Horz Tab w/Justification  Esc I
 ;"HTS        ;Horizontal Tab Set        Esc H             VT100
 ;"HVP(Pn,P2) ;Horz & Vertical Position  Esc [ Pn ; Pn f  VT100
 ;"ICH(Pn)    ;Insert Character          Esc [ Pn @
 ;"IL(Pn)     ;Insert Line               Esc [ Pn L
 ;"IND        ;Index                     Esc D           VT100
 ;"NEL        ;Next Line                 Esc E           VT100
 ;"NP(Pn)     ;Next Page                 Esc [ Pn U
 ;"PP(Pn)     ;Preceding Page            Esc [ Pn V
 ;"IS         ;Reset to Initial State    Esc c
 ;"RM(Pn)     ;Reset Mode                Esc [ Ps l     VT100
 ;"SD(Pn)     ;Scroll Down               Esc [ Pn T
 ;"SL(Pn)     ;Scroll Left               Esc [ Pn Space @
 ;"SM(Pn)     ;Select Mode               Esc [ Ps h     VT100
 ;"SPA        ;Start of Protected Area   Esc V
 ;"SPI(Pn,P2) ;Spacing Increment         Esc [ Pn ; Pn Space G
 ;"SR(Pn)     ;Scroll Right              Esc [ Pn Space A
 ;"SA         ;Start of Selected Area    Esc F
 ;"ST         ;String Terminator         Esc \
 ;"SU(Pn)     ;Scroll Up                 Esc [ Pn S
 ;"TBC(Pn)    ;Tab Clear                 Esc [ Ps g        VT100
 ;"VPA(Pn)    ;Vert Position Absolute    Esc [ Pn d
 ;"VPR(Pn)    ;Vert Position Relative    Esc [ Pn e
 ;"VCULOAD    ;Unsave Cursor                              ESC [ u
 ;"VCUSAV2    ;Save Cursor & Attrs                        ESC 7
 ;"VCULOAD2   ;Restore Cursor & Attrs                     ESC 8

 ;"VT100 specific calls
 ;"--------------------
 ;"VCEL       ;Erase from cursor to end of line           Esc [ 0 K    or Esc [ K
 ;"VCBL       ;Erase from beginning of line to cursor     Esc [ 1 K
 ;"VEL        ;Erase line containing cursor               Esc [ 2 K
 ;"VCES       ;Erase from cursor to end of screen         Esc [ 0 J    or Esc [ J
 ;"VCBS       ;Erase from beginning of screen to cursor   Esc [ 1 J
 ;"VCS        ;Erase entire screen                        Esc [ 2 J
 ;"VCUSAV     ;Save Cursor                                ESC [ s
 ;"VTATRIB(n) ;Set Text attributes    <ESC>[{attr1};...;{attrn}m
 ;"VFGCOLOR(n);Set Text Foreground Color  <ESC>[{attr1};...;{attrn}m
 ;"VBGCOLOR(n);Set Text Background Color  <ESC>[{attr1};...;{attrn}m
 ;"VCOLORS(FG,BG) ;Set Text Colors   <ESC>[{attr1};...;{attrn}m
 ;"SetGlobals
 ;"KillGlobals
 ;"DemoColors
 ;"DemoClr2


 ;"=====================================================


EscN(Num,N2,Cmd)
       new tempX,tempY
       set tempX=$X
       set tempY=$Y
       set $X=1 ;"ensure escape chars don't cause a wrap.
       write $char(27,91)_Num
       if $data(N2) write ";"_N2
       if $data(Cmd) write Cmd
       ;"reset $X,$Y so that escape characters aren't counted for line wrapping
       set $X=tempX
       set $Y=tempY
       quit

CBT(Pn) ;"CBT  Cursor Backward Tab  Esc [ Pn Z
       do EscN(.Pn,,"Z")
       quit

CCH     ;"Cancel Previous Character Esc T
       write $char(27)_"T"

CHA(Pn) ;"Cursor Horzntal Absolute  Esc [ Pn G
       do EscN(.Pn,,"G")
       set $X=Pn
       quit

CHT(Pn) ;"Cursor Horizontal Tab     Esc [ Pn I
       do EscN(.Pn,,"I") quit

CNL(Pn) ;"Cursor Next Line          Esc [ Pn E
       do EscN(.Pn,,"E")
       set $Y=$Y+1
       quit

CPL(Pn) ;"Cursor Preceding Line     Esc [ Pn F
       do EscN(.Pn,,"F")
       if $Y>0 set $Y=$Y-1
       quit

CPR(Pn,P2) ;"Cursor Position Report Esc [ Pn ; Pn R     VT100
       do EscN(.Pn,.P2,"R") quit

CTC(Pn) ;"Cursor Tab Control        Esc [ Ps W
       do EscN(.Pn,,"W") quit

CUB(Pn) ;"Cursor Backward           Esc [ Pn D          VT100
       do EscN(.Pn,,"D")
       set $X=$X-1
       quit

CUD(Pn) ;"Cursor Down               Esc [ Pn B          VT100
       do EscN(.Pn,,"B")
       set $Y=$Y+1
       quit

CUF(Pn) ;"Cursor Forward            Esc [ Pn C          VT100
       do EscN(.Pn,,"C")
       set $X=$X+1
       quit

CUP(X,Y) ;"Cursor Position        Esc [ Pn ; Pn H     VT100
       do EscN(.Y,.X,"H")
       set $X=X
       set $Y=Y
       quit

HOME    ;"Cursor Home               Esc [ H     ('home' is top left)
       set $X=1  ;"ensure characters below don't cause a wrap.
       w $char(27,91)_"H"
       set $X=1  ;"now set $X to home value.
       set $Y=1
       quit

CUU(Pn) ;"Cursor Up                 Esc [ Pn A          VT100
       do EscN(.Pn,,"A")
       set $Y=$Y-1
       quit

CVT(Pn) ;"Cursor Vertical Tab       Esc [ Pn Y
       do EscN(.Pn,,"Y") quit

DCH(Pn) ;"Delete Character          Esc [ Pn P
       do EscN(.Pn,,"P") quit

DL(Pn)  ;"Delete Line               Esc [ Pn M
       do EscN(.Pn,,"M") quit

EA(Pn)  ;"Erase in Area             Esc [ Ps O
       do EscN(.Pn,,"O") quit

ECH(Pn) ;"Erase Character           Esc [ Pn X
       do EscN(.Pn,,"X") quit

ED(Pn)  ;"Erase in Display          Esc [ Ps J         VT100
       do EscN(.Pn,,"J") quit

EF(Pn)  ;"Erase in Field            Esc [ Ps N
       do EscN(.Pn,,"N") quit

EL(Pn)  ;"Erase in Line             Esc [ Ps K         VT100
       do EscN(.Pn,,"K") quit

EPA     ;"End of Protected Area     Esc W
       w $char(27)_"W" quit

ESA     ;"End of Selected Area      Esc G
       w $char(27)_"G" quit

FNT(Pn,P2) ;"Font Selection            Esc [ Pn ; Pn Space D
       do EscN(.Pn,P2,"D") quit

GSM(Pn,P2) ;"Graphic Size Modify       Esc [ Pn ; Pn Space B
       do EscN(.Pn,P2,"B") quit

GSS(Pn) ;"Graphic Size Selection    Esc [ Pn Space C
       do EscN(.Pn,,"C") quit

HPA(Pn) ;"Horz Position Absolute    Esc [ Pn `
       do EscN(.Pn,,"`") quit

HPR(Pn) ;"Horz Position Relative    Esc [ Pn a
       do EscN(.Pn,,"a") quit

HTJ     ;"Horz Tab w/Justification  Esc I
       w $char(27)_"I" quit

HTS     ;"Horizontal Tab Set        Esc H             VT100
       w $char(27)_"H" quit

HVP(Pn,P2) ;"Horz & Vertical Position  Esc [ Pn ; Pn f  VT100
       do EscN(.Pn,P2,"A") quit

ICH(Pn) ;"Insert Character          Esc [ Pn @
       do EscN(.Pn,,"@") quit

IL(Pn)  ;"Insert Line               Esc [ Pn L
       do EscN(.Pn,,"L") quit

IND     ;"Index                     Esc D           VT100
       w $char(27)_"D" quit

NEL     ;"Next Line                 Esc E           VT100
       w $char(27)_"E" quit

NP(Pn)  ;"Next Page                 Esc [ Pn U
       do EscN(.Pn,,"U") quit

PP(Pn)  ;"Preceding Page            Esc [ Pn V
       do EscN(.Pn,,"V") quit

IS      ;"Reset to Initial State    Esc c
       w $char(27)_"c" quit

RM(Pn)  ;"Reset Mode                Esc [ Ps l     VT100
       do EscN(.Pn,,"l") quit

SD(Pn)  ;"Scroll Down               Esc [ Pn T
       do EscN(.Pn,,"T") quit

SL(Pn)  ;"Scroll Left               Esc [ Pn Space @
       do EscN(.Pn,," @") quit

SM(Pn)  ;"Select Mode               Esc [ Ps h     VT100
       do EscN(.Pn,,"h") quit

SPA     ;"Start of Protected Area   Esc V
       w $char(27)_"V" quit

SPI(Pn,P2) ;"Spacing Increment         Esc [ Pn ; Pn Space G
       do EscN(.Pn,P2," G") quit

SR(Pn)  ;"Scroll Right              Esc [ Pn Space A
       do EscN(.Pn,," A") quit

SA      ;"Start of Selected Area    Esc F
       w $char(27)_"F" quit

ST      ;"String Terminator         Esc \
       w $char(27)_"\" quit

SU(Pn)  ;"Scroll Up                 Esc [ Pn S
       do EscN(.Pn,,"S") quit

TBC(Pn) ;"Tab Clear                 Esc [ Ps g        VT100
       do EscN(.Pn,,"g") quit

VPA(Pn) ;"Vert Position Absolute    Esc [ Pn d
       do EscN(.Pn,,"d") quit

VPR(Pn) ;"Vert Position Relative    Esc [ Pn e
       do EscN(.Pn,,"e") quit


VCULOAD ;"Unsave Cursor                              ESC [ u
       w $char(27,91)_"u" quit

VCUSAV2 ;"Save Cursor & Attrs                        ESC 7
       w $char(27)_"7" quit

VCULOAD2 ;"Restore Cursor & Attrs                    ESC 8
       w $char(27)_"8" quit


 ;"--------------------------------------------------------------
 ;"VT100 specific calls
 ;"Terminal interface

VCEL    ;"Erase from cursor to end of line           Esc [ 0 K    or Esc [ K
       do EscN("0",,"K") quit

VCBL    ;"Erase from beginning of line to cursor     Esc [ 1 K
       do EscN("1",,"K") quit

VEL     ;"Erase line containing cursor               Esc [ 2 K
       do EscN("2",,"K") quit

VCES    ;"Erase from cursor to end of screen         Esc [ 0 J    or Esc [ J
       do EscN("0",,"J") quit

VCBS    ;"Erase from beginning of screen to cursor   Esc [ 1 J
       do EscN("1",,"J") quit

VCS     ;"Erase entire screen                        Esc [ 2 J
       do EscN("2",,"J") quit

VCUSAV  ;"Save Cursor                                ESC [ s
       w $char(27,91)_"s" quit

 ;"VCULOAD ;"Unsave Cursor                              ESC [ u
 ;"       w $char(27,91)_"u" quit

 ;"VCUSAV2 ;"Save Cursor & Attrs                        ESC 7
 ;"       w $char(27)_"7" quit

 ;"VCULOAD2 ;"Restore Cursor & Attrs                    ESC 8
 ;"       w $char(27)_"8" quit

VTATRIB(n) ;"Set Text attributes    <ESC>[{attr1};...;{attrn}m
       ;"0-Reset all attributes
       ;"1-Bright
       ;"2-Dim
       ;"4-Underscore
       ;"5-Blink
       ;"7-Reverse
       ;"8-Hidden
       do EscN(n,,"m") quit

VFGCOLOR(n) ;"Set Text Foreground Color  <ESC>[{attr1};...;{attrn}m
        ;"See note about colors in VCOLORS
       do VTATRIB(0)
       if n>7 do
       . do VTATRIB(1)
       . set n=n-7
       set n=n+30
       do EscN(n,,"m") quit

VBGCOLOR(n) ;"Set Text Background Color  <ESC>[{attr1};...;{attrn}m
        ;"See note about colors in VCOLORS
       do VTATRIB(0)
       if n>7 do
       . do VTATRIB(1)
       . set n=n-7
       set n=n+40
       do EscN(n,,"m") quit

VCOLORS(FG,BG) ;Set Text Colors   <ESC>[{attr1};...;{attrn}m
       ;"Note: 5/29/06  I don't know if the color numbers are working
       ;"       correctly.  The best way to determine what the color should
       ;"       be is to run DemoColor and pick the numbers wanted for desired colors
       do VTATRIB(0)
       if FG>7 do
       . do VTATRIB(1)
       . set FG=FG-7
       if BG>7 do
       . do VTATRIB(1)
       . set BG=BG-7

       set FG=FG+30
       set BG=BG+40
       do EscN(FG,BG,"m") quit
       quit

SetGlobals
       set TMGcBlack=0
       set TMGcRed=1
       set TMGcGreen=2
       set TMGcYellow=3
       set TMGcBlue=4
       set TMGcMagenta=5
       set TMGcCyan=6
       set TMGcGrey=7

       set TMGcBRed=8
       set TMGcBGreen=9
       set TMGcBYellow=10
       set TMGcBBlue=11
       set TMGcBMagenta=12
       set TMGcBCyan=13
       set TMGcBGrey=14,TMGcFGBWhite=14
       set TMGcWhite=15

       quit

KillGlobals
       kill TMGcBlack
       kill TMGcRed
       kill TMGcGreen
       kill TMGcYellow
       kill TMGcBlue
       kill TMGcMagenta
       kill TMGcCyan
       kill TMGcGrey

       kill TMGcBRed
       kill TMGcBGreen
       kill TMGcBYellow
       kill TMGcBBlue
       kill TMGcBMagenta
       kill TMGcBCyan
       kill TMGcBGrey
       kill TMGcWhite
       kill TMGcFGBWhite
       quit

ColorBox(SetBG,SetFG)
        ;"Purpose: to write a grid on the screen, showing all the color combos
        ;"Input: SetBG -- OPTIONAL.  If data sent, then ONLY that background will be shown.
        ;"                            (i.e. for only picking a foreground color)
        ;"       SetFG -- OPTIONAL.  If data sent, then only for picking background color
        new fg,bg
        ;"write "SetBG=",$get(SetBG),!
        ;"write "SetFG=",$get(SetFG),!
        if $data(SetFG)#10=0 do
        . write "FG:",?10
        . for fg=0:1:15 do
        . . write $$RJ^XLFSTR(fg,2)," "
        . write !

        new start,finish
        set start=0,finish=15
        if ($data(SetBG)#10=1) do
        . set (start,finish)=SetBG
        for bg=start:1:finish do
        . if bg=0 write "BG:"
        . write ?7,$$RJ^XLFSTR(bg,2),?10
        . for fg=0:1:15 do
        . . do VCOLORS(fg,bg)
        . . if $data(SetFG)#10=0 do
        . . . write " X "
        . . else  do
        . . . write "   "
        . . do VTATRIB(0)
        . write !
        quit

Pick1Color(Label,InitValue)
        ;"Purpose: prompt user to pick a color
        ;"Input: Label -- Foreground or background
        ;"       InitValue.  Value to return if nothing selected.
        ;"Results: returns value 0-15 if selected, or -1 if abort.
        new result
        write "Enter "_Label_" color number (0-15,^ to abort): "
        read result:$get(DTIME,3600),!
        if (result="")!(+result'=result)!(+result<0)!(+result>15) set result=+$get(InitValue)
        quit result

PickFGColor(fg,bg)
        ;"Purpose: prompt user to pick a foreground color
        ;"Input -- fg.  Value to return if nothing selected.
        ;"Results: returns value 0-15 if selected, or -1 if abort.
        do ColorBox(.bg)
        new result set result=$$Pick1Color("Foreground (FG)",.fg)
        quit result

PickBGColor(InitValue)
        ;"Purpose: prompt user to pick a background color
        ;"Input -- InitValue.  Value to return if nothing selected.
        ;"Results: returns value 0-15 if selected, or -1 if abort.
        do ColorBox(,1)
        new result set result=$$Pick1Color("Background (BG)",.InitValue)
        quit result

PickColors(fg,bg)
        ;"Purpose: prompt user to pick a FG and BG colors
        ;"Results: returns value 0-15
        do ColorBox()
        set fg=$$Pick1Color("Foreground (FG)",.fg)
        set bg=$$Pick1Color("Background (BG)",.bg)
        quit

DemoColors
        ;"Purpose: to write a lines on the screen, showing all the color combos
        do VCUSAV2
        new fg,bg
        for bg=1:1:14 do
        . for fg=1:1:14 do
        . . do VCOLORS(fg,bg)
        . . write "Text with background color #",bg," and foreground color #",fg
        . . do VTATRIB(0)
        . . write !
        do VCULOAD2
        quit


