TMGTRNRP ;TMG/kst/TRANSCRIPTION REPRINT REPORT FUNCTIONS ;03/25/06
         ;;1.0;TMG-LIB;**1**;09/01/05
 
 ;" TRANSCRIPTION REPRINT REPORT FUNCTIONS
 
        ;"=======================================================================
        ;" API -- Public Functions.
        ;"=======================================================================
        ;"REPRINTSET
        ;"PRTEMPL  -- RE-PRINT TEMPLATE
 
        ;"=======================================================================
        ;" Private Functions.
        ;"=======================================================================
        ;"LoadBatches(CompArray)
        ;"ShowBatchInfo(Info)
        ;"ShowSummary(Summary)
        ;"OneLineSummary(Summary,Array,Batch)
        ;"SummarizeBatchInfo(Info,Summary)
        ;"GetBatchInfo(Job,Info)
        ;"GetDocInfo(DocIEN,Info)
 
 
 
REPRINTSET
        ;"Purpose: In our setting, we have the transcriptionists signing documents for the physicians,
        ;"              because they won't sign them for themselves.  A problem arose where the notes
        ;"              were not properly printed at the time of signing.  So this function allows a user
        ;"              to browse through the batches of signed documents, and reprint them.
 
        new CompArray
        new SelectedBatch set SelectedBatch=0
        new done set done=0
 
        write #,!
        write "  --------------------------------------------------",!
        write "  Re-Print Documents that were Batch-Signed.",!
        write "  --------------------------------------------------",!
        write !,"Scanning documents... Please wait.",!
 
        do LoadBatches(.CompArray)
 
Loop1
        write #,!
        write "  --------------------------------------------------",!
        write "  Re-Print Documents that were Batch-Signed.",!
        write "  --------------------------------------------------",!
        write "  How would you like to search for the correct batch?",!
        write "  1. By Date Signed.",!
        write "  2. By Transcriptionist.",!
        write "  3. By Author.",!
        write "  4. By Visit date.",!
        write "  5. Exit",!!
 
        new input
        read "Enter Number of Option: ",input:$get(DTIME,3600),!
        if (input="")!(input="^") set input="5"
 
        if input="1" do
        . set SelectedBatch=$$BrowseBy^TMGTREE(.CompArray,"BY-SIGNED")
        else  if input="2" do
        . set SelectedBatch=$$BrowseBy^TMGTREE(.CompArray,"BY-TRANS")
        else  if input="3" do
        . set SelectedBatch=$$BrowseBy^TMGTREE(.CompArray,"BY-AUTHOR")
        else  if input="4" do
        . set SelectedBatch=$$BrowseBy^TMGTREE(.CompArray,"BY-VISITDATE")
        else  if input="5" set done=1
 
        if SelectedBatch>0 do
        . set done=$$PrintBatch(SelectedBatch)
 
        if done=0 goto Loop1
 
RPSDone
        write !,"Goodbye.",!
        quit
 
 
PrintBatch(SelectedBatch)
        ;"Purpose: To reprint a set of batch signed documents
        ;"Input: the SelectedBatch (really a job number) to print
        ;"Result: 1 if print OK.  0 if user cancels
 
        new result set result=0
 
        write !,"Great, you have selected batch: #",SelectedBatch,!
        new Info,input
        if $$GetBatchInfo(SelectedBatch,.Info) do
        . do ShowBatchInfo(.Info)
        . read !,"Reprint this batch? YES// ",input:$get(DTIME,3600),!
        . if input="" set input="Y"
        . if ("YesyesYES"[input)=0 quit
        . new PrintArray
        . merge PrintArray=^TMG("BATCH SIGNED DOCS",SelectedBatch)
        . do PRINT^TMGTRAN1(.PrintArray)
        . set result=1
 
PBDone
        quit result
 
 
LoadBatches(CompArray)
        ;"Purpose: to browse through the batches, and allow user to select one
        ;"Input:  compArray -- PASS BY REFERENCE -- an array to put composite into
        ;"Results: returns a batch/job number
 
        new cTmp set cTmp="BATCH SIGNED DOCS"
        new Batch
 
        set Batch=$order(^TMG(cTmp,""))
        if Batch'="" for  do  quit:(Batch="")
        . new Info,Summary
        . if $$GetBatchInfo(Batch,.Info) do
        . . do SummarizeBatch(.Info,.Summary)
        . . new OneLine
        . . set OneLine=$$OneLineSummary(.Summary,.CompArray,Batch)
        . set Batch=$order(^TMG(cTmp,Batch))
 
        ;"zwr CompArray(*)
 
BBDone
        quit
 
 
ShowBatchInfo(Info)
        ;"Purpose: To Display the info retrieved by GetBatchInfo
 
        new DocIEN,i
 
        write "Visit Date; Transcr Date; Signed Date; Transcr, Author; Patient",!
        for i=1:1:60 write "-"
        write !
        set DocIEN=$order(Info(""))
        if +DocIEN>0 for  do  quit:(+DocIEN=0)
        . new tDate
        . set tDate=$get(Info(DocIEN,"VISIT DATE"))
        . write $$DTFormat^TMGMISC(tDate,"ww mm/dd/yy"),"; "
        . set tDate=$get(Info(DocIEN,"TRANS DATE"))
        . write $$DTFormat^TMGMISC(tDate,"ww mm/dd/yy"),"; "
        . set tDate=$get(Info(DocIEN,"DATE SIGNED"))
        . write $$DTFormat^TMGMISC(tDate,"ww mm/dd/yy"),"; "
        . write $get(Info(DocIEN,"TRANS","INITS")),"; "
        . write $get(Info(DocIEN,"AUTHOR","INITS")),"; "
        . write $get(Info(DocIEN,"PATIENT","NAME")),"; "
        . write !
        . set DocIEN=$order(Info(DocIEN))
 
SBIDone
        quit
 
 
ShowSummary(Summary)
        ;"Purpose: to Display the Summary retrieved by SummarizeBatchInfo
 
        new ts,tDate,tCount
 
        set ts=$order(Summary("TRANS","INITS",""))
        if ts'="" for  do  quit:(ts="")
        . set tCount=$get(Summary("TRANS","INITS",ts))
        . write tCount," patients transcribed by ",ts,!
        . set ts=$order(Summary("TRANS","INITS",ts))
 
        set ts=$order(Summary("AUTHOR","NAME",""))
        if ts'="" for  do  quit:(ts="")
        . set tCount=$get(Summary("AUTHOR","NAME",ts))
        . write tCount," patients with author: ",ts,!
        . set ts=$order(Summary("AUTHOR","NAME",ts))
 
        set ts=$order(Summary("DATE SIGNED",""))
        if ts'="" for  do  quit:(ts="")
        . set tCount=$get(Summary("DATE SIGNED",ts))
        . set tDate=$$DTFormat^TMGMISC(ts,"ww mm/dd/yy")
        . write +tCount," patients with date signed: ",tDate,!
        . set ts=$order(Summary("DATE SIGNED",ts))
 
        set ts=$order(Summary("VISIT DATE",""))
        if ts'="" for  do  quit:(ts="")
        . set tCount=$get(Summary("VISIT DATE",ts))
        . set tDate=$$DTFormat^TMGMISC(ts,"ww mm/dd/yy")
        . write +tCount," patients with visit date: ",tDate,!
        . set ts=$order(Summary("VISIT DATE",ts))
 
        set ts=$order(Summary("TRANS DATE",""))
        if ts'="" for  do  quit:(ts="")
        . set tCount=$get(Summary("TRANS DATE",ts))
        . set tDate=$$DTFormat^TMGMISC(ts,"ww mm/dd/yy")
        . write +tCount," patients with transcription date: ",tDate,!
        . set ts=$order(Summary("TRANS DATE",ts))
 
        write "--------------------------------------------------",!
        quit
 
 
OneLineSummary(Summary,Array,Batch)
        ;"Purpose: to Display the Summary retrieved by SummarizeBatchInfo
        ;"Input: Summary -- the array to display info from
        ;"        Array - PASS BY REFERENCE an out parameter
        ;"              Will put results into array, if passed
        ;"              Format:
        ;"              Array(DateSigned,TransInitials,AuthorName,VisitDate)
        ;"        Batch: number of batchused  to label line
        ;"Results: a one line summary.  If multiple entries, just picks larges.
 
        new ts,tDate,date,tCount,count,S,entries
        new DateSigned,TransInitials,AuthorName,VisitDate
        new result set result=""
 
        set S="",count=0,entries=0
        set ts=$order(Summary("DATE SIGNED",""))
        if ts'="" for  do  quit:(ts="")
        . set entries=entries+1
        . set tCount=$get(Summary("DATE SIGNED",ts))
        . if tCount>count do
        . . set count=tCount
        . . set S="Signed "_$$DTFormat^TMGMISC(ts,"mm/dd/yy")
        . set ts=$order(Summary("DATE SIGNED",ts))
        if entries>1 set S=S_"+"
        set DateSigned=S
        set result=result_S
        set result=result_"; "
 
        set S="",count=0
        set ts=$order(Summary("TRANS","NAME",""))
        if ts'="" for  do  quit:(ts="")
        . set entries=entries+1
        . set tCount=$get(Summary("TRANS","NAME",ts))
        . if tCount>count do
        . . set count=tCount
        . . set S=ts
        . set ts=$order(Summary("TRANS","NAME",ts))
        if entries>1 set S=S_"+"
        set TransInitials=S
        set result=result_S
        set result=result_"; "
 
        set S="",count=0
        set ts=$order(Summary("AUTHOR","NAME",""))
        if ts'="" for  do  quit:(ts="")
        . set entries=entries+1
        . set tCount=$get(Summary("AUTHOR","NAME",ts))
        . if tCount>count do
        . . set count=tCount
        . . set S=ts
        . set ts=$order(Summary("AUTHOR","NAME",ts))
        if entries>1 set S=S_"+"
        set AuthorName=S
        set result=result_S
        set result=result_"; "
 
        set S="",count=0
        set ts=$order(Summary("VISIT DATE",""))
        if ts'="" for  do  quit:(ts="")
        . set entries=entries+1
        . set tCount=$get(Summary("VISIT DATE",ts))
        . if tCount>count do
        . . set count=tCount
        . . set S=$$DTFormat^TMGMISC(ts,"ww mm/dd/yy")
        . set ts=$order(Summary("VISIT DATE",ts))
        if entries>1 set S=S_"+"
        set VisitDate=S
        set result=result_"Visit date: "_S
        set result=result_"; "
 
        set Array("BY-SIGNED",DateSigned,TransInitials,AuthorName,VisitDate)=$get(Batch)
        set Array("BY-TRANS",TransInitials,DateSigned,AuthorName,VisitDate)=$get(Batch)
        set Array("BY-AUTHOR",AuthorName,DateSigned,TransInitials,VisitDate)=$get(Batch)
        set Array("BY-VISITDATE",VisitDate,DateSigned,TransInitials,AuthorName)=$get(Batch)
 
        quit result
 
 
SummarizeBatchInfo(Info,Summary)
        ;"Purpose: To summarize  info retrieved by GetBatchInfo
        ;"Input: Info -- PASS BY REFERENCE -- the info array to display
        ;"        Summary -- PASS BY REFERENCE -- the array to contain summary info.
        ;"              Format as follows:
        ;"                      Summary("TRANS","INITS","nlx")=count
        ;"                      Summary("TRANS","NAME","Nancy L. Xavier")=count
        ;"                      Summary("DATE SIGNED", FMDate)=count
        ;"                      Summary("AUTHOR","NAME","Marcus M. Welby")=count
        ;"                      Summary("AUTHOR","INITS","mmw")=count
        ;"                      Summary("PATIENTS")=count
        ;"                      Summary("VISIT DATE",FMDate)=count
        ;"                      Summary("TRANS DATE",FMDate)=count
 
        new DocIEN
        set DocIEN=$order(Info(""))
        if +DocIEN>0 for  do  quit:(+DocIEN=0)
        . new tDate,tInits,tName
        . set tDate=$get(Info(DocIEN,"VISIT DATE"))\1
        . set Summary("VISIT DATE",tDate)=$get(Summary("VISIT DATE",tDate))+1
        . set tDate=$get(Info(DocIEN,"TRANS DATE"))\1
        . set Summary("TRANS DATE",tDate)=$get(Summary("TRANS DATE",tDate))+1
        . set tDate=$get(Info(DocIEN,"DATE SIGNED"))\1
        . set Summary("DATE SIGNED",tDate)=$get(Summary("DATE SIGNED",tDate))+1
        . set tInits=$get(Info(DocIEN,"TRANS","INITS"))
        . set Summary("TRANS","INITS",tInits)=$get(Summary("TRANS","INITS",tInits))+1
        . set tName=$get(Info(DocIEN,"TRANS","NAME"))
        . set Summary("TRANS","NAME",tName)=$get(Summary("TRANS","NAME",tName))+1
        . set tInits=$get(Info(DocIEN,"AUTHOR","INITS"))
        . set Summary("AUTHOR","INITS",tInits)=$get(Summary("AUTHOR","INITS",tInits))+1
        . set tName=$get(Info(DocIEN,"AUTHOR","NAME"))
        . set Summary("AUTHOR","NAME",tName)=$get(Summary("AUTHOR","NAME",tName))+1
        . set Summary("PATIENTS")=$get(Summary("PATIENTS"))+1
        . set DocIEN=$order(Info(DocIEN))
 
SmBIDone
        quit
 
GetBatchInfo(Job,Info)
        ;"Purpose: to return stats for a given sign batch
        ;"Input:  Job: the job number to investigate
        ;"          Info -- PASS BY REFERENCE.. an out parameter
        ;"              Format: Returns an aggregate array of all the docs
        ;"              Info(DocIEN,"TRANS","INITS")="nlx"
        ;"              Info(DocIEN,"TRANS","NAME")="Nancy L. Xavier"
        ;"              Info(DocIEN,"TRANS","IEN")=1234
        ;"              Info(DocIEN,"DATE SIGNED")=FMDate
        ;"              Info(DocIEN,"AUTHOR","NAME")="Marcus M. Welby"
        ;"              Info(DocIEN,"AUTHOR","INITS")="mmw"
        ;"              Info(DocIEN,"AUTHOR","IEN")="1234
        ;"              Info(DocIEN,"PATIENT","NAME")="Doe,John G"
        ;"              Info(DocIEN,"VISIT DATE")=FMDate
        ;"              Info(DocIEN,"TRANS DATE")=FMDate
        ;"Result: 0 if failure, otherwise 1
 
        new result set result=0
        new cTmp set cTmp="BATCH SIGNED DOCS"
        new DocInfo
        if +$get(Job)=0 goto GBIDone
 
        new DocIEN set DocIEN=$order(^TMG(cTmp,Job,0))
        if +DocIEN>0 for  do  quit:(+DocIEN=0)
        . set result=$$GetDocInfo(DocIEN,.Info)
        . set DocIEN=$order(^TMG(cTmp,Job,DocIEN))
 
GBIDone
        quit result
 
 
GetDocInfo(DocIEN,Info)
        ;"Purpose: to get information on a given documen
        ;"Input: DocIEN - the IEN number of the document to investigate
        ;"         Info -- PASS BY REFERENCE an out parameter
        ;"              Format as follows:
        ;"              Info(DocIEN,"TRANS","INITS")="nlx"
        ;"              Info(DocIEN,"TRANS","NAME")="Nancy L. Xavier"
        ;"              Info(DocIEN,"TRANS","IEN")=1234
        ;"              Info(DocIEN,"DATE SIGNED")=FMDate
        ;"              Info(DocIEN,"AUTHOR","NAME")="Marcus M. Welby"
        ;"              Info(DocIEN,"AUTHOR","INITS")="mmw"
        ;"              Info(DocIEN,"AUTHOR","IEN")="1234
        ;"              Info(DocIEN,"PATIENT","NAME")="Doe,John G"
        ;"              Info(DocIEN,"VISIT DATE")=FMDate
        ;"              Info(DocIEN,"TRANS DATE")=FMDate
        ;"Result: 0 if failure, 1 if success
 
        new result set result=0
        if $get(DocIEN)=0 goto GDIDone
        if $get(^TIU(8925,DocIEN,0))="" goto GDIDone
 
        new AuthIEN,initials,AuthName,PatIEN,TransIEN,TransInit
 
        set Info(DocIEN,"TRANS DATE")=$piece($get(^TIU(8925,DocIEN,12)),"^",1)
        set Info(DocIEN,"VISIT DATE")=$piece($get(^TIU(8925,DocIEN,0)),"^",7)
        set Info(DocIEN,"DATE SIGNED")=$piece($get(^TIU(8925,DocIEN,15)),"^",1)
        set AuthIEN=$piece($get(^TIU(8925,DocIEN,12)),"^",2)  ;"field 1202 = Author
        if +AuthIEN'=0 do
        . set Info(DocIEN,"AUTHOR","INITS")=$piece($get(^VA(200,AuthIEN,0)),"^",2)   ;"field .02 = initials
        . set Info(DocIEN,"AUTHOR","NAME")=$piece($get(^VA(200,AuthIEN,0)),"^",1)   ;"field .01 = Name
        else  do
        . set Info(DocIEN,"AUTHOR","INITS")="???"
        . set Info(DocIEN,"AUTHOR","NAME")="???"
        set PatIEN=$piece($get(^TIU(8925,DocIEN,0)),"^",2)  ;"field .02 = patient IEN
        if +PatIEN'=0 do
        . set Info(DocIEN,"PATIENT","NAME")=$piece($get(^DPT(PatIEN,0)),"^",1)      ;"field .01 is patient name
        else  do
        . set Info(DocIEN,"PATIENT","NAME")="???"
        set TransIEN=$piece($get(^TIU(8925,DocIEN,13)),"^",2) ;"field 1302 = Entered by IEN
        if +TransIEN'=0 do
        . set Info(DocIEN,"TRANS","INITS")=$piece($get(^VA(200,TransIEN,0)),"^",2) ;" field .02 = initials
        . set Info(DocIEN,"TRANS","NAME")=$piece($get(^VA(200,TransIEN,0)),"^",1)   ;"field .01 = Name
        else  do
        . set Info(DocIEN,"TRANS","INITS")="???"
        . set Info(DocIEN,"TRANS","NAME")="???"
 
 
        set result=1
 
GDIDone
        quit result
 
 
FindBatch(DocIEN)
        ;"Purpose: given a DocIEN, find the batch number it was printed in
 
        new result set result=0
        new batch
        set batch=$order(^TMG("BATCH SIGNED DOCS",""))
        if batch'="" for  do  quit:(index="")
        . if $data(^TMG("BATCH SIGNED DOCS",batch,DocIEN))#10=1 do
        . . write "Printed in batch: ",batch,!
        . . set result=batch
        . set batch=$order(^TMG("BATCH SIGNED DOCS",batch))
 
        quit result
 
 
PRTEMPL  ;"i.e. RE-PRINT TEMPLATE
        ;"Purpose: To ask for a SORT TEMPLATE that contains documents to reprint.
 
        write !,!,"This will allow printing of documents stored in a TEMPLATE.",!
        write "This TEMPLATE should have been already created by a Fileman SEARCH.",!
 
        new DIC,Y
        set DIC=.401
        set DIC(0)="MAEQ"
        do ^DIC
        if +Y>0 do
        . new PrintArray
        . if $piece($get(^DIBT(+Y,0)),"^",4)'=8925 do  quit
        . . write "That template is for another file.  Sorry.",!
        . merge PrintArray=^DIBT(+Y,1)
        . if $data(PrintArray)=0 do  quit
        . . write "That template doesn't contain any documents to print.",!
        . do PRINT^TMGTRAN1(.PrintArray)
 
        quit
