TMGHTML1 ;TMG/kst/HTML Mini-chart creator ;03/25/06
         ;;1.0;TMG-LIB;**1**;01/10/06
 
 ;"TMG HTML EXPORT FUNCTION
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"1-10-2006
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 
 ;"=======================================================================
 ;"PRIVATE API FUNCTIONS
 ;"=======================================================================
 ;"DumpNtes(List,FPath,OutArray)
 ;"MakeFName(IEN)
 ;"GetTemplateRecs(pRecs,Template)
 ;"Write1Note(IEN)
 
 
 ;"=======================================================================
 ;"Dependencies   (duplicates shown in parenthesies)
 ;"=======================================================================
 ;"^TMGMISC
 
MAKESITE(FPath,Template)
        ;"Purpose: To create an interlinked site with specified notes.
        ;"Input: FPath OPTIONAL -- if not provided, user will be asked
        ;"              This is the directory where output is to be sent
        ;"      Input OPTIONAL -- if not provided, user will be asked
        ;"              This is the name of the search/sort template holding
        ;"              a list of IENs to output
        ;"Output: files are written to file system
        ;"Result: none.
 
 
        if $get(FPath)="" do
        . write !!,"This will export TIU DOCUMENT records to an interlinked website.",!!
        . read "Enter destination directory path: ",FPath,!
        if FPath="^" goto MSDone
 
        ;"Create core index.htm
        ;"----------------------
        if $$OpenIO(FPath,"index.htm")=0 do  goto MSDone
        . write "Error.  Aborting.",!
        new offset
        for offset=1:1  do  quit:(s["{^}")
        . set s=$piece($TEXT(IndexDat+offset),";;",2)
        . quit:(s["{^}")
        . write s,!
        do ^%ZISC ;" Close the output device
 
        ;"Create core intro.htm
        ;"----------------------
        if $$OpenIO(FPath,"intro.htm")=0 do  goto MSDone
        . write "Error.  Aborting.",!
        new offset
        for offset=1:1  do  quit:(s["{^}")
        . set s=$piece($TEXT(IntroDat+offset),";;",2)
        . quit:(s["{^}")
        . write s,!
        do ^%ZISC ;" Close the output device
 
        ;"Create individual files with notes.
        ;"-----------------------------------
        new OutArray
        do WriteTemplate(.FPath,.Template,.OutArray)
 
 
        ;"Create toc.htm-- the table of contents.
        ;"---------------------------------------
        if $$OpenIO(FPath,"toc.htm")=0 do  goto MSDone
        . write "Error.  Aborting.",!
        do MakeTOC(.OutArray)
        do ^%ZISC ;" Close the output device
 
MSDone
        write "Good bye.",!!
        quit
 
WriteTemplate(FPath,Template,OutArray)
        ;"Purpose: To write out notes listed in Template to directory FPath
        ;"Input: FPath -- The name of the directory to put the output files to
        ;"      Template -- OPTIONAL -- the name of a search/sort template that contains
        ;"              list of IENS's to output
        ;"              If not supplied, user will be asked for name.
        ;"      OutArray -- An OUT parameter.  PASS BY REFERENCE
        ;"              An array to receive results of names written.  See WriteList for format
        ;"Output: files are written to directory
        ;"Result: none
 
        new List,count
        set count=$$GetTemplateRecs("List",.Template)
 
        new PrgsFn set PrgsFn="do ProgressBar^TMGUSRIF(TMGCUR,""Progress"",1,TMGMAX,,TMGSTART)"
 
        if count>0 do
        . do WriteList(.List,FPath,.OutArray,PrgsFn)
 
        quit
 
 
WriteList(List,FPath,OutArray,PrgCallback)
        ;"Purpose: To write out all notes given in List to separate files in FPath
        ;"Input: List -- PASS BY REFERENCE.  A list of IEN's that must be written.
        ;"              Format as follows:
        ;"              List(IEN1)=""
        ;"              List(IEN2)=""
        ;"              List(IEN3)=""
        ;"              List(IEN4)=""
        ;"              ...
        ;"      FPath -- The name of the directory that files should be written to
        ;"              e.g. "/tmp/output/"
        ;"      OutArray -- An OUT parameter.  PASS BY REFERENCE
        ;"              An array to receive results of names written.  Format:
        ;"              OutArray(IEN1)=Filename1
        ;"              OutArray(IEN1,PatientNameAndDOB1)=""
        ;"              OutArray(IEN2)=Filename2
        ;"              OutArray(IEN2,PatientNameAndDOB2)=""
        ;"              OutArray(IEN3)=Filename3
        ;"              OutArray(IEN3,PatientNameAndDOB3)=""
        ;"              OutArray(IEN4)=Filename4
        ;"              OutArray(IEN4,PatientNameAndDOB4)=""
        ;"              OutArray("B",PatientNameAndDOB1,IEN1)=""
        ;"              OutArray("B",PatientNameAndDOB1,IEN1b)="" <-- if more than one IEN per patient.
        ;"              OutArray("B",PatientNameAndDOB2,IEN2)=""
        ;"              OutArray("B",PatientNameAndDOB3,IEN3)=""
        ;"              OutArray("B",PatientNameAndDOB4,IEN4)=""
        ;"      PrgCallback: OPTIONAL -- if supplied, then M code contained in this string
        ;"              will be xecuted periodically, to allow display of a progress bar etc.
        ;"              Note: the following variables with global scope will be declared and
        ;"                      available for use: TMGCUR (current count), TMGMAX (max count),
        ;"                      TMGSTART (the start time
        ;"
        ;"Output: A series of files will be written (or overwritten) to directory
        ;"      Each file will be a TIU DOCUMENT in .htm format.
        ;"      Filename format: lastname_firstname_title_datetime.htm
        ;"Result: none
 
        new ien
        kill OutArray
        new TMGMAX set TMGMAX=0
        new TMGSTART set TMGSTART=$H
        new TMGCUR set TMGCUR=0
        set ien=$order(List(""))
        if ien'="" for  do  quit:(ien="")
        . set TMGMAX=TMGMAX+1
        . set ien=$order(List(ien))
        new delay set delay=0
 
        set ien=$order(List(""))
        if ien'="" for  do  quit:(ien="")
        . set TMGCUR=TMGCUR+1
        . new FName
        . set FName=$$MakeFName(ien)
        . if $$OpenIO(FPath,FName)'=0 do
        . . do Write1Note(ien)
        . . do ^%ZISC ;" Close the output device
        . . set OutArray(ien)=FName
        . . new PtName,DOB,DFN
        . . set DFN=$$GET1^DIQ(8925,ien_",",.02,"I")
        . . set PtName=$$GET1^DIQ(2,DFN_",",.01)
        . . set DOB=$$GET1^DIQ(2,DFN_",",.03)
        . . set PtName=PtName_" "_DOB
        . . set OutArray(ien,PtName)=""
        . . set OutArray("B",PtName,ien)=""
        . if (delay>30),$get(PrgCallback)'="" do  ;"update progress bar every 30 cycles
        . . new $etrap set $etrap="write ""(Invalid M Code!.  Error Trapped.)"" set $etrap="""",$ecode="""""
        . . xecute PrgCallback  ;"call the specified progress code.
        . . set delay=0
        . else  set delay=delay+1
        . set ien=$order(List(ien))
 
        quit
 
 
OpenIO(FPath,FName,NodeDiv)
        ;"Purpose: to open the IO channel such that all writes
        ;"      will go to the file specified.
        ;"Input: FPath -- the path to open file in
        ;"       FName -- the name of the file to open
        ;"       NodeDiv -- OPTIONAL (default is "/") -- the path delimiter for OS
        ;"result: 1=OK To continue, 0=error
 
        new result set result=1
        new PFName set PFName=FPath
        set NodeDiv=$get(NodeDiv,"/")
        new ch
        set ch=$extract(PFName,$length(PFName))
        if ch'=NodeDiv set PFName=PFName_NodeDiv
        set PFName=PFName_FName
 
        ;"Select IO channel
        set %ZIS("HFSNAME")=PFName
        set %ZIS="Q" ;"queing allowed
        set %ZIS("HFSMODE")="W"  ;"write mode
        set IOP="HFS"
 
        do ^%ZIS  ;"standard device call
        if POP do  goto OIODone
        . set result=0
 
        use IO
 
OIODone
        quit result
 
 
MakeFName(IEN)
        ;"Purpose: To create a filename from TIU DOCUMENT IEN
        ;"Input -- IEN.  and IEN from file 8925
        ;"Result -- the filename
 
        new result set result=""
        new name,type,datetime
 
        set name=$$GET1^DIQ(8925,IEN_",",.02)
        set name=$translate(name,",","_")
        set name=$translate(name," ","-")
 
        set type=$$GET1^DIQ(8925,IEN_",",.01)
        set type=$translate(type," ","-")
 
        set date=$$GET1^DIQ(8925,IEN_",",.07,"I")
        set date=$$DTFormat^TMGMISC(date,"mm-dd-yyyy")
 
        set result=name_"_"_type_"_"_date_".htm"
        quit result
 
 
GetTemplateRecs(pRecs,Template)
        ;"Purpose: to ask user for a search/sort template to inport records from.
        ;"Input -- pRecs -- pointer to (i.e. name of) array to fill
        ;"                      will probably be passed with "Array(12345)"
        ;"         Template -- OPTIONAL.  Name of template to import.
        ;"              If not supplied, user will be asked for name
        ;"Output: Data is put into pRecs like this:
        ;"              @pRecs@(IEN1)=""
        ;"              @pRecs@(IEN2)=""
        ;"              @pRecs@(IEN3)=""
        ;"Result: Count of records imported
        ;"Note: uses global variable pHeader
 
        new File set File=8925
        new count set count=0
        new Y
        if $get(pRecs)="" goto GTRDone
 
        for  do  quit:((+Y>0)!(+Y=-1))
        . new DIC
        . set DIC=.401
        . if $get(Template)'="" do
        . . set X=Template
        . else  do
        . . set DIC(0)="AEQ"
        . . write "Select a Template containing records for import. ",!
        . . write "(? for list, ^ to quit) "
        . . set DIC("A")="Enter Template: "
        . do ^DIC
        . if $get(Template)="" write !
        . if +Y'>0 quit
        . new node set node=$get(^DIBT(+Y,0))
        . if $piece(node,"^",4)'=File do  quit
        . . set Y=0  ;"signal to try again
        . . new PriorErrorFound
        . . write "Error: That template doesn't contain a list of progress notes. Please select another.",!
 
        if (+Y>0)&($data(^DIBT(+Y,1))>1) do
        . new index set index=$order(^DIBT(+Y,1,0))
        . if index'="" for  do  quit:(index="")
        . . set @pRecs@(index)=""
        . . set count=count+1
        . . set index=$order(^DIBT(+Y,1,index))
 
        if $get(Template)="" write count," Records selected.",!
 
GTRDone
        quit count
 
 
 
Write1Note(IEN)
        ;"Purpose: To write out a progress note in HTML format
        ;"Input: IEN -- the IEN in file 8925 (TIU DOCUMENT)
        ;"Output: The note (in complete HTML format) is written to current
        ;"      output device.
        ;"Result: none:
 
        new offset,s
        new IENS set IENS=IEN_","
 
        for offset=1:1  do  quit:(s["{^}")
        . set s=$piece($TEXT(NoteHdr+offset),";;",2)
        . quit:(s["{^}")
        . write s,!
 
        write "<h2><strong>",$$GET1^DIQ(8925,IENS,".01"),"</strong></h2>",!  ;"Note type
        write "<p><strong>Name: </strong>",$$GET1^DIQ(8925,IENS,".02"),"<br>",!    ;"patient name
        new Date set Date=$$GET1^DIQ(8925,IENS,".07","I")
        set Date=$$DTFormat^TMGMISC(Date,"mmmm d,yyyy")
        write "<strong>Date: </strong>",Date,"</p>",!    ;"note date
        write "<p><strong>Note: </strong></p>",!
 
        new TMGWP,x
        set x=$$GET1^DIQ(8925,IENS,2,"","TMGWP")="WP"
        do
        . new i
        . write "<p>"
        . set i=$order(TMGWP(""))
        . for  do  quit:(i="")
        . . new line set line=$get(TMGWP(i))
        . . set line=$$SYMENC^MXMLUTL(line)
        . . write line,"<br>",!
        . . set i=$order(TMGWP(i))
        . write "</p>",!
 
        write "<p><strong><u>Note Detail</u>:</strong><br>",!
        write "<font size=""2""><strong>Author</strong>: ",$$GET1^DIQ(8925,IENS,"1202"),"</font><br>",!
        write "<font size=""2""><strong>Signature Date/Time</strong>: ",$$GET1^DIQ(8925,IENS,"1501"),"</font><br>",!
        write "<font size=""2""><strong>Status</strong>: ",$$GET1^DIQ(8925,IENS,".05"),"</font><br>",!
        write "<font size=""2""><strong>Location</strong>: ",$$GET1^DIQ(8925,IENS,"1211"),"</font><br>",!
        write "<font size=""2""><strong>Transcriptionist</strong>: ",$$GET1^DIQ(8925,IENS,"1302"),"</font><br>",!
        write "<font size=""2""><strong>Transcription Date/Time</strong>: ",$$GET1^DIQ(8925,IENS,"1201"),"</font><br>",!
        ;"write "<font size=""2""><strong>Line count</strong>: ",$$GET1^DIQ(8925,IENS,".1"),"</font><br>",!
        ;"write "<font size=""2""><strong>Character count</strong>: ",$$GET1^DIQ(8925,IENS,"22711"),"</font><br>",!
        write "</p>",!
 
        write "</body",!
        write "</html>",!
 
        quit
 
 
MakeTOC(OutArray)
        ;"Purpose: To write toc.htm (the table of contents side panel)
        ;"Input: IEN -- the IEN in file 8925 (TIU DOCUMENT)
        ;"Output: OutArray -- PASS BY REFERENCE
        ;"              An array with file names written.  Format:
        ;"              OutArray(IEN1)=Filename1
        ;"              OutArray(IEN1,PatientNameAndDOB1)=""
        ;"              OutArray(IEN2)=Filename2
        ;"              OutArray(IEN2,PatientNameAndDOB2)=""
        ;"              OutArray(IEN3)=Filename3
        ;"              OutArray(IEN3,PatientNameAndDOB3)=""
        ;"              OutArray(IEN4)=Filename4
        ;"              OutArray(IEN4,PatientNameAndDOB4)=""
        ;"              OutArray("B",PatientNameAndDOB1,IEN1)=""
        ;"              OutArray("B",PatientNameAndDOB1,IEN1b)="" <-- if more than one IEN per patient.
        ;"              OutArray("B",PatientNameAndDOB2,IEN2)=""
        ;"              OutArray("B",PatientNameAndDOB3,IEN3)=""
        ;"              OutArray("B",PatientNameAndDOB4,IEN4)=""
        ;"
        ;"Result: none:
 
        new offset,s
 
        for offset=1:1  do  quit:(s["{^}")
        . set s=$piece($TEXT(TOCHdr+offset),";;",2)
        . quit:(s["{^}")
        . write s,!
 
        ;"Write Patient name and DOB, then list of their notes , then repeat.
        new Patient
        set Patient=$order(OutArray("B",""))
        if Patient'="" for  do  quit:(Patient="")
        . write "<p><strong>",Patient,"</strong></p>",!
        . write "<ul>",!
        . new ien set ien=$order(OutArray("B",Patient,""))
        . if ien'="" for  do  quit:(ien="")
        . . new Type,Date,FName
        . . set Type=$$GET1^DIQ(8925,ien_",",".01") ;"Note type
        . . set Date=$$GET1^DIQ(8925,ien_",",".07","I") ;"note date
        . . set Date=$$DTFormat^TMGMISC(Date,"mm/dd/yyyy")
        . . set FName=OutArray(ien)
        . . write "<li><a href=""",FName,""" target=""main"">"
        . . write Type," -- ",Date
        . . write "</a></li>",!
        . . set ien=$order(OutArray("B",Patient,ien))
        . set Patient=$order(OutArray("B",Patient))
        . write "</ul>",!
 
        write "</body",!
        write "</html>",!
 
        quit
 
 
 
 ;"=======================================================================
IndexDat
        ;;<html>
        ;; <head>
        ;;  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
        ;;  <meta name="Author" content="Open Vista Team &amp; ed. by Kevin Toppenberg">
        ;;  <meta name="GENERATOR" content="Kate 2.1 on Linux">
        ;;  <title>Open VistA Exported Notes</title>
        ;; </head>
        ;; <frameset cols="200,*">
        ;;  <frame name="toc" src="toc.htm" resize>
        ;;  <frame name="main" src="intro.htm">
        ;;  <noframes>
        ;;   <body>
        ;;   </body>
        ;;  </noframes>
        ;; </frameset>
        ;;</html>
        ;;
        ;;{^}  ;"Kevin's custom end-of-data symbol
 
IntroDat
        ;;<html>
        ;;<head>
        ;;  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
        ;;  <meta name="GENERATOR" content="Kate 2.1 on Linux">
        ;;  <title>OpenVistA Exported Notes</title>
        ;; </head>
        ;; <body bgcolor="#FFFFFF" link="#FFFF00" vlink="#800080">
        ;;  <p><strong>Please Select A Patient from List at Left</strong></p>
        ;; </body>
        ;;</html>
        ;;
        ;;{^}  ;"Kevin's custom end-of-data symbol
 
 
TOCHdr
        ;;<html>
        ;;<head>
        ;;<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
        ;;<title>OpenVista List of Patients</title>
        ;;</head>
        ;;<body link="#0000FF" vlink="#800080">
        ;;<p><a href="intro.htm" target="main">Introduction</a></p>
        ;;<p><font size="5"><b>Patients</b></font></p>
        ;;
        ;;{^}  ;"Kevin's custom end-of-data symbol
 
 
NoteHdr
        ;;<html>
        ;;
        ;; <head>
        ;;  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
        ;;  <title>OpenVistA Introduction</title>
        ;; </head>
        ;; <body>
        ;
        ;;{^}  ;"Kevin's custom end-of-data symbol
 
 
