TMGPRPN  ;TMG/kst/Print Notes Fns. ;03/25/06
         ;;1.0;TMG-LIB;**1**;04/25/04
 
 ;"TMG PRINT NOTES FUNCTIONS
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"CONTPRNT -- print notes for chosed patient, contigiously or divided
 ;"CONTPRN2(PtIEN) -- print notes for specified patient
 ;"PRPNQUIET(OPTIONS) -- print notes based on input options
 
 ;"=======================================================================
 ;"PRIVATE API FUNCTIONS
 ;"=======================================================================
 
 
 ;"=======================================================================
 ;"=======================================================================
 
CONTPRNT
        ;"Purpose: To ask for patient name, and date range, and output device
        ;"        and then print notes contigously (i.e. not a separate page
        ;"        for each note), or on separate pages
        ;"Input: none -- will ask user for values
        ;"Output: none -- will print to chosen device based on user preference
 
        new Options
 
        write !,"-- PRINT NOTES FOR A PATIENT, CONTIGIOUSLY -- ",!!
 
        set DIC=2  ;"PATIENT file
        set DIC(0)="MAQE"
        set DIC("A")="Enter name of Patient to print note for (^ to abort): "
        do ^DIC
 
        do CONTPRN2(+Y)
RADone
        quit
 
 
CONTPRN2(PtIEN)
        ;"Purpose: For specified patient, ask for date range, output device,
        ;"        and if to print notes contigously (i.e. not a separate page
        ;"        for each note) or on separate pages, and if to list avail notes.
        ;"Input: PtIEN -- record number  in file #2
        ;"Output: none -- will print to chosen device based on user preference
 
        new Options
 
        write !
 
        set Options("PATIENT")=$get(PtIEN,-1)
        if Options("PATIENT")'>0 do  goto CP2Done
        . write !,"No patient selected.  Aborting.",!
 
        new YN,index
        read !,"Show list of available notes? (^ to abort): YES// ",YN:$get(DTIME,3600)
        if YN="" set YN="Y"
        if YN="^" write "Aborting.",! goto CP2Done
        if ($$UP^XLFSTR(YN)["Y") do
        . write !,"Available notes",!
        . write "---------------",!
        . set index=$order(^TIU(8925,"C",PtIEN,""),1)
        . for  do  quit:(index="")
        . . if index="" quit  ;"note index is DocIEN
        . . new S,Date,DateS,DocTIEN,TypeName,X,Y
        . . set Date=$piece($get(^TIU(8925,index,13)),"^",1)
        . . set Y="D" set DateS=$$FMTE^XLFDT(Date)
        . . set DocTIEN=$piece($get(^TIU(8925,index,0)),"^",1)
        . . set TypeName=$piece($get(^TIU(8925.1,DocTIEN,0)),"^",1)
        . . if TypeName="" set TypeName="(Unknown document type): "_DocTIEN
        . . write DateS," -- ",TypeName,!
        . . set index=$order(^TIU(8925,"C",PtIEN,index),1)
 
        new %DT
        set %DT="AEP"
        set %DT("A")="Enter starting date (^ to abort): "
        do ^%DT
        if Y=-1 do  goto CP2Done
        . write "Invalid date.  Aborting.",!
        set Options("START")=Y
 
        set %DT("A")="Enter ending date (^ to abort): "
        do ^%DT
        if Y=-1 do  goto CP2Done
        . write "Invalid date.  Aborting report.",!
        set Options("END")=Y
 
        new ContMode
        read !,"Print each note on a separate page? NO// ",ContMode:$get(DTIME,3600),!
        if ContMode="" set ContMode="N"
        set Options("CONTMODE")=($$UP^XLFSTR(ContMode)["N")
        if ContMode="^" write "Aborting.",! goto CP2Done
 
        set %ZIS("A")="Enter output printer or device (^ to abort): "
        do ^%ZIS
        if POP do  goto CP2Done
        . write !,"Error selecting output printer or device. Aborting report.",!
 
        use IO
        do PRPNQUIET(.Options)
        use IO(0)
 
        do ^%ZISC
 
        write !,"Done.  Good bye!",!!
CP2Done
        quit
 
 
PRPNQUIET(OPTIONS)
        ;"Purpose: To create a report on transcription productivity based on
        ;"        options specified in OPTIONS.
        ;"Input: The following elements in OPTIONS should be defined
        ;"        0PTIONS("PATIENT")  ;"the IEN of the user (IEN from file 200)
        ;"        OPTIONS("START") ;"Earliest date of documents, in Fileman internal format
        ;"        OPTIONS("END")   ;"Latest date of documents, in Fileman internal format
        ;"        OPTIONS("CONTMODE") ;"if 1, then notes printed contigiously
        ;"Note: This will create a report by writing to the current device
        ;"        If the user wants output to go to a DEVICE, then they should call
        ;"        ^%ZIS prior to calling this function, then use IO,
        ;"        then when done, use IO(0) and call ^%ZISC to close
 
        if $get(TMGDEBUG)>0 do DebugEntry^TMGDEBUG(.DBIndent,"PRPNQUIET^TMGPRPN")
 
        new PtIEN
        new index set index=""
 
        set PtIEN=+$get(OPTIONS("PATIENT"))
        if PtIEN=0 do  goto PQDone
        . write "No patient record number supplied. Aborting.",!
        set StartDT=+$get(OPTIONS("START"))
        if (StartDT=0) do
        . write "No start date specified. Aborting.",!
        set EndDT=+$get(OPTIONS("END"))
        if (EndDT=0) do
        . write "No end date specified. Aborting.",!
 
        kill ^TMP("TIUPR",$J)
        set index=$order(^TIU(8925,"C",PtIEN,""))
        for  do  quit:(index="")
        . if index="" quit  ;"note index is DocIEN
        . new S,SSN,DATE
        . set SSN=$Piece(^DPT(PtIEN,0),"^",9)
        . Set DATE=$piece($get(^TIU(8925,index,13)),"^",1)
        . if (DATE'<StartDT)&(DATE'>EndDT) do
        . . Set ^TMP("TIUPR",$Job,SSN_";"_PtIEN,DATE,index)="VistA EMR"
        . set index=$order(^TIU(8925,"C",PtIEN,index))
 
        do PRINT^TIUPRPN1(1,1) ;0=> Chart Copy, 1=>Contigious
 
PQDone
        if $get(TMGDEBUG)>0 do DebugExit^TMGDEBUG(.DBIndent,"PRPNQUIET^TMGPRPN")
        quit
 
 
