TMGQIO ;TMG/kst/Quiet IO routines ;03/25/06
        ;;1.0;TMG-LIB;**1**;11/01/04

 ;"'QUIET IO   To provide routines for quite (non-interactive) IO that programs can call.
 ;"=============================================================================
 ;"Kevin Toppenberg, MD  11-04
 ;"
 ;"'QUIET IO"
 ;"
 ;"Purpose:
 ;"  To provide routines for quite (non-interactive) IO that programs can call.
 ;"     i.e. replacement routines for READ and WRITE
 ;"
 ;"Functions:
 ;"  OUTP(SILENT,A,B,C,D,E,F,G,H,I,J)
 ;"  WOUT(S)
 ;"  SILENTW(S) -- puts output into INFO("TEXT")
 ;"  INP(VAR,SILENT,TIMEOUT,SILNTVAL,A,B,C,D,E,F,G,H,I,J)
 ;"
 ;"Dependancies:
 ;"  if TMGDEBUG defined, then requires TMGDEBUG.m
 ;"=============================================================================

OUTP(SILENT,A,B,C,D,E,F,G,H,I,J)
  ;"Purpose: To provide an output channel for this program module.  Will allow
  ;"    converting to a "SILENT-OUTPUT" mode.
  ;
  ;"IF $GET(TMGDEBUG)>0 DO DebugEntry^TMGDEBUG(.DBIndent,"OUTP^TMGQIO")
  IF $GET(SILENT,0)=1 DO  GOTO OPQUIT
  . IF '$$SILENTW(.A) QUIT
  . IF '$$SILENTW(.B) QUIT
  . IF '$$SILENTW(.C) QUIT
  . IF '$$SILENTW(.D) QUIT
  . IF '$$SILENTW(.E) QUIT
  . IF '$$SILENTW(.F) QUIT
  . IF '$$SILENTW(.G) QUIT
  . IF '$$SILENTW(.H) QUIT
  . IF '$$SILENTW(.I) QUIT
  . IF '$$SILENTW(.J) QUIT
  ELSE  DO  GOTO OPQUIT
  . IF '$$WOUT(.A) QUIT
  . IF '$$WOUT(.B) QUIT
  . IF '$$WOUT(.C) QUIT
  . IF '$$WOUT(.D) QUIT
  . IF '$$WOUT(.E) QUIT
  . IF '$$WOUT(.F) QUIT
  . IF '$$WOUT(.G) QUIT
  . IF '$$WOUT(.H) QUIT
  . IF '$$WOUT(.I) QUIT
  . IF '$$WOUT(.J) QUIT
  ;
OPQUIT
  ;"IF $GET(TMGDEBUG)>0 DO DebugExit^TMGDEBUG(.DBIndent,"OUTP^TMGQIO")
  QUIT
  ;
  ;
WOUT(S)
  ;"Purpose: To write out S, or newline if "!" passed
  ;"Result: 1 if text output, 0 if it wasn't
  ;
  ;"IF $GET(TMGDEBUG)>0 DO DebugEntry^TMGDEBUG(.DBIndent,"WOUT^TMGQIO")
  ;"IF $GET(TMGDEBUG)>0 DO DebugMsg^TMGDEBUG(.DBIndent,"S='",$GET(S),"'")
  NEW RESULT SET RESULT=0
  IF $DATA(S)'=0 DO
  . SET RESULT=1
  . IF S="!" WRITE ! QUIT
  . IF ($EXTRACT(S,1)="?")&(+$EXTRACT(S,2,256)>0) DO
  . . NEW INDENT,I
  . . SET INDENT=+$EXTRACT(S,2,256)
  . . FOR I=1:1:INDENT WRITE " "
  . ELSE  WRITE S
  ;"IF $GET(TMGDEBUG)>0 DO DebugExit^TMGDEBUG(.DBIndent,"WOUT^TMGQIO")
  QUIT RESULT
  ;
  ;
SILENTW(S)
  ;"Purpose: To take text and put in INFO Array
  ;"Result: 1 if text output, 0 if it wasn't
  ;
 IF $GET(TMGDEBUG)>0 DO DebugEntry^TMGDEBUG(.DBIndent,"SILENTW^TMGQIO")
 NEW RESULT SET RESULT=0
 IF $DATA(S)=0 GOTO SWQ
 NEW LINE
 SET LINE=$get(INFO("TEXT","LINES"),1)
 DO DebugMsg^TMGDEBUG(.DBIndent,"s=",S)
 IF S="!" DO
 . IF $DATA(INFO("TEXT",LINE))=0 SET INFO("TEXT",LINE)=" "
 . SET INFO("TEXT","LINES")=LINE+1
 ELSE  DO
 . IF $EXTRACT(S,1)="?" set S="" ;"Ignore ?x's
 . SET INFO("TEXT",LINE)=$get(INFO("TEXT",LINE)," ")_S
 SET RESULT=1
SWQ
 IF $GET(TMGDEBUG)>0 DO DebugExit^TMGDEBUG(.DBIndent,"SILENTW^TMGQIO")
 QUIT RESULT
 ;
 ;
INP(VAR,SILENT,TIMEOUT,SILNTVAL,A,B,C,D,E,F,G,H,I,J)
        ;"Purpose: To provide an input that may or may not be silent
        ;"Input VAR: variable to input. SHOULD PASS BY REFERENCE
        ;"      SILENT: 1=silent (will get value from SILNTVAL), 0=interactive
        ;"      TIMEOUT: value to timeout user input (optional, will default to 120)
        ;"      SILNTVAL: the value to use to assign VAR if SILENT=1
        ;"      A..J: optional prompts for input if not in silent mode
 IF $GET(TMGDEBUG)>0 DO DebugEntry^TMGDEBUG(.DBIndent,"INP^TMGQIO")

 SET SILENT=$get(SILENT,0)
 IF SILENT=1 DO
 . SET VAR=$get(SILNTVAL)
 . IF $GET(TMGDEBUG)>0 DO DebugMsg^TMGDEBUG(.DBIndent,"Silent input used=",VAR)
 . DO OUTP(SILNTOUT,VAR,"!") ;//to show log the value used.
 ELSE  DO
 . DO OUTP(SILNTOUT,.A,.B,.C,.D,.E,.F,.G,.H,.I,.J)
 . SET TIMEOUT=$get(TIMEOUT,120)
 . READ VAR:TIMEOUT
 . DO OUTP(SILNTOUT,"!")
 ;
 IF $GET(TMGDEBUG)>0 DO DebugExit^TMGDEBUG(.DBIndent,"INP^TMGQIO")
 QUIT
 ;
 ;
