TMGTICKL ;TMG/kst-Tickler Text Object Support Files;09/04/08
         ;;1.0;TMG-LIB;**1**;09/05/08

 ;"---------------------------------------------------------------------------
 ;"PUBLIC FUNCTIONS
 ;"---------------------------------------------------------------------------
 ;"GETMSG(DocIEN,WPArray) -- retrieve tickler message in document.
 ;"FLMSG(IEN) -- return the first line of the tickler message
 ;"SELTCKLS(SelArray) -- Browse tickler messages and return array of IEN's selected.
 ;"REUSER -- Allow browsing for a set of Tickler files, and reassigning the target user
 ;"REDATE -- Allow browsing for a set of Tickler files, and reassigning the due date
 ;"BROWSE -- Browse tickler messages.
 ;"$$SELTICKLERS(SelArray) -- Browse tickler messages and return array of IEN's selected.
 ;"CLEANDON -- remove tickler messages that have been completed, thus no longer needed.
 ;"CLEANOPH -- remove tickler messages that have been orphaned, thus no longer needed.
 ;"DispTicklers(IENArray) -- Display a list of tickler messages

 ;"---------------------------------------------------------------------------
 ;"PRIVATE FUNCTIONS
 ;"---------------------------------------------------------------------------
 ;"Dependencies:
 ;"  IENSelector^TMGUSRIF
 ;"    --> SELECT^%ZVEMKT
 ;"    --> ItrAInit^TMGITR
 ;"  Menu^TMGUSRIF
 ;"  ShowDIERR^TMGDEBUG

FLMSG(IEN)
        ;"Purpose: To return the first line of the tickler message
        ;"NOTE: !!! DON'T REMOVE THIS FUNCTION.  It is called by the computed field,
        ;"      FIRST LINE OF MESSAGE (field #5) in file 22705.5 (TICKLER FILE MESSAGES)
        ;"Input: IEN: IEN in file 22705.5
        ;"Output: Returns first line, or "" if null

        new result set result=""
        new DocIEN set DocIEN=+$piece($get(^TMG(22705.5,IEN,0)),"^",4)
        if DocIEN>0 do
        . new WPArray
        . new temp set temp=$$GETMSG(DocIEN,.WPArray)
        . set result=$get(WPArray(1))
        quit result


GETMSG(DocIEN,WPArray)
        ;"Purpose: To retrieve the message for a tickler message in document.
        ;"Note: It is expected that the Tickler text structure will be:
        ;"
        ;"        ======= [TICKLER MESSGE] =======
        ;"        #DUE#: Put-DUE-DATE-here
        ;"        ================================
        ;"        Message: ...
        ;"
        ;"        ================================
        ;"
        ;"      And specifically, the key elements are:
        ;"        1. Entire Tickler starts with [TICKLER MESSGE]
        ;"        2. Message starts on line after ===========
        ;"        3. Messge ends with line with ===========
        ;"              If no closing =========== found, message extends to end of document
        ;"
        ;"Input: DocIEN -- IEN in 8925
        ;"       WPArray -- PASS BY REFERENCE, an OUT PARAMETER.  Returns message.  Format:
        ;"                  WPArray(1)='1st list'
        ;"                  WPArray(2)='2nd line' etc...
        ;"Result: 1 if found, 0 if not.

        new found,line set (found,line)=0
        for  set line=$order(^TIU(8925,DocIEN,"TEXT",line)) quit:(+line'>0)!found  do
        . set found=($get(^TIU(8925,DocIEN,"TEXT",line,0))["[TICKLER MESSGE]")
        . if found do
        . . new done set done=0
        . . new lineText set lineText=""
        . . for  quit:done  set line=$order(^TIU(8925,DocIEN,"TEXT",line)) quit:(+line'>0)!done  do
        . . . set done=$get(^TIU(8925,DocIEN,"TEXT",line,0))["====="
        . . set done=0
        . . new wpIndex set wpIndex=1
        . . for  set line=$order(^TIU(8925,DocIEN,"TEXT",line)) quit:(+line'>0)!done  do
        . . . set done=$get(^TIU(8925,DocIEN,"TEXT",line,0))["====="
        . . . if done quit
        . . . set WPArray(wpIndex)=$get(^TIU(8925,DocIEN,"TEXT",line,0))
        . . . set wpIndex=wpIndex+1

        quit found


BROWSE
        ;"Purpose: To browse tickler messages
        ;"Results: none

        new SelArray,abort
        write !
        set abort=$$SELTICKLERS(.SelArray)
        if abort goto BWDN
        if $data(SelArray)=0 goto BWDN
        new % set %=1
        write "Review tickler messages for selected entries?" do YN^DICN write !
        if %=-1 set abort=1 goto SELTDONE
        if %=1 do DispTicklers(.SelArray)
        write "Goodbye.",!
BWDN    quit


DELTICKL ;
        ;"Purpose: allow user to pick tickler message to delete.
        new SelArray
        write !
        new % set %=2
        write "Select tickler messages to DELETE" do YN^DICN write !
        if %'=1 goto DTDN
        set abort=$$SELTICKLERS(.SelArray)
        if abort goto DTDN
        if $data(SelArray)=0 goto DTDN

        set %=1
        write "Review tickler messages for selected entries?" do YN^DICN write !
        if %=-1 goto DTDN
        if %=1 do DispTicklers(.SelArray)

        set %=2
        write "Delete selected tickler messages" do YN^DICN write !
        if %=-1 goto DTDN
        new DelCt set DelCt=0
        if %=1 do
        . set DelCt=$$DELSET(.SelArray)
        . write DelCt," tickler messages deleted.",!

        write "Goodbye.",!
        do PressToCont^TMGUSRIF
DTDN    quit



SELTICKLERS(SelArray)
        ;"Browse tickler messages and return array of IEN's selected.
        ;"Input: SelArray -- PASS BY REFERENCE.  An OUT ARRAY.
        ;"Output: SelArray is filled as follows:
        ;"          SelArray(IEN)=DispLineNumber
        ;"          SelArray(IEN)=DispLineNumber
        ;"Results: 1 if aborted, otherwise 0

        new abort set abort=0
        kill SelArray
        write !,"== TICKER MESSAGES BROWSER ==",!!
        new % set %=2
        write "View COMPLETED ticker messages " DO YN^DICN write !
        if %=-1 goto SELTDONE
        new HideCompl set HideCompl=(%=2)

        new Menu,usrChoice
        new LineCt set LineCt=1
        set Menu(0)="Pick Display Order for Selector"
        if HideCompl do
        . set Menu(LineCt)="User Name; Due Date; Patient Name"_$C(9)_"3;1;.01;2^20;15;20;10",LineCt=LineCt+1
        . set Menu(LineCt)="Patient Name; User Name; Due Date"_$C(9)_".01;3;1;2^20;20;15;10",LineCt=LineCt+1
        . set Menu(LineCt)="Due Date; Patient Name; User Name"_$C(9)_"1;.01;3;2^15;20;20;10",LineCt=LineCt+1
        . set Menu(LineCt)="Note Date; Patient Name; User Name"_$C(9)_"4;.01;3;2^15;20;10;15",LineCt=LineCt+1
        else  do
        . set Menu(LineCt)="User Name; Status; Due Date; Patient Name"_$C(9)_"3;2;1;.01^20;10;15;20",LineCt=LineCt+1
        . set Menu(LineCt)="Patient Name; Status; User Name; Due Date"_$C(9)_".01;2;3;1^20;10;20;15",LineCt=LineCt+1
        . set Menu(LineCt)="Due Date; Patient Name; Status; User Name"_$C(9)_"1;.01;2;3^15;20;10;20",LineCt=LineCt+1
        . set Menu(LineCt)="Note Date; Patient Name; Status; User Name"_$C(9)_"4;.01;2;3^15;20;10;15",LineCt=LineCt+1
        . set Menu(LineCt)="Status; Due Date; Patient Name; User Name"_$C(9)_"2;1;.01;3^10;15;20;20",LineCt=LineCt+1

        set usrChoice=$$Menu^TMGUSRIF(.Menu,3)
        if usrChoice="^" goto SELTDONE

        new fields,widths
        set fields=$piece(usrChoice,"^",1)
        set widths=$piece(usrChoice,"^",2)

        new IENArray
        new IEN set IEN=0
        for  set IEN=$order(^TMG(22705.5,IEN)) quit:(+IEN'>0)  do
        . new status
        . set status=$piece($get(^TMG(22705.5,IEN,0)),"^",3)
        . if (status="C"),(HideCompl=1) quit
        . set IENArray(IEN)=""
        .
        new Header set Header="Pick Tickler Messages. Press <ESC><ESC> when done."
        do IENSelector^TMGUSRIF("IENArray","SelArray",22705.5,fields,widths,Header,fields)
SELTDONE
        quit abort


CLEANDON ;
        ;"Purpose: to remove tickler messages that have been completed, thus no longer needed.
        ;"Results: None
        write !,"== CLEAN UP COMPLETED TICKER MESSAGES ==",!!
        new % set %=2
        write "DELETE all COMPLETED ticker messages " DO YN^DICN write !
        if %'=1 goto DELDONE
        do GetStatusSet("C",.IENArray) ;
        new DelCt set DelCt=$$DELSET(.IENArray)
        write DelCt," completed tickler messages deleted.",!
DELDONE quit

CLEANOPH ;
        ;"Purpose: to remove tickler messages that have been orphaned, thus no longer needed.
        ;"NOTE: An orphan note is created when a user launches a tickler object in a note, but
        ;"      then removes the text, so that the note does not actually have a tickler in it.
        ;"Results: None
        new abort set abort=0
        New IENArray
        write !,"== CLEAN UP ORPHANED TICKER MESSAGES ==",!!
        write "Note: An ORPHAN ticker message occurs when a user launches",!
        write "      the tickler text object from in CPRS, but then deletes",!
        write "      it, so that the note does not actually have a tickler",!
        write "      message in it.  There should be no harm in doing this.",!,!
        new % set %=2
        write "DELETE all ORPHANED ticker messages " DO YN^DICN write !
        if %'=1 goto ORPHDONE
        do GetStatusSet("O",.IENArray) ;
        new DelCt set DelCt=$$DELSET(.IENArray)
        write DelCt," orphaned tickler messages deleted.",!
        do PressToCont^TMGUSRIF
ORPHDONE quit

GetStatusSet(Status,IENArray) ;
        ;"Purpose: return a set of entries with given status.
        ;"Input:  Status -- the internal form of desired status.
        ;"        IENArray. PASS BY REFERENCE.  format as below.
        ;"          IENArray(IEN)=""
        ;"          IENArray(IEN)=""
        new IEN set IEN=0
        for  set IEN=$order(^TMG(22705.5,IEN)) quit:(+IEN'>0)  do
        . new ThisStat set ThisStat=$piece($get(^TMG(22705.5,IEN,0)),"^",3)
        . if (ThisStat=Status) set IENArray(IEN)=""
        quit

DELSET(IENArray) ;
        ;"Purpose: To delete the specified Tickler Entries.
        ;"Input: IENArray. PASS BY REFERENCE.  format as below.
        ;"          IENArray(IEN)=""
        ;"          IENArray(IEN)=""
        ;"      NOTe: All included entries will be deleted with NO confirmation.
        ;"Results: returns number of deleted entries.
        ;
        new DIK set DIK="^TMG(22705.5,"
        new DA
        new DelCt set DelCt=0
        new IEN set IEN=0
        for  set IEN=$order(IENArray(IEN)) quit:(+IEN'>0)  do
        . set DA=IEN do ^DIK
        . set DelCt=DelCt+1
        quit DelCt

DispTicklers(IENArray)
        ;"Purpose: Display a list of tickler messages
        ;"Input: IENArray. PASS BY REFERENCE.  format:
        ;"          IENArray(IEN)=""
        ;"          IENArray(IEN)=""
        ;"Results: None

        new count set count=0
        new abort set abort=0
        new TklIEN set TklIEN=""
        for  set TklIEN=$order(SelArray(TklIEN)) quit:(TklIEN="")!abort  do
        . set count=count+1
        . write "----------------------------------",!
        . write "STATUS:   ",$$GET1^DIQ(22705.5,TklIEN,2),!
        . write "DUE DATE: ",$$GET1^DIQ(22705.5,TklIEN,1),!
        . write "PATIENT:  ",$$GET1^DIQ(22705.5,TklIEN,.01),!
        . write "DOCUMENT: ",$$GET1^DIQ(22705.5,TklIEN,.05)," (#",$$GET1^DIQ(22705.5,TklIEN,.05,"I"),")",!
        . write "DOC DATE: ",$$GET1^DIQ(22705.5,TklIEN,4),!
        . write "USER:     ",$$GET1^DIQ(22705.5,TklIEN,3),!
        . write "MESSAGE (1st line):",!," ",$$GET1^DIQ(22705.5,TklIEN,5),!
        . if count#3=0 do
        . . new temp read "Press Enter to Continue",temp:$get(DTIME,3600),!
        . . set abort=(temp="^")

        if count=0 write "(No items to display.)",!
        write !
        quit


REUSER  ;"Reassign Tickler File Recipient User
        ;"Purpose: to allow browsing for a set of Tickler files, and reassigning the target user
        ;"Result: none

        new numErrors set numErrors=0
        new NumProcessed set NumProcessed=0

        write !," -= REASSIGN RECIPIENT USER FOR TICKLER MESSAGES =-",!,!
        write "You will next be able to select tickler messages to reassign.",!
        write "Note: Only change tickler messages with a PENDING status.",!
        write "      Changing others will have no effect.",!,!
        do PressToCont^TMGUSRIF

        if $$SELTICKLERS(.SelArray)=1 goto REUDONE

        if $data(SelArray)=0 goto REUDONE
        new % set %=2
        write "Pick new recipient user for the selected tickler messages?"
        do YN^DICN write !
        if %'=1 goto REUDONE

        new DIC set DIC=200
        set DIC(0)="MAEQ"
        set DIC("A")="Select new RECIPIENT USER: "
        do ^DIC write !
        if +Y'>0 goto REUDONE

        new IEN set IEN=""
        for  set IEN=$order(SelArray(IEN)) quit:(IEN="")  do
        . set NumProcessed=NumProcessed+1
        . new TMGFDA,TMGMSG
        . set TMGFDA(22705.5,IEN_",",3)=+Y
        . do FILE^DIE("","TMGFDA","TMGMSG")
        . if $data(TMGMSG("DIERR"))>0 do
        . . do ShowDIERR^TMGDEBUG(.TMGMSG)
        . . set numErrors=numErrors+1
REUDONE
        write !,NumProcessed," tickler message file entries processed.",!
        if NumProcessed>0 write numErrors," errors encountered.",!
        write "Goodbye",!
        quit


REDATE  ;"Reassign Due Dates for Tickler File
        ;"Purpose: to allow browsing for a set of Tickler files, and reassigning due date
        ;"Result: none

        write !," -= REASSIGN DUE DATE FOR TICKLER MESSAGES =-",!,!
        write "You will next be able to select tickler messages to change.",!
        write "Note: Only change tickler messages with a PENDING status.",!
        write "      Changing others will have no effect.",!,!
        do PressToCont^TMGUSRIF

        if $$SELTICKLERS(.SelArray)=1 goto REDDONE

        new numErrors set numErrors=0
        new NumProcessed set NumProcessed=0
        if $data(SelArray)=0 goto REUDONE
        new % set %=2
        write "Pick new DUE DATE for the selected tickler messages?"
        do YN^DICN write !
        if %'=1 goto REDDONE

        new DIR,X,Y
        set DIR(0)="DO",DIR("A")="Enter new DUE DATE (^ to abort)"
        do ^DIR write !
        if +Y'>0 goto REDDONE

        new IEN set IEN=""
        for  set IEN=$order(SelArray(IEN)) quit:(IEN="")  do
        . set NumProcessed=NumProcessed+1
        . new TMGFDA,TMGMSG
        . set TMGFDA(22705.5,IEN_",",1)=+Y
        . do FILE^DIE("","TMGFDA","TMGMSG")
        . if $data(TMGMSG("DIERR"))>0 do
        . . do ShowDIERR^TMGDEBUG(.TMGMSG)
        . . set numErrors=numErrors+1

REDDONE
        write !,NumProcessed," tickler message file entries processed.",!
        if NumProcessed>0 write numErrors," errors encountered.",!
        write "Goodbye",!
        quit