<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:cda="urn:hl7-org:v3"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                version="1.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
<xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


<!--PROLOG-->
<xsl:output method="text"/>

   <!--XSD TYPES FOR XSLT2-->


<!--KEYS AND FUNCTIONS-->


<!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
            <xsl:variable name="p_1" select="1+    count(preceding-sibling::*[name()=name(current())])"/>
            <xsl:if test="$p_1&gt;1 or following-sibling::*[name()=name(current())]">[<xsl:value-of select="$p_1"/>]</xsl:if>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>']</xsl:text>
            <xsl:variable name="p_2"
                          select="1+   count(preceding-sibling::*[local-name()=local-name(current())])"/>
            <xsl:if test="$p_2&gt;1 or following-sibling::*[local-name()=local-name(current())]">[<xsl:value-of select="$p_2"/>]</xsl:if>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
<xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
<xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters--><xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
<xsl:template match="/">
      <xsl:apply-templates select="/" mode="M6"/>
      <xsl:apply-templates select="/" mode="M7"/>
      <xsl:apply-templates select="/" mode="M8"/>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->


<!--PATTERN p-2.16.840.1.113883.10.20.12-errorsHL7 QRDA Category I Header (Section 2) - errors validation phase-->


	<!--RULE -->
<xsl:template match="/" priority="1006" mode="M6">

		<!--ASSERT -->
<xsl:choose>
         <xsl:when test=".//cda:templateId/@root=&#34;2.16.840.1.113883.10.20.12&#34;"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-5: The value of one ClinicalDocument/templateId/@root SHALL be
       2.16.840.1.113883.10.20.12 representing conformance to the generic
       QRDA Category I framework constraints.
     (.//cda:templateId/@root="2.16.840.1.113883.10.20.12")</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M6"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[cda:templateId/@root=&#34;2.16.840.1.113883.10.20.12&#34;]" priority="1005"
                 mode="M6">

		<!--ASSERT -->
<xsl:choose>
         <xsl:when test="cda:realmCode[@code = &#34;US&#34;]"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-2: The realmCode element SHALL be present where the value of @code is US.
     (cda:realmCode[@code = "US"])</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="cda:typeId[@root = &#34;2.16.840.1.113883.1.3&#34; and @extension = &#34;POCD_HD000040&#34;]"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-3: The value of typeId/@root SHALL be 2.16.840.1.113883.1.3 and value of 
       typeId/@extension SHALL be POCD_HD000040.
     (cda:typeId[@root = "2.16.840.1.113883.1.3" and @extension = "POCD_HD000040"])</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(cda:code) = 1 and cda:code[@code=&#34;55182-0&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-6: A QRDA Category I report SHALL contain exactly one
       ClinicalDocument/code with a value of 55182-0 2.16.840.1.113883.6.1
       LOINC STATIC.
     (count(cda:code) = 1 and cda:code[@code="55182-0" and @codeSystem="2.16.840.1.113883.6.1"])</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="contains(translate(cda:title,'QWERTYUIOPASDFGHJKLZXCVBNM','qwertyuiopasdfghjklzxcvbnm'),'qrda incidence report') or                   contains(translate(cda:title,'QWERTYUIOPASDFGHJKLZXCVBNM','qwertyuiopasdfghjklzxcvbnm'),'quality measure report')"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-7: A QRDA Category I report SHALL contain exactly one
       ClinicalDocument/title element valued with a case-insensitive, text
       string containing "QRDA Incidence Report" or "Quality measure
       Report".
     (contains(translate(cda:title,'QWERTYUIOPASDFGHJKLZXCVBNM','qwertyuiopasdfghjklzxcvbnm'),'qrda incidence report') or contains(translate(cda:title,'QWERTYUIOPASDFGHJKLZXCVBNM','qwertyuiopasdfghjklzxcvbnm'),'quality measure report'))</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(cda:recordTarget/cda:patientRole) = 1"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-8: A QRDA Category I report SHALL contain exactly one
       ClinicalDocument/recordTarget/PatientRole.
     (count(cda:recordTarget/cda:patientRole) = 1)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="cda:author/cda:assignedAuthor/cda:assignedPerson or                   cda:author/cda:assignedAuthor/cda:assignedAuthoringDevice "/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-9: A QRDA Category I report SHALL contain one or more
        ClinicalDocument/author/assignedAuthor/assignedPerson and/or
        ClinicalDocument/author/assignedAuthor/assignedAuthoringDevice.
     (cda:author/cda:assignedAuthor/cda:assignedPerson or cda:author/cda:assignedAuthor/cda:assignedAuthoringDevice)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(cda:informant) = 1"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-10: A QRDA Category I report SHALL contain exactly one
       ClinicalDocument/informant, which represents the reporting facility.
       CONF-QRDA-I-11: An organization source of information SHALL be represented with
       informant.
     (count(cda:informant) = 1)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="cda:custodian/cda:assignedCustodian/cda:representedCustodianOrganization/cda:id/@root or                   cda:custodian/cda:assignedCustodian/cda:representedCustodianOrganization/cda:id[@nullFlavor=&#34;MSK&#34;]"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-12: A QRDA Category I report SHALL contain exactly one
       custodian/assignedCustodian/representedCustodianOrganization/
       id element.
       CONF-QRDA-I-13: The value of custodian/assignedCustodian/
       representedCustodianOrganization/id element @root SHALL be the id
       root of the custodian organization.
     (cda:custodian/cda:assignedCustodian/cda:representedCustodianOrganization/cda:id/@root or cda:custodian/cda:assignedCustodian/cda:representedCustodianOrganization/cda:id[@nullFlavor="MSK"])</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(cda:legalAuthenticator) or count(cda:legalAuthenticator/cda:time) = 1"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-15: If present, a QRDA Category I report legalAuthenticator SHALL
       contain exactly one ClinicalDocument/legalAuthenticator/time element.
     (not(cda:legalAuthenticator) or count(cda:legalAuthenticator/cda:time) = 1)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(cda:legalAuthenticator) or count(cda:legalAuthenticator/cda:signatureCode) = 1"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-16: If present, a QRDA Category I report legalAuthenticator SHALL
        contain exactly one signatureCode element.
     (not(cda:legalAuthenticator) or count(cda:legalAuthenticator/cda:signatureCode) = 1)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(cda:legalAuthenticator) or                   cda:legalAuthenticator/cda:signatureCode[@code=&#34;S&#34;] or                   cda:legalAuthenticator/cda:signatureCode[@nullFlavor=&#34;MSK&#34;]"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-17: The value of a QRDA ClinicalDocument/signatureCode/@code
       SHALL be S.
     (not(cda:legalAuthenticator) or cda:legalAuthenticator/cda:signatureCode[@code="S"] or cda:legalAuthenticator/cda:signatureCode[@nullFlavor="MSK"])</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(cda:legalAuthenticator) or                   cda:legalAuthenticator/cda:assignedEntity"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-18: If present, a QRDA Category I report legalAuthenticator SHALL
       contain exactly one assignedEntity element that represents the legal
       authenticator of the document.
     (not(cda:legalAuthenticator) or cda:legalAuthenticator/cda:assignedEntity)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(cda:legalAuthenticator) or                   cda:legalAuthenticator/cda:assignedEntity/cda:id"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-19: The ClinicalDocument/legalAuthenticator/assigned entity
       SHALL contain an id element.
     (not(cda:legalAuthenticator) or cda:legalAuthenticator/cda:assignedEntity/cda:id)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="cda:component/cda:structuredBody"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-20: A QRDA Category I report SHALL contain exactly one
       ClinicalDocument/component/structuredBody.
     (cda:component/cda:structuredBody)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(.//cda:section/cda:code[@code=&#34;55186-1&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]) &gt; 0"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-21: A QRDA Category I report SHALL contain at least one and MAY contain
       more than one Measure section each containing information about a single measure.
     (count(.//cda:section/cda:code[@code="55186-1" and @codeSystem="2.16.840.1.113883.6.1"]) &gt; 0)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M6"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[cda:code[@code=&#34;55186-1&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]]"
                 priority="1004"
                 mode="M6">

		<!--ASSERT -->
<xsl:choose>
         <xsl:when test="self::cda:section[parent::cda:component[parent::cda:structuredBody[parent::cda:component[parent::cda:ClinicalDocument]]]] or                   parent::cda:section[@code=&#34;55185-3&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]/cda:component"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-22: The Measure section SHALL be a top-level section if it is not part of a
       measure set.
     (self::cda:section[parent::cda:component[parent::cda:structuredBody[parent::cda:component[parent::cda:ClinicalDocument]]]] or parent::cda:section[@code="55185-3" and @codeSystem="2.16.840.1.113883.6.1"]/cda:component)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="cda:templateId"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-33: The Measure section SHALL contain at least one templateId uniquely
        identifying each Measure name and version
     (cda:templateId)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(parent::cda:section[@code=&#34;55185-3&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]/cda:entry) or                   contains(translate(cda:title,&#34;QWERTYUIOPASDFGHJKLZXCVBNM&#34;,&#34;qwertyuiopasdfghjklzxcvbnm&#34;),&#34;measure section: &#34;)"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-36: A non-nested Measure section SHALL be valued with section/title
       with a case-insensitive, text string containing "measure section:
       &lt;measure name&gt;".
     (not(parent::cda:section[@code="55185-3" and @codeSystem="2.16.840.1.113883.6.1"]/cda:entry) or contains(translate(cda:title,"QWERTYUIOPASDFGHJKLZXCVBNM","qwertyuiopasdfghjklzxcvbnm"),"measure section: "))</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="not(parent::cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/cda:section) or                   contains(translate(cda:title,&#34;QWERTYUIOPASDFGHJKLZXCVBNM&#34;,&#34;qwertyuiopasdfghjklzxcvbnm&#34;),&#34;measure section&#34;)"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-37: A nested Measure section SHALL be valued with section/title with
        a case-insensitive, text string containing "measure section".
     (not(parent::cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/cda:section) or contains(translate(cda:title,"QWERTYUIOPASDFGHJKLZXCVBNM","qwertyuiopasdfghjklzxcvbnm"),"measure section"))</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(.//cda:section[cda:code[@code = &#34;55187-9&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]]) = 1"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-39: A Measure section SHALL contain exactly one nested Reporting
       Parameters section (as described in Section 2.4.3 Reporting Parameters
       Section).
     (count(.//cda:section[cda:code[@code = "55187-9" and @codeSystem="2.16.840.1.113883.6.1"]]) = 1)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(.//cda:section[cda:code[@code = &#34;55188-7&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]]) = 1"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-40: A Measure section SHALL contain exactly one nested Patient Data
        section (as described in Section 2.4.4 Patient Data Section).
     (count(.//cda:section[cda:code[@code = "55188-7" and @codeSystem="2.16.840.1.113883.6.1"]]) = 1)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="cda:entry/cda:act[@classCode=&#34;ACT&#34; and @moodCode=&#34;DEF&#34;]"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-42: Each measure SHALL be represented with act.
       CONF-QRDA-I-43: For each act in the Measure section, the value for act/@classCode
       in a measure act SHALL be ACT 2.16.840.1.113883.5.6 ActClass STATIC.
       CONF-QRDA-I-44: For each act in the Measure section the act/@moodCode in a
       measure act SHALL be DEF 2.16.840.1.113883.5.1001 ActMood STATIC.
     (cda:entry/cda:act[@classCode="ACT" and @moodCode="DEF"])</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M6"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[cda:code[@code=&#34;55186-1&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]]/cda:entry/cda:act[@classCode=&#34;ACT&#34; and @moodCode=&#34;DEF&#34;]"
                 priority="1003"
                 mode="M6">

		<!--ASSERT -->
<xsl:choose>
         <xsl:when test="cda:code"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-45: For each act in the Measure section there SHALL be an act/code
       reflecting the measure name and version.
     (cda:code)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M6"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[cda:code[@code=&#34;55185-3&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]]"
                 priority="1002"
                 mode="M6">

		<!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(.//cda:section[cda:code[@code=&#34;55186-1&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]]) = 1"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-24: The Measure Set section SHALL contain one nested Measure section
       and SHALL NOT contain more than one nested Measure section.
     (count(.//cda:section[cda:code[@code="55186-1" and @codeSystem="2.16.840.1.113883.6.1"]]) = 1)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="cda:templateId"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-26: The Measure Set section SHALL contain a templateId uniquely
       identifying the Measure Set name and version.
     (cda:templateId)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="contains(translate(cda:title,'QWERTYUIOPASDFGHJKLZXCVBNM','qwertyuiopasdfghjklzxcvbnm'),'measure set: ')"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-29: The Measure Set section SHALL be valued with section/title with a
       case-insensitive, text string containing "Measure set: &lt;measure set
       name&gt;".
     (contains(translate(cda:title,'QWERTYUIOPASDFGHJKLZXCVBNM','qwertyuiopasdfghjklzxcvbnm'),'measure set: '))</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(.//cda:section/cda:code[@code=&#34;55186-1&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]) &gt; 0 "/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-31: The nested Measure section SHALL contain at least one measure that
        belongs to the measure set.
     (count(.//cda:section/cda:code[@code="55186-1" and @codeSystem="2.16.840.1.113883.6.1"]) &gt; 0)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M6"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[cda:code[@code=&#34;55187-9&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]]"
                 priority="1001"
                 mode="M6">

		<!--ASSERT -->
<xsl:choose>
         <xsl:when test="contains(translate(cda:title,&#34;QWERTYUIOPASDFGHJKLZXCVBNM&#34;,&#34;qwertyuiopasdfghjklzxcvbnm&#34;),&#34;reporting parameters&#34;)"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-49: The Reporting Parameters section SHALL be valued with
       section/title with a case-insensitive, text string containing "Reporting
       Parameters".
     (contains(translate(cda:title,"QWERTYUIOPASDFGHJKLZXCVBNM","qwertyuiopasdfghjklzxcvbnm"),"reporting parameters"))</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="cda:entry/cda:act[@classCode=&#34;ACT&#34; and @moodCode=&#34;EVN&#34;]/cda:code[@code=&#34;252116004&#34; and @codeSystem=&#34;2.16.840.1.113883.6.96&#34;]"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-50: The Reporting Parameters section SHALL contain exactly one
       Observation Parameters Act, represented as an act.
       CONF-QRDA-I-51: The value for act/@classCode in an Observation Parameters Act
       SHALL be ACT 2.16.840.1.113883.5.6 ActClass STATIC.
       CONF-QRDA-I-52: The value for act/@moodCode in an Observation Parameters Act
       SHALL be EVN 2.16.840.1.113883.5.1001 ActMood STATIC.
       CONF-QRDA-I-53: The value for act/code SHALL be 252116004 Observation
       Parameters 2.16.840.1.113883.6.96 SNOMED-CT STATIC.
     (cda:entry/cda:act[@classCode="ACT" and @moodCode="EVN"]/cda:code[@code="252116004" and @codeSystem="2.16.840.1.113883.6.96"])</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="cda:entry/cda:act[@classCode=&#34;ACT&#34; and @moodCode=&#34;EVN&#34;][cda:code[@code=&#34;252116004&#34; and @codeSystem=&#34;2.16.840.1.113883.6.96&#34;]]/cda:effectiveTime[cda:low and cda:high]"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-54: The reporting time period SHALL be represented with an
       effectiveTime/low element combined with a high element representing
       respectively the first and last days of the period reported.
     (cda:entry/cda:act[@classCode="ACT" and @moodCode="EVN"][cda:code[@code="252116004" and @codeSystem="2.16.840.1.113883.6.96"]]/cda:effectiveTime[cda:low and cda:high])</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M6"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[cda:code[@code=&#34;55188-7&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]]"
                 priority="1000"
                 mode="M6">

		<!--ASSERT -->
<xsl:choose>
         <xsl:when test="contains(translate(cda:title,&#34;QWERTYUIOPASDFGHJKLZXCVBNM&#34;,&#34;qwertyuiopasdfghjklzxcvbnm&#34;),&#34;patient data&#34;)"/>
         <xsl:otherwise>
            <xsl:message>
       Error: CONF-QRDA-I-57: The Patient Data section SHALL be valued with section/title with a
       case-insensitive, text string containing "Patient Data".
     (contains(translate(cda:title,"QWERTYUIOPASDFGHJKLZXCVBNM","qwertyuiopasdfghjklzxcvbnm"),"patient data"))</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M6"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M6"/>
   <xsl:template match="@*|node()" priority="-2" mode="M6">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M6"/>
   </xsl:template>

   <!--PATTERN p-2.16.840.1.113883.10.20.12-warningsHL7 QRDA Category I Header (Section 2) - warning validation phase-->


	<!--RULE -->
<xsl:template match="*[cda:templateId/@root=&#34;2.16.840.1.113883.10.20.12&#34;]" priority="1000"
                 mode="M7">

		<!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(cda:legalAuthenticator) = 1"/>
         <xsl:otherwise>
            <xsl:message>
       Warning: CONF-QRDA-I-14: A QRDA Category I report SHOULD contain exactly one
       legalAuthenticator element.
     (count(cda:legalAuthenticator) = 1)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M7"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M7"/>
   <xsl:template match="@*|node()" priority="-2" mode="M7">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M7"/>
   </xsl:template>

   <!--PATTERN p-2.16.840.1.113883.10.20.12-notesHL7 QRDA Category I Header (Section 2) - note validation phase-->


	<!--RULE -->
<xsl:template match="*[cda:templateId/@root=&#34;2.16.840.1.113883.10.20.12&#34;]" priority="1003"
                 mode="M8">

		<!--ASSERT -->
<xsl:choose>
         <xsl:when test="count(cda:component/cda:structuredBody/cda:component/cda:section/cda:code[@code=&#34;55186-1&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]) &gt; 1"/>
         <xsl:otherwise>
            <xsl:message>
       Note: CONF-QRDA-I-21: A QRDA Category I report ... MAY contain
       more than one non-nested top-level Measure section each containing
       information about a single measure.
     (count(cda:component/cda:structuredBody/cda:component/cda:section/cda:code[@code="55186-1" and @codeSystem="2.16.840.1.113883.6.1"]) &gt; 1)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test=".//cda:section/cda:code[@code=&#34;55185-3&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]"/>
         <xsl:otherwise>
            <xsl:message>
       Note: CONF-QRDA-I-23: A QRDA Category I report MAY contain one or more Measure Set
       sections.
     (.//cda:section/cda:code[@code="55185-3" and @codeSystem="2.16.840.1.113883.6.1"])</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT -->
<xsl:choose>
         <xsl:when test="cda:component/cda:structuredBody/cda:component/cda:section/cda:code[@code=&#34;55186-1&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;] and                   .//cda:section/cda:code[@code=&#34;55185-3&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]"/>
         <xsl:otherwise>
            <xsl:message>
       Note: CONF-QRDA-I-25: A QRDA Category I report MAY contain both Measure Set sections and
       individual top-level Measure sections.
     (cda:component/cda:structuredBody/cda:component/cda:section/cda:code[@code="55186-1" and @codeSystem="2.16.840.1.113883.6.1"] and .//cda:section/cda:code[@code="55185-3" and @codeSystem="2.16.840.1.113883.6.1"])</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M8"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[cda:code[@code=&#34;55186-1&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]]"
                 priority="1002"
                 mode="M8">

		<!--ASSERT -->
<xsl:choose>
         <xsl:when test="cda:text"/>
         <xsl:otherwise>
            <xsl:message>
       Note: CONF-QRDA-I-41: The Measure section MAY contain a section/text element for the
       description of the measure(s).
     (cda:text)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M8"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[cda:code[@code=&#34;55186-1&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]]/cda:entry/cda:act[@classCode=&#34;ACT&#34; and @moodCode=&#34;DEF&#34;]"
                 priority="1001"
                 mode="M8">

		<!--ASSERT -->
<xsl:choose>
         <xsl:when test="cda:text"/>
         <xsl:otherwise>
            <xsl:message>
       Note: CONF-QRDA-I-46: Each measure act MAY contain an act/text element containing a
        description of the measure.
     (cda:text)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M8"/>
   </xsl:template>

	  <!--RULE -->
<xsl:template match="*[cda:code[@code=&#34;55185-3&#34; and @codeSystem=&#34;2.16.840.1.113883.6.1&#34;]]"
                 priority="1000"
                 mode="M8">

		<!--ASSERT -->
<xsl:choose>
         <xsl:when test="cda:text"/>
         <xsl:otherwise>
            <xsl:message>
       Note: CONF-QRDA-I-30: The Measure Set section MAY contain a section/text element for
       the description of the measure set or MAY contain a formal representation of
       a description of the measure set.
     (cda:text)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M8"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M8"/>
   <xsl:template match="@*|node()" priority="-2" mode="M8">
      <xsl:apply-templates select="*|comment()|processing-instruction()" mode="M8"/>
   </xsl:template>
</xsl:stylesheet>