BMXADOX1	; IHS/CIHA/GIS - RPC CALL: GENERATE AN ADO SCHEMA STRING AND DATA SET ;
	;;2.2;BMX;;Sep 07, 2010
	; EXMAPLES OF FILEMAN SCHEMA GENERATION
	;
	;
	; N OUT,DAX,% S DAX=0 D SS^BMXADO(.OUT,1,DAX,"^^^5^I^^^^3,XSUB,2160010.03") D DISP(OUT) Q  ; TEST EXTENDED SUBJOIN
	;
DISP(OUT)	;
	D DISP^BMXADOX(OUT)
	Q
	;
SCHEMA(NAME)	; GIVEN SCHEMA NAME, RETURN THE IEN
	N IEN
	S IEN=$O(^BMXADO("B",NAME,0))
	Q IEN
	;
NUM	; ITERATE BY IEN
	; IX="",START WITH IEN=1, STOP AFTER IEN=20, MAX # RECORDS RETURNED = 5
	; TO VIEW INTERNAL VALUES SET VSTG="~1~20~5~I"
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("IHS PATIENT")
	D SS^BMXADO(.OUT,SIEN,"","~1~20~5")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
IX	; ITERATE BY INDEX
	; ITERATE USING THE "B" INDEX
	; START WITH PT NAME "C", STOP AFTER PATIENT NAME = "D", MAX # RECORDS RETURNED = 5
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("IHS PATIENT")
	D SS^BMXADO(.OUT,SIEN,"","B~C~D~5")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
VCN	; SHOW VALUES FOR A SINGLE VISIT THAT AS A DEFINED VCN
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("BMXADO DATA ENTRY IDENTIFIERS")
	D SS^BMXADO(.OUT,SIEN,"","VCN~1.242A~1.242A~")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
MT	; MEASUREMNT TYPES
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("BMXADO MEASUREMENT TYPES")
	D SS^BMXADO(.OUT,SIEN,"","B~~")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
PROB	; PATIENT PROBLEMS
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("BMXADO PROBLEMS")
	D SS^BMXADO(.OUT,SIEN,"","AA~53~53")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
PB1	; ALT PROB RETRIEVAL TEST
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("BMXADO PROBLEMS")
	D SS^BMXADO(.OUT,SIEN,"","~221~221~")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	; 
POV	; RETURN THE POV SCHEMA
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("BMXADO ADD POV")
	D SS^BMXADO(.OUT,SIEN,"","")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
NOTES	; RETURN NOTES FOR A SPECIFIC PATIENT PROBLEMS
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("BMXADO NOTES")
	D SS^BMXADO(.OUT,SIEN,"","~~~~~NOTES~BMXADOFD~53")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
RENT	; ITERATE IN CHUNKS
	; RE-ITERATE USING THE "B" INDEX
	; START WITH PT IEN 5 AS THE "SEED", STOP AFTER PATIENT NAME = "D", MAX # RECORDS RETURNED = 5
	N OUT,%,SIEN,SEED,LSEED,X,Y
	S SEED=0,LSEED=""
	S SIEN=$$SCHEMA("IHS PATIENT")
RIT	F  D  I '$G(SEED) Q
	. ; D SS^BMXADO(.OUT,SIEN,SEED,"B~CA~CB~5")
	. D SS^BMXADO(.OUT,SIEN,SEED,"~~~5")
	. D DISP(OUT) R %:$G(DTIME,60) E  S SEED="" Q
	. I %?1"^" S SEED="" Q
	. S X=$P(@OUT@(1),U,1)
	. S SEED=$P(X,"|",3)
	. I SEED=LSEED S SEED="" Q
	. S LSEED=SEED
	. K ^TMP("BMX ADO",$J)
	. Q
	Q
	;
SUB	; SUBFILE ITERATION
	; THE SCHEMA IS ATTACHED TO THE MEDICARE ELIGIBILITY FILE/ELIG DATE SUBFILE
	; THE DA STRING HAS A VALUE OF '1,',: THE IEN IN THE PARENT FILE.
	; NOTE THE COMMA IN THE DA STRING.  THIS INDICATES THAT THE FILE IEN IS 1 BUT THE SUBFILE IEN IS UNSPECIFIED 
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("UPDATE MEDICARE DATES")
	D SS^BMXADO(.OUT,SIEN,"1,","~~~")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
DINUM	; DINUMED POINTER ITERATION
	; THE SCHEMA IS ATTACHED TO THE IHS PATIENT FILE (9000001)
	; THE IHS PATIENT FILE IS DINUM'D AND ITS .01 FIELD POINTS TO THE VA PATIENT FILE (2)
	; BECAUSE OF THE SPECIAL RELATIONSHIP BETWEEN THE FILES, WE CAN USE THE B INDEX OF FILE 2 TO ITERATE FILE 9000001.
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("IHS PATIENT")
	D SS^BMXADO(.OUT,SIEN,"","B~A~B~5")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
IXP	; INDEXED POINTER ITERATION
	; THE SCHEMA IS ATTACHED TO THE V POV FILE
	; THE AC CROSS REFERENCE INDEXES THE PATIENT FIELD
	; BY STARTING AND STOPING WITH PATIENT 1 (MAX=5) WE COLLECT THE FIRST 5 POVS FOR PATIENT 1 IN THE FILE
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("VIEW POVS")
	D SS^BMXADO(.OUT,SIEN,"","AC~1~1~5")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
AA	; ITERATE USING AA INDEX
	; INDEX IS 'AA"  THE START AND STOP DATES ARE SPECIFIED IN EXTERNAL FORMAT.  MAX=10
	; THE FOLLOWING FILTERS ARE SPECIFIED IN THE LAST PARAMETER ("1|WT|C"):
	;   1=PATIENT DFN #1
	;   WT=RETURN ONLY WEIGHTS. MEASUREMENT TYPE MUST BE SPECIFIED WITH A VALID, UNAMBIGUOUS LOOKUP VALUE.
	;   C=RETRUN VALUES IN CHRONOLOGICAL ORDER USE 'R' INSTEAD OF 'C' FOR REVERSE CHRONOLOGICAL ORDER. DEFAULT=C
	;   THE SEED PARAMTER IS SET AND CAN BE USED TO RETURN DATA IN CHUNKS
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("VIEW MEASUREMENTS")
	D SS^BMXADO(.OUT,SIEN,"","AA~3/21/1985~6/4/1986~5~~~~1|WT|C")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
AA2	; ITERATE USING AA INDEX
	; THIS SCHEMA IS ATTACHED TO THE VISIT FILE (9000010)
	; IN THIS CASE THERE IS NO ATTRIBUTE TYPE SO THE FILTER PARAM HAS ONLY 2 PIECES "1|R"
	;   1=PATIENT DFN
	;   R=RETURN DATA IN REVERSE CHRONOLOGICAL ORDER
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("VISITS")
	D SS^BMXADO(.OUT,SIEN,"","AA~3/21/1985~6/4/1986~5~~~~1|R")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
CIT	; CUSTOM ITERATOR
	; IF COMPLEX OR UNUSUAL SORTING/FILTERING IS REQUITED, USE A CUSTOM ITERATOR
	; THE CUSTOM ITERATOR IS DEFINED BY 6TH, 7TH AND 8TH PIECES IN THE VSTG
	;   PIECE 8=TAG, PIECE 9=ROUTINE, PIECE 8=A PARAMETER PASSED TO THE ENTRY POINT
	;   THE 9TH PIECE CONTAINS PT DFN, TIMESTAMP, VISIT TYPE, LOC IEN, AND SERVICE CATEGORY IN A "|" DELIMTED STRING
	;   THE ITERATOR CALL TAG^ROUTINE(PARAM) TO GENERATE IENS
	; IN THIS CASE THE SCHEMA IS ATTACHED TO THE VISIT FILE.
	; GIVEN THE INFORMATION IN THE PARAMETER, THE CUSTOM ITERATOR RETURNS POSSIBLE DUPLICATE VISITS
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("VISITS")
	D SS^BMXADO(.OUT,SIEN,"","~~~~~DUPV~BMXADOV2~1|4/19/04@1PM|I|4585|A~")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
TRIGGER	; TEXT TRIGGER FUNCTION
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("PATIENT DEMOGRAPHICS")
	D SS^BMXADO(.OUT,SIEN,"","~1~5")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
ID	; IDENTIFIER FIELD
	; THE SCHEMA IS ATTACHED TO THE VA PATIENT FILE (2)
	; THE SCHEMA HAS A BUILT IN FIELD (.01ID) THAT RETURNS THE IDENTIFIERS
	; THE ENTRY POINT THAT GENERATES THE IDETIFIERS IS STORED IN THE BMX ADO SCHEMA FILE
	N OUT,%,SIEN
	S SIEN=$$SCHEMA("UPDATE PATIENT DEMOGRAPHICS")
	D SS^BMXADO(.OUT,SIEN,"","~1~1~")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
JMD	; JOIN MASTER TO DETAIL
	N OUT,%,SIEN1,SIEN2,VSTG,SIEN3,JSTG
	S SIEN1=$$SCHEMA("PATIENT DEMOGRAPHICS")
	S SIEN2=$$SCHEMA("VIEW MEASUREMENTS")
	S SIEN3=$$SCHEMA("VIEW MEDS")
	S VSTG="~1~5" ; INSTRUCTIONS FOR GATHERING DATA SET FOR PTS 1-5 FROM THE MASTER FILE
	S JSTG=SIEN3_",.001,.02IEN,AA~1/1/1960~6/30/2004~~~~~|C" ; + INSTRUCTIONS FOR 1ST JOIN TO GET MEDS
	S JSTG=JSTG_"@JOIN@"_SIEN2_",.001,.02IEN,AA~1/1/1988~12/31/1988~~~~~|WT|R" ; + INSTRUCTIONS FOR 2ND JOIN TO GET MSRMNTS
	D SS^BMXADO(.OUT,SIEN1,"",VSTG,JSTG)
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	; 
JVPT	; JOIN PT DEMOG TO VISIT
	N OUT,%,SIEN1,SIEN2,VSTG,JSTG
	S SIEN1=$$SCHEMA("PATIENT DEMOGRAPHICS")
	S SIEN2=$$SCHEMA("VISITS")
	S VSTG="~1~1" ; INSTRUCTIONS FOR GATHERING DATA SET FOR PT 5 FROM THE MASTER FILE
	S JSTG=SIEN2_",.05IEN,.001,AC" ; + INSTRUCTIONS FOR 1ST JOIN TO GET VISIT INFO
	D SS^BMXADO(.OUT,SIEN1,"",VSTG,JSTG)
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
JAC	; TEST AC INDEX
	N OUT,%,SIEN1,SIEN2
	S SIEN1=$$SCHEMA("PATIENT DEMOGRAPHICS")
	S SIEN2=$$SCHEMA("VIEW LABS")
	S SIEN3=$$SCHEMA("VIEW MEASUREMENTS")
	D SS^BMXADO(.OUT,SIEN1,"","~3~5~~~~~~"_SIEN2_",.001,.02IEN,AC@JOIN@"_SIEN3_",.001,.02IEN,AC")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	; 
JPB	; TEST AA INDEX JOINS FOR PROBLEM LIST
	N OUT,%,SIEN1,SIEN2
	S SIEN1=$$SCHEMA("PATIENT DEMOGRAPHICS")
	S SIEN2=$$SCHEMA("VIEW PROBLEMS")
	D SS^BMXADO(.OUT,SIEN1,"","~1~5~~~~~~"_SIEN2_",.001,.02IEN,AA")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	; 
JSUB	; SUBFILE JOIN
	; IN THIS CASE THE RECORDS IN A PARENT FILE ARE "JOINED" TO THE RECORDS IN ONE OF ITS SUB FILES
	; THE SCHEMA IS ATTACHED TO THE "MEDICARE ELIGIBLE" FILE
	; IT IS JOINED TO ITS SUBFILE, "ELIG DATES", VIA THE UPDATE MEDICARE DATES SCHEMA
	N OUT,%,SIEN1,SIEN2
	S SIEN1=$$SCHEMA("UPDATE MEDICARE INFO")
	S SIEN2=$$SCHEMA("UPDATE MEDICARE DATES")
	D SS^BMXADO(.OUT,SIEN1,"","~1~5~~~~~~"_SIEN2_",SUB")
	D DISP(OUT) R %:$G(DTIME,60)
	K ^TMP("BMX ADO",$J)
	Q
	;
ADD	; ADD A NEW ENTRY
	; THIS IS A 2 STEP PROCESS:
	;   FIRST GET THE SCHEMA FOR THE FILE YOU WISH TO UPDATE
	;     THIS SCHEMA TYPICALLY BEGINS WITH THE WORD "UPDATE"
	;     IT CONTAINS NO ID IR IEN FIELDS
	;   SECOND ADD THE DATA NODE TO THE ARRAY
	;     IT HAS THE SAME FORMAT AS A DATA STRING ASSOCIATED WITH THE SCHEMA EXCEPT THE FIRST "^" PIECE IS NULL
	;     THIS PIECE CORRESPONDS TO THE IEN OF THE RECORD.  SINCE THE RECORD HASNOT BEEN ADDED YET, IT IS NULL.
	;     IN THE DATA STRING, ALL POINTER VALUES ARE PRECEDED BY THE '`' CHARACTER AND EA. STRING ENDS IN $C(30)
	;     MULTIPLE DATA STRINGS CAN BE APPENDED AS NEW NODES AT THE BOTTOM OF THE ARRAY
	;     IN THIS CASE WE ARE ADDING A RECORD TO THE V MEASUREMENT FILE
	;     DATA STRING="^MEASUREMENT TYPE IEN^PATIENT DFN^VISIT IEN^RESULT"_$C(30)
	;   THERE ARE 2 INPUT PARAMS:
	;     THE CLOSED REF WHERE THE INPUT ARRAY IS STORED
	;     SINCE IT IS PASSED BY REFERENCE "OUT" CAN BE NULL OR UNDEFIEND.
	;     OUT WILL BE DEFINED AT THE CONCLUSION OF THE TRANSACTION.
	;   THE OUTPUT IS IN THE OUT ARRAY
	;   OUT(1)="OK|ien" WHERE ien IS THE IEN OF THE RECORD THAT HAS BEE ADDED.
	;   IF THE TRANSACTION FAILED, AN ERROR MSG WILL BE IN THE OUT ARRAY
	;
	N OUT,%,SIEN,NODE
	S SIEN=$$SCHEMA("UPDATE MEASUREMENTS")
	D SS^BMXADO(.OUT,SIEN,"","") ; GET SCHEMA
	S NODE=$O(^TMP("BMX ADO",$J,999999),-1)+1
	S ^TMP("BMX ADO",$J,NODE)="^`2^`1^`71164^175.75"_$C(30)
	D DISP(OUT) R %:$G(DTIME,60) ; DISPLAY THE INPUT ARRAY BEFORE UPDATING THE RECORD
	D BAFM^BMXADOF1(.OUT,$NA(^TMP("BMX ADO",$J))) ; EP FOR UPDAING THE RECORD
	K ^TMP("BMX ADO",$J)
	W !!,OUT S %=0 F  S %=$O(OUT(%)) Q:'%  W !,OUT(%) ; SEND BACK AN ACKNOWLEDGEMENT OR ERROR MSG
	Q
	;
DELREC	; DELETE AN ENTRY
	; THE SIMPLEST WAY TO DELETE AN ENTRY IS TO PUT THE RECORD IEN IN THE DA STRING PRECEDED BY A MINUS SIGN
	; YOU CAN ALSO SET THE VALUE OF THE .01 FIELD TO "@"
	; IF THE VALUE OF THE .01 FIELD IS NULL AND THE DA STRING IS NOT PRECEDED BY A MINUS SIGN, THE TRANSACTION WILL BE CANCELLED
	; IF THE DA STRING IS NULL, THE TRANSACTION WILL BE CANCELLED
	N OUT,%,SIEN,NODE,DEL
	S DEL=51385
	S SIEN=$$SCHEMA("UPDATE MEASUREMENTS")
	D SS^BMXADO(.OUT,SIEN,"","") ; GET SCHEMA
	S NODE=$O(^TMP("BMX ADO",$J,999999),-1)+1
	S ^TMP("BMX ADO",$J,NODE)="-"_DEL_$C(30)
	D DISP(OUT) R %:$G(DTIME,60) ; DISPLAY THE INPUT ARRAY BEFORE UPDATING THE RECORD
	D BAFM^BMXADOF1(.OUT,$NA(^TMP("BMX ADO",$J))) ; EP FOR UPDAING THE RECORD
	K ^TMP("BMX ADO",$J)
	W !!,OUT S %=0 F  S %=$O(OUT(%)) Q:'%  W !,OUT(%) ; SEND BACK AN ACKNOWLEDGEMENT OR ERROR MSG
	Q
	;
EDIT	; EDIT AN EXISTING ENTRY
	; SIMILAR TO ABOVE EXCEPT THAT THE FIRST "^" PIECE OF THE DATA NODE IS THE IEN OF THE RECORD TO BE EDITIED
	; NOTE THAT THERE IS NO '`' IN FRONT OF THE FIRST PIECE.  IT IS A PURE INTEGER
	N OUT,%,SIEN,NODE
	S SIEN=$$SCHEMA("UPDATE MEASUREMENTS")
	D SS^BMXADO(.OUT,SIEN,"","") ; GET SCHEMA
	S NODE=$O(^TMP("BMX ADO",$J,999999),-1)+1
	S ^TMP("BMX ADO",$J,NODE)="51385^^^^176^`6"_$C(30)
	D DISP(OUT) R %:$G(DTIME,60) ; DISPLAY THE INPUT ARRAY BEFORE UPDATING THE RECORD
	D BAFM^BMXADOF1(.OUT,$NA(^TMP("BMX ADO",$J))) ; EP FOR UPDAING THE RECORD
	K ^TMP("BMX ADO",$J)
	W !!,OUT S %=0 F  S %=$O(OUT(%)) Q:'%  W !,OUT(%) ; SEND BACK AN ACKNOWLEDGEMENT OR ERROR MSG
	Q
	;
DELVAL	; DELETE A VALUE IN A FIELD
	; SIMILAR TO EDIT EXCEPT THE VALUE IS "@"
	N OUT,%,SIEN,NODE
	S SIEN=$$SCHEMA("UPDATE MEASUREMENTS")
	D SS^BMXADO(.OUT,SIEN,"","") ; GET SCHEMA
	S NODE=$O(^TMP("BMX ADO",$J,999999),-1)+1
	S ^TMP("BMX ADO",$J,NODE)="51385^^^^^@"_$C(30)
	D DISP(OUT) R %:$G(DTIME,60) ; DISPLAY THE INPUT ARRAY BEFORE UPDATING THE RECORD
	D BAFM^BMXADOF1(.OUT,$NA(^TMP("BMX ADO",$J))) ; EP FOR UPDAING THE RECORD
	K ^TMP("BMX ADO",$J)
	W !!,OUT S %=0 F  S %=$O(OUT(%)) Q:'%  W !,OUT(%) ; SEND BACK AN ACKNOWLEDGEMENT OR ERROR MSG
	Q
