                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Payers">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.9"/>
                                <code code="48768-6" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Insurance</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Identification Numbers</th>
                                                <th>Payment Provider</th>
                                                <th>Subscriber</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Payers/a:Payer">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time" select="a:DateTime/a:ExactDateTime"/>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:IDs">
                                                            <xsl:value-of select="a:Type/a:Text"/>:<xsl:text xml:space="preserve"> </xsl:text><xsl:value-of select="a:ID"/><br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:PaymentProvider/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Subscriber/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Payers/a:Payer">
                                    <entry typeCode="DRIV">
                                        <act classCode="ACT" moodCode="DEF">
                                            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.17" assigningAuthorityName="IHE PCC"/>
                                            <templateId root="2.16.840.1.113883.10.20.1.20" assigningAuthorityName="CCD"/>
                                            <!-- Coverage entry template -->
                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                            </xsl:call-template>
                                            <code code="48768-6" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Payment sources"/>
                                            <statusCode code="completed"/>
                                            <entryRelationship typeCode="COMP">
                                                <act classCode="ACT" moodCode="EVN">
                                                    <templateId root="2.16.840.1.113883.3.88.11.83.5" assigningAuthorityName="HITSP C83"/>
                                                    <templateId root="2.16.840.1.113883.10.20.1.26" assigningAuthorityName="CCD"/>
                                                    <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.18" assigningAuthorityName="IHE PCC"/>
                                                    <!--Insurance provider template -->
                                                    <id>
                                                        <xsl:attribute name="root">
                                                            <xsl:value-of select="a:IDs[1]/a:ID"/>
                                                        </xsl:attribute>
                                                        <xsl:attribute name="extension">
                                                            <xsl:value-of select="a:IDs[1]/a:Type/a:Text"/>
                                                        </xsl:attribute>
                                                    </id>

                                                    <!-- <code> -->
                                                    <xsl:call-template name="ccdCodedValue">
                                                        <xsl:with-param name="ccrCodedDescription" select="a:Description"/>
                                                        <xsl:with-param name="nodeName" select="'code'"/>
                                                    </xsl:call-template>

                                                    <statusCode code="completed"/>

                                                    <xsl:call-template name="ccdPerformer">
                                                        <xsl:with-param name="ccrActorReference" select="a:PaymentProvider"/>
                                                    </xsl:call-template>

                                                    <participant typeCode="HLD">
                                                        <xsl:call-template name="ccdParticipantRoleActor">
                                                            <xsl:with-param name="ccrActorReference" select="a:Subscriber"/>
                                                        </xsl:call-template>
                                                    </participant>
                                                </act>
                                            </entryRelationship>
                                        </act>
                                    </entry>
                                </xsl:for-each>
                            </section>
                        </component>
                    </xsl:if>
