                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Medications">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.3.88.11.83.112" assigningAuthorityName="HITSP/C83"/>
                                <templateId root="1.3.6.1.4.1.19376.1.5.3.1.3.19" assigningAuthorityName="IHE PCC"/>
                                <templateId root="2.16.840.1.113883.10.20.1.8" assigningAuthorityName="HL7 CCD"/>
                                <!--Medications section template-->
                                <code code="10160-0" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="History of medication use"/>
                                <title>Medications</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Medication</th>
                                                <th>Date</th>
                                                <th>Status</th>
                                                <th>Form</th>
                                                <th>Strength</th>
                                                <th>Quantity</th>
                                                <th>SIG</th>
                                                <th>Indications</th>
                                                <th>Instruction</th>
                                                <th>Refills</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Medications/a:Medication">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Product/a:ProductName/a:Text"/>
                                                        <xsl:if test="a:Product/a:BrandName">
                                                            <xsl:text xml:space="preserve"> </xsl:text>(<xsl:value-of select="a:Product/a:BrandName/a:Text"/>)
                                                        </xsl:if>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time" select="a:DateTime/a:ExactDateTime"/>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Status/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Product/a:Form/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Product/a:Strength">
                                                            <xsl:if test="position() > 1">
                                                                <xsl:text>/</xsl:text>
                                                            </xsl:if>
                                                            <xsl:value-of select="a:Value"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:Units/a:Unit"/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Quantity/a:Value"/>
                                                        <xsl:text xml:space="preserve"> </xsl:text>
                                                        <xsl:value-of select="a:Quantity/a:Units/a:Unit"/>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Directions/a:Direction">
                                                            <xsl:choose>
                                                                <xsl:when test="a:Description/a:Text">
                                                                    <xsl:value-of select="a:Description/a:Text"/>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <xsl:value-of select="a:Dose/a:Value"/>
                                                                    <xsl:text xml:space="preserve"> </xsl:text>
                                                                    <xsl:value-of select="a:Dose/a:Units/a:Unit"/>
                                                                    <xsl:text xml:space="preserve"> </xsl:text>
                                                                    <xsl:value-of select="a:Route/a:Text"/>
                                                                    <xsl:text xml:space="preserve"> </xsl:text>
                                                                    <xsl:value-of select="a:Frequency/a:Value"/>
                                                                    <xsl:if test="a:Duration">
                                                                        <xsl:text xml:space="preserve">( </xsl:text>for <xsl:value-of select="a:Duration/a:Value"/><xsl:text xml:space="preserve"> </xsl:text><xsl:value-of select="a:Duration/a:Units/a:Unit"/><xsl:text xml:space="preserve"> )</xsl:text>
                                                                    </xsl:if>
                                                                    <xsl:if test="a:MultipleDirectionModifier/a:ObjectAttribute">
                                                                        <xsl:for-each select="a:MultipleDirectionModifier/a:ObjectAttribute">
                                                                            <xsl:value-of select="a:Attribute"/>
                                                                            <br/>
                                                                            <xsl:value-of select="a:AttributeValue/a:Value"/>
                                                                        </xsl:for-each>
                                                                    </xsl:if>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Directions/a:Direction[1]/a:Indication">
                                                            <xsl:call-template name="problemDescription">
                                                                <xsl:with-param name="objID" select="a:InternalCCRLink/a:LinkID"/>
                                                            </xsl:call-template>
                                                            <br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:PatientInstructions/a:Instruction">
                                                            <xsl:value-of select="a:Text"/>
                                                            <br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Refills/a:Refill">
                                                            <xsl:value-of select="a:Number"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Medications/a:Medication">
                                    <entry typeCode="DRIV">
                                        <substanceAdministration classCode="SBADM" moodCode="EVN">
                                            <templateId root="2.16.840.1.113883.10.20.1.24" assigningAuthorityName="CCD"/>
                                            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.7.1" assigningAuthorityName="IHE PCC"/>

                                            <!--Medication activity template -->

                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                            </xsl:call-template>

                                            <statusCode code='completed'/>

                                            <xsl:call-template name="ccdDateTime">
                                                <xsl:with-param name="dt" select="a:DateTime"/>
                                                <xsl:with-param name="type" select="'IVL_TS'"/>
                                            </xsl:call-template>

                                            <xsl:call-template name="ccdMedicationFrequency">
                                                <xsl:with-param name="frequency" select="a:Directions/a:Direction/a:Frequency"/>
                                            </xsl:call-template>

                                            <xsl:call-template name="ccdCodedValue">
                                                <xsl:with-param name="ccrCodedDescription" select="a:Directions/a:Direction/a:Route"/>
                                                <xsl:with-param name="nodeName" select="'routeCode'"/>
                                                <xsl:with-param name="domain" select="'RouteOfAdministration'"/>
                                            </xsl:call-template>

                                            <xsl:if test="a:Directions/a:Direction/a:Dose">
                                                <doseQuantity>
                                                    <low>
                                                        <xsl:attribute name="value">
                                                            <xsl:value-of select="a:Directions/a:Direction/a:Dose/a:Value"></xsl:value-of>
                                                        </xsl:attribute>
                                                        <xsl:attribute name="unit">
                                                            <xsl:value-of select="a:Directions/a:Direction/a:Dose/a:Unit"></xsl:value-of>
                                                        </xsl:attribute>
                                                    </low>
                                                    <high>
                                                        <xsl:attribute name="value">
                                                            <xsl:value-of select="a:Directions/a:Direction/a:Dose/a:Value"></xsl:value-of>
                                                        </xsl:attribute>
                                                        <xsl:attribute name="unit">
                                                            <xsl:value-of select="a:Directions/a:Direction/a:Dose/a:Unit"></xsl:value-of>
                                                        </xsl:attribute>
                                                    </high>
                                                </doseQuantity>
                                            </xsl:if>
                                            <consumable>
                                                <manufacturedProduct>
                                                    <templateId root="2.16.840.1.113883.3.88.11.83.8.2" assigningAuthorityName="HITSP C83"/>
                                                    <templateId root="2.16.840.1.113883.10.20.1.53" assigningAuthorityName="CCD"/>
                                                    <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.7.2" assigningAuthorityName="IHE PCC"/>

                                                    <!-- Product template -->

                                                    <manufacturedMaterial>
                                                        <xsl:call-template name="ccdCodedValue">
                                                            <xsl:with-param name="ccrCodedDescription" select="a:Product/a:ProductName"/>
                                                            <xsl:with-param name="nodeName" select="'code'"/>
                                                        </xsl:call-template>
                                                        <name>
                                                            <xsl:value-of select="a:Product/a:BrandName/a:Text"/>
                                                        </name>
                                                    </manufacturedMaterial>
                                                </manufacturedProduct>
                                            </consumable>
                                        </substanceAdministration>
                                    </entry>
                                </xsl:for-each>
                            </section>
                        </component>
                    </xsl:if>
