    <xsl:template name="ccdAssignedEntity">
        <xsl:param name="ccrActorObjectID"/>

        <xsl:variable name="CCRActor" select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$ccrActorObjectID]"/>

        <assignedEntity>
            <xsl:call-template name="ccdEntityID">
                <xsl:with-param name="CCRActor" select="$CCRActor"/>
            </xsl:call-template>

            <xsl:call-template name="ccdAddress">
                <xsl:with-param name="CCRActorAddress" select="$CCRActor/a:Address"/>
            </xsl:call-template>

            <xsl:call-template name="ccdTelecom">
                <xsl:with-param name="CCRActor" select="$CCRActor"/>
            </xsl:call-template>

            <xsl:if test="$CCRActor/a:Person">
                <xsl:call-template name="ccdPerson">
                    <xsl:with-param name="CCRActorPerson" select="$CCRActor/a:Person"/>
                    <xsl:with-param name="personNodeName" select="'assignedPerson'"/>
                </xsl:call-template>
            </xsl:if>

            <xsl:if test="$CCRActor/a:InternalCCRLink[a:LinkRelationship='Organization']">
                <xsl:call-template name="ccdOrganization">
                    <xsl:with-param name="ccrActorObjectID" select="$CCRActor/a:InternalCCRLink[a:LinkRelationship='Organization']/a:LinkID"/>
                    <xsl:with-param name="organizationNodeName" select="'representedOrganization'"/>
                </xsl:call-template>
            </xsl:if>

        </assignedEntity>
    </xsl:template>

    <xsl:template name="ccdPatient">
        <xsl:param name="CCRActorPerson"/>
        <patient>
            <xsl:call-template name="ccdPersonName">
                <xsl:with-param name="CCRActorName" select="$CCRActorPerson/a:Name"/>
            </xsl:call-template>

            <xsl:if test="$CCRActorPerson/a:Gender">
                <xsl:call-template name="ccdCodedValue">
                    <xsl:with-param name="ccrCodedDescription" select="$CCRActorPerson/a:Gender"/>
                    <xsl:with-param name="domain" select="'AdministrativeGender'"/>
                    <xsl:with-param name="nodeName" select="'administrativeGenderCode'"/>
                </xsl:call-template>
            </xsl:if>

            <xsl:if test="$CCRActorPerson/a:DateOfBirth">
                <birthTime>
                    <xsl:attribute name="value">
                        <xsl:call-template name="date:format-date">
                            <xsl:with-param name="date-time" select="$CCRActorPerson/a:DateOfBirth/a:ExactDateTime"/>
                            <xsl:with-param name="pattern">yyyyMMddhhmmss</xsl:with-param>
                        </xsl:call-template>
                    </xsl:attribute>
                </birthTime>
            </xsl:if>

            <xsl:if test="/a:ContinuityOfCareRecord/a:Body/a:SocialHistory/a:SocialHistoryElement[a:Type/a:Text='Marital Status']">
                <xsl:call-template name="ccdCodedValue">
                    <xsl:with-param name="ccrCodedDescription" select="/a:ContinuityOfCareRecord/a:Body/a:SocialHistory/a:SocialHistoryElement[a:Type/a:Text='Marital Status']/a:Description"/>
                    <xsl:with-param name="domain" select="'MaritalStatus'"/>
                    <xsl:with-param name="nodeName" select="'maritalStatusCode'"/>
                </xsl:call-template>
            </xsl:if>

            <xsl:if test="/a:ContinuityOfCareRecord/a:Body/a:SocialHistory/a:SocialHistoryElement[a:Type/a:Text='Language']">
                <languageCommunication>
                    <templateId root="2.16.840.1.113883.3.88.11.83.2" assigningAuthorityName="HITSP/C83"/>
                    <templateId root="1.3.6.1.4.1.19376.1.5.3.1.2.1" assigningAuthorityName="IHE/PCC"/>
                    <xsl:call-template name="ccdCodedValue">
                        <xsl:with-param name="ccrCodedDescription" select="/a:ContinuityOfCareRecord/a:Body/a:SocialHistory/a:SocialHistoryElement[a:Type/a:Text='Language']/a:Description"></xsl:with-param>
                        <xsl:with-param name="domain" select="'HumanLanguage'"/>
                        <xsl:with-param name="nodeName" select="'languageCode'"/>
                    </xsl:call-template>
                </languageCommunication>
            </xsl:if>
        </patient>
    </xsl:template>

    <xsl:template name="ccdPerformer">
        <xsl:param name="ccrActorReference"/>
        <performer typeCode="PRF">
            <xsl:if test="$ccrActorReference/a:ActorRole">
                <xsl:call-template name="ccdCodedValue">
                    <xsl:with-param name="ccrCodedDescription" select="$ccrActorReference/a:ActorRole"/>
                    <xsl:with-param name="nodeName" select="'functionCode'"/>
                </xsl:call-template>
            </xsl:if>
            <xsl:call-template name="ccdAssignedEntity">
                <xsl:with-param name="ccrActorObjectID" select="$ccrActorReference/a:ActorID"/>
            </xsl:call-template>
        </performer>
    </xsl:template>

    <xsl:template name="ccdPerson">
        <xsl:param name="CCRActorPerson"/>
        <xsl:param name="personNodeName">assignedPerson</xsl:param>
        <xsl:element name="{$personNodeName}">
            <xsl:call-template name="ccdPersonName">
                <xsl:with-param name="CCRActorName" select="$CCRActorPerson/a:Name"/>
            </xsl:call-template>
        </xsl:element>
    </xsl:template>

    <xsl:template name="ccdPersonName">
        <xsl:param name="CCRActorName"/>
        <name>
            <xsl:if test="$CCRActorName/a:CurrentName/a:Title">
                <prefix>
                    <xsl:value-of select="$CCRActorName/a:CurrentName/a:Title"/>
                </prefix>
            </xsl:if>
            <xsl:if test="$CCRActorName/a:CurrentName/a:Given">
                <given>
                    <xsl:value-of select="$CCRActorName/a:CurrentName/a:Given"/>
                </given>
            </xsl:if>
            <xsl:if test="$CCRActorName/a:CurrentName/a:Middle">
                <given>
                    <xsl:value-of select="$CCRActorName/a:CurrentName/a:Middle"/>
                </given>
            </xsl:if>
            <xsl:if test="$CCRActorName/a:CurrentName/a:Family">
                <family>
                    <xsl:value-of select="$CCRActorName/a:CurrentName/a:Family"/>
                </family>
            </xsl:if>
            <xsl:if test="$CCRActorName/a:CurrentName/a:Suffix">
                <suffix>
                    <xsl:value-of select="$CCRActorName/a:CurrentName/a:Suffix"/>
                </suffix>
            </xsl:if>
        </name>
    </xsl:template>

    <xsl:template name="ccdOrganization">
        <xsl:param name="ccrActorObjectID"/>
        <xsl:param name="organizationNodeName"/>

        <xsl:variable name="CCRActor" select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$ccrActorObjectID]"/>

        <xsl:element name="{$organizationNodeName}">
            <xsl:call-template name="ccdEntityID">
                <xsl:with-param name="CCRActor" select="$CCRActor"/>
            </xsl:call-template>
            <xsl:call-template name="ccdTelecom">
                <xsl:with-param name="CCRActor" select="$CCRActor"/>
            </xsl:call-template>

            <xsl:call-template name="ccdAddress">
                <xsl:with-param name="CCRActorAddress" select="$CCRActor/a:Address[1]"/>
            </xsl:call-template>
        </xsl:element>
    </xsl:template>

    <xsl:template name="ccdPatientRole">
        <xsl:param name="ccrActorObjectID"/>

        <xsl:variable name="CCRActor" select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$ccrActorObjectID]"/>

        <xsl:call-template name="ccdEntityID">
            <xsl:with-param name="CCRActor" select="$CCRActor"/>
        </xsl:call-template>

        <xsl:call-template name="ccdAddress">
            <xsl:with-param name="CCRActorAddress" select="$CCRActor/a:Address[1]"/>
        </xsl:call-template>

        <xsl:call-template name="ccdTelecom">
            <xsl:with-param name="CCRActor" select="$CCRActor"/>
        </xsl:call-template>

        <xsl:call-template name="ccdPatient">
            <xsl:with-param name="CCRActorPerson" select="$CCRActor/a:Person"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="ccdAssignedAuthor">
        <xsl:param name="ccrActorObjectID"/>
		<assignedAuthor>
        <xsl:variable name="CCRActor" select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$ccrActorObjectID]"/>

        <xsl:call-template name="ccdEntityID">
            <xsl:with-param name="CCRActor" select="$CCRActor"/>
        </xsl:call-template>

        <xsl:call-template name="ccdAddress">
            <xsl:with-param name="CCRActorAddress" select="$CCRActor/a:Address[1]"/>
        </xsl:call-template>

        <xsl:call-template name="ccdTelecom">
            <xsl:with-param name="CCRActor" select="$CCRActor"/>
        </xsl:call-template>

        <xsl:call-template name="ccdPerson">
            <xsl:with-param name="CCRActorPerson" select="$CCRActor/a:Person"/>
        </xsl:call-template>

        <xsl:if test="$CCRActor/a:InternalCCRLink[a:LinkRelationship='Organization']">
            <representedOrganization>
                <xsl:call-template name="ccdOrganization">
                    <xsl:with-param name="ccrActorObjectID" select="$CCRActor/a:InternalCCRLink[a:LinkRelationship='Organization']/a:LinkID"/>
                </xsl:call-template>
            </representedOrganization>
        </xsl:if>
        </assignedAuthor>
    </xsl:template>

    <xsl:template name="ccdParticipantRoleActor">
        <xsl:param name="ccrActorObjectID"/>

        <xsl:variable name="CCRActor" select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$ccrActorObjectID]"/>

        <xsl:call-template name="ccdEntityID">
            <xsl:with-param name="CCRActor" select="$CCRActor"/>
        </xsl:call-template>

        <xsl:call-template name="ccdAddress">
            <xsl:with-param name="CCRActorAddress" select="$CCRActor/a:Address[1]"/>
        </xsl:call-template>

        <xsl:call-template name="ccdTelecom">
            <xsl:with-param name="CCRActor" select="$CCRActor"/>
        </xsl:call-template>

        <xsl:if test="$CCRActor/a:Organization/a:Name">
            <playingEntity classCode="PLC">
                <name>
                    <xsl:value-of select="$CCRActor/a:Organization/a:Name"/>
                </name>
            </playingEntity>
        </xsl:if>
    </xsl:template>

    <xsl:template name="ccdParticipantRoleCodedDescription">
        <xsl:param name="ccrCodedDescription"/>
        <participantRole classCode="MANU">
           <!--Product Detail-->
           <playingEntity classCode="MMAT">
				<xsl:if test="$ccrCodedDescription/a:Code">
					<xsl:call-template name="ccdCodedValue">
						<xsl:with-param name="ccrCodedDescription" select="$ccrCodedDescription"/>
						<xsl:with-param name="nodeName" select="'code'"/>
					</xsl:call-template>
				</xsl:if>
				<name>
					<xsl:value-of select="$ccrCodedDescription/a:Text"/>
				</name>
			</playingEntity>
		</participantRole>
    </xsl:template>

    <xsl:template name="ccdEntityID">
        <xsl:param name="CCRActor"/>
        <id>
            <xsl:choose>
                <xsl:when test="$CCRActor/a:IDs">
                    <xsl:attribute name="extension">
                        <xsl:value-of select="$CCRActor/a:IDs[1]/a:ID"/>
                    </xsl:attribute>
                    <xsl:attribute name="root">
                        <xsl:value-of select="$CCRActor/a:IDs[1]/a:Type/a:Text"/>
                    </xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="extension">
                        <xsl:value-of select="$CCRActor/a:ActorObjectID"/>
                    </xsl:attribute>
                    <xsl:attribute name="root">
                        <xsl:text>CCRActorID</xsl:text>
                    </xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
        </id>
         <xsl:if test="$CCRActor/a:Organization">
            <name><xsl:value-of select="$CCRActor/a:Organization/a:Name"></xsl:value-of></name>
        </xsl:if>
    </xsl:template>		
    <xsl:template name="ccdAddress">
        <xsl:param name="CCRActorAddress"/>
        <addr>
            <xsl:choose>
                <xsl:when test="$CCRActorAddress">
                    <xsl:attribute name="use">
                        <xsl:call-template name="CDAVocabularyLookup">
                            <xsl:with-param name="domain" select="'telecommunicationsAddressUse'"/>
                            <xsl:with-param name="ccrtext" select="$CCRActorAddress/a:Type/a:Text"/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <streetAddressLine>
                        <xsl:value-of select="$CCRActorAddress/a:Line1"/>
                    </streetAddressLine>
                    <city>
                        <xsl:value-of select="$CCRActorAddress/a:City"/>
                    </city>
                    <state>
                        <xsl:value-of select="$CCRActorAddress/a:State"/>
                    </state>
                    <postalCode>
                        <xsl:value-of select="$CCRActorAddress/a:PostalCode"/>
                    </postalCode>
                </xsl:when>
                <xsl:otherwise>
                    <streetAddressLine/>
                </xsl:otherwise>
            </xsl:choose>
        </addr>
    </xsl:template>
    
    <xsl:template name="ccdTelecom">
        <xsl:param name="CCRActor"/>
        <telecom>
            <xsl:if test="$CCRActor/a:Telephone">
                <xsl:attribute name="use">
                    <xsl:call-template name="CDAVocabularyLookup">
                        <xsl:with-param name="domain" select="'telecommunicationsAddressUse'"/>
                        <xsl:with-param name="ccrtext" select="$CCRActor/a:Telephone/a:Type/a:Text"/>
                    </xsl:call-template>
                </xsl:attribute>
                <xsl:attribute name="value">
                    <xsl:text>tel:+1-</xsl:text>
                    <xsl:value-of select="$CCRActor/a:Telephone[1]/a:Value"/>
                </xsl:attribute>
            </xsl:if>
        </telecom>

        <xsl:if test="$CCRActor/a:Email">
            <telecom>
                <xsl:choose>
                    <xsl:when test="$CCRActor/a:Telephone">
                        <xsl:attribute name="use">
                            <xsl:call-template name="CDAVocabularyLookup">
                                <xsl:with-param name="domain" select="'telecommunicationsAddressUse'"/>
                                <xsl:with-param name="ccrtext" select="$CCRActor/a:Telephone/a:Type/a:Text"/>
                            </xsl:call-template>
                        </xsl:attribute>
                        <xsl:attribute name="value">
                            <xsl:text>mailto:</xsl:text>
                            <xsl:value-of select="$CCRActor/a:Email[1]/a:Value"/>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="value">
                            <xsl:text>Unknown</xsl:text>
                        </xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
            </telecom>
        </xsl:if>
    </xsl:template>

    <xsl:template name="ccdID">
        <xsl:param name="ccrObjectID"/>
        <xsl:param name="suffix"/>
        <id>
            <xsl:attribute name="root">
                <xsl:value-of select="$ccrObjectID"></xsl:value-of>
            </xsl:attribute>
            <xsl:attribute name="extension">CCRObjectID</xsl:attribute>
        </id>
    </xsl:template>

    <xsl:template name="ccdCodedValue">
        <xsl:param name="ccrCodedDescription"/>
        <xsl:param name="type"/>
        <xsl:param name="domain"/>
        <xsl:param name="nodeName">value</xsl:param>
        <xsl:param name="originalTextReference"/>

        <xsl:element name="{$nodeName}">
            <xsl:if test="$type">
                <xsl:attribute name="xsi:type">
                    <xsl:value-of select="$type"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="$ccrCodedDescription/a:Code">
                    <xsl:attribute name="displayName">
                        <xsl:value-of select="$ccrCodedDescription/a:Text"/>
                    </xsl:attribute>
                    <xsl:attribute name="code">
                        <xsl:value-of select="$ccrCodedDescription/a:Code/a:Value"/>
                    </xsl:attribute>
                    <xsl:attribute name="codeSystemName">
                        <xsl:value-of select="$ccrCodedDescription/a:Code/a:CodingSystem"/>
                    </xsl:attribute>
                    <xsl:attribute name="codeSystem">
                        <xsl:call-template name="HL7OIDLookup">
                            <xsl:with-param name="name" select="$ccrCodedDescription/a:Code/a:CodingSystem"/>
                        </xsl:call-template>
                    </xsl:attribute>
                </xsl:when>
                <xsl:when test="$domain">
                    <xsl:variable name="cdaCode">
                        <xsl:call-template name="CDAVocabularyLookup">
                            <xsl:with-param name="domain" select="$domain"/>
                            <xsl:with-param name="ccrtext" select="$ccrCodedDescription/a:Text"/>
                        </xsl:call-template>
                    </xsl:variable>
                    <xsl:attribute name="displayName">
                        <xsl:call-template name="CDADisplayNameLookup">
                            <xsl:with-param name="domain" select="$domain"/>
                            <xsl:with-param name="cdacode" select="$cdaCode"/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <xsl:attribute name="code">
                        <xsl:value-of select="$cdaCode"></xsl:value-of>
                    </xsl:attribute>
                    <xsl:attribute name="codeSystemName">
                        <xsl:call-template name="CDAVocabularyCodeSystemNameLookup">
                            <xsl:with-param name="domain" select="$domain"/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <xsl:attribute name="codeSystemName">
                        <xsl:call-template name="CDAVocabularyCodeSystemLookup">
                            <xsl:with-param name="domain" select="$domain"/>
                        </xsl:call-template>
                    </xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <originalText>
                        <xsl:value-of select="$ccrCodedDescription/a:Text"/>
                        <xsl:if test="$originalTextReference">
                            <reference>
                                <xsl:attribute name="value">
                                    <xsl:value-of select="$originalTextReference"/>
                                </xsl:attribute>
                            </reference>
                        </xsl:if>
                    </originalText>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>

    <xsl:template name="ccdDateTime">
        <xsl:param name="dt"/>
        <xsl:param name="type"/>
        <xsl:if test="$dt">
            <xsl:if test="$dt[1]/a:ExactDateTime">
                <effectiveTime>
                    <xsl:if test="$type">
                        <xsl:attribute name="xsi:type">
                            <xsl:value-of select="$type"></xsl:value-of>
                        </xsl:attribute>
                    </xsl:if>
                    <low>
                        <xsl:attribute name="value">
                            <xsl:call-template name="date:format-date">
                                <xsl:with-param name="date-time" select="$dt[1]/a:ExactDateTime"/>
                                <xsl:with-param name="pattern">yyyyMMdd</xsl:with-param>
                            </xsl:call-template>
                        </xsl:attribute>
                    </low>
                    <high nullFlavor="UNK"/>
                </effectiveTime>
            </xsl:if>
            <xsl:if test="$dt[1]/a:DateTimeRange">
                <effectiveTime>
                    <low>
                        <xsl:attribute name="value">
                            <xsl:call-template name="date:format-date">
                                <xsl:with-param name="date-time" select="$dt[1]/a:DateTimeRange/a:BeginRange/a:ExactDateTime"/>
                                <xsl:with-param name="pattern">yyyyMMdd</xsl:with-param>
                            </xsl:call-template>
                        </xsl:attribute>
                    </low>
                    <high>
                        <xsl:attribute name="value">
                            <xsl:call-template name="date:format-date">
                                <xsl:with-param name="date-time" select="$dt[1]/a:DateTimeRange/a:EndRange/a:ExactDateTime"/>
                                <xsl:with-param name="pattern">yyyyMMdd</xsl:with-param>
                            </xsl:call-template>
                        </xsl:attribute>
                    </high>
                </effectiveTime>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <xsl:template name="ccdMedicationFrequency">
        <xsl:param name="frequency"/>
        <xsl:if test="$frequency">
            <xsl:choose>
                <xsl:when test="$frequency/a:Value='qd'">
                    <effectiveTime xsi:type="PIVL_TS" operator="A">
                        <xsl:attribute name="institutionSpecified">true</xsl:attribute>
                        <period>
                            <xsl:attribute name="value">24</xsl:attribute>
                            <xsl:attribute name="unit">h</xsl:attribute>
                        </period>
                    </effectiveTime>
                </xsl:when>
                <xsl:when test="$frequency/a:Value='bid'">
                    <effectiveTime xsi:type="PIVL_TS" operator="A">
                        <xsl:attribute name="institutionSpecified">true</xsl:attribute>
                        <period>
                            <xsl:attribute name="value">12</xsl:attribute>
                            <xsl:attribute name="unit">h</xsl:attribute>
                        </period>
                    </effectiveTime>
                </xsl:when>
                <xsl:when test="$frequency/a:Value='tid'">
                    <effectiveTime xsi:type="PIVL_TS" operator="A">
                        <xsl:attribute name="institutionSpecified">true</xsl:attribute>
                        <period>
                            <xsl:attribute name="value">8</xsl:attribute>
                            <xsl:attribute name="unit">h</xsl:attribute>
                        </period>
                    </effectiveTime>
                </xsl:when>
                <xsl:when test="$frequency/a:Value='qid'">
                    <effectiveTime xsi:type="PIVL_TS" operator="A">
                        <xsl:attribute name="institutionSpecified">true</xsl:attribute>
                        <period>
                            <xsl:attribute name="value">6</xsl:attribute>
                            <xsl:attribute name="unit">h</xsl:attribute>
                        </period>
                    </effectiveTime>
                </xsl:when>
                <xsl:when test="$frequency/a:Value='qam'">
                    <effectiveTime xsi:type='EIVL' operator='A'>
                        <event code='ACM'/>
                    </effectiveTime>
                </xsl:when>
                <xsl:when test="$frequency/a:Value='qpm'">
                    <effectiveTime xsi:type='EIVL' operator='A'>
                        <event code='PCV'/>
                    </effectiveTime>
                </xsl:when>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

    <xsl:template name="ccdStatus">
        <xsl:param name="ccrStatus"/>

        <entryRelationship typeCode="REFR">
            <observation classCode="OBS" moodCode="EVN">
                <templateId root="2.16.840.1.113883.10.20.1.50"/>
                <!-- Problem status observation template -->
                <code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
                <statusCode code="completed"/>
                <xsl:call-template name="ccdCodedValue">
                    <xsl:with-param name="ccrCodedDescription" select="$ccrStatus"/>
                </xsl:call-template>
            </observation>
        </entryRelationship>
    </xsl:template>

    <xsl:template name="ccdStatusObservation">
        <xsl:param name="status"/>
        <xsl:variable name="statusText" select="$status/a:Text"></xsl:variable>
        <xsl:choose>
            <xsl:when test="$statusText='Active'">
                <xsl:call-template name="ccdStatusElement">
                    <xsl:with-param name="statusCode" select="'55561003'"/>
                    <xsl:with-param name="statusDisplayName" select="$statusText"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$statusText='Inactive'">
                <xsl:call-template name="ccdStatusElement">
                    <xsl:with-param name="statusCode" select="'73425007'"/>
                    <xsl:with-param name="statusDisplayName" select="$statusText"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$statusText='Chronic'">
                <xsl:call-template name="ccdStatusElement">
                    <xsl:with-param name="statusCode" select="'90734009'"/>
                    <xsl:with-param name="statusDisplayName" select="$statusText"/>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="ccdStatusProcedure">
        <xsl:param name="status"/>
        <xsl:variable name="statusText" select="$status/a:Text"></xsl:variable>
        <xsl:choose>
            <xsl:when test="$statusText='Completed'">
                <statusCode code="completed"/>
            </xsl:when>
            <xsl:when test="$statusText='Active'">
                <statusCode code="active"/>
            </xsl:when>
            <xsl:when test="$statusText='Aborted'">
                <statusCode code="aborted"/>
            </xsl:when>
            <xsl:when test="$statusText='Cancelled' or $statusText='Canceled'">
                <statusCode code="cancelled"/>
            </xsl:when>
            <xsl:otherwise>
                <statusCode>
                    <xsl:attribute name="code">
                        <xsl:value-of select="$statusText"></xsl:value-of>
                    </xsl:attribute>
                </statusCode>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="ccdStatusElement">
        <xsl:param name="statusCode"/>
        <xsl:param name="statusDisplayName"/>
        <value>
            <xsl:attribute name="xsi:type">CE</xsl:attribute>
            <xsl:attribute name="code">
                <xsl:value-of select="$statusCode"></xsl:value-of>
            </xsl:attribute>
            <xsl:attribute name="codeSystem">2.16.840.1.113883.6.96</xsl:attribute>
            <xsl:attribute name="displayName">
                <xsl:value-of select="$statusDisplayName"></xsl:value-of>
            </xsl:attribute>
        </value>
    </xsl:template>

    <xsl:template name="ccdObservation">
        <xsl:param name="ccrTestNode"/>
        <xsl:param name="testDate"/>

        <component>
            <observation classCode="OBS" moodCode="EVN">
                <templateId root="2.16.840.1.113883.3.88.11.83.15" assigningAuthorityName="HITSP C83"/>
                <templateId root="2.16.840.1.113883.10.20.1.31" assigningAuthorityName="CCD"/>
                <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.13" assigningAuthorityName="IHE PCC"/>

                <!-- Result observation template -->

                <xsl:call-template name="ccdID">
                    <xsl:with-param name="ccrObjectID" select="$ccrTestNode/a:CCRDataObjectID"/>
                </xsl:call-template>

                <!-- <code> -->
                <xsl:call-template name="ccdCodedValue">
                    <xsl:with-param name="ccrCodedDescription" select="$ccrTestNode/a:Description"/>
                    <xsl:with-param name="nodeName" select="'code'"/>
                </xsl:call-template>

                <text>
                    <reference>
                        <xsl:attribute name="value">
                            <xsl:text>#</xsl:text>
                            <xsl:value-of select="$ccrTestNode/a:CCRDataObjectID"/>
                        </xsl:attribute>
                    </reference>
                </text>

                <statusCode code="completed"/>

                <!-- <effectiveTime> -->
                <xsl:choose>
                    <xsl:when test="$ccrTestNode/a:DateTime">
                        <xsl:call-template name="ccdDateTime">
                            <xsl:with-param name="dt" select="$ccrTestNode/a:DateTime"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="ccdDateTime">
                            <xsl:with-param name="dt" select="$testDate"/>
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>

                <xsl:choose>
                    <xsl:when test="$ccrTestNode/a:TestResult[a:Value!='']">
                        <value xsi:type="PQ">
                            <xsl:attribute name="value">
                                <xsl:value-of select="$ccrTestNode/a:TestResult/a:Value"/>
                            </xsl:attribute>
                            <xsl:attribute name="unit">
                                <xsl:value-of select="$ccrTestNode/a:TestResult/a:Units/a:Unit"/>
                            </xsl:attribute>
                        </value>
                    </xsl:when>
                    <xsl:when test="$ccrTestNode/a:TestResult[a:Description/a:Text!='']">
                        <value xsi:type="TX">
                            <xsl:attribute name="value">
                                <xsl:value-of select="$ccrTestNode/a:TestResult/a:Description/a:Text"/>
                            </xsl:attribute>
                        </value>
                    </xsl:when>
                </xsl:choose>

                <xsl:if test="$ccrTestNode/a:Flag">
                    <xsl:call-template name="ccdCodedValue">
                        <xsl:with-param name="ccrCodedDescription" select="$ccrTestNode/a:Flag"/>
                        <xsl:with-param name="nodeName" select="'interpretationCode'"/>
                        <xsl:with-param name="domain" select="'ObservationInterpretation'"/>
                    </xsl:call-template>
                </xsl:if>

                <xsl:if test="$ccrTestNode/a:NormalResult">
                    <referenceRange>
                        <xsl:if test="$ccrTestNode/a:NormalResult/a:Normal/a:Description/a:Text">
                            <observationRange>
                                <text>
                                    <xsl:value-of select="$ccrTestNode/a:NormalResult/a:Normal/a:Description/a:Text"/>
                                </text>
                            </observationRange>
                        </xsl:if>
                    </referenceRange>
                </xsl:if>

            </observation>
        </component>

    </xsl:template>
</xsl:stylesheet>
