                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:VitalSigns">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.16"/>
                                <code code="8716-3" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Vital Signs</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Vital Sign</th>
                                                <th>Date</th>
                                                <th>Result</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:VitalSigns/a:Result">
                                                <tr>
                                                    <xsl:attribute name="id">
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                    </xsl:attribute>

                                                    <td>
                                                        <xsl:value-of select="a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time" select="a:DateTime/a:ExactDateTime"/>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Test">
                                                            <xsl:value-of select="a:Description/a:Text"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:TestResult/a:Value"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:TestResult/a:Units/a:Unit"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:Flag/a:Text"/>
                                                            <br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:VitalSigns/a:Result">
                                    <entry typeCode="DRIV">
                                        <organizer classCode="CLUSTER" moodCode="EVN">
                                            <templateId root="2.16.840.1.113883.10.20.1.32" assigningAuthorityName="CCD"/>
                                            <templateId root="2.16.840.1.113883.10.20.1.35" assigningAuthorityName="CCD"/>
                                            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.13.1" assigningAuthorityName="IHE PCC"/>
                                            <!-- Vital signs organizer template -->

                                            <xsl:variable name="testDate" select="a:DateTime"/>

                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                            </xsl:call-template>

                                            <code code="46680005" codeSystem="2.16.840.1.113883.6.96" displayName="Vital signs" codeSystemName="SNOMED CT"/>
                                            <statusCode code="completed"/>
                                            <xsl:call-template name="ccdDateTime">
                                                <xsl:with-param name="dt" select="$testDate"/>
                                            </xsl:call-template>

                                            <xsl:call-template name="ccdObservation">
                                                <xsl:with-param name="ccrTestNode" select="a:Test[1]"/>
                                                <xsl:with-param name="testDate" select="$testDate"/>
                                            </xsl:call-template>

                                        </organizer>
                                    </entry>
                                </xsl:for-each>
                            </section>
                        </component>
                    </xsl:if>
