                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:FamilyHistory">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.4"/>
                                <code code="10157-6" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Family History</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Code</th>
                                                <th>Description</th>
                                                <th>Relationship(s)</th>
                                                <th>Status</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:FamilyHistory/a:FamilyProblemHistory">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time" select="a:DateTime/a:ExactDateTime"/>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:apply-templates select="a:Problem/a:Description/a:Code"/>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Problem">
                                                            <xsl:value-of select="a:Description/a:Text"/>
                                                            <br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:FamilyMember/a:ActorRole/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Status/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                            </section>
                        </component>
                    </xsl:if>
