                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Immunizations">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.6"/>
                                <code code="11369-6" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Immunizations</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Code</th>
                                                <th>Vaccine</th>
                                                <th>Date</th>
                                                <th>Route</th>
                                                <th>Site</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Immunizations/a:Immunization">
                                                <tr>
                                                    <xsl:attribute name="id">
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                    </xsl:attribute>
                                                    <td>
                                                        <xsl:apply-templates select="a:Product/a:ProductName/a:Code"/>
                                                    </td>
                                                    <td>

                                                        <xsl:value-of select="a:Product/a:ProductName/a:Text"/>
                                                        <xsl:if test="a:Product/a:Form">
                                                            <xsl:text xml:space="preserve"> </xsl:text>(<xsl:value-of select="a:Product/a:Form/a:Text"/>)
                                                        </xsl:if>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time" select="a:DateTime/a:ExactDateTime"/>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Directions/a:Direction/a:Route/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:attribute name="id">
                                                            <xsl:value-of select="a:CCRDataObjectID"/>
                                                            <xsl:text>:Site</xsl:text>
                                                        </xsl:attribute>

                                                        <xsl:value-of select="a:Directions/a:Direction/a:Site/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Immunizations/a:Immunization">
                                    <entry typeCode="DRIV">
                                        <substanceAdministration classCode="SBADM" moodCode="EVN">
                                            <templateId root="2.16.840.1.113883.10.20.1.24" assigningAuthorityName="CCD"/>
                                            <templateId root="2.16.840.1.113883.3.88.11.83.13" assigningAuthorityName="HITSP C83"/>
                                            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.12" assigningAuthorityName="IHE PCC"/>

                                            <!-- Medication activity template -->

                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                            </xsl:call-template>

                                            <code code="IMMUNIZ" codeSystem="2.16.840.1.113883.5.4" codeSystemName="HL7 ActCode"/>
                                            <text>
                                                <reference>
                                                    <xsl:attribute name="value">
                                                        <xsl:text>#</xsl:text>
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                    </xsl:attribute>
                                                </reference>
                                            </text>

                                            <statusCode code='completed'/>

                                            <xsl:call-template name="ccdDateTime">
                                                <xsl:with-param name="dt" select="a:DateTime"/>
                                                <xsl:with-param name="type" select="'IVL_TS'"/>
                                            </xsl:call-template>

                                            <xsl:call-template name="ccdCodedValue">
                                                <xsl:with-param name="ccrCodedDescription" select="a:Directions/a:Direction/a:Route"/>
                                                <xsl:with-param name="nodeName" select="'routeCode'"/>
                                                <xsl:with-param name="domain" select="'RouteOfAdministration'"/>
                                            </xsl:call-template>

                                            <xsl:if test="a:Directions/a:Direction/a:Site">
                                                <xsl:call-template name="ccdCodedValue">
                                                    <xsl:with-param name="ccrCodedDescription" select="a:Directions/a:Direction/a:Site"/>
                                                    <xsl:with-param name="nodeName" select="'approachSiteCode'"/>
                                                    <xsl:with-param name="originalTextReference">
                                                        <xsl:text>#</xsl:text>
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                        <xsl:text>:Site</xsl:text>
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:if>

                                            <consumable>
                                                <manufacturedProduct>
                                                    <templateId root="2.16.840.1.113883.3.88.11.83.8.2" assigningAuthorityName="HITSP C83"/>
                                                    <templateId root="2.16.840.1.113883.10.20.1.53" assigningAuthorityName="CCD"/>
                                                    <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.7.2" assigningAuthorityName="IHE PCC"/>

                                                    <!-- Product template -->

                                                    <manufacturedMaterial>
                                                        <xsl:call-template name="ccdCodedValue">
                                                            <xsl:with-param name="ccrCodedDescription" select="a:Product/a:ProductName"/>
                                                            <xsl:with-param name="nodeName" select="'code'"/>
                                                        </xsl:call-template>
                                                        <name>
                                                            <xsl:value-of select="a:Product/a:BrandName/a:Text"/>
                                                        </name>
                                                    </manufacturedMaterial>
                                                </manufacturedProduct>
                                            </consumable>

                                        </substanceAdministration>
                                    </entry>
                                </xsl:for-each>
                            </section>
                        </component>
                    </xsl:if>
