<?xml version="1.0" encoding="UTF-8"?>
<!--
Conversion of CCR to Level 3 CCD

Orginal Author:   	Ken Miller
Solventus LLC
ken.miller@solventus.coms

Contributors:
Richard Braman, EHR Doctors, Inc rbraman@ehrdoctors.com
George Lilly (WorldVistA glilly@glilly.net)
Nancy Antracite, WorldVistA
xxxx - Oroville Hospital

Date: 	2010-05-5
Version: 	0.1

License :

        This program is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program.  If not, see http://www.gnu.org/licenses.

-->
<xsl:stylesheet version="1.0" xmlns="urn:hl7-org:v3" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:a="urn:astm-org:CCR" xmlns:date="http://exslt.org/dates-and-times"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="a date">
    <xsl:import href="./templates/cdavocablookup.xsl"/>
    <xsl:import href="./templates/hl7oidlookup.xsl"/>
    <xsl:import href="./templates/code.xsl"/>
    <xsl:import href="./templates/actor.xsl"/>
    <xsl:import href="./templates/datetime.xsl"/>
    <xsl:import href="./templates/problemDescription.xsl"/>

    <xsl:output method="xml" encoding="utf-8" version="1.0" indent="yes"/>
    <xsl:template match="/">
<!--WV Added new munltiple documentation of added have to do with encounter times, etc.-->

<!--
********************************************************
CDA Header
********************************************************
-->

<!--
******************
Document Information
**********************
-->
<ClinicalDocument xmlns="urn:hl7-org:v3" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:hl7-org:v3 CDA.xsd">
	<!-- Created with XML Copy Editor  Open Source Sourceforge project. -->
<!--WVP This is the clinical document type ID-->
  <realmCode code="US"/>
	<typeId root="2.16.840.1.113883.1.3" extension="POCD_HD000040"/>
	<!-- QRDA Category I generic template ID. -->
	<!--WVP these next two lines are fixed-->
	<templateId root="2.16.840.1.113883.10.20.12" />
	<!--only in the july spec so not sure if it should be here-->
	<templateId root="2.16.840.1.113883.3.249.11.100.1"/>
	<!--WVV 2.16.840.1.113883.3.543 is fixed and is the beginninng of WorldVistAs OID, change the extension for a new document and the version for changes to this one-->
	<id>
                <xsl:attribute name="root">
                    <xsl:value-of select="/a:ContinuityOfCareRecord/a:CCRDocumentObjectID"></xsl:value-of>
                </xsl:attribute>
            </id>
		 <!--WVP next two lines fixed-->
	<code code="55182-0" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Quality Measure Report"/>
	<title>QRDA Incidence Report</title>
		<!--WVV time-->
	<effectiveTime value="20100703"/>
		<!--WVP for next two lines-->
  <confidentialityCode codeSystem="2.16.840.1.113883.5.25" code="N"/>
  <languageCode code="en-US"/>
  <!--WV? Don't change this in the document set we are working on-->
  <setId root="2.16.840.1.113883.3.543" extension="01.01.01.100000001"/>
	 <versionNumber value="1"/>
  <!--WVP  I made one up but we will have to have an OID for the Clincal Document SET which we will make up for ourselves eventually-->
  
 <!--
 *******************
 Patient Information
 ****************
 -->
	<!-- This is the patient for which the report is describing. -->
	<recordTarget>
<patientRole>
                <xsl:call-template name="ccdPatientRole">
                    <xsl:with-param name="ccrActorObjectID" select="/a:ContinuityOfCareRecord/a:Patient[1]/a:ActorID"/>
                </xsl:call-template>
                </patientRole>
	</recordTarget>

<!--
*****************************
Author
**************
-->
	<!-- This example assumes the doctor is creating the report and it is Required.  -->
	<author>
	  <!--WVV Edit time has to be precise at least to the day-->
		<time value="20100703" />
		<assignedAuthor>
		  <!--WVP eventually id this is required, the root is fixed -->
		  <!--andn the extension is the SOFTWARE version number assigned by CMS to WV EHR-->
			<id root="2.16.840.1.113883.3.249.6" extension="100001" />
			<!--WVVassignedPerson not required-->
			<assignedPerson>
				<name>
				  <!--WV Edit-->
					<given>Nancy</given>
					<family>Anthracite</family>
					<suffix>MD</suffix>
				</name>
			</assignedPerson>
			<representedOrganization>
			  <!--WV? id root is OID for the organization so I made one up for this document set-->
				<id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>WorldVistA Test Clinic</name>
			</representedOrganization>
		</assignedAuthor>
	</author>
		<!-- The reporting healthcare facility is represented using the CCD "Source of Information" construct, via the Informant participant. -->
	<informant>
	   <assignedEntity>
      <!--WV this null flavor is required as is-->
			<id nullFlavor="NA"/>
			<representedOrganization>
				<!--WV root is the OID of the organization.  ID is required but name is not and id is OID stated earlier-->
        <id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>World VistA Test Clinic</name>
			</representedOrganization>
		</assignedEntity>
	</informant>

	<!-- This example assumes that the institution responsible for the data is serving as custodian. -->
	<!--WV This element is required as is the sSD which is not stated if it is an OID but assumed it is-->
	<!--WV Name is not required, only ID is required.-->
	<custodian>
		<assignedCustodian>
			<representedCustodianOrganization>
				<id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>WorldVistA Test Clinic</name>
			</representedCustodianOrganization>
		</assignedCustodian>
	</custodian>

	<!-- In this example, the author is also serving as legal authenticator. -->
	<!--WV section is this is not required-->
<legalAuthenticator>
		<time value="20100703" />
		<!--WV the signature code of S is required-->
		<signatureCode code="S" />
		<assignedEntity>
      <!--WV document does not specify the requirements of the id but it is required-->
      <!--WVP and the sample suggests it is the number below and extension is ???-->
			<id root="2.16.840.1.113883.3.543" extension="111111" />
			<assignedPerson>
				<name>
					<given>Nancy</given>
					<family>Anthracite</family>
					<suffix>MD</suffix>
				</name>
			</assignedPerson>
			<representedOrganization>
			  <!--WV? and is fixed for the WorldVistA Test Clinic in this submitted document series-->
				<id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>WorldVistA Test Clinic</name>
			</representedOrganization>
		</assignedEntity>
	</legalAuthenticator>
	
	
	
	<!--Added to sample as it is new since 2008-->
	<!--WVP permanent for participant in the primary care provider participant-->
<!--WVP performer type codes are numerous but PRF is performer or the person who did it-->
	<participant typeCode="PRF">
	  <!--WVP required as is for function-->
	  <!-- WVP I believe PCP is primary care provider but not sure-->
	  <functionCode code="PCP" codeSystem="2.16.840.1.113883.5.88"/>
	  <!--WVP Associated Entity is required ti be there with this PROV-->
	  <associatedEntity classCode="PROV">
	    <!--WV? OID of the provider fixed for this series of documents-->
	    <id root="2.16.840.1.113883.3.249.6" extension="111111" />
	    <!--WV associated person is not required so presumabley the code will suffice not sure??-->
	    <associatedPerson>
	      <name>
	        <prefix>Dr.</prefix>
	        <given>Nancy</given>
	        <family>Anthracite</family>
        </name>
	    </associatedPerson>
    </associatedEntity>
	</participant>
	
	<!--The service event is the encounter that describes tehe encunter as well as the provider, location and time-->
	<!--!There can be one or more documentation elements depending on the number of encounters during the reporting period-->
	<!--WVV IMPORTANT!! The encounter codeds are recorded here-->
	<!-- They are in appendix B of the downloadable resource document-->
	<!-- Each documentation of is a single service event-->
	
<!--Occurence of Measures episode documention-->
<!--Like an encounter section only for QRDA-->
<!--Same doctor, same clinic, different date and different enconter code-->
	
	
	<!--First Visit documentationOf section-->
<!--DOCUMENTATIONOFSECTION-->

	<!-- 
********************************************************
CDA Body
********************************************************
-->
 <component>
 	<structuredBody>
  	<!-- 
	  ********************************************************
     Measure Set Section
	  ********************************************************
     -->
 	    <component>
        <section>
        <!-- WVP QRDA Category I measure-specific template ID for 2010 #1. -->
        <!--WP Next 3 lines do not change during the reporting period, for the measures section-->
        <templateId root="2.16.840.1.113883.3.249.11.50" />
        <code code="55185-3" codeSystem="2.16.840.1.113883.6.1" />
        <title>Measure set: CMS EHR Measure Set</title>
         <text>2010 Measures Set Measures</text>
          <!--
                ***************************************************
                Measure Section
                ***************************************************
                -->
           <component>
            <section>
              <!--template ID for each measure being reported-->
              <templateId root="2.16.840.1.113883.3.249.11.2" />
              <templateId root="2.16.840.1.113883.3.249.11.3" />
              <templateId root="2.16.840.1.113883.3.249.11.4" />
              <templateId root="2.16.840.1.113883.3.249.11.5" />
              <templateId root="2.16.840.1.113883.3.249.11.6" />
              <templateId root="2.16.840.1.113883.3.249.11.7" />
              <templateId root="2.16.840.1.113883.3.249.11.8" />
              <templateId root="2.16.840.1.113883.3.249.11.9" />
              <templateId root="2.16.840.1.113883.3.249.11.10" />
              <templateId root="2.16.840.1.113883.3.249.11.11" />
              <templateId root="2.16.840.1.113883.3.249.11.15" />
             <!--New for 2011--> 
              <templateId root="2.16.840.1.113883.3.249.11.51" />
              <templateId root="2.16.840.1.113883.3.249.11.52" />
              <templateId root="2.16.840.1.113883.3.249.11.53" />
              <templateId root="2.16.840.1.113883.3.249.11.54" />
              <templateId root="2.16.840.1.113883.3.249.11.55" />
              <templateId root="2.16.840.1.113883.3.249.11.56" />
              <templateId root="2.16.840.1.113883.3.249.11.57" />
              <templateId root="2.16.840.1.113883.3.249.11.58" />
              <templateId root="2.16.840.1.113883.3.249.11.59" />
              <templateId root="2.16.840.1.113883.3.249.11.60" />
              <code code="55186-1" codeSystem="2.16.840.1.113883.6.1" />
        
              <title>Measure Section</title>
              <!--Here is where the HTML begins for the above and it is optional-->
              <text>
                <list>
                  <item>CMS Measure #1: Diabetes Mellitus: Hemoglobin A1c Poor Control in Diabetes Mellitus</item>
                  <item>CMS Measure #2: Diabetes Mellitus: Low Density Lipoprotein (LDL-C) Control in Diabetes Mellitus</item>
                  <item>CMS Measure #3: Diabetes Mellitus: High Blood Pressure Control in Diabetes Mellitus</item>
                  <item>CMS Measure #5: Heart Failure: Angiotensin-Converting Enzyme (ACE) Inhibitor or Angiotensin Receptor Blocker (ARB) Therapy for Left Ventricular Systolic Dysfunction (LVSD)</item>
                  <item>CMS Measure #7: Coronary Artery Disease (CAD): Beta-Blocker Therapy for CAD Patients with Prior Myocardial Infarction (MI)</item>
                  <item>CMS Measure #110: Preventive Care and Screening: Influenza Immunization for Patients >= 50 Years</item>
                  <item>CMS Measure #111: Preventive Care and Screening: Pneumonia Vaccination for Patients 65 Years and Older</item>
                  <item>CMS Measure #112: Preventive Care and Screening: Screening Mammography</item>
                  <item>CMS Measure #113: Preventive Care and Screening: Colorectal Cancer Screening</item>
                  <item>CMS Measure #124: Health Information Technology (HIT): Adoption/Use of Electronic Health Records (EHR)</item>
                  <item>CMS Measure eRx:Adoption/Use of Medication Electronic Prescribing Measure</item>
                  <!--added 2011 measures-->
                  <item>CMS Measure #39: Screening or Therapy for Osteoporosis for Women Aged 65 Years and Older</item>
                  <item>CMS Measure #47: Advance Care Plan </item>
                  <item>CMS Measure #48: Urinary Incontinence: Assessment of Presence or Absence of Urinary Incontinence in Women Aged 65 Years and Older</item>
                  <item>CMS Measure #128: Preventive Care and Screening: Body Mass Index (BMI) Screening and Follow-Up </item>
		  <item>CMS Measure #173: Preventive Care and Screening: Unhealthy Alcohol Use - Screening</item>
		  <item>CMS Measure #0013: Hypertension (HTN): Blood Pressure Measurement - QRDA Cat I template </item>
		  <item>CMS Measure #0022: Drugs to be avoided in the Elderly </item>
		  <item>CMS Measure #0024: Body Mass Index (BMI) 2 through 18 years of age </item>
		  <item>CMS Measure #0028: Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention</item>
		  <item>CMS Measure #0038: Childhood Immunization Status - QRDA Cat I template</item>
                </list>
              </text>
              <!--Begin listing of acts-->
             <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  
                  <code code="PQRI-1" codeSystem="2.16.840.1.113883.3.249.12" displayName="Hemoglobin A1c Poor Control in Diabetes Mellitus"/>
                  <text>Percentage of patients 18 through 75 years with diabetes mellitus who had most recent hemoglobin A1C greater than 9.0%</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  
                  <code code="PQRI-2" codeSystem="2.16.840.1.113883.3.249.12" displayName="Low Density Lipoprotein (LDL-C) Control in Diabetes Mellitus"/>
                  <text>Percentage of patients 18 through 75 years with diabetes mellitus who had most recent LDL-C level in control (less than 100 mg./dL)</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                
                  <code code="PQRI-3" codeSystem="2.16.840.1.113883.3.249.12" displayName="Hemoglobin A1c Poor Control in Diabetes Mellitus"/>
                  <text>Percentage of patients 18 through 75 years with diabetes mellitus who had most recent blood pressure in control (less than 140/80 mmHg)</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  
                  <code code="PQRI-5" codeSystem="2.16.840.1.113883.3.249.12" displayName="Heart Failure: Angiotensin-Converting Enzyme (ACE) Inhibitor or Angiotensin Receptor Blocker (ARB) Therapy for Left Ventricular Systolic Dysfunction (LVSD)"/>
                  <text>Percentage of patients 18 years and older with a diagnosis of heart frilure and LVSD who were prescribed ACE inhibitor or ARB therapy</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  
                  <code code="PQRI-7" codeSystem="2.16.840.1.113883.3.249.12" displayName="Beta-Blocker Therapy for CAD Patients with Prior Myocardial Infarction"/>
                  <text>Percentage of patients 18 aged 18 years and older wit a diagnosis of CAD and prior MI who were prescribed beta-blocker therapy</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  
                  <code code="PQRI-110" codeSystem="2.16.840.1.113883.3.249.12" displayName="Influenza Immunization for Patients >= 50 Years"/>
                  <text>Percentage of patients aged 50 years and older who received an influenza immunization during the flu season (September through February)</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                 
                  <code code="PQRI-111" codeSystem="2.16.840.1.113883.3.249.12" displayName="Pneumonia Vaccination for Patients 65 Years and Older"/>
                  <text>Percentage of patients afed 65 years and older who have ever received a pneumoccal vaccine</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                
                  <code code="PQRI-112" codeSystem="2.16.840.1.113883.3.249.12" displayName="Screening Mammography"/>
                  <text>Percentage of womaen aged 40 through 69 years who had a mammogram to screen for breast cancer within 24 months</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                 
                  <code code="PQRI-113" codeSystem="2.16.840.1.113883.3.249.12" displayName="Colorectal Cancer Screening"/>
                  <text>Percentage of patients aged 50 through 80 who received the appropriate colorectal cancer screening</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  
                  <code code="PQRI-124" codeSystem="2.16.840.1.113883.3.249.12" displayName="Adoption/Use of Electronic Health Records (EHR)"/>
                  <text>Documents whether provider has adopted and is using health information technology. To qualify, the provider must havea adopted and be using a certified/qualified electronic health record (EHR)</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  
                  <code code="eRx" codeSystem="2.16.840.1.113883.3.249.12" displayName="Adoption/Use of Medication Electronic Prescribing Measure"/>
                  <text>Documents whether provider has adopted and is using ePrescribing</text>
                  <statusCode code="completed"/>
                </act>
                </entry>
                
 <!--******************************************
               Begin 2011 measures
 ********************************************-->
                <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  
                  <code code="PQRI-39" codeSystem="2.16.840.1.113883.3.249.12" displayName="Screening or Therapy for Osteoporosis for Women Aged 65 Years and Older"/>
                  <text>Percentage of patients who had a DXA measurement ordered or performed at least once since age 60 or pharmacologic therapy prescribed within 12 months before the end of the measurement period</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  
                  <code code="PQRI-47" codeSystem="2.16.840.1.113883.3.249.12" displayName="Advance Care Plan"/>
                  <text>Percentage of patients age 65 and older who have an advanced care plan or surrogate decision maker documented in the medical record or documented in the medical record that an advance care plan was discussed but the patient did not wish or was not able to name a surrogate decision maker or provide an advance care plan.</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                
                  <code code="PQRI-48" codeSystem="2.16.840.1.113883.3.249.12" displayName="Urinary Incontinence: Assessment of Presence or Absence of Urinary Incontinence in Women Aged 65 Years and Older"/>
                  <text>Percentage of patients equal to or older than 65 years of age at the beginning of the measurement perion who were assesed for the presence or absence of urinary incontinence within 12 months.</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  
                  <code code="PQRI-128" codeSystem="2.16.840.1.113883.3.249.12" displayName="Preventive Care and Screening: Body Mass Index (BMI) Screening and Follow-Up"/>
                  <text>Percentage of patients aged 18 yesrs and older with a calculate BMI in the past 6 months or during the current visit documented in the medical record and if the most recent BMI is ourtide parameters, a follow-up plan is documented. Ages 65 and older BMI equal to or greater than 30 or less than 22 and ages 18-64, BMI greater than or equal to 25 or less than 18.5</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  
                  <code code="PQRI-173" codeSystem="2.16.840.1.113883.3.249.12" displayName="Preventive Care and Screening: Unhealthy Alcohol Use - Screening"/>
                  <text>Percentage of patients aged 18 years and older who were screened for unhealthy alcohol use using a systematic method within 24 months</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  
                  <code code="PQRI-13" codeSystem="2.16.840.1.113883.3.249.12" displayName="Hypertension (HTN): Blood Pressure Measurement"/>
                  <text>Percentage of patients aged 18 years and older with a diagnosis of hypertension in the beginning of the measurement period with a blood pressure recoreded.</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                 
                  <code code="PQRI-22" codeSystem="2.16.840.1.113883.3.249.12" displayName="Drugs to be avoided in the elderly"/>
                  <text>Percentage of patients aged 65 years and older who received at least one drug to be acoided in the elderly and/or two different drugs to be avoided in the elderly in the measurement period</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                
                  <code code="PQRI-24" codeSystem="2.16.840.1.113883.3.249.12" displayName="BMI age 2-18 years of age"/>
                  <text>Percentage of children 2-18 years of age at the beginning of the measurement period whose weight is classified based on BMI percentile for age and gender.</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                 
                  <code code="PQRI-28" codeSystem="2.16.840.1.113883.3.249.12" displayName="Preventive care and Screening: Tobacco Use: Screening and Cessation Intervention"/>
                  <text>Percentage of patients aged 18 years of older who were screened about tobacco use at least once during the two year measurement preoid AND who received cessation counseling if identified as a tobacco user.</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  
                  <code code="PQRI-38" codeSystem="2.16.840.1.113883.3.249.12" displayName="Childhood immumnization status"/>
                  <text>Percentage of children who turn two years of age during the measurement period who have had four DTaP/DT, three IPV, one MMR and three H influenza type B, three hepatitis B, one chicken pox vaccine (VZV) and four pneumococcal conjugate vaccines by their second birthday</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  
                  <code code="" codeSystem="2.16.840.1.113883.3.249.12" displayName=""/>
                  <text>Documents whether provider has adopted and is using ePrescribing</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
                  <!--
                  *******************************
                  Reporting Parameters Section
                  *****************************
                   -->
              <component>
                  <section>
                      <code code="55187-9" codeSystem="2.16.840.1.113883.6.1"/>
                      <title>Reporting Parameters</title>
                      <text>
                        <list>
                          <item>Reporting Period Jan 1, 2010 to Dec 31, 2010</item>
                        </list>
                      </text>
                      <entry>
                        <act classCode="ACT" moodCode="EVN">
                        <code code="252116004" codeSystem="2.16.840.1.113883.6.96" displayName="Observation Parameters"/>
                        <effectiveTime>
                          <low value="20100101"/>
                          <high value="20101231"/>
                        </effectiveTime>
                      </act>
                    </entry>
                  </section>
                </component>
                         
        
 <!-- 
                  ********************************************************
                  Patient Data 
                  ********************************************************
                 -->
                <component>
                  <section>
                    <code code="55188-7" codeSystem="2.16.840.1.113883.6.1"/>
                    <title>Patient Data</title>
                  </section>
                </component>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Procedures">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.12"/>
                                <code code="47519-4" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Procedures</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Code</th>
                                                <th>Description</th>
                                                <th>Location</th>
                                                <th>Substance</th>
                                                <th>Method</th>
                                                <th>Position</th>
                                                <th>Site</th>
                                                <th>Status</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Procedures/a:Procedure">
                                                <tr>
                                                    <xsl:attribute name="id">
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                    </xsl:attribute>

                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <table>
                                                        <tbody>
                                                            <xsl:apply-templates select="a:DateTime"/>
                                                        </tbody>
                                                    </table>
                                                    <td>
                                                        <xsl:apply-templates select="a:Description/a:Code"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Locations/a:Location">
                                                            <xsl:value-of select="a:Description/a:Text"/>
                                                            <xsl:if test="a:Actor">
                                                                (<xsl:call-template name="actorName">
                                                                    <xsl:with-param name="objID" select="a:Actor/a:ActorID"/>
                                                                </xsl:call-template>
                                                                <xsl:if test="a:Actor/a:ActorRole/a:Text">
                                                                    <xsl:text xml:space="preserve"> - </xsl:text><xsl:value-of select="a:ActorRole/a:Text"/>)
                                                                </xsl:if>
                                                            </xsl:if>)
                                                            <xsl:if test="position() != last()">
                                                                <br/>
                                                            </xsl:if>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Substance">
                                                            <xsl:value-of select="a:Text"/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Method/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Position/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Site/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Status/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>

                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Procedures/a:Procedure">
                                    <entry typeCode="DRIV">
                                        <procedure classCode="PROC" moodCode="EVN">
                                            <templateId root="2.16.840.1.113883.3.88.11.83.17" assigningAuthorityName="HITSP C83"/>
                                            <templateId root="2.16.840.1.113883.10.20.1.29" assigningAuthorityName="CCD"/>
                                            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.19" assigningAuthorityName="IHE PCC"/>

                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                            </xsl:call-template>

                                            <!-- <code> -->
                                            <xsl:call-template name="ccdCodedValue">
                                                <xsl:with-param name="ccrCodedDescription" select="a:Description"/>
                                                <xsl:with-param name="nodeName" select="'code'"/>
                                            </xsl:call-template>

                                            <text>
                                                <reference>
                                                    <xsl:attribute name="value">
                                                        <xsl:text>#</xsl:text>
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                    </xsl:attribute>
                                                </reference>
                                            </text>

                                            <xsl:call-template name="ccdStatusProcedure">
                                                <xsl:with-param name="status" select="a:Status"/>
                                            </xsl:call-template>

                                            <xsl:call-template name="ccdDateTime">
                                                <xsl:with-param name="dt" select="a:DateTime"/>
                                            </xsl:call-template>

                                            <xsl:if test="a:Method">
                                                <xsl:call-template name="ccdCodedValue">
                                                    <xsl:with-param name="ccrCodedDescription" select="a:Method"/>
                                                    <xsl:with-param name="nodeName" select="'approachSiteCode'"/>
                                                </xsl:call-template>
                                            </xsl:if>

                                            <xsl:if test="a:Site">
                                                <xsl:call-template name="ccdCodedValue">
                                                    <xsl:with-param name="ccrCodedDescription" select="a:Site"/>
                                                    <xsl:with-param name="nodeName" select="'targetSiteCode'"/>
                                                </xsl:call-template>
                                            </xsl:if>

                                            <xsl:if test="a:Practitioners/a:Practitioner">
                                                <xsl:call-template name="ccdPerformer">
                                                    <xsl:with-param name="ccrActorReference" select="a:Practitioners/a:Practitioner[1]"/>
                                                </xsl:call-template>
                                            </xsl:if>
                                        </procedure>
                                    </entry>
                                </xsl:for-each>
                            </section>
                        </component>
                    </xsl:if>
<component>
<section>
<!--We are including only a coverage activity for Medicare here. There is also policy activity and and authorization activity that I don't think we need to report for QRDA, at least not for most reports-->
<templateId root="2.16.840.1.113883.10.20.1.9"/>
<!-- 48768-6 is payment sources and is fixed CQ-188,189,190-->
<code code="48768-6" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Payment Sources"/>
<!--CQ-191,192-->
<title>Payers</title>
<text />
<!--medicare-->
<entry typeCode="DRIV">
<!--WVP moodCode is DEF is definition to describe the characteristics of who must be involved in an act CQ-194,195-->
<act classCode="ACT" moodCode="DEF">
<!--WVP coverage activity template is the 10.20.1.20 CQ-193-->
<templateId root="2.16.840.1.113883.10.20.1.20"/>
<!--Coverage Shall Include and Act ID CQ-196-->
<!--looks like a UUID to me-->
<id root="1751b180-8a54-11df-a4ee-0800200c9c66"/><!--FIX!!!???-->
<!--CQ-197-198 It appears that statusCode="completed" need to follow the code code ... here and below-->

<!--CQ199,200-->
<code code="48768-6" codeSystem="2.16.840.1.113883.6.1" displayName="Payment sources"/>
<statusCode code="completed"/>

<!--A coverage activity shall contain on or more act/entryRelationship. The value for  act/entryRelationship/@typeCode shall be COMP which SHALL be  the CMS QRDA Policy Activity CQ-201, 203-->
<!--It MAY contain an entryRelationship/sequenceNumber CQ-202-->
<entryRelationship typeCode="COMP">
<!--  for the act is event with moodCode EVN  CQ-205,206,207-->
<act classCode="ACT" moodCode="EVN">
<!--Policy activity is the 10.20.1.26 template CQ-205-->
<templateId root="2.16.840.1.113883.10.20.1.26"/>
<templateId root="2.16.840.1.113883.3.249.11.100.7"/>

<!-- act/id which is the group or contract number related to the insurance policy or program CQ-208-->
<id root="dbbb6311-8a4d-11df-a4ee-0800200c9c66"/><!--!!!FIX-->
<!--Act statusCode must be completed CQ-210-->
<!--This SHOULD be present and comes from the downloadable resource S display name is in quotes AUTOPOL - "automobile" policy;EHCPOL additional insurance in addition to Medicare in this case
HSAPOL "Health Spending Account";PUBLICPOL "public healthcare" which is NOT Medicare - maybe a state program for example
WBCPOL is "workers compensation" CQ-211,212-->
<!--<code code="PUBLICPOL" codeSystem="2.16.840.1.113883.5.4" displayName="Public Healthcare"/>-->
<code code="PUBLICPOL" codeSystem="2.16.840.1.113883.5.4" displayName="Public Healthcare"/>
<!--WVP performer type codes are numerous but PRF is performer representing the Payer CQ-213-->
<statusCode code="completed"/>
<performer typeCode="PRF">

<!--performer/assignedEntity id is the payer identification and the extension comes from the downloadable resource section I insurance plan TYPE CQ-214-->
<assignedEntity>
<id root="2.16.840.1.113883.12.86" extension="MC"/>
<!--<representedOrganization>
<name>CMS</name>
</representedOrganization>-->
</assignedEntity>
</performer>
<!-- Act/participant @typeCode this represents the covered party CQ-215-->
<participant typeCode="COV">
<participantRole>
<!--A covered party in a policy activity SHOULD contain one or more participant/participantRole/id to represent the patien's member of subscriber identifier with respect to the payer
For participant/paricipantRole/id either the Social Security Number or HIC Number SHALL be submitted for Medicare patients. for SSN the ID @root SHALL be 2.16.840.1.113883.4.1 where
the HIC id/@root shall be 2.16.840.1.113883.3.249.13 CQ-216"RoleCode" in the downloadable resource-->
<!-- in this case theextension is the patients SSN for a medicare patient so it is the same each time for one patient-->
<id root="2.16.840.1.113883.4.1" extension="@@SSN@@"/>
<!--The covered party in tha policy activity SHOULD contain exactly one particpant/participantRole/code for self, family etc from the valuse set PolicyOrPrograCoverageRoleType 2.16.840.1.113883.1.11.19809 CQ-217,218-->
<code code="SELF" codeSystem="2.16.840.1.113883.5.111" displayName="Self"/>
</participantRole>
</participant>
</act>
</entryRelationship>
</act>
</entry>
</section>
</component>
</section>
</component>
</section>
</component>
</structuredBody>
</component>
</ClinicalDocument>
    </xsl:template>
    <xsl:template name="ccdAssignedEntity">
        <xsl:param name="ccrActorObjectID"/>

        <xsl:variable name="CCRActor" select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$ccrActorObjectID]"/>

        <assignedEntity>
            <xsl:call-template name="ccdEntityID">
                <xsl:with-param name="CCRActor" select="$CCRActor"/>
            </xsl:call-template>

            <xsl:call-template name="ccdAddress">
                <xsl:with-param name="CCRActorAddress" select="$CCRActor/a:Address"/>
            </xsl:call-template>

            <xsl:call-template name="ccdTelecom">
                <xsl:with-param name="CCRActor" select="$CCRActor"/>
            </xsl:call-template>

            <xsl:if test="$CCRActor/a:Person">
                <xsl:call-template name="ccdPerson">
                    <xsl:with-param name="CCRActorPerson" select="$CCRActor/a:Person"/>
                    <xsl:with-param name="personNodeName" select="'assignedPerson'"/>
                </xsl:call-template>
            </xsl:if>

            <xsl:if test="$CCRActor/a:InternalCCRLink[a:LinkRelationship='Organization']">
                <xsl:call-template name="ccdOrganization">
                    <xsl:with-param name="ccrActorObjectID" select="$CCRActor/a:InternalCCRLink[a:LinkRelationship='Organization']/a:LinkID"/>
                    <xsl:with-param name="organizationNodeName" select="'representedOrganization'"/>
                </xsl:call-template>
            </xsl:if>

        </assignedEntity>
    </xsl:template>

    <xsl:template name="ccdPatient">
        <xsl:param name="CCRActorPerson"/>
        <patient>
            <xsl:call-template name="ccdPersonName">
                <xsl:with-param name="CCRActorName" select="$CCRActorPerson/a:Name"/>
            </xsl:call-template>

            <xsl:if test="$CCRActorPerson/a:Gender">
                <xsl:call-template name="ccdCodedValue">
                    <xsl:with-param name="ccrCodedDescription" select="$CCRActorPerson/a:Gender"/>
                    <xsl:with-param name="domain" select="'AdministrativeGender'"/>
                    <xsl:with-param name="nodeName" select="'administrativeGenderCode'"/>
                </xsl:call-template>
            </xsl:if>

            <xsl:if test="$CCRActorPerson/a:DateOfBirth">
                <birthTime>
                    <xsl:attribute name="value">
                        <xsl:call-template name="date:format-date">
                            <xsl:with-param name="date-time" select="$CCRActorPerson/a:DateOfBirth/a:ExactDateTime"/>
                            <xsl:with-param name="pattern">yyyyMMddhhmmss</xsl:with-param>
                        </xsl:call-template>
                    </xsl:attribute>
                </birthTime>
            </xsl:if>

            <xsl:if test="/a:ContinuityOfCareRecord/a:Body/a:SocialHistory/a:SocialHistoryElement[a:Type/a:Text='Marital Status']">
                <xsl:call-template name="ccdCodedValue">
                    <xsl:with-param name="ccrCodedDescription" select="/a:ContinuityOfCareRecord/a:Body/a:SocialHistory/a:SocialHistoryElement[a:Type/a:Text='Marital Status']/a:Description"/>
                    <xsl:with-param name="domain" select="'MaritalStatus'"/>
                    <xsl:with-param name="nodeName" select="'maritalStatusCode'"/>
                </xsl:call-template>
            </xsl:if>

            <xsl:if test="/a:ContinuityOfCareRecord/a:Body/a:SocialHistory/a:SocialHistoryElement[a:Type/a:Text='Language']">
                <languageCommunication>
                    <templateId root="2.16.840.1.113883.3.88.11.83.2" assigningAuthorityName="HITSP/C83"/>
                    <templateId root="1.3.6.1.4.1.19376.1.5.3.1.2.1" assigningAuthorityName="IHE/PCC"/>
                    <xsl:call-template name="ccdCodedValue">
                        <xsl:with-param name="ccrCodedDescription" select="/a:ContinuityOfCareRecord/a:Body/a:SocialHistory/a:SocialHistoryElement[a:Type/a:Text='Language']/a:Description"></xsl:with-param>
                        <xsl:with-param name="domain" select="'HumanLanguage'"/>
                        <xsl:with-param name="nodeName" select="'languageCode'"/>
                    </xsl:call-template>
                </languageCommunication>
            </xsl:if>
        </patient>
    </xsl:template>

    <xsl:template name="ccdPerformer">
        <xsl:param name="ccrActorReference"/>
        <performer typeCode="PRF">
            <xsl:if test="$ccrActorReference/a:ActorRole">
                <xsl:call-template name="ccdCodedValue">
                    <xsl:with-param name="ccrCodedDescription" select="$ccrActorReference/a:ActorRole"/>
                    <xsl:with-param name="nodeName" select="'functionCode'"/>
                </xsl:call-template>
            </xsl:if>
            <xsl:call-template name="ccdAssignedEntity">
                <xsl:with-param name="ccrActorObjectID" select="$ccrActorReference/a:ActorID"/>
            </xsl:call-template>
        </performer>
    </xsl:template>

    <xsl:template name="ccdPerson">
        <xsl:param name="CCRActorPerson"/>
        <xsl:param name="personNodeName">assignedPerson</xsl:param>
        <xsl:element name="{$personNodeName}">
            <xsl:call-template name="ccdPersonName">
                <xsl:with-param name="CCRActorName" select="$CCRActorPerson/a:Name"/>
            </xsl:call-template>
        </xsl:element>
    </xsl:template>

    <xsl:template name="ccdPersonName">
        <xsl:param name="CCRActorName"/>
        <name>
            <xsl:if test="$CCRActorName/a:CurrentName/a:Title">
                <prefix>
                    <xsl:value-of select="$CCRActorName/a:CurrentName/a:Title"/>
                </prefix>
            </xsl:if>
            <xsl:if test="$CCRActorName/a:CurrentName/a:Given">
                <given>
                    <xsl:value-of select="$CCRActorName/a:CurrentName/a:Given"/>
                </given>
            </xsl:if>
            <xsl:if test="$CCRActorName/a:CurrentName/a:Middle">
                <given>
                    <xsl:value-of select="$CCRActorName/a:CurrentName/a:Middle"/>
                </given>
            </xsl:if>
            <xsl:if test="$CCRActorName/a:CurrentName/a:Family">
                <family>
                    <xsl:value-of select="$CCRActorName/a:CurrentName/a:Family"/>
                </family>
            </xsl:if>
            <xsl:if test="$CCRActorName/a:CurrentName/a:Suffix">
                <suffix>
                    <xsl:value-of select="$CCRActorName/a:CurrentName/a:Suffix"/>
                </suffix>
            </xsl:if>
        </name>
    </xsl:template>

    <xsl:template name="ccdOrganization">
        <xsl:param name="ccrActorObjectID"/>
        <xsl:param name="organizationNodeName"/>

        <xsl:variable name="CCRActor" select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$ccrActorObjectID]"/>

        <xsl:element name="{$organizationNodeName}">
            <xsl:call-template name="ccdEntityID">
                <xsl:with-param name="CCRActor" select="$CCRActor"/>
            </xsl:call-template>
            <xsl:call-template name="ccdTelecom">
                <xsl:with-param name="CCRActor" select="$CCRActor"/>
            </xsl:call-template>

            <xsl:call-template name="ccdAddress">
                <xsl:with-param name="CCRActorAddress" select="$CCRActor/a:Address[1]"/>
            </xsl:call-template>
        </xsl:element>
    </xsl:template>

    <xsl:template name="ccdPatientRole">
        <xsl:param name="ccrActorObjectID"/>

        <xsl:variable name="CCRActor" select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$ccrActorObjectID]"/>

        <xsl:call-template name="ccdEntityID">
            <xsl:with-param name="CCRActor" select="$CCRActor"/>
        </xsl:call-template>

        <xsl:call-template name="ccdAddress">
            <xsl:with-param name="CCRActorAddress" select="$CCRActor/a:Address[1]"/>
        </xsl:call-template>

        <xsl:call-template name="ccdTelecom">
            <xsl:with-param name="CCRActor" select="$CCRActor"/>
        </xsl:call-template>

        <xsl:call-template name="ccdPatient">
            <xsl:with-param name="CCRActorPerson" select="$CCRActor/a:Person"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="ccdAssignedAuthor">
        <xsl:param name="ccrActorObjectID"/>
		<assignedAuthor>
        <xsl:variable name="CCRActor" select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$ccrActorObjectID]"/>

        <xsl:call-template name="ccdEntityID">
            <xsl:with-param name="CCRActor" select="$CCRActor"/>
        </xsl:call-template>

        <xsl:call-template name="ccdAddress">
            <xsl:with-param name="CCRActorAddress" select="$CCRActor/a:Address[1]"/>
        </xsl:call-template>

        <xsl:call-template name="ccdTelecom">
            <xsl:with-param name="CCRActor" select="$CCRActor"/>
        </xsl:call-template>

        <xsl:call-template name="ccdPerson">
            <xsl:with-param name="CCRActorPerson" select="$CCRActor/a:Person"/>
        </xsl:call-template>

        <xsl:if test="$CCRActor/a:InternalCCRLink[a:LinkRelationship='Organization']">
            <representedOrganization>
                <xsl:call-template name="ccdOrganization">
                    <xsl:with-param name="ccrActorObjectID" select="$CCRActor/a:InternalCCRLink[a:LinkRelationship='Organization']/a:LinkID"/>
                </xsl:call-template>
            </representedOrganization>
        </xsl:if>
        </assignedAuthor>
    </xsl:template>

    <xsl:template name="ccdParticipantRoleActor">
        <xsl:param name="ccrActorObjectID"/>

        <xsl:variable name="CCRActor" select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$ccrActorObjectID]"/>

        <xsl:call-template name="ccdEntityID">
            <xsl:with-param name="CCRActor" select="$CCRActor"/>
        </xsl:call-template>

        <xsl:call-template name="ccdAddress">
            <xsl:with-param name="CCRActorAddress" select="$CCRActor/a:Address[1]"/>
        </xsl:call-template>

        <xsl:call-template name="ccdTelecom">
            <xsl:with-param name="CCRActor" select="$CCRActor"/>
        </xsl:call-template>

        <xsl:if test="$CCRActor/a:Organization/a:Name">
            <playingEntity classCode="PLC">
                <name>
                    <xsl:value-of select="$CCRActor/a:Organization/a:Name"/>
                </name>
            </playingEntity>
        </xsl:if>
    </xsl:template>

    <xsl:template name="ccdParticipantRoleCodedDescription">
        <xsl:param name="ccrCodedDescription"/>
        <participantRole classCode="MANU">
           <!--Product Detail-->
           <playingEntity classCode="MMAT">
				<xsl:if test="$ccrCodedDescription/a:Code">
					<xsl:call-template name="ccdCodedValue">
						<xsl:with-param name="ccrCodedDescription" select="$ccrCodedDescription"/>
						<xsl:with-param name="nodeName" select="'code'"/>
					</xsl:call-template>
				</xsl:if>
				<name>
					<xsl:value-of select="$ccrCodedDescription/a:Text"/>
				</name>
			</playingEntity>
		</participantRole>
    </xsl:template>

    <xsl:template name="ccdEntityID">
        <xsl:param name="CCRActor"/>
        <id>
            <xsl:choose>
                <xsl:when test="$CCRActor/a:IDs">
                    <xsl:attribute name="extension">
                        <xsl:value-of select="$CCRActor/a:IDs[1]/a:ID"/>
                    </xsl:attribute>
                    <xsl:attribute name="root">
                        <xsl:value-of select="$CCRActor/a:IDs[1]/a:Type/a:Text"/>
                    </xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="extension">
                        <xsl:value-of select="$CCRActor/a:ActorObjectID"/>
                    </xsl:attribute>
                    <xsl:attribute name="root">
                        <xsl:text>CCRActorID</xsl:text>
                    </xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
        </id>
         <xsl:if test="$CCRActor/a:Organization">
            <name><xsl:value-of select="$CCRActor/a:Organization/a:Name"></xsl:value-of></name>
        </xsl:if>
    </xsl:template>		
    <xsl:template name="ccdAddress">
        <xsl:param name="CCRActorAddress"/>
        <addr>
            <xsl:choose>
                <xsl:when test="$CCRActorAddress">
                    <xsl:attribute name="use">
                        <xsl:call-template name="CDAVocabularyLookup">
                            <xsl:with-param name="domain" select="'telecommunicationsAddressUse'"/>
                            <xsl:with-param name="ccrtext" select="$CCRActorAddress/a:Type/a:Text"/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <streetAddressLine>
                        <xsl:value-of select="$CCRActorAddress/a:Line1"/>
                    </streetAddressLine>
                    <city>
                        <xsl:value-of select="$CCRActorAddress/a:City"/>
                    </city>
                    <state>
                        <xsl:value-of select="$CCRActorAddress/a:State"/>
                    </state>
                    <postalCode>
                        <xsl:value-of select="$CCRActorAddress/a:PostalCode"/>
                    </postalCode>
                </xsl:when>
                <xsl:otherwise>
                    <streetAddressLine/>
                </xsl:otherwise>
            </xsl:choose>
        </addr>
    </xsl:template>
    
    <xsl:template name="ccdTelecom">
        <xsl:param name="CCRActor"/>
        <telecom>
            <xsl:if test="$CCRActor/a:Telephone">
                <xsl:attribute name="use">
                    <xsl:call-template name="CDAVocabularyLookup">
                        <xsl:with-param name="domain" select="'telecommunicationsAddressUse'"/>
                        <xsl:with-param name="ccrtext" select="$CCRActor/a:Telephone/a:Type/a:Text"/>
                    </xsl:call-template>
                </xsl:attribute>
                <xsl:attribute name="value">
                    <xsl:text>tel:+1-</xsl:text>
                    <xsl:value-of select="$CCRActor/a:Telephone[1]/a:Value"/>
                </xsl:attribute>
            </xsl:if>
        </telecom>

        <xsl:if test="$CCRActor/a:Email">
            <telecom>
                <xsl:choose>
                    <xsl:when test="$CCRActor/a:Telephone">
                        <xsl:attribute name="use">
                            <xsl:call-template name="CDAVocabularyLookup">
                                <xsl:with-param name="domain" select="'telecommunicationsAddressUse'"/>
                                <xsl:with-param name="ccrtext" select="$CCRActor/a:Telephone/a:Type/a:Text"/>
                            </xsl:call-template>
                        </xsl:attribute>
                        <xsl:attribute name="value">
                            <xsl:text>mailto:</xsl:text>
                            <xsl:value-of select="$CCRActor/a:Email[1]/a:Value"/>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="value">
                            <xsl:text>Unknown</xsl:text>
                        </xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
            </telecom>
        </xsl:if>
    </xsl:template>

    <xsl:template name="ccdID">
        <xsl:param name="ccrObjectID"/>
        <xsl:param name="suffix"/>
        <id>
            <xsl:attribute name="root">
                <xsl:value-of select="$ccrObjectID"></xsl:value-of>
            </xsl:attribute>
            <xsl:attribute name="extension">CCRObjectID</xsl:attribute>
        </id>
    </xsl:template>

    <xsl:template name="ccdCodedValue">
        <xsl:param name="ccrCodedDescription"/>
        <xsl:param name="type"/>
        <xsl:param name="domain"/>
        <xsl:param name="nodeName">value</xsl:param>
        <xsl:param name="originalTextReference"/>

        <xsl:element name="{$nodeName}">
            <xsl:if test="$type">
                <xsl:attribute name="xsi:type">
                    <xsl:value-of select="$type"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="$ccrCodedDescription/a:Code">
                    <xsl:attribute name="displayName">
                        <xsl:value-of select="$ccrCodedDescription/a:Text"/>
                    </xsl:attribute>
                    <xsl:attribute name="code">
                        <xsl:value-of select="$ccrCodedDescription/a:Code/a:Value"/>
                    </xsl:attribute>
                    <xsl:attribute name="codeSystemName">
                        <xsl:value-of select="$ccrCodedDescription/a:Code/a:CodingSystem"/>
                    </xsl:attribute>
                    <xsl:attribute name="codeSystem">
                        <xsl:call-template name="HL7OIDLookup">
                            <xsl:with-param name="name" select="$ccrCodedDescription/a:Code/a:CodingSystem"/>
                        </xsl:call-template>
                    </xsl:attribute>
                </xsl:when>
                <xsl:when test="$domain">
                    <xsl:variable name="cdaCode">
                        <xsl:call-template name="CDAVocabularyLookup">
                            <xsl:with-param name="domain" select="$domain"/>
                            <xsl:with-param name="ccrtext" select="$ccrCodedDescription/a:Text"/>
                        </xsl:call-template>
                    </xsl:variable>
                    <xsl:attribute name="displayName">
                        <xsl:call-template name="CDADisplayNameLookup">
                            <xsl:with-param name="domain" select="$domain"/>
                            <xsl:with-param name="cdacode" select="$cdaCode"/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <xsl:attribute name="code">
                        <xsl:value-of select="$cdaCode"></xsl:value-of>
                    </xsl:attribute>
                    <xsl:attribute name="codeSystemName">
                        <xsl:call-template name="CDAVocabularyCodeSystemNameLookup">
                            <xsl:with-param name="domain" select="$domain"/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <xsl:attribute name="codeSystemName">
                        <xsl:call-template name="CDAVocabularyCodeSystemLookup">
                            <xsl:with-param name="domain" select="$domain"/>
                        </xsl:call-template>
                    </xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <originalText>
                        <xsl:value-of select="$ccrCodedDescription/a:Text"/>
                        <xsl:if test="$originalTextReference">
                            <reference>
                                <xsl:attribute name="value">
                                    <xsl:value-of select="$originalTextReference"/>
                                </xsl:attribute>
                            </reference>
                        </xsl:if>
                    </originalText>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:template>

    <xsl:template name="ccdDateTime">
        <xsl:param name="dt"/>
        <xsl:param name="type"/>
        <xsl:if test="$dt">
            <xsl:if test="$dt[1]/a:ExactDateTime">
                <effectiveTime>
                    <xsl:if test="$type">
                        <xsl:attribute name="xsi:type">
                            <xsl:value-of select="$type"></xsl:value-of>
                        </xsl:attribute>
                    </xsl:if>
                    <low>
                        <xsl:attribute name="value">
                            <xsl:call-template name="date:format-date">
                                <xsl:with-param name="date-time" select="$dt[1]/a:ExactDateTime"/>
                                <xsl:with-param name="pattern">yyyyMMdd</xsl:with-param>
                            </xsl:call-template>
                        </xsl:attribute>
                    </low>
                    <high nullFlavor="UNK"/>
                </effectiveTime>
            </xsl:if>
            <xsl:if test="$dt[1]/a:DateTimeRange">
                <effectiveTime>
                    <low>
                        <xsl:attribute name="value">
                            <xsl:call-template name="date:format-date">
                                <xsl:with-param name="date-time" select="$dt[1]/a:DateTimeRange/a:BeginRange/a:ExactDateTime"/>
                                <xsl:with-param name="pattern">yyyyMMdd</xsl:with-param>
                            </xsl:call-template>
                        </xsl:attribute>
                    </low>
                    <high>
                        <xsl:attribute name="value">
                            <xsl:call-template name="date:format-date">
                                <xsl:with-param name="date-time" select="$dt[1]/a:DateTimeRange/a:EndRange/a:ExactDateTime"/>
                                <xsl:with-param name="pattern">yyyyMMdd</xsl:with-param>
                            </xsl:call-template>
                        </xsl:attribute>
                    </high>
                </effectiveTime>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <xsl:template name="ccdMedicationFrequency">
        <xsl:param name="frequency"/>
        <xsl:if test="$frequency">
            <xsl:choose>
                <xsl:when test="$frequency/a:Value='qd'">
                    <effectiveTime xsi:type="PIVL_TS" operator="A">
                        <xsl:attribute name="institutionSpecified">true</xsl:attribute>
                        <period>
                            <xsl:attribute name="value">24</xsl:attribute>
                            <xsl:attribute name="unit">h</xsl:attribute>
                        </period>
                    </effectiveTime>
                </xsl:when>
                <xsl:when test="$frequency/a:Value='bid'">
                    <effectiveTime xsi:type="PIVL_TS" operator="A">
                        <xsl:attribute name="institutionSpecified">true</xsl:attribute>
                        <period>
                            <xsl:attribute name="value">12</xsl:attribute>
                            <xsl:attribute name="unit">h</xsl:attribute>
                        </period>
                    </effectiveTime>
                </xsl:when>
                <xsl:when test="$frequency/a:Value='tid'">
                    <effectiveTime xsi:type="PIVL_TS" operator="A">
                        <xsl:attribute name="institutionSpecified">true</xsl:attribute>
                        <period>
                            <xsl:attribute name="value">8</xsl:attribute>
                            <xsl:attribute name="unit">h</xsl:attribute>
                        </period>
                    </effectiveTime>
                </xsl:when>
                <xsl:when test="$frequency/a:Value='qid'">
                    <effectiveTime xsi:type="PIVL_TS" operator="A">
                        <xsl:attribute name="institutionSpecified">true</xsl:attribute>
                        <period>
                            <xsl:attribute name="value">6</xsl:attribute>
                            <xsl:attribute name="unit">h</xsl:attribute>
                        </period>
                    </effectiveTime>
                </xsl:when>
                <xsl:when test="$frequency/a:Value='qam'">
                    <effectiveTime xsi:type='EIVL' operator='A'>
                        <event code='ACM'/>
                    </effectiveTime>
                </xsl:when>
                <xsl:when test="$frequency/a:Value='qpm'">
                    <effectiveTime xsi:type='EIVL' operator='A'>
                        <event code='PCV'/>
                    </effectiveTime>
                </xsl:when>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

    <xsl:template name="ccdStatus">
        <xsl:param name="ccrStatus"/>

        <entryRelationship typeCode="REFR">
            <observation classCode="OBS" moodCode="EVN">
                <templateId root="2.16.840.1.113883.10.20.1.50"/>
                <!-- Problem status observation template -->
                <code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
                <statusCode code="completed"/>
                <xsl:call-template name="ccdCodedValue">
                    <xsl:with-param name="ccrCodedDescription" select="$ccrStatus"/>
                </xsl:call-template>
            </observation>
        </entryRelationship>
    </xsl:template>

    <xsl:template name="ccdStatusObservation">
        <xsl:param name="status"/>
        <xsl:variable name="statusText" select="$status/a:Text"></xsl:variable>
        <xsl:choose>
            <xsl:when test="$statusText='Active'">
                <xsl:call-template name="ccdStatusElement">
                    <xsl:with-param name="statusCode" select="'55561003'"/>
                    <xsl:with-param name="statusDisplayName" select="$statusText"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$statusText='Inactive'">
                <xsl:call-template name="ccdStatusElement">
                    <xsl:with-param name="statusCode" select="'73425007'"/>
                    <xsl:with-param name="statusDisplayName" select="$statusText"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$statusText='Chronic'">
                <xsl:call-template name="ccdStatusElement">
                    <xsl:with-param name="statusCode" select="'90734009'"/>
                    <xsl:with-param name="statusDisplayName" select="$statusText"/>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="ccdStatusProcedure">
        <xsl:param name="status"/>
        <xsl:variable name="statusText" select="$status/a:Text"></xsl:variable>
        <xsl:choose>
            <xsl:when test="$statusText='Completed'">
                <statusCode code="completed"/>
            </xsl:when>
            <xsl:when test="$statusText='Active'">
                <statusCode code="active"/>
            </xsl:when>
            <xsl:when test="$statusText='Aborted'">
                <statusCode code="aborted"/>
            </xsl:when>
            <xsl:when test="$statusText='Cancelled' or $statusText='Canceled'">
                <statusCode code="cancelled"/>
            </xsl:when>
            <xsl:otherwise>
                <statusCode>
                    <xsl:attribute name="code">
                        <xsl:value-of select="$statusText"></xsl:value-of>
                    </xsl:attribute>
                </statusCode>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="ccdStatusElement">
        <xsl:param name="statusCode"/>
        <xsl:param name="statusDisplayName"/>
        <value>
            <xsl:attribute name="xsi:type">CE</xsl:attribute>
            <xsl:attribute name="code">
                <xsl:value-of select="$statusCode"></xsl:value-of>
            </xsl:attribute>
            <xsl:attribute name="codeSystem">2.16.840.1.113883.6.96</xsl:attribute>
            <xsl:attribute name="displayName">
                <xsl:value-of select="$statusDisplayName"></xsl:value-of>
            </xsl:attribute>
        </value>
    </xsl:template>

    <xsl:template name="ccdObservation">
        <xsl:param name="ccrTestNode"/>
        <xsl:param name="testDate"/>

        <component>
            <observation classCode="OBS" moodCode="EVN">
                <templateId root="2.16.840.1.113883.3.88.11.83.15" assigningAuthorityName="HITSP C83"/>
                <templateId root="2.16.840.1.113883.10.20.1.31" assigningAuthorityName="CCD"/>
                <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.13" assigningAuthorityName="IHE PCC"/>

                <!-- Result observation template -->

                <xsl:call-template name="ccdID">
                    <xsl:with-param name="ccrObjectID" select="$ccrTestNode/a:CCRDataObjectID"/>
                </xsl:call-template>

                <!-- <code> -->
                <xsl:call-template name="ccdCodedValue">
                    <xsl:with-param name="ccrCodedDescription" select="$ccrTestNode/a:Description"/>
                    <xsl:with-param name="nodeName" select="'code'"/>
                </xsl:call-template>

                <text>
                    <reference>
                        <xsl:attribute name="value">
                            <xsl:text>#</xsl:text>
                            <xsl:value-of select="$ccrTestNode/a:CCRDataObjectID"/>
                        </xsl:attribute>
                    </reference>
                </text>

                <statusCode code="completed"/>

                <!-- <effectiveTime> -->
                <xsl:choose>
                    <xsl:when test="$ccrTestNode/a:DateTime">
                        <xsl:call-template name="ccdDateTime">
                            <xsl:with-param name="dt" select="$ccrTestNode/a:DateTime"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="ccdDateTime">
                            <xsl:with-param name="dt" select="$testDate"/>
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>

                <xsl:choose>
                    <xsl:when test="$ccrTestNode/a:TestResult[a:Value!='']">
                        <value xsi:type="PQ">
                            <xsl:attribute name="value">
                                <xsl:value-of select="$ccrTestNode/a:TestResult/a:Value"/>
                            </xsl:attribute>
                            <xsl:attribute name="unit">
                                <xsl:value-of select="$ccrTestNode/a:TestResult/a:Units/a:Unit"/>
                            </xsl:attribute>
                        </value>
                    </xsl:when>
                    <xsl:when test="$ccrTestNode/a:TestResult[a:Description/a:Text!='']">
                        <value xsi:type="TX">
                            <xsl:attribute name="value">
                                <xsl:value-of select="$ccrTestNode/a:TestResult/a:Description/a:Text"/>
                            </xsl:attribute>
                        </value>
                    </xsl:when>
                </xsl:choose>

                <xsl:if test="$ccrTestNode/a:Flag">
                    <xsl:call-template name="ccdCodedValue">
                        <xsl:with-param name="ccrCodedDescription" select="$ccrTestNode/a:Flag"/>
                        <xsl:with-param name="nodeName" select="'interpretationCode'"/>
                        <xsl:with-param name="domain" select="'ObservationInterpretation'"/>
                    </xsl:call-template>
                </xsl:if>

                <xsl:if test="$ccrTestNode/a:NormalResult">
                    <referenceRange>
                        <xsl:if test="$ccrTestNode/a:NormalResult/a:Normal/a:Description/a:Text">
                            <observationRange>
                                <text>
                                    <xsl:value-of select="$ccrTestNode/a:NormalResult/a:Normal/a:Description/a:Text"/>
                                </text>
                            </observationRange>
                        </xsl:if>
                    </referenceRange>
                </xsl:if>

            </observation>
        </component>

    </xsl:template>
</xsl:stylesheet>
