<?xml version="1.0" encoding="UTF-8"?>
<?xml-stylesheet type="text/xsl" href="cda.xsl"?>

<!--
Conversion of CCR to Level 3 CCD

Orginal Author:   	Ken Miller
Solventus LLC
ken.miller@solventus.coms

Contributors:
Richard Braman, EHR Doctors, Inc rbraman@ehrdoctors.com
George Lilly (WorldVistA glilly@glilly.net)
Nancy Antracite, WorldVistA
xxxx - Oroville Hospital

Date: 	2010-05-5
Version: 	0.1

License :

        This program is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program.  If not, see http://www.gnu.org/licenses.

-->
<xsl:stylesheet version="1.0" xmlns="urn:hl7-org:v3" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:a="urn:astm-org:CCR" xmlns:date="http://exslt.org/dates-and-times"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="a date">
    <xsl:import href="./templates/cdavocablookup.xsl"/>
    <xsl:import href="./templates/hl7oidlookup.xsl"/>
    <xsl:import href="./templates/code.xsl"/>
    <xsl:import href="./templates/actor.xsl"/>
    <xsl:import href="./templates/datetime.xsl"/>
    <xsl:import href="./templates/problemDescription.xsl"/>

    <xsl:output method="xml" encoding="utf-8" version="1.0" indent="yes"/>
    <xsl:template match="/">
<!--WV Added new munltiple documentation of added have to do with encounter times, etc.-->

<!--
********************************************************
CDA Header
********************************************************
-->

<!--
******************
Document Information
**********************
-->
<ClinicalDocument xmlns="urn:hl7-org:v3" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:hl7-org:v3 CDA.xsd">
	<!-- Created with XML Copy Editor  Open Source Sourceforge project. -->
<!--WVP This is the clinical document type ID-->
  <realmCode code="US"/>
	<typeId root="2.16.840.1.113883.1.3" extension="POCD_HD000040"/>
	<!-- QRDA Category I generic template ID. -->
	<!--WVP these next two lines are fixed-->
	<templateId root="2.16.840.1.113883.10.20.12" />
	<!--only in the july spec so not sure if it should be here-->
	<templateId root="2.16.840.1.113883.3.249.11.100.1"/>
	<!--WVV 2.16.840.1.113883.3.543 is fixed and is the beginninng of WorldVistAs OID, change the extension for a new document and the version for changes to this one-->
	
	
	<!--Script replaces UUID each time if the version number is 1-->
	<id root="2.16.840.1.113883.3.543" extension="@@@UUID-DOC@@@"/>

             <!--   <xsl:attribute name="root">
                    <xsl:value-of select="/a:ContinuityOfCareRecord/a:CCRDocumentObjectID"></xsl:value-of>
                </xsl:attribute>
            </id>-->
		 <!--WVP next two lines fixed-->
	<code code="55182-0" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Quality Measure Report"/>
	<title>QRDA Incidence Report</title>
		<!--WVV time-->
	<effectiveTime value="20100703"/>
		<!--WVP for next two lines-->
  <confidentialityCode codeSystem="2.16.840.1.113883.5.25" code="N"/>
  <languageCode code="en-US"/>
  <!--WV? Don't change this in the document set we are working on-->
  <setId root="2.16.840.1.113883.3.543" extension="@@@UUID-SET@@@"/>
	 <versionNumber value="1"/>
  <!--WVP  I made one up but we will have to have an OID for the Clincal Document SET which we will make up for ourselves eventually-->
  
 <!--
 *******************
 Patient Information
 ****************
 -->
	<!-- This is the patient for which the report is describing. -->
	<recordTarget>
<patientRole>
                <xsl:call-template name="ccdPatientRole">
                    <xsl:with-param name="ccrActorObjectID" select="/a:ContinuityOfCareRecord/a:Patient[1]/a:ActorID"/>
                </xsl:call-template>
                </patientRole>
	</recordTarget>

<!--
*****************************
Author
**************
-->
	<!-- This example assumes the doctor is creating the report and it is Required.  -->
	<author>
	  <!--WVV Edit time has to be precise at least to the day-->
		<time value="20100703" />
		<assignedAuthor>
		  <!--WVP eventually id this is required, the root is fixed -->
		  <!--andn the extension is the SOFTWARE version number assigned by CMS to WV EHR-->
			<id root="2.16.840.1.113883.3.249.6" extension="100001" />
			<!--WVVassignedPerson not required-->
			<assignedPerson>
				<name>
				  <!--WV Edit-->
					<given>Nancy</given>
					<family>Anthracite</family>
					<suffix>MD</suffix>
				</name>
			</assignedPerson>
			<representedOrganization>
			  <!--WV? id root is OID for the organization so I made one up for this document set-->
				<id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>WorldVistA Test Clinic</name>
			</representedOrganization>
		</assignedAuthor>
	</author>
		<!-- The reporting healthcare facility is represented using the CCD "Source of Information" construct, via the Informant participant. -->
	<informant>
	   <assignedEntity>
      <!--WV this null flavor is required as is-->
			<id nullFlavor="NA"/>
			<representedOrganization>
				<!--WV root is the OID of the organization.  ID is required but name is not and id is OID stated earlier-->
        <id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>World VistA Test Clinic</name>
			</representedOrganization>
		</assignedEntity>
	</informant>

	<!-- This example assumes that the institution responsible for the data is serving as custodian. -->
	<!--WV This element is required as is the sSD which is not stated if it is an OID but assumed it is-->
	<!--WV Name is not required, only ID is required.-->
	<custodian>
		<assignedCustodian>
			<representedCustodianOrganization>
				<id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>WorldVistA Test Clinic</name>
			</representedCustodianOrganization>
		</assignedCustodian>
	</custodian>

	<!-- In this example, the author is also serving as legal authenticator. -->
	<!--WV section is this is not required-->
<legalAuthenticator>
		<time value="20100703" />
		<!--WV the signature code of S is required-->
		<signatureCode code="S" />
		<assignedEntity>
      <!--WV document does not specify the requirements of the id but it is required-->
      <!--WVP and the sample suggests it is the number below and extension is ???-->
			<id root="2.16.840.1.113883.3.543" extension="111111" />
			<assignedPerson>
				<name>
					<given>Nancy</given>
					<family>Anthracite</family>
					<suffix>MD</suffix>
				</name>
			</assignedPerson>
			<representedOrganization>
			  <!--WV? and is fixed for the WorldVistA Test Clinic in this submitted document series-->
				<id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>WorldVistA Test Clinic</name>
			</representedOrganization>
		</assignedEntity>
	</legalAuthenticator>
	
	
	
	<!--Added to sample as it is new since 2008-->
	<!--WVP permanent for participant in the primary care provider participant-->
<!--WVP performer type codes are numerous but PRF is performer or the person who did it-->
	<participant typeCode="PRF">
	  <!--WVP required as is for function-->
	  <!-- WVP I believe PCP is primary care provider but not sure-->
	  <functionCode code="PCP" codeSystem="2.16.840.1.113883.5.88"/>
	  <!--WVP Associated Entity is required ti be there with this PROV-->
	  <associatedEntity classCode="PROV">
	    <!--WV? OID of the provider fixed for this series of documents-->
	    <id root="2.16.840.1.113883.3.249.6" extension="111111" />
	    <!--WV associated person is not required so presumabley the code will suffice not sure??-->
	    <associatedPerson>
	      <name>
	        <prefix>Dr.</prefix>
	        <given>Nancy</given>
	        <family>Anthracite</family>
        </name>
	    </associatedPerson>
    </associatedEntity>
	</participant>
	
	<!--The service event is the encounter that describes tehe encunter as well as the provider, location and time-->
	<!--!There can be one or more documentation elements depending on the number of encounters during the reporting period-->
	<!--WVV IMPORTANT!! The encounter codeds are recorded here-->
	<!-- They are in appendix B of the downloadable resource document-->
	<!-- Each documentation of is a single service event-->
	
<!--Occurence of Measures episode documention-->
<!--Like an encounter section only for QRDA-->
<!--Same doctor, same clinic, different date and different enconter code-->
	
	
	<!--First Visit documentationOf section-->
<!--DOCUMENTATIONOFSECTION-->

	<!-- 
********************************************************
CDA Body
********************************************************
-->
 <component>
 	<structuredBody>
  	<!-- 
	  ********************************************************
     Measure Set Section
	  ********************************************************
     -->
 	    <component>
        <section>
        <!-- WVP QRDA Category I measure-specific template ID for 2010 #1. -->
        <!--WP Next 3 lines do not change during the reporting period, for the measures section-->
        <templateId root="2.16.840.1.113883.3.249.11.50" />
        <code code="55185-3" codeSystem="2.16.840.1.113883.6.1" />
        <title>Measure set: CMS EHR Measure Set</title>
         <text>2010 Measures Set Measures</text>
          <!--
                ***************************************************
                Measure Section
                ***************************************************
                -->
           <component>
            <section>
              <!--template ID for each measure being reported-->
              <templateId root="2.16.840.1.113883.3.249.11.2" />
            <!--  <templateId root="2.16.840.1.113883.3.249.11.3" />
              <templateId root="2.16.840.1.113883.3.249.11.4" />
              <templateId root="2.16.840.1.113883.3.249.11.5" />
              <templateId root="2.16.840.1.113883.3.249.11.6" />
              <templateId root="2.16.840.1.113883.3.249.11.7"/>
              <templateId root="2.16.840.1.113883.3.249.11.8" />
              <templateId root="2.16.840.1.113883.3.249.11.9" />
              <templateId root="2.16.840.1.113883.3.249.11.10" />
              <templateId root="2.16.840.1.113883.3.249.11.11" />
              <templateId root="eRx/2.16.840.1.113883.3.249.11.15" />-->
             <!--New for 2011--> 
             <!-- <templateId root="2.16.840.1.113883.3.249.11.51" />
              <templateId root="2.16.840.1.113883.3.249.11.52" />
              <templateId root="2.16.840.1.113883.3.249.11.53" />
              <templateId root="2.16.840.1.113883.3.249.11.54" />
              <templateId root="2.16.840.1.113883.3.249.11.55" />
              <templateId root="2.16.840.1.113883.3.249.11.56" />
              <templateId root="2.16.840.1.113883.3.249.11.57" />
              <templateId root="2.16.840.1.113883.3.249.11.58" />
              <templateId root="2.16.840.1.113883.3.249.11.59" />
              <templateId root="2.16.840.1.113883.3.249.11.60" />-->
              <code code="55186-1" codeSystem="2.16.840.1.113883.6.1" />
        
              <title>Measure Section</title>
              <!--Here is where the HTML begins for the above and it is optional-->
              <text>
                <list>
                  <item>CMS Measure #1: Diabetes Mellitus: Hemoglobin A1c Poor Control in Diabetes Mellitus</item>
                <!--  <item>CMS Measure #2: Diabetes Mellitus: Low Density Lipoprotein (LDL-C) Control in Diabetes Mellitus</item>
                 <item>CMS Measure #3: Diabetes Mellitus: High Blood Pressure Control in Diabetes Mellitus</item>
                  <item>CMS Measure #5: Heart Failure: Angiotensin-Converting Enzyme (ACE) Inhibitor or Angiotensin Receptor Blocker (ARB) Therapy for Left Ventricular Systolic Dysfunction (LVSD)</item>
                  <item>CMS Measure #7: Coronary Artery Disease (CAD): Beta-Blocker Therapy for CAD Patients with Prior Myocardial Infarction (MI)</item>
                  <item>CMS Measure #110: Preventive Care and Screening: Influenza Immunization for Patients >= 50 Years</item>
                  <item>CMS Measure #111: Preventive Care and Screening: Pneumonia Vaccination for Patients 65 Years and Older</item>
                  <item>CMS Measure #112: Preventive Care and Screening: Screening Mammography</item>
                  <item>CMS Measure #113: Preventive Care and Screening: Colorectal Cancer Screening</item>
                  <item>CMS Measure #124: Health Information Technology (HIT): Adoption/Use of Electronic Health Records (EHR)</item>
                  <item>CMS Measure eRx:Adoption/Use of Medication Electronic Prescribing Measure</item>-->
                  <!--added 2011 measures-->
                  <!--<item>CMS Measure #39: Screening or Therapy for Osteoporosis for Women Aged 65 Years and Older</item>
                  <item>CMS Measure #47: Advance Care Plan </item>
                  <item>CMS Measure #48: Urinary Incontinence: Assessment of Presence or Absence of Urinary Incontinence in Women Aged 65 Years and Older</item>
                  <item>CMS Measure #128: Preventive Care and Screening: Body Mass Index (BMI) Screening and Follow-Up </item>
		  <item>CMS Measure #173: Preventive Care and Screening: Unhealthy Alcohol Use - Screening</item>
		  <item>CMS Measure #0013: Hypertension (HTN): Blood Pressure Measurement - QRDA Cat I template </item>
		  <item>CMS Measure #0022: Drugs to be avoided in the Elderly </item>
		  <item>CMS Measure #0024: Body Mass Index (BMI) 2 through 18 years of age </item>
		  <item>CMS Measure #0028: Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention</item>
		  <item>CMS Measure #0038: Childhood Immunization Status - QRDA Cat I template</item>-->
                </list>
              </text>
              <!--Begin listing of acts-->
             <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="2.16.840.1.113883.3.249.11.2" />
                  <code code="PQRI-1" codeSystem="2.16.840.1.113883.3.249.12" displayName="Hemoglobin A1c Poor Control in Diabetes Mellitus"/>
                  <text>Percentage of patients 18 through 75 years with diabetes mellitus who had most recent hemoglobin A1C greater than 9.0%</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <!--<entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="2.16.840.1.113883.3.249.11.3" />
                 <code code="PQRI-2" codeSystem="2.16.840.1.113883.3.249.12" displayName="Low Density Lipoprotein (LDL-C) Control in Diabetes Mellitus"/>
                  <text>Percentage of patients 18 through 75 years with diabetes mellitus who had most recent LDL-C level in control (less than 100 mg./dL)</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                <id root="2.16.840.1.113883.3.249.11.4" />
                  <code code="PQRI-3" codeSystem="2.16.840.1.113883.3.249.12" displayName="Hemoglobin A1c Poor Control in Diabetes Mellitus"/>
                  <text>Percentage of patients 18 through 75 years with diabetes mellitus who had most recent blood pressure in control (less than 140/80 mmHg)</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="2.16.840.1.113883.3.249.11.5" />
                  <code code="PQRI-5" codeSystem="2.16.840.1.113883.3.249.12" displayName="Heart Failure: Angiotensin-Converting Enzyme (ACE) Inhibitor or Angiotensin Receptor Blocker (ARB) Therapy for Left Ventricular Systolic Dysfunction (LVSD)"/>
                  <text>Percentage of patients 18 years and older with a diagnosis of heart frilure and LVSD who were prescribed ACE inhibitor or ARB therapy</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="2.16.840.1.113883.3.249.11.6" />
                  <code code="PQRI-7" codeSystem="2.16.840.1.113883.3.249.12" displayName="Beta-Blocker Therapy for CAD Patients with Prior Myocardial Infarction"/>
                  <text>Percentage of patients 18 aged 18 years and older wit a diagnosis of CAD and prior MI who were prescribed beta-blocker therapy</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="2.16.840.1.113883.3.249.11.7"/>
                  <code code="PQRI-110" codeSystem="2.16.840.1.113883.3.249.12" displayName="Influenza Immunization for Patients >= 50 Years"/>
                  <text>Percentage of patients aged 50 years and older who received an influenza immunization during the flu season (September through February)</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                 <id root="2.16.840.1.113883.3.249.11.8" />
                  <code code="PQRI-111" codeSystem="2.16.840.1.113883.3.249.12" displayName="Pneumonia Vaccination for Patients 65 Years and Older"/>
                  <text>Percentage of patients afed 65 years and older who have ever received a pneumoccal vaccine</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                <id root="2.16.840.1.113883.3.249.11.9" />
                  <code code="PQRI-112" codeSystem="2.16.840.1.113883.3.249.12" displayName="Screening Mammography"/>
                  <text>Percentage of womaen aged 40 through 69 years who had a mammogram to screen for breast cancer within 24 months</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                 <id root="2.16.840.1.113883.3.249.11.10" />
                  <code code="PQRI-113" codeSystem="2.16.840.1.113883.3.249.12" displayName="Colorectal Cancer Screening"/>
                  <text>Percentage of patients aged 50 through 80 who received the appropriate colorectal cancer screening</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="2.16.840.1.113883.3.249.11.14" />
                  <code code="PQRI-124" codeSystem="2.16.840.1.113883.3.249.12" displayName="Adoption/Use of Electronic Health Records (EHR)"/>
                  <text>Documents whether provider has adopted and is using health information technology. To qualify, the provider must havea adopted and be using a certified/qualified electronic health record (EHR)</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="2.16.840.1.113883.3.249.11.14" />
                  <code code="eRx" codeSystem="2.16.840.1.113883.3.249.12" displayName="Adoption/Use of Medication Electronic Prescribing Measure"/>
                  <text>Documents whether provider has adopted and is using ePrescribing</text>
                  <statusCode code="completed"/>
                </act>
                </entry>-->
                
 <!--******************************************
               Begin 2011 measures
 ********************************************-->
                <!--<entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                   <id root="2.16.840.1.113883.3.249.11.51" />
                    <code code="PQRI-39" codeSystem="2.16.840.1.113883.3.249.12" displayName="Screening or Therapy for Osteoporosis for Women Aged 65 Years and Older"/>
                  <text>Percentage of patients who had a DXA measurement ordered or performed at least once since age 60 or pharmacologic therapy prescribed within 12 months before the end of the measurement period</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="2.16.840.1.113883.3.249.11.52" />
                  <code code="PQRI-47" codeSystem="2.16.840.1.113883.3.249.12" displayName="Advance Care Plan"/>
                  <text>Percentage of patients age 65 and older who have an advanced care plan or surrogate decision maker documented in the medical record or documented in the medical record that an advance care plan was discussed but the patient did not wish or was not able to name a surrogate decision maker or provide an advance care plan.</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                   <id root="2.16.840.1.113883.3.249.11.53" />
                  <code code="PQRI-48" codeSystem="2.16.840.1.113883.3.249.12" displayName="Urinary Incontinence: Assessment of Presence or Absence of Urinary Incontinence in Women Aged 65 Years and Older"/>
                  <text>Percentage of patients equal to or older than 65 years of age at the beginning of the measurement perion who were assesed for the presence or absence of urinary incontinence within 12 months.</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                <id root="2.16.840.1.113883.3.249.11.54" /> 
                  <code code="PQRI-128" codeSystem="2.16.840.1.113883.3.249.12" displayName="Preventive Care and Screening: Body Mass Index (BMI) Screening and Follow-Up"/>
                  <text>Percentage of patients aged 18 yesrs and older with a calculate BMI in the past 6 months or during the current visit documented in the medical record and if the most recent BMI is ourtide parameters, a follow-up plan is documented. Ages 65 and older BMI equal to or greater than 30 or less than 22 and ages 18-64, BMI greater than or equal to 25 or less than 18.5</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                               <id root="2.16.840.1.113883.3.249.11.55" />
              <id root="2.16.840.1.113883.3.249.11.56" />
                  <code code="PQRI-173" codeSystem="2.16.840.1.113883.3.249.12" displayName="Preventive Care and Screening: Unhealthy Alcohol Use - Screening"/>
                  <text>Percentage of patients aged 18 years and older who were screened for unhealthy alcohol use using a systematic method within 24 months</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                                <id root="2.16.840.1.113883.3.249.11.56" />
              <id root="2.16.840.1.113883.3.249.11.57" />

                  <code code="PQRI-13" codeSystem="2.16.840.1.113883.3.249.12" displayName="Hypertension (HTN): Blood Pressure Measurement"/>
                  <text>Percentage of patients aged 18 years and older with a diagnosis of hypertension in the beginning of the measurement period with a blood pressure recoreded.</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                 <id root="2.16.840.1.113883.3.249.11.57" />
                  <code code="PQRI-22" codeSystem="2.16.840.1.113883.3.249.12" displayName="Drugs to be avoided in the elderly"/>
                  <text>Percentage of patients aged 65 years and older who received at least one drug to be acoided in the elderly and/or two different drugs to be avoided in the elderly in the measurement period</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                 <id root="2.16.840.1.113883.3.249.11.58" />
                  <code code="PQRI-24" codeSystem="2.16.840.1.113883.3.249.12" displayName="BMI age 2-18 years of age"/>
                  <text>Percentage of children 2-18 years of age at the beginning of the measurement period whose weight is classified based on BMI percentile for age and gender.</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="2.16.840.1.113883.3.249.11.59"/>             
                  <code code="PQRI-28" codeSystem="2.16.840.1.113883.3.249.12" displayName="Preventive care and Screening: Tobacco Use: Screening and Cessation Intervention"/>
                  <text>Percentage of patients aged 18 years of older who were screened about tobacco use at least once during the two year measurement preoid AND who received cessation counseling if identified as a tobacco user.</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="2.16.840.1.113883.3.249.11.60" />
                  <code code="PQRI-38" codeSystem="2.16.840.1.113883.3.249.12" displayName="Childhood immumnization status"/>
                  <text>Percentage of children who turn two years of age during the measurement period who have had four DTaP/DT, three IPV, one MMR and three H influenza type B, three hepatitis B, one chicken pox vaccine (VZV) and four pneumococcal conjugate vaccines by their second birthday</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  
                  <code code="" codeSystem="2.16.840.1.113883.3.249.12" displayName=""/>
                  <text>Documents whether provider has adopted and is using ePrescribing</text>
                  <statusCode code="completed"/>
                </act>
              </entry>-->
                  <!--
                  *******************************
                  Reporting Parameters Section
                  *****************************
                   -->
              <component>
                  <section>
                      <code code="55187-9" codeSystem="2.16.840.1.113883.6.1"/>
                      <title>Reporting Parameters</title>
                      <text>
                        <list>
                          <item>Reporting Period Jan 1, 2010 to Dec 31, 2010</item>
                        </list>
                      </text>
                      <entry>
                        <act classCode="ACT" moodCode="EVN">
                        <code code="252116004" codeSystem="2.16.840.1.113883.6.96" displayName="Observation Parameters"/>
                        <effectiveTime>
                          <low value="20100101"/>
                          <high value="20101231"/>
                        </effectiveTime>
                      </act>
                    </entry>
                  </section>
                </component>
                         
        
 <!-- 
                  ********************************************************
                  Patient Data 
                  ********************************************************
                 -->
                <component>
                  <section>
                    <code code="55188-7" codeSystem="2.16.840.1.113883.6.1"/>
                    <title>Patient Data</title>
                  </section>
                </component>
